/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.editor;

public class Selector {
    public static final String TYPE_FIELD = "field";
    public static final String TYPE_REGION_ALL = "region.all";
    public static final String TYPE_REGION_SELECTED = "region.selected";
    public static final String TYPE_RANGE = "range";
    private String type;
    private boolean inside = true;
    private float min = 0.0f;
    private float max = 0.0f;

    public Selector() {
    }

    public Selector(String type, boolean inside) {
        this.type = type;
        this.inside = inside;
    }

    public boolean isRegion() {
        return Selector.isRegion(this.type);
    }

    public static boolean isRegion(String type) {
        return type.equals(TYPE_REGION_SELECTED) || type.equals(TYPE_REGION_ALL);
    }

    public boolean isRange() {
        return Selector.isRange(this.type);
    }

    public static boolean isRange(String type) {
        return type.equals(TYPE_RANGE);
    }

    public String toString() {
        if (this.type.equals(TYPE_FIELD)) {
            return "entire field";
        }
        if (this.type.equals(TYPE_REGION_ALL)) {
            return "all regions";
        }
        if (this.type.equals(TYPE_REGION_SELECTED)) {
            return "selected regions";
        }
        if (this.type.equals(TYPE_RANGE)) {
            return "within range (" + this.min + "," + this.max + ")";
        }
        return "???";
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getType() {
        return this.type;
    }

    public void setInside(boolean value) {
        this.inside = value;
    }

    public boolean getInside() {
        return this.inside;
    }

    public void setMin(float value) {
        this.min = value;
    }

    public float getMin() {
        return this.min;
    }

    public void setMax(float value) {
        this.max = value;
    }

    public float getMax() {
        return this.max;
    }
}

