/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.gis.MapMaker;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.RadarSweepControl;
import ucar.unidata.idv.control.drawing.DrawingCommand;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.GlyphCreatorCommand;
import ucar.unidata.idv.control.editor.Action;
import ucar.unidata.idv.control.editor.Selector;
import ucar.unidata.ui.Command;
import ucar.unidata.ui.CommandManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import visad.Data;
import visad.FieldImpl;
import visad.UnionSet;
import visad.VisADException;

public class RadarEditor
extends DrawingControl {
    private MyRadarSweepControl radarSweepControl;
    private PythonInterpreter interpreter;
    private JTextField maxFld;
    private JTextField minFld;
    private JTextArea exprFld;
    private JComboBox regionModeCbx;
    private JComboBox insideCbx;
    private JTextArea commandsTextArea;
    private CommandManager commandManager = new CommandManager(10);
    private List<Action> actions = new ArrayList<Action>();
    private JList actionList;
    private int exprCnt = 0;

    public RadarEditor() {
        this.setCoordType(3);
        this.setLineWidth(2);
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        if (this.radarSweepControl != null) {
            this.radarSweepControl.doRemove();
        }
        super.doRemove();
    }

    protected void setField(FieldImpl field) throws Exception {
        this.radarSweepControl.getGridDisplayable().loadData(field);
        this.radarSweepControl.setCurrentSlice(field);
    }

    @Override
    public boolean init(List choices) throws VisADException, RemoteException {
        super.init((DataChoice)null);
        this.radarSweepControl = new MyRadarSweepControl();
        this.radarSweepControl.setUse3D(false);
        this.radarSweepControl.init(this.getDisplayId(), this.getCategories(), choices, this.getControlContext(), "", this.getDataSelection());
        return true;
    }

    private PythonInterpreter getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = this.getControlContext().getJythonManager().createInterpreter();
        }
        return this.interpreter;
    }

    protected void appendCommand(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RadarEditor.this.commandsTextArea.append(text);
            }
        });
    }

    public String getRegionMode() {
        return (String)((TwoFacedObject)this.regionModeCbx.getSelectedItem()).getId();
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.actionList = new JList();
        this.actionList.setSelectionMode(2);
        this.actionList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GuiUtils.isDeleteEvent(e)) {
                    int[] indices = RadarEditor.this.actionList.getSelectedIndices();
                    List tmp = RadarEditor.this.actions;
                    RadarEditor.this.actions = new ArrayList(tmp);
                    for (int i = 0; i < indices.length; ++i) {
                        RadarEditor.this.actions.remove(tmp.get(indices[i]));
                    }
                    RadarEditor.this.updateActionList();
                }
            }
        });
        this.updateActionList();
        this.actionList.setVisibleRowCount(5);
        this.commandsTextArea = new JTextArea("", 5, 40);
        this.regionModeCbx = new JComboBox<Object>(new Object[]{new TwoFacedObject((Object)"All Regions", "region.all"), new TwoFacedObject((Object)"Selected Regions", "region.selected"), new TwoFacedObject((Object)"Entire Field", "field")});
        this.insideCbx = new JComboBox<String>(new String[]{"Inside Region", "Outside Region"});
        JTabbedPane tabbedPane = new JTabbedPane();
        this.maxFld = new JTextField("0", 5);
        this.minFld = new JTextField("0", 5);
        this.exprFld = new JTextArea("", 3, 30);
        this.exprFld.setToolTipText("e.g, value = value*4;");
        JPanel regionComp = GuiUtils.hbox((Component)this.regionModeCbx, (Component)this.insideCbx, 5);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(GuiUtils.rLabel("History:"));
        comps.add(GuiUtils.left(this.commandManager.getContents(false)));
        comps.add(GuiUtils.rLabel("Apply To:"));
        comps.add(GuiUtils.left(regionComp));
        ArrayList<JPanel> actionComps = new ArrayList<JPanel>();
        actionComps.add(GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.makeButton("Average", this, "doAverage"), (Component)GuiUtils.makeButton("Absolute value", this, "doAbsoluteValue"), 5)));
        actionComps.add(GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.hbox((Component)GuiUtils.makeButton("Max", this, "doMax"), (Component)this.maxFld, 2), (Component)GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.makeButton("Min", this, "doMin"), (Component)this.minFld, 2)), 5)));
        actionComps.add(GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.makeButton("Expression", this, "doExpr"), (Component)this.exprFld, 2)));
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel actionComp = GuiUtils.doLayout(actionComps, 1, GuiUtils.WT_N, GuiUtils.WT_N);
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        comps.add(GuiUtils.rLabel("Actions:"));
        comps.add(actionComp);
        JPanel topComp = GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        JPanel execButtons = GuiUtils.hbox((Component)GuiUtils.makeButton("Execute", this, "executeActions"), (Component)GuiUtils.makeButton("Clear", this, "clearActions"), 5);
        JPanel actionsComp = GuiUtils.inset((Component)GuiUtils.topCenter(GuiUtils.left(execButtons), new JScrollPane(this.actionList)), new Insets(5, 0, 0, 0));
        JPanel commandsPanel = GuiUtils.topCenter(topComp, actionsComp);
        tabbedPane.add("Commands", commandsPanel);
        tabbedPane.add("Regions", GuiUtils.topCenter(this.doMakeControlsPanel(), this.doMakeShapesPanel()));
        tabbedPane.add("Radar Display", this.radarSweepControl.doMakeContents());
        return tabbedPane;
    }

    private UnionSet getMapLines(Selector selector) throws Exception {
        List glyphsToUse;
        if (!selector.isRegion()) {
            return null;
        }
        List list = glyphsToUse = selector.getType().equals("region.all") ? this.glyphs : this.selectedGlyphs;
        if (glyphsToUse.size() == 0) {
            return null;
        }
        MapMaker mapMaker = new MapMaker();
        for (DrawingGlyph glyph : glyphsToUse) {
            mapMaker.addMap(glyph.getLatLons());
        }
        return mapMaker.getMaps();
    }

    private String getMapLinesJython(Selector selector, StringBuffer sb) throws Exception {
        List glyphsToUse;
        String var = "regions_" + this.exprCnt++;
        if (!selector.isRegion()) {
            sb.append(var + "=None;\n");
            return var;
        }
        List list = glyphsToUse = selector.getType().equals("region.all") ? this.glyphs : this.selectedGlyphs;
        if (glyphsToUse.size() == 0) {
            sb.append(var + "=None;\n");
            return var;
        }
        sb.append(var + "=MapMaker();\n");
        MapMaker mapMaker = new MapMaker();
        for (DrawingGlyph glyph : glyphsToUse) {
            float[][] latLons = glyph.getLatLons();
            sb.append(var + ".addMap(array([");
            for (int i = 0; i < latLons[0].length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(latLons[0][i]);
                sb.append(",");
                sb.append(latLons[1][i]);
            }
            sb.append("],'f'));\n");
        }
        return var;
    }

    private void updateActionList() {
        this.actionList.setListData(new Vector<Action>(this.actions));
    }

    public void addAction(Action action) {
        this.actions.add(action);
        this.updateActionList();
    }

    public void executeActions() {
        this.executeActions(false);
    }

    public void executeAndClearActions() {
        this.executeActions(true);
    }

    public void clearActions() {
        this.actions = new ArrayList<Action>();
        this.updateActionList();
    }

    public void executeActions(boolean andClear) {
        try {
            FieldImpl oldSlice = this.radarSweepControl.getCurrentSlice();
            for (Action action : this.actions) {
                this.applyAction(action);
            }
            FieldImpl newSlice = this.radarSweepControl.getCurrentSlice();
            this.commandManager.add(new FieldCommand(this, oldSlice, newSlice), true);
            this.radarSweepControl.getGridDisplayable().loadData(newSlice);
            if (andClear) {
                this.clearActions();
            }
        }
        catch (Exception exc) {
            RadarEditor.logException("Error", exc);
        }
    }

    public void applyAction(Action action) {
        try {
            UnionSet mapLines = this.getMapLines(action.getSelector());
            if (mapLines == null && action.getSelector().isRegion()) {
                RadarEditor.userMessage("No regions defined");
                return;
            }
            long t1 = System.currentTimeMillis();
            FieldImpl oldSlice = this.radarSweepControl.getCurrentSlice();
            StringBuffer sb = new StringBuffer();
            this.getInterpreter().set("field", oldSlice);
            if (action.getJython() != null) {
                this.getInterpreter().exec(action.getJython());
            }
            if (action.getSelector().isRegion()) {
                this.getInterpreter().set("mapLines", mapLines);
                this.getInterpreter().exec("newField = mapsApplyToField('" + action.getFunction() + "',field,mapLines," + (action.getSelector().getInside() ? "1" : "0") + ")");
            }
            long t2 = System.currentTimeMillis();
            System.err.println("Time:" + (t2 - t1));
            PyObject obj = this.interpreter.get("newField");
            FieldImpl newSlice = (FieldImpl)obj.__tojava__(Data.class);
            this.radarSweepControl.setCurrentSlice(newSlice);
        }
        catch (Exception exc) {
            RadarEditor.logException("Error", exc);
        }
    }

    public void addAction(String name, String func) {
        this.addAction(new Action(name, func, this.getSelector()));
    }

    private Selector getSelector() {
        return new Selector(this.getRegionMode(), this.insideCbx.getSelectedIndex() == 0);
    }

    public void doAverage() {
        this.addAction("Average", "mapsAverage(originalValues, newValues, indexArray)");
    }

    public void doExpr() {
        String expr = this.exprFld.getText();
        String funcName = "exprFunction" + this.exprCnt++;
        Action action = new Action("Expression " + expr.replace("\n", ""), funcName + "(originalValues,newValues,indexArray)", this.getSelector());
        StringBuffer jython = new StringBuffer("def " + funcName + "(originalValues,newValues,indexArray):\n");
        jython.append("\tfor i in xrange(len(indexArray)):\n");
        jython.append("\t\tindex=indexArray[i];\n");
        jython.append("\t\tvalue=originalValues[0][index];\n");
        for (String line : StringUtil.split(expr, "\n", false, false)) {
            jython.append("\t\t");
            jython.append(line);
            jython.append("\n");
        }
        jython.append("\t\tnewValues[0][index] = value;\n");
        action.setJython(jython.toString());
        this.addAction(action);
    }

    public void doAbsoluteValue() {
        this.addAction("Absolute value", "mapsAbsoluteValue(originalValues, newValues, indexArray)");
    }

    public void doMax() {
        String value = this.maxFld.getText();
        this.addAction("Max (" + value + ")", "mapsMax(originalValues, newValues, indexArray," + value + ")");
    }

    public void doMin() {
        String value = this.minFld.getText();
        this.addAction("Min (" + value + ")", "mapsMin(originalValues, newValues, indexArray," + value + ")");
    }

    @Override
    protected boolean showFilledCbx() {
        return false;
    }

    @Override
    protected void makeModePanel(List widgets) {
        List commands = Misc.newList(CMD_SELECT, CMD_MOVE, CMD_STRETCH);
        ArrayList<DrawingCommand> shapes = new ArrayList<DrawingCommand>();
        this.currentCmd = GlyphCreatorCommand.CMD_CLOSEDPOLYGON;
        shapes.add(GlyphCreatorCommand.CMD_CLOSEDPOLYGON);
        ButtonGroup bg = new ButtonGroup();
        widgets.add(GuiUtils.rLabel("Mode:"));
        if (this.straightCbx == null) {
            this.straightCbx = new JCheckBox("Straight", this.getStraight());
        }
        widgets.add(GuiUtils.left(GuiUtils.hbox((Component)this.makeButtonPanel(shapes, bg), (Component)this.makeButtonPanel(commands, bg), (Component)this.straightCbx, this.enabledCbx)));
    }

    @Override
    protected boolean showTimeWidgets() {
        return false;
    }

    @Override
    protected boolean showLocationWidgets() {
        return false;
    }

    public void setActions(List<Action> value) {
        this.actions = value;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public static class FieldCommand
    extends Command {
        RadarEditor editor;
        FieldImpl oldSlice;
        FieldImpl newSlice;

        public FieldCommand(RadarEditor editor, FieldImpl oldSlice, FieldImpl newSlice) {
            this.editor = editor;
            this.oldSlice = oldSlice;
            this.newSlice = newSlice;
        }

        @Override
        public void doCommand() {
            try {
                this.editor.radarSweepControl.getGridDisplayable().loadData(this.newSlice);
                this.editor.radarSweepControl.setCurrentSlice(this.newSlice);
            }
            catch (Exception exc) {
                RadarEditor.logException("Error", exc);
            }
        }

        @Override
        public void undoCommand() {
            try {
                this.editor.radarSweepControl.getGridDisplayable().loadData(this.oldSlice);
                this.editor.radarSweepControl.setCurrentSlice(this.oldSlice);
            }
            catch (Exception exc) {
                RadarEditor.logException("Error", exc);
            }
        }
    }

    public static class MyRadarSweepControl
    extends RadarSweepControl {
        @Override
        protected void addToControlContext() {
        }

        @Override
        public boolean getShowInLegend() {
            return false;
        }

        @Override
        protected void setCurrentSlice(FieldImpl slice) throws Exception {
            super.setCurrentSlice(slice);
        }

        @Override
        protected FieldImpl getCurrentSlice() throws Exception {
            return super.getCurrentSlice();
        }
    }
}

