/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JTextField;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.VMManager;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.ShapeGlyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.TextDisplayable;
import visad.CommonUnit;
import visad.Data;
import visad.DisplayEvent;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.VisADException;
import visad.georef.EarthLocation;

public class TransectGlyph
extends ShapeGlyph {
    private Real maxDataDistance;
    LineDrawing maxDistanceBox;
    private ViewDescriptor viewDescriptor;
    private boolean showText = true;
    private TextDisplayable startTextDisplayable;
    private TextDisplayable endTextDisplayable;
    private CompositeDisplayable waypointDisplayable;
    private TextType startTextType;
    private TextType endTextType;
    private TextType waypointTextType;
    private String startText = "B";
    private String endText = "E";
    private String waypointText = "W";
    private JTextField startTextFld;
    private JTextField endTextFld;
    private JTextField waypointTextFld;
    private JTextField maxDistanceFld;
    private TransectViewManager tvm;
    private Object lastPoint = null;
    private static final String PROP_MULTIPLE_SEGMENTS = "idv.transect.multisegment";

    public TransectGlyph() {
        this.setShapeType(2);
    }

    public TransectGlyph(DrawingControl control, DisplayEvent event, boolean editable) throws VisADException, RemoteException {
        this(control, event, editable, true);
    }

    public TransectGlyph(DrawingControl control, DisplayEvent event, boolean editable, boolean showText) throws VisADException, RemoteException {
        super(control, event);
        this.showText = showText;
        this.setShapeType(2);
        this.editable = editable;
    }

    @Override
    protected int getNumInterpolationPoints() {
        return 10;
    }

    @Override
    public void setVisible(boolean visible) throws VisADException, RemoteException {
        super.setVisible(visible);
        this.checkBoxVisibility();
    }

    @Override
    public void checkTimeVisibility() throws VisADException, RemoteException {
    }

    public void checkBoxVisibility() throws VisADException, RemoteException {
        if (this.maxDistanceBox == null) {
            return;
        }
        if (this.maxDataDistance == null || !super.isVisible()) {
            this.maxDistanceBox.setVisible(false);
        } else {
            double km = this.maxDataDistance.getValue(CommonUnit.meter) / 1000.0;
            if (km > 2000.0) {
                this.maxDistanceBox.setVisible(false);
            } else if (this.control != null) {
                this.maxDistanceBox.setVisible(this.control.shouldBeVisible(this));
            }
        }
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        int i;
        super.updateLocation();
        if (this.points.size() < 2) {
            return;
        }
        if (this.showText) {
            this.setText(this.startTextDisplayable, 0, this.startText, this.startTextType);
            if (this.points.size() > 2) {
                for (int i2 = 1; i2 < this.points.size() - 1; ++i2) {
                    int numwaypoints = this.waypointDisplayable.displayableCount();
                    if (i2 > numwaypoints) {
                        TextDisplayable waypoint = new TextDisplayable("waypoint text_" + typeCnt++, this.waypointTextType);
                        waypoint.setTextSize(this.control.getDisplayScale() * 2.0f);
                        if (this.getColor() != null) {
                            this.setColor(waypoint, this.getColor());
                        }
                        this.setText(waypoint, i2, this.waypointText + i2, this.waypointTextType);
                        this.waypointDisplayable.addDisplayable(waypoint);
                        continue;
                    }
                    this.setText((TextDisplayable)this.waypointDisplayable.getDisplayable(i2 - 1), i2, this.waypointText + i2, this.waypointTextType);
                }
            }
            this.setText(this.endTextDisplayable, this.points.size() - 1, this.endText, this.endTextType);
        }
        this.checkBoxVisibility();
        if (this.maxDataDistance == null || this.maxDistanceBox == null) {
            return;
        }
        double km = this.maxDataDistance.getValue(CommonUnit.meter) / 1000.0;
        if (km > 2000.0) {
            return;
        }
        EarthLocation p1 = (EarthLocation)this.points.get(0);
        EarthLocation p2 = (EarthLocation)this.points.get(this.points.size() - 1);
        RealTupleType mathType = RealTupleType.LatitudeLongitudeAltitude;
        Bearing baseBearing = Bearing.calculateBearing(p1.getLatitude().getValue(), p1.getLongitude().getValue(), p2.getLatitude().getValue(), p2.getLongitude().getValue());
        double baseAngle = baseBearing.getAngle();
        LatLonPointImpl[] llps = new LatLonPointImpl[]{Bearing.findPoint(p1.getLatitude().getValue(), p1.getLongitude().getValue(), baseAngle + 90.0, km, null), Bearing.findPoint(p2.getLatitude().getValue(), p2.getLongitude().getValue(), baseAngle + 90.0, km, null), Bearing.findPoint(p2.getLatitude().getValue(), p2.getLongitude().getValue(), baseAngle - 90.0, km, null), Bearing.findPoint(p1.getLatitude().getValue(), p1.getLongitude().getValue(), baseAngle - 90.0, km, null), Bearing.findPoint(p1.getLatitude().getValue(), p1.getLongitude().getValue(), baseAngle + 90.0, km, null)};
        Object lineVals = this.getPointValues();
        float alt = lineVals[2][0];
        lineVals = new float[3][llps.length];
        for (int i3 = 0; i3 < lineVals[0].length; ++i3) {
            lineVals[0][i3] = (float)llps[i3].getLatitude();
            lineVals[1][i3] = (float)llps[i3].getLongitude();
        }
        float[][] tmp = new float[3][];
        for (i = 0; i < lineVals[0].length - 1; ++i) {
            tmp[0] = Misc.merge(tmp[0], Misc.interpolate(2 + this.getNumInterpolationPoints(), lineVals[0][i], lineVals[0][i + 1]));
            tmp[1] = Misc.merge(tmp[1], Misc.interpolate(2 + this.getNumInterpolationPoints(), lineVals[1][i], lineVals[1][i + 1]));
        }
        tmp[2] = new float[tmp[0].length];
        lineVals = tmp;
        for (i = 0; i < lineVals[0].length; ++i) {
            lineVals[2][i] = alt;
        }
        Gridded3DSet theData = new Gridded3DSet((MathType)mathType, (float[][])lineVals, lineVals[0].length);
        this.maxDistanceBox.setData(theData);
    }

    @Override
    public void setLineWidth(float value) {
        super.setLineWidth(value);
        try {
            if (this.maxDistanceBox != null) {
                this.maxDistanceBox.setLineWidth(value);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Setting color", exc);
        }
    }

    private void setText(TextDisplayable displayable, int index, String lbl, TextType textType) throws VisADException, RemoteException {
        Text t = new Text(textType, lbl);
        Tuple theData = null;
        float[][] lineVals = this.getPointValues();
        if (lineVals.length == 3) {
            theData = new Tuple(new Data[]{new RealTuple(RealTupleType.LatitudeLongitudeAltitude, new double[]{lineVals[0][index], lineVals[1][index], lineVals[2][index]}), t});
            displayable.setData(theData);
        }
    }

    @Override
    public String getExtraDescription() {
        if (!this.editable) {
            return "System Transect";
        }
        return "";
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        this.maxDistanceBox = new LineDrawing("TransectGlyph_" + typeCnt++);
        this.maxDistanceBox.setLineWidth(this.getLineWidth());
        this.maxDistanceBox.setColor(this.getColor());
        this.addDisplayable(this.maxDistanceBox);
        if (this.showText) {
            this.startTextType = TextType.getTextType("TransectGlyphText_" + typeCnt++);
            this.startTextDisplayable = new TextDisplayable("start text_" + typeCnt++, this.startTextType);
            this.startTextDisplayable.setTextSize(this.control.getDisplayScale() * 2.0f);
            this.endTextType = TextType.getTextType("TransectGlyphText_" + typeCnt++);
            this.endTextDisplayable = new TextDisplayable("end text_" + typeCnt++, this.endTextType);
            this.endTextDisplayable.setTextSize(this.control.getDisplayScale() * 2.0f);
            this.waypointTextType = TextType.getTextType("TransectGlyphText_" + typeCnt++);
            this.waypointDisplayable = new CompositeDisplayable("waypoints");
            this.addDisplayable(this.startTextDisplayable);
            this.addDisplayable(this.endTextDisplayable);
            this.addDisplayable(this.waypointDisplayable);
        }
        return true;
    }

    @Override
    public DrawingGlyph handleMouseDragged(DisplayEvent event) throws VisADException, RemoteException {
        if (!this.editable) {
            return null;
        }
        if (!this.canDoMultiSegment()) {
            return super.handleMouseDragged(event);
        }
        this.lastPoint = this.getPoint(event);
        if (this.points.size() < 2) {
            this.points.add(this.getPoint(event));
        } else {
            this.points.set(this.points.size() - 1, this.getPoint(event));
        }
        this.updateLocation();
        return this;
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        super.getPropertiesComponents(comps, compMap);
        this.startTextFld = new JTextField(this.startText, 5);
        this.endTextFld = new JTextField(this.endText, 5);
        comps.add(GuiUtils.rLabel("Start Label:"));
        comps.add(GuiUtils.left(this.startTextFld));
        comps.add(GuiUtils.rLabel("End Label:"));
        comps.add(GuiUtils.left(this.endTextFld));
        if (this.points.size() > 2) {
            this.waypointTextFld = new JTextField(this.waypointText, 5);
            comps.add(GuiUtils.rLabel("Waypoint Label:"));
            comps.add(GuiUtils.left(this.waypointTextFld));
        }
        this.maxDistanceFld = null;
        this.tvm = null;
        if (this.viewDescriptor != null) {
            VMManager vmManager = this.control.getControlContext().getIdv().getVMManager();
            List vms = vmManager.getViewManagers(TransectViewManager.class);
            this.tvm = (TransectViewManager)VMManager.findViewManagerInList(this.viewDescriptor, vms);
            if (this.tvm != null && this.maxDataDistance != null) {
                this.maxDistanceFld = new JTextField(this.maxDataDistance.getValue() + " [" + this.maxDataDistance.getUnit() + "]", 15);
                this.maxDistanceFld.setToolTipText("Maximum distance shown. e.g.: value[unit]");
                comps.add(GuiUtils.rLabel("Max distance:"));
                comps.add(GuiUtils.left(this.maxDistanceFld));
            }
        }
    }

    @Override
    protected boolean applyProperties(Hashtable compMap) throws VisADException, RemoteException {
        if (!super.applyProperties(compMap)) {
            return false;
        }
        this.setStartText(this.startTextFld.getText().trim());
        this.setEndText(this.endTextFld.getText().trim());
        if (this.waypointTextFld != null) {
            this.setWaypointText(this.waypointTextFld.getText().trim());
        }
        try {
            if (this.maxDistanceFld != null) {
                Real oldMaxDataDistance = this.maxDataDistance;
                this.maxDataDistance = Util.toReal(this.maxDistanceFld.getText().trim());
                this.tvm.setMaxDataDistance(this.maxDataDistance);
                this.updateLocation();
            }
        }
        catch (Exception exc) {
            LogUtil.userErrorMessage("Bad value:" + this.maxDistanceFld.getText().trim());
            return false;
        }
        return true;
    }

    @Override
    public String getTypeName() {
        return "Transect";
    }

    public void setStartText(String value) {
        this.startText = value;
    }

    public String getStartText() {
        return this.startText;
    }

    public void setEndText(String value) {
        this.endText = value;
    }

    public String getEndText() {
        return this.endText;
    }

    public void setWaypointText(String value) {
        this.waypointText = value;
    }

    public String getWaypointText() {
        return this.waypointText;
    }

    @Override
    public String getDescription() {
        if (this.getForDisplay()) {
            return "Display";
        }
        return "Transect";
    }

    @Override
    public boolean isSelectable() {
        return !this.getForDisplay();
    }

    public boolean getForDisplay() {
        return this.viewDescriptor != null;
    }

    public void setViewDescriptor(ViewDescriptor value) {
        this.viewDescriptor = value;
    }

    public ViewDescriptor getViewDescriptor() {
        return this.viewDescriptor;
    }

    public void setMaxDataDistance(Real value) {
        this.maxDataDistance = value;
    }

    public Real getMaxDataDistance() {
        return this.maxDataDistance;
    }

    @Override
    public DrawingGlyph handleKeyPressed(DisplayEvent event) throws VisADException, RemoteException {
        if (this.points.size() < 2 || this.lastPoint == null || !this.canDoMultiSegment()) {
            return this;
        }
        InputEvent inputEvent = event.getInputEvent();
        if (!(inputEvent instanceof KeyEvent)) {
            return this;
        }
        KeyEvent keyEvent = (KeyEvent)inputEvent;
        if (keyEvent.getKeyCode() != 32) {
            return this;
        }
        this.points.add(this.lastPoint);
        this.lastPoint = null;
        this.updateLocation();
        return this;
    }

    private boolean canDoMultiSegment() {
        return this.control.getControlContext().getIdv().getStateManager().getPreferenceOrProperty(PROP_MULTIPLE_SEGMENTS, false);
    }
}

