/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.ShapeUtility;
import ucar.visad.display.ImageRGBDisplayable;
import ucar.visad.display.ShapeDisplayable;
import visad.ConstantMap;
import visad.Display;
import visad.DisplayEvent;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.TextControl;
import visad.TextType;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.util.ImageHelper;

public class TextGlyph
extends DrawingGlyph {
    private static final TextControl.Justification[] JUSTIFICATIONS = new TextControl.Justification[]{TextControl.Justification.LEFT, TextControl.Justification.CENTER, TextControl.Justification.RIGHT, TextControl.Justification.TOP, TextControl.Justification.BOTTOM};
    public static final String JUST_LEFT = "Left";
    public static final String JUST_CENTER = "Center";
    public static final String JUST_RIGHT = "Right";
    public static final String JUST_TOP = "Top";
    public static final String JUST_BOTTOM = "Bottom";
    private static final String[] JUSTIFICATION_NAMES = new String[]{"Left", "Center", "Right", "Top", "Bottom"};
    private DisplayEvent displayEvent;
    JTextArea textArea;
    JScrollPane textSP;
    JEditorPane editor;
    HyperlinkListener hyperlinkListener;
    JComponent editorWrapper;
    JComponent textContents;
    public static final String ATTR_MARKER = "marker";
    public static final String ATTR_MARKERSCALE = "markerscale";
    public static final String ATTR_SHOWMARKER = "showmarker";
    public static final String ATTR_JUSTIFICATION = "justification";
    public static final String ATTR_FONTSIZE = "fontsize";
    public static final String ATTR_FONTFACE = "fontface";
    public static final String ATTR_FONTSTRING = "fontstring";
    public static final String ATTR_FONT = "font";
    private String horizontalJustification = "Left";
    private String verticalJustification = "Bottom";
    private TextType textType;
    private Font font;
    private String text;
    private JEditorPane renderedEditor;
    private ImageRGBDisplayable imageDisplayable;
    Linear2DSet imageDomain;
    Image image;
    int width;
    int height;
    FlatField imageData;
    private ShapeDisplayable pointDisplayable;
    protected boolean showMarker = false;
    protected double markerScale = 0.1;
    protected String markerType = "PIN";
    private int htmlWidth = -1;
    double[] origin;
    double[] lr;
    List dialogs = new ArrayList();
    private float lastScale = Float.NaN;
    private HTMLEditorKit editorKit;

    public TextGlyph() {
    }

    public TextGlyph(DrawingControl control, DisplayEvent event, String text) {
        super(control, event);
        this.text = text;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    @Override
    public String getExtraDescription() {
        return this.text;
    }

    @Override
    public DrawingGlyph handleCreation(DisplayEvent event) throws VisADException, RemoteException {
        super.handleCreation(event);
        this.points = Misc.newList(this.getPoint(event));
        this.updateLocation();
        return null;
    }

    @Override
    public boolean initFromUser(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        Font font = control.getFont();
        if (font != null) {
            this.setFont(font);
        }
        this.horizontalJustification = control.getJustification();
        this.verticalJustification = control.getVerticalJustification();
        this.makeTextContents();
        if (!GuiUtils.showOkCancelDialog(null, "Text entry", this.textContents, null)) {
            return false;
        }
        this.text = this.textArea.getText();
        this.htmlWidth = this.editor.getSize().width;
        return super.initFromUser(control, event);
    }

    @Override
    public boolean mousePressed(DisplayEvent event) throws VisADException, RemoteException {
        this.displayEvent = event;
        if (this.renderedEditor == null || this.origin == null || this.lr == null) {
            return false;
        }
        double[] xy = this.control.screenToBox(event.getX(), event.getY());
        double xpercent = (xy[0] - this.origin[0]) / (this.lr[0] - this.origin[0]);
        double ypercent = (xy[1] - this.origin[1]) / (this.lr[1] - this.origin[1]);
        if (xpercent < 0.0 || xpercent > 1.0) {
            return false;
        }
        if (ypercent < 0.0 || ypercent > 1.0) {
            return false;
        }
        int x = (int)(xpercent * (double)this.width);
        int y = (int)(ypercent * (double)this.height);
        MouseListener[] ml = this.renderedEditor.getMouseListeners();
        MouseEvent me = null;
        int[] buttons = new int[]{1, 2, 3};
        int[] masks = new int[]{16, 8, 8};
        for (int i = 0; i < buttons.length; ++i) {
            MouseEvent tmpMe = new MouseEvent(this.renderedEditor, 0, System.currentTimeMillis(), masks[i], x, y, 1, false, buttons[i]);
            if (!SwingUtilities.isLeftMouseButton(tmpMe)) continue;
            me = tmpMe;
            break;
        }
        if (me == null) {
            return true;
        }
        for (int j = 0; j < ml.length; ++j) {
            ml[j].mouseClicked(me);
        }
        return true;
    }

    private void makeTextContents() {
        if (this.textArea == null) {
            this.textArea = new JTextArea("", 5, 30);
            this.editor = new JEditorPane();
            this.editor.setEditable(false);
            this.editor.setContentType("text/html");
            this.editor.addHyperlinkListener(this.getHyperlinkListener());
            this.textArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent ke) {
                    try {
                        TextGlyph.this.editor.setText(TextGlyph.this.processHtml(TextGlyph.this.textArea.getText()));
                    }
                    catch (Exception exc) {
                        LogUtil.logException("Rendering html image", exc);
                    }
                }
            });
            this.textSP = new JScrollPane(this.textArea);
            this.textArea.setPreferredSize(new Dimension(300, 100));
            this.textSP.setPreferredSize(new Dimension(300, 100));
            this.editor.setPreferredSize(new Dimension(300, 75));
            this.textContents = GuiUtils.doLayout(new JComponent[]{new JLabel("Text: (May be html)"), this.textSP, GuiUtils.inset((Component)new JLabel("Preview:"), new Insets(5, 0, 0, 0)), this.editorWrapper = GuiUtils.hsplit(this.editor, GuiUtils.filler(), this.getHtmlWidthToUse(), 1.0)}, 1, GuiUtils.WT_Y, GuiUtils.WT_NYNY);
            this.textContents = GuiUtils.inset((Component)this.textContents, 5);
        }
        this.textArea.setText(this.text);
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        String fontStr;
        super.initFromXml(control, node);
        String just = XmlUtil.getAttribute((Node)node, ATTR_JUSTIFICATION, (String)null);
        if (just != null) {
            if ((just = just.toLowerCase()).length() != 2) {
                System.err.println("Unknown text justification:" + just);
            } else {
                if (just.charAt(0) == 'l') {
                    this.horizontalJustification = JUST_LEFT;
                } else if (just.charAt(0) == 'c') {
                    this.horizontalJustification = JUST_CENTER;
                } else if (just.charAt(0) == 'r') {
                    this.horizontalJustification = JUST_RIGHT;
                } else {
                    System.err.println("Unknown text horizontal justification:" + just);
                }
                if (just.charAt(1) == 'a') {
                    this.verticalJustification = JUST_BOTTOM;
                } else if (just.charAt(1) == 'b') {
                    this.verticalJustification = JUST_TOP;
                } else if (just.charAt(1) == 'c') {
                    this.verticalJustification = JUST_CENTER;
                } else {
                    System.err.println("Unknown text vertical justification:" + just);
                }
            }
        }
        if ((fontStr = XmlUtil.getAttribute((Node)node, ATTR_FONTSTRING, (String)null)) != null) {
            this.setFont(Font.decode(fontStr));
        } else {
            this.setFont(new Font(XmlUtil.getAttribute((Node)node, ATTR_FONTFACE, "times"), 0, XmlUtil.getAttribute((Node)node, ATTR_FONTSIZE, 12)));
        }
        this.text = XmlUtil.getAttribute(node, "text");
        this.showMarker = XmlUtil.getAttribute((Node)node, ATTR_SHOWMARKER, this.showMarker);
        this.markerType = XmlUtil.getAttribute((Node)node, ATTR_MARKER, this.markerType);
        this.markerScale = XmlUtil.getAttribute((Node)node, ATTR_MARKERSCALE, this.markerScale);
    }

    @Override
    public String getTagName() {
        return "text";
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        e.setAttribute("text", this.text);
        String just = "";
        just = this.horizontalJustification.equalsIgnoreCase(JUST_LEFT) ? "l" : (this.horizontalJustification.equalsIgnoreCase(JUST_CENTER) ? "c" : "r");
        just = this.verticalJustification.equalsIgnoreCase(JUST_TOP) ? just + "b" : (this.verticalJustification.equalsIgnoreCase(JUST_BOTTOM) ? just + "a" : just + "c");
        e.setAttribute(ATTR_JUSTIFICATION, just);
        e.setAttribute(ATTR_MARKER, this.markerType);
        e.setAttribute(ATTR_SHOWMARKER, "" + this.showMarker);
        e.setAttribute(ATTR_MARKERSCALE, "" + this.markerScale);
        if (this.font != null) {
            e.setAttribute(ATTR_FONTFACE, this.font.getName());
            e.setAttribute(ATTR_FONTSIZE, "" + this.font.getSize());
        }
    }

    private HyperlinkListener getHyperlinkListener() {
        if (this.hyperlinkListener == null) {
            this.hyperlinkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    TextGlyph.this.handleHyperlinkUpdate(e);
                }
            };
        }
        return this.hyperlinkListener;
    }

    private Image getImage(String html, int htmlWidth) throws Exception {
        Color bg = this.getBgcolor();
        if (this.renderedEditor == null) {
            this.renderedEditor = new JEditorPane();
            this.renderedEditor.setContentType("text/html");
            this.renderedEditor.setEditorKit(this.getEditorKit());
            this.renderedEditor.addHyperlinkListener(this.getHyperlinkListener());
        }
        Color tmpBg = new Color(123, 124, 125);
        ImageUtils.getEditor(this.renderedEditor, this.processHtml(html), htmlWidth, bg == null ? tmpBg : null, null);
        if (bg != null) {
            this.renderedEditor.setBackground(bg);
        } else {
            this.renderedEditor.setBackground(tmpBg);
        }
        Image image = bg != null ? ImageUtils.getImage(this.renderedEditor) : ImageUtils.getImage(this.renderedEditor, tmpBg);
        return image;
    }

    private void handleHyperlinkUpdate(HyperlinkEvent e) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String url = e.getURL() == null ? e.getDescription() : e.getURL().toString();
        if ((url = url.trim()).indexOf("popup(") >= 0) {
            String text;
            boolean modal = true;
            if (url.startsWith("modalpopup")) {
                text = url.trim().substring(11);
                modal = true;
            } else {
                text = url.trim().substring(6);
                modal = false;
            }
            text = text.substring(0, text.length() - 1);
            Component comp = this.imageDisplayable.getDisplayMaster().getDisplayComponent();
            int x = comp.getLocationOnScreen().x + this.displayEvent.getX();
            int y = comp.getLocationOnScreen().y + this.displayEvent.getY();
            if (this.dialogs.size() > 0) {
                Component[] comps = (Component[])this.dialogs.get(0);
                try {
                    String contents = IOUtil.readContents(text, (String)null);
                    if (contents != null) {
                        text = contents;
                    }
                }
                catch (Exception contents) {
                    // empty catch block
                }
                ((JEditorPane)comps[0]).setText(text);
                JDialog dialog = (JDialog)comps[1];
                if (!dialog.isVisible()) {
                    dialog.setLocation(new Point(x, y));
                    dialog.setVisible(true);
                } else {
                    dialog.toFront();
                }
                return;
            }
            Component[] comps = GuiUtils.popup(text, x, y, modal);
            if (!modal) {
                this.dialogs.add(comps);
            }
            return;
        }
        properties.put("glyph", this);
        properties.put("control", this.control);
        this.control.getControlContext().getIdv().hyperlinkUpdate(e, properties);
    }

    @Override
    public void setBeenRemoved(boolean value) {
        super.setBeenRemoved(value);
        if (value) {
            for (int i = 0; i < this.dialogs.size(); ++i) {
                Component[] comps = (Component[])this.dialogs.get(i);
                ((JDialog)comps[1]).dispose();
            }
        }
    }

    private String processHtml(String text) {
        Color c = this.getColor();
        String tmp = text;
        tmp = "<html><body style=\"margin:0;color:#" + StringUtil.padRight(Integer.toHexString(c.getRed()), 2, "0") + StringUtil.padRight(Integer.toHexString(c.getGreen()), 2, "0") + StringUtil.padRight(Integer.toHexString(c.getBlue()), 2, "0") + "; " + (this.font != null ? "font-size:" + this.font.getSize() + "pt;" : "") + (this.font != null ? "font-family:" + this.font.getFamily() + ";" : "") + "\">" + tmp + "</body></html>";
        return tmp;
    }

    private int getHtmlWidthToUse() {
        if (this.text != null && this.text.trim().startsWith("<nobr>")) {
            return -1;
        }
        return this.htmlWidth;
    }

    private void updateImage() {
        try {
            this.image = this.getImage(this.text, this.getHtmlWidthToUse());
            this.imageData = TextGlyph.makeField(this.image, 0.0f, false);
            this.imageDomain = (Linear2DSet)this.imageData.getDomainSet();
        }
        catch (Exception exc) {
            LogUtil.logException("Rendering html image", exc);
        }
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        this.updateImage();
        this.textType = TextType.getTextType("TextGlyph_" + typeCnt++);
        this.imageDisplayable = new ImageRGBDisplayable("ImageGlyph." + typeCnt++, false);
        ColorTable colorTable = this.control.getRGBColorTable();
        this.imageDisplayable.setRangeForColor(0.0, 255.0);
        this.imageDisplayable.setColorPalette(colorTable.getAlphaTable());
        if (!this.getFullLatLon() || this.isInXYSpace()) {
            this.imageDisplayable.addConstantMap(new ConstantMap(this.getZPosition(), Display.ZAxis));
        } else {
            this.imageDisplayable.addConstantMap(new ConstantMap(this.getZPosition(), Display.ZAxis));
        }
        this.addDisplayable(this.imageDisplayable);
        this.pointDisplayable = new ShapeDisplayable("TextGlyph_" + typeCnt++, ShapeUtility.createShape("PLUS")[0]);
        this.setMarkerType(this.markerType);
        this.pointDisplayable.setVisible(this.showMarker);
        this.pointDisplayable.setAutoSize(true);
        if (this.font != null) {
            this.setFont(this.font);
        }
        if (this.showMarker) {
            this.addDisplayable(this.pointDisplayable);
        }
        return true;
    }

    @Override
    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        return null;
    }

    @Override
    public DrawingGlyph handleMouseMoved(DisplayEvent event) throws VisADException, RemoteException {
        this.points = Misc.newList(this.getPoint(event));
        this.updateLocation();
        return this;
    }

    private void textGlyphDoneBeingCreated() throws VisADException, RemoteException {
        if (!this.showMarker && this.text.trim().length() == 0) {
            this.control.removeGlyph(this);
        } else {
            this.control.setSelection(this);
        }
    }

    public void setFont(Font value) {
        this.font = value;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    protected boolean shouldShowBgColorSelector() {
        return true;
    }

    @Override
    protected boolean applyProperties(Hashtable compMap) throws VisADException, RemoteException {
        if (!super.applyProperties(compMap)) {
            return false;
        }
        this.text = ((JTextField)compMap.get("text")).getText();
        this.text = this.textArea.getText();
        this.htmlWidth = this.editor.getSize().width;
        JComboBox fontBox = (JComboBox)compMap.get(ATTR_FONT);
        TwoFacedObject fontTfo = (TwoFacedObject)fontBox.getSelectedItem();
        this.font = (Font)fontTfo.getId();
        JComboBox fontSizeBox = (JComboBox)compMap.get(ATTR_FONTSIZE);
        Object selected = fontSizeBox.getSelectedItem();
        int fontSize = new Integer(selected.toString());
        this.setShowMarker(((JCheckBox)compMap.get("showMarkerCbx")).isSelected());
        JComboBox shapeBox = (JComboBox)compMap.get("shapeBox");
        JTextField scaleField = (JTextField)compMap.get("scaleField");
        this.markerScale = Misc.parseNumber(scaleField.getText().trim());
        this.setMarkerType(TwoFacedObject.getIdString(shapeBox.getSelectedItem()));
        this.horizontalJustification = (String)((JComboBox)compMap.get("hjust")).getSelectedItem();
        this.verticalJustification = (String)((JComboBox)compMap.get("vjust")).getSelectedItem();
        this.setFont(this.font.deriveFont((float)fontSize));
        this.setText(this.text);
        this.editor.setText(this.processHtml(this.text));
        this.updateImage();
        return true;
    }

    private HTMLEditorKit getEditorKit() {
        if (this.editorKit != null) {
            // empty if block
        }
        this.editorKit = new HTMLEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return new MyHTMLFactory();
            }

            public String toString() {
                return "MyEditorKit";
            }

            class MyHTMLFactory
            extends HTMLEditorKit.HTMLFactory {
                MyHTMLFactory() {
                }

                @Override
                public View create(javax.swing.text.Element elem) {
                    Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (o.toString().equals("colortable")) {
                        System.err.println("making ctw");
                        return new ColorTableWrapper(elem);
                    }
                    return super.create(elem);
                }
            }
        };
        return this.editorKit;
    }

    @Override
    public void viewpointChanged() throws VisADException, RemoteException {
        float scale = this.control.getDisplayScale();
        if (scale == this.lastScale) {
            return;
        }
        this.updateImage();
        this.updateLocation();
    }

    @Override
    public void projectionChanged() throws VisADException, RemoteException {
        this.lastScale = Float.NaN;
        this.updateLocation();
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        JTextField textField = new JTextField(this.text);
        this.makeTextContents();
        comps.add(GuiUtils.rLabel("Text:"));
        comps.add(this.textSP);
        comps.add(GuiUtils.rLabel("Preview:"));
        comps.add(this.editorWrapper);
        this.editor.setText(this.processHtml(this.text));
        compMap.put("text", textField);
        JComboBox fontBox = GuiUtils.doMakeFontBox(this.font);
        JComboBox fontSizeBox = GuiUtils.doMakeFontSizeBox(this.font.getSize());
        compMap.put(ATTR_FONTSIZE, fontSizeBox);
        compMap.put(ATTR_FONT, fontBox);
        comps.add(GuiUtils.rLabel("Font:"));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)fontBox, (Component)new JLabel("Size:"), (Component)fontSizeBox, 5)));
        JComboBox<Object> horizontalJustificationBox = new JComboBox<Object>(new Object[]{JUST_LEFT, JUST_CENTER, JUST_RIGHT});
        horizontalJustificationBox.setSelectedItem(this.horizontalJustification);
        compMap.put("hjust", horizontalJustificationBox);
        JComboBox<Object> verticalJustificationBox = new JComboBox<Object>(new Object[]{JUST_BOTTOM, JUST_CENTER, JUST_TOP});
        verticalJustificationBox.setSelectedItem(this.verticalJustification);
        compMap.put("vjust", verticalJustificationBox);
        comps.add(GuiUtils.rLabel("Alignment:"));
        comps.add(GuiUtils.left(GuiUtils.flow(new Component[]{horizontalJustificationBox, verticalJustificationBox})));
        JTextField scaleField = new JTextField("" + this.markerScale, 5);
        JCheckBox showMarkerCbx = new JCheckBox("Show", this.showMarker);
        JComboBox<TwoFacedObject> shapeBox = new JComboBox<TwoFacedObject>(ShapeUtility.SHAPES);
        TwoFacedObject tfo = new TwoFacedObject((Object)this.markerType, this.markerType);
        int index = Misc.toList(ShapeUtility.SHAPES).indexOf(tfo);
        if (index >= 0) {
            shapeBox.setSelectedIndex(index);
        } else {
            shapeBox.setSelectedItem(tfo);
        }
        compMap.put("showMarkerCbx", showMarkerCbx);
        compMap.put("shapeBox", shapeBox);
        compMap.put("scaleField", scaleField);
        JPanel markerPanel = GuiUtils.left(GuiUtils.hbox((Component)showMarkerCbx, shapeBox, GuiUtils.label(" Scale: ", scaleField)));
        comps.add(GuiUtils.rLabel("Marker:"));
        comps.add(markerPanel);
        super.getPropertiesComponents(comps, compMap);
    }

    @Override
    public String getTypeName() {
        return "Text";
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        Font cfont;
        if (this.points.size() == 0) {
            return;
        }
        if (this.text == null || this.imageDisplayable == null || this.points.size() == 0) {
            return;
        }
        if (this.font == null && (cfont = this.control.getFont()) != null) {
            this.setFont(cfont);
        }
        this.lastScale = this.control.getDisplayScale();
        try {
            int bottom;
            int top;
            int right;
            int left;
            int[] pt = this.control.boxToScreen(this.getBoxPoint(0));
            int x = pt[0];
            int y = pt[1];
            this.width = this.imageDomain.getX().getLength();
            this.height = this.imageDomain.getY().getLength();
            if (this.horizontalJustification.equalsIgnoreCase(JUST_LEFT)) {
                left = x;
                right = x + this.width;
            } else if (this.horizontalJustification.equalsIgnoreCase(JUST_RIGHT)) {
                left = x - this.width;
                right = x;
            } else {
                left = x - this.width / 2;
                right = x + this.width / 2;
            }
            if (this.verticalJustification.equalsIgnoreCase(JUST_TOP)) {
                top = y;
                bottom = y + this.height;
            } else if (this.verticalJustification.equalsIgnoreCase(JUST_BOTTOM)) {
                top = y - this.height;
                bottom = y;
            } else {
                top = y - this.height / 2;
                bottom = y + this.height / 2;
            }
            this.origin = this.control.screenToBox(left, top);
            this.lr = this.control.screenToBox(right, bottom);
            this.lr[2] = this.origin[2] = (double)this.getZPosition();
            Linear2DSet domain = new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float)this.origin[0], (float)this.lr[0], this.imageDomain.getX().getLength(), (float)this.origin[1], (float)this.lr[1], this.imageDomain.getY().getLength());
            FlatField newImageData = (FlatField)GridUtil.setSpatialDomain(this.imageData, domain);
            this.imageDisplayable.setConstantPosition(this.getZPosition(), Display.ZAxis);
            this.imageDisplayable.loadData((FieldImpl)this.getTimeField(newImageData));
            this.actualPoints = this.getBoundingBox(Misc.newList(this.origin, this.lr));
        }
        catch (Exception exc) {
            LogUtil.logException("Rendering image", exc);
            return;
        }
        float[][] points = this.getPointValues(true);
        this.pointDisplayable.setPoint(points[0][0], points[1][0], points[2][0]);
        super.updateLocation();
    }

    public void setText(String value) {
        this.text = value;
        try {
            this.updateLocation();
        }
        catch (Exception exc) {
            LogUtil.logException("Setting text", exc);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setHorizontalJustification(String value) {
        this.horizontalJustification = value;
    }

    public String getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public void setVerticalJustification(String value) {
        this.verticalJustification = value;
    }

    public String getVerticalJustification() {
        return this.verticalJustification;
    }

    public void setShowMarker(boolean value) throws VisADException, RemoteException {
        boolean change = this.showMarker != value;
        this.showMarker = value;
        if (change && this.pointDisplayable != null) {
            if (this.showMarker) {
                this.addDisplayable(this.pointDisplayable);
            } else {
                this.removeDisplayable(this.pointDisplayable);
            }
        }
    }

    public boolean getShowMarker() {
        return this.showMarker;
    }

    public void setMarkerType(String value) throws VisADException, RemoteException {
        this.markerType = value;
        if (this.pointDisplayable != null) {
            VisADGeometryArray marker = ShapeUtility.createShape(this.markerType)[0];
            marker = ShapeUtility.setSize(marker, 0.4f * (float)this.markerScale * this.control.getDisplayScale());
            this.pointDisplayable.setMarker(marker);
        }
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public void setMarkerScale(double value) throws VisADException, RemoteException {
        this.markerScale = value;
        this.setMarkerType(this.markerType);
    }

    public double getMarkerScale() {
        return this.markerScale;
    }

    public void setHtmlWidth(int value) {
        this.htmlWidth = value;
    }

    public int getHtmlWidth() {
        return this.htmlWidth;
    }

    private static FlatField makeField(Image image, float alphaThreshold, boolean makeAlpha) throws IOException, VisADException {
        float[][] fArrayArray;
        RealType[] realTypeArray;
        if (image == null) {
            throw new VisADException("image cannot be null");
        }
        ImageHelper ih = new ImageHelper();
        int width = -1;
        int height = -1;
        while (true) {
            if (width < 0) {
                width = image.getWidth(ih);
            }
            if (height < 0) {
                height = image.getHeight(ih);
            }
            if (ih.badImage || width >= 0 && height >= 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (ih.badImage) {
            throw new IOException("Not an image");
        }
        int numPixels = width * height;
        int[] words = new int[numPixels];
        PixelGrabber grabber = new PixelGrabber(image.getSource(), 0, 0, width, height, words, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = grabber.getColorModel();
        float[] red_pix = new float[numPixels];
        float[] green_pix = new float[numPixels];
        float[] blue_pix = new float[numPixels];
        float[] alpha_pix = new float[numPixels];
        boolean hasAlpha = cm.hasAlpha();
        for (int i = 0; i < numPixels; ++i) {
            red_pix[i] = cm.getRed(words[i]);
            green_pix[i] = cm.getGreen(words[i]);
            blue_pix[i] = cm.getBlue(words[i]);
            alpha_pix[i] = hasAlpha ? (float)cm.getAlpha(words[i]) : 0.0f;
        }
        int alphaCnt = 0;
        boolean opaque = true;
        if (!makeAlpha && alphaThreshold >= 0.0f) {
            for (int i = 0; i < numPixels; ++i) {
                float alphaValue = hasAlpha ? (float)cm.getAlpha(words[i]) : 255.0f;
                if (!(alphaValue <= alphaThreshold)) continue;
                ++alphaCnt;
                red_pix[i] = Float.NaN;
                green_pix[i] = Float.NaN;
                blue_pix[i] = Float.NaN;
                opaque = false;
            }
        }
        RealType line = RealType.getRealType("ImageLine");
        RealType element = RealType.getRealType("ImageElement");
        RealType c_red = RealType.getRealType("Red_text");
        RealType c_green = RealType.getRealType("Green_text");
        RealType c_blue = RealType.getRealType("Blue_text");
        RealType c_alpha = RealType.getRealType("Alpha_text");
        if (makeAlpha) {
            RealType[] realTypeArray2 = new RealType[4];
            realTypeArray2[0] = c_red;
            realTypeArray2[1] = c_green;
            realTypeArray2[2] = c_blue;
            realTypeArray = realTypeArray2;
            realTypeArray2[3] = c_alpha;
        } else {
            RealType[] realTypeArray3 = new RealType[3];
            realTypeArray3[0] = c_red;
            realTypeArray3[1] = c_green;
            realTypeArray = realTypeArray3;
            realTypeArray3[2] = c_blue;
        }
        RealType[] c_all = realTypeArray;
        RealTupleType radiance = new RealTupleType(c_all);
        RealType[] domain_components = new RealType[]{element, line};
        RealTupleType image_domain = new RealTupleType(domain_components);
        Linear2DSet domain_set = new Linear2DSet((MathType)image_domain, 0.0, (float)((double)width - 1.0), width, (float)((double)height - 1.0), 0.0, height);
        FunctionType image_type = new FunctionType(image_domain, radiance);
        FlatField field = new FlatField(image_type, domain_set);
        if (makeAlpha) {
            float[][] fArrayArray2 = new float[4][];
            fArrayArray2[0] = red_pix;
            fArrayArray2[1] = green_pix;
            fArrayArray2[2] = blue_pix;
            fArrayArray = fArrayArray2;
            fArrayArray2[3] = alpha_pix;
        } else {
            float[][] fArrayArray3 = new float[3][];
            fArrayArray3[0] = red_pix;
            fArrayArray3[1] = green_pix;
            fArrayArray = fArrayArray3;
            fArrayArray3[2] = blue_pix;
        }
        float[][] samples = fArrayArray;
        try {
            field.setSamples(samples, false);
        }
        catch (RemoteException e) {
            throw new VisADException("Couldn't finish image initialization");
        }
        return field;
    }

    class ColorTableWrapper
    extends ComponentView {
        javax.swing.text.Element element;

        ColorTableWrapper(javax.swing.text.Element e) {
            super(e);
            this.element = e;
        }

        @Override
        protected Component createComponent() {
            AttributeSet attrs = this.element.getAttributes();
            Enumeration<?> names = attrs.getAttributeNames();
            String ctName = null;
            StringBuffer properties = new StringBuffer("");
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                String value = attrs.getAttribute(name).toString();
                if (value.equals("colortable") || !name.toString().equalsIgnoreCase("name")) continue;
                ctName = value;
                break;
            }
            if (ctName == null) {
                return new JLabel("No name defined");
            }
            JLabel label = TextGlyph.this.control.getControlContext().getIdv().getColorTableManager().getLabel(ctName);
            if (label == null) {
                return new JLabel("Unknown name:" + ctName);
            }
            JLabel other = new JLabel("THIS IS THE LABEL"){

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.red);
                    super.paintComponent(g);
                    System.err.println("painting label");
                }
            };
            return GuiUtils.vbox(label, other);
        }
    }
}

