/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.ShapeUtility;
import ucar.visad.WxSymbolGroup;
import ucar.visad.display.ShapeDisplayable;
import visad.DisplayEvent;
import visad.RealTuple;
import visad.RealTupleType;
import visad.VisADException;

public class SymbolGlyph
extends DrawingGlyph {
    private String defaultSymbol = "CROSS";
    private float defaultScale = 1.0f;
    public static final String ATTR_SCALE = "scale";
    public static final String ATTR_SYMBOL = "symbol";
    private ShapeDisplayable shapeDisplayable;
    private String symbol = this.defaultSymbol;
    private float scale = this.defaultScale;
    private TwoFacedObject selectedSymbol;
    private JLabel symbolLabel;
    private JComboBox symbolBox;
    private JTextField scaleFld;
    private JButton symbolBtn;

    public SymbolGlyph() {
    }

    public SymbolGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        super(control, event);
    }

    public SymbolGlyph(DrawingControl control, DisplayEvent event, String symbol) throws VisADException, RemoteException {
        this(control, event);
        this.symbol = symbol;
    }

    @Override
    public boolean isValid() {
        return this.points != null && this.points.size() >= 1;
    }

    @Override
    public DrawingGlyph handleMouseDragged(DisplayEvent event) throws VisADException, RemoteException {
        if (this.points.size() == 0) {
            this.points.add(this.getPoint(event));
        } else {
            this.points.set(0, this.getPoint(event));
        }
        this.updateLocation();
        return this;
    }

    @Override
    public DrawingGlyph handleCreation(DisplayEvent event) throws VisADException, RemoteException {
        this.handleMouseDragged(event);
        return super.handleCreation(event);
    }

    @Override
    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        System.err.println("mouse pressed");
        return this.handleMouseDragged(event);
    }

    @Override
    protected boolean applyProperties(Hashtable compMap) throws VisADException, RemoteException {
        float newScale;
        if (!super.applyProperties(compMap)) {
            return false;
        }
        if (this.selectedSymbol != null) {
            this.defaultSymbol = (String)this.selectedSymbol.getId();
        }
        String newSymbol = this.selectedSymbol != null ? (String)this.selectedSymbol.getId() : this.symbol;
        this.defaultScale = newScale = new Float(this.scaleFld.getText().trim()).floatValue();
        if (newScale != this.scale || !Misc.equals(newSymbol, this.symbol)) {
            this.symbol = newSymbol;
            this.scale = newScale;
            this.shapeDisplayable.setMarker(ShapeUtility.setSize(ShapeUtility.makeShape(this.symbol), this.scale * 0.04f * this.control.getDisplayScale()));
        }
        return true;
    }

    public void showSymbolPopup() {
        ArrayList<JMenu> items = new ArrayList<JMenu>();
        ArrayList<JMenuItem> subItems = new ArrayList<JMenuItem>();
        for (int i = 0; i < ShapeUtility.SHAPES.length; ++i) {
            subItems.add(GuiUtils.makeMenuItem(ShapeUtility.SHAPES[i].toString(), this, "setPropertySymbol", ShapeUtility.SHAPES[i]));
        }
        items.add(GuiUtils.makeMenu("General", subItems));
        List symbolGroups = WxSymbolGroup.getSymbolGroups();
        for (int i = 0; i < symbolGroups.size(); ++i) {
            WxSymbolGroup s = (WxSymbolGroup)symbolGroups.get(i);
            subItems = new ArrayList();
            List symbols = s.getSymbols();
            for (int symbolIdx = 0; symbolIdx < symbols.size(); ++symbolIdx) {
                TwoFacedObject tfo = (TwoFacedObject)symbols.get(symbolIdx);
                subItems.add(GuiUtils.makeMenuItem(tfo.toString(), this, "setPropertySymbol", tfo));
            }
            JMenu symbolMenu = GuiUtils.makeMenu(s.getName(), subItems);
            GuiUtils.limitMenuSize(symbolMenu, "Group", 20);
            items.add(symbolMenu);
        }
        GuiUtils.showPopupMenu(items, this.symbolBtn);
    }

    public void setPropertySymbol(TwoFacedObject tfo) {
        this.selectedSymbol = tfo;
        String name = tfo.toString();
        if (name.length() > 30) {
            name = name.substring(0, 29) + "...";
        }
        this.symbolLabel.setText(name);
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        super.getPropertiesComponents(comps, compMap);
        this.selectedSymbol = null;
        this.scaleFld = new JTextField("" + this.scale, 8);
        this.symbolLabel = new JLabel(" ");
        String name = WxSymbolGroup.getName(this.symbol);
        if (name == null) {
            name = this.symbol;
        }
        if (name.length() > 30) {
            name = name.substring(0, 29) + "...";
        }
        this.symbolLabel.setText(name);
        this.symbolBtn = GuiUtils.makeButton("Symbol:", this, "showSymbolPopup");
        comps.add(GuiUtils.right(this.symbolBtn));
        comps.add(GuiUtils.left(this.symbolLabel));
        comps.add(GuiUtils.rLabel("Scale:"));
        comps.add(GuiUtils.left(this.scaleFld));
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        RealTupleType mathType = null;
        if (this.isInXYSpace()) {
            mathType = RealTupleType.SpatialCartesian3DTuple;
        } else if (this.isInLatLonSpace()) {
            mathType = RealTupleType.LatitudeLongitudeAltitude;
        }
        this.shapeDisplayable = new ShapeDisplayable("symbolglyph", mathType);
        this.shapeDisplayable.setMarker(ShapeUtility.setSize(ShapeUtility.makeShape(this.symbol), this.scale * 0.04f * this.control.getDisplayScale()));
        this.shapeDisplayable.setAutoSize(true);
        this.addDisplayable(this.shapeDisplayable);
        return true;
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        super.initFromXml(control, node);
        this.scale = XmlUtil.getAttribute((Node)node, ATTR_SCALE, this.scale);
        this.symbol = XmlUtil.getAttribute((Node)node, ATTR_SYMBOL, this.defaultSymbol);
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        e.setAttribute(ATTR_SCALE, "" + this.scale);
        e.setAttribute(ATTR_SYMBOL, "" + this.symbol);
    }

    @Override
    public String getTagName() {
        return ATTR_SYMBOL;
    }

    protected int getNumInterpolationPoints() {
        return 0;
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        if (this.points.size() < 1) {
            return;
        }
        RealTupleType mathType = null;
        if (this.isInXYSpace()) {
            mathType = RealTupleType.SpatialCartesian3DTuple;
        } else if (this.isInLatLonSpace()) {
            mathType = RealTupleType.LatitudeLongitudeAltitude;
        }
        float[][] lineVals = this.getPointValues();
        RealTuple loc = new RealTuple(mathType, new double[]{lineVals[0][0], lineVals[1][0], lineVals[2][0]});
        this.shapeDisplayable.setPoint(loc);
        super.updateLocation();
    }

    @Override
    public String getTypeName() {
        return "Symbol";
    }

    @Override
    public String getDescription() {
        String name = WxSymbolGroup.getName(this.symbol);
        if (name == null) {
            name = this.symbol;
        }
        if (name.length() > 20) {
            name = name.substring(0, 19) + "...";
        }
        return this.getTypeName() + " - " + name;
    }

    public void setSymbol(String value) {
        this.symbol = value;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setDefaultSymbolSymbol(String value) {
        this.defaultSymbol = value;
    }

    public String getDefaultSymbol() {
        return this.defaultSymbol;
    }

    public void setScale(float value) {
        this.scale = value;
    }

    public float getScale() {
        return this.scale;
    }

    public void setDefaultScale(float value) {
        this.defaultScale = value;
    }

    public float getDefaultScale() {
        return this.defaultScale;
    }
}

