/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.LineGlyph;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;
import visad.DisplayEvent;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.VisADException;

public class ShapeGlyph
extends LineGlyph {
    public static final String ATTR_SHAPETYPE = "shapetype";
    public static final int SHAPE_RECTANGLE = 0;
    public static final int SHAPE_OVAL = 1;
    public static final int SHAPE_LINE = 2;
    public static final int SHAPE_DIAMOND = 3;
    public static final int SHAPE_HARROW = 4;
    public static final int SHAPE_VARROW = 5;
    public static final int[] SHAPES = new int[]{0, 1, 2, 3};
    public static final String[] SHAPE_NAMES = new String[]{"Rectangle", "Oval", "Line", "Diamond"};
    private int shapeType = 0;

    public ShapeGlyph() {
    }

    public ShapeGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        super(control, event);
    }

    public ShapeGlyph(DrawingControl control, DisplayEvent event, int shapeType) throws VisADException, RemoteException {
        this(control, event);
        this.shapeType = shapeType;
        this.setFilled(control.getFilled());
    }

    @Override
    public boolean canShowDistance() {
        return this.shapeType == 2;
    }

    @Override
    public boolean canShowArea() {
        return this.shapeType == 0;
    }

    @Override
    public boolean isValid() {
        return this.points != null && this.points.size() >= 2;
    }

    @Override
    public DrawingGlyph handleMouseDragged(DisplayEvent event) throws VisADException, RemoteException {
        if (this.points.size() == 1 || this.points.size() == 0) {
            this.points.add(this.getPoint(event));
        } else {
            this.points.set(1, this.getPoint(event));
        }
        this.updateLocation();
        return this;
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        super.initFromXml(control, node);
        String type = XmlUtil.getAttribute((Node)node, ATTR_SHAPETYPE, "Rectangle").toLowerCase();
        for (int i = 0; i < SHAPES.length; ++i) {
            if (!SHAPE_NAMES[i].toLowerCase().equals(type)) continue;
            this.shapeType = SHAPES[i];
            break;
        }
    }

    @Override
    protected boolean constrainedTo2D() {
        return true;
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        for (int i = 0; i < SHAPES.length; ++i) {
            if (SHAPES[i] != this.shapeType) continue;
            e.setAttribute(ATTR_SHAPETYPE, SHAPE_NAMES[i]);
            break;
        }
    }

    @Override
    public String getTagName() {
        return "shape";
    }

    protected int getNumInterpolationPoints() {
        return 0;
    }

    public static float[][] interpolate(int cnt, float[] startXYZ, float[] endXYZ) {
        float[][] lineVals = new float[3][cnt];
        for (int i = 0; i < 3; ++i) {
            lineVals[i] = Misc.interpolate(cnt, startXYZ[i], endXYZ[i]);
        }
        return lineVals;
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        if (this.points.size() < 2) {
            return;
        }
        RealTupleType mathType = null;
        if (this.isInXYSpace()) {
            mathType = RealTupleType.SpatialCartesian3DTuple;
        } else if (this.isInLatLonSpace()) {
            mathType = RealTupleType.LatitudeLongitudeAltitude;
        }
        float ONE_THIRD = 0.33333f;
        float TWO_THIRD = 0.66666f;
        float[][] lineVals = this.getPointValues();
        if (this.shapeType == 2) {
            if (this.getNumInterpolationPoints() > 0) {
                float[][] allLines = null;
                for (int p = 0; p < lineVals[0].length - 1; ++p) {
                    int k;
                    int j;
                    float[][] segment = ShapeGlyph.interpolate(2 + this.getNumInterpolationPoints(), new float[]{lineVals[0][p], lineVals[1][p], lineVals[2][p]}, new float[]{lineVals[0][p + 1], lineVals[1][p + 1], lineVals[2][p + 1]});
                    int newPoints = segment[0].length;
                    if (allLines == null) {
                        allLines = segment;
                        continue;
                    }
                    int numExistingPoints = allLines[0].length;
                    float[][] tmpArray = new float[3][numExistingPoints + newPoints];
                    for (j = 0; j < numExistingPoints; ++j) {
                        for (k = 0; k < 3; ++k) {
                            tmpArray[k][j] = allLines[k][j];
                        }
                    }
                    for (j = 0; j < newPoints; ++j) {
                        for (k = 0; k < 3; ++k) {
                            tmpArray[k][numExistingPoints + j] = segment[k][j];
                        }
                    }
                    allLines = tmpArray;
                }
                lineVals = allLines;
            }
            Gridded3DSet theData = new Gridded3DSet((MathType)mathType, lineVals, lineVals[0].length);
            this.lineDisplayable.setData(theData);
        } else if (this.shapeType == 0) {
            float[][] pts = ShapeGlyph.makeRectangle(lineVals);
            this.setActualPoints(pts);
            Gridded3DSet theData = new Gridded3DSet((MathType)mathType, pts, 5);
            this.lineDisplayable.setData(this.tryToFill(pts, theData));
        } else if (this.shapeType == 4) {
            float[][] pts = new float[3][8];
            for (int i = 0; i < pts[0].length; ++i) {
                pts[2][i] = lineVals[2][0];
            }
            int idxX = this.isInXYSpace() ? 0 : 1;
            int idxY = this.isInXYSpace() ? 1 : 0;
            float left = lineVals[idxX][0];
            float right = lineVals[idxX][1];
            float top = lineVals[idxY][0];
            float bottom = lineVals[idxY][1];
            float width = right - left;
            float height = bottom - top;
            pts[idxX][0] = left;
            pts[idxX][1] = left + TWO_THIRD * width;
            pts[idxX][2] = left + TWO_THIRD * width;
            pts[idxX][3] = right;
            pts[idxX][4] = left + TWO_THIRD * width;
            pts[idxX][5] = left + TWO_THIRD * width;
            pts[idxX][6] = left;
            pts[idxX][7] = left;
            pts[idxY][0] = top + ONE_THIRD * height;
            pts[idxY][1] = top + ONE_THIRD * height;
            pts[idxY][2] = top;
            pts[idxY][3] = top + 0.5f * height;
            pts[idxY][4] = bottom;
            pts[idxY][5] = top + TWO_THIRD * height;
            pts[idxY][6] = top + TWO_THIRD * height;
            pts[idxY][7] = top + ONE_THIRD * height;
            this.setActualPoints(pts);
            Gridded3DSet theData = new Gridded3DSet((MathType)mathType, pts, pts[0].length);
            this.lineDisplayable.setData(this.tryToFill(pts, theData));
        } else if (this.shapeType == 5) {
            float[][] pts = new float[3][8];
            for (int i = 0; i < pts[0].length; ++i) {
                pts[2][i] = lineVals[2][0];
            }
            int idxX = this.isInXYSpace() ? 0 : 1;
            int idxY = this.isInXYSpace() ? 1 : 0;
            float left = lineVals[idxX][0];
            float right = lineVals[idxX][1];
            float top = lineVals[idxY][0];
            float bottom = lineVals[idxY][1];
            float width = right - left;
            float height = bottom - top;
            pts[idxX][0] = left;
            pts[idxX][1] = left + 0.5f * width;
            pts[idxX][2] = right;
            pts[idxX][3] = left + TWO_THIRD * width;
            pts[idxX][4] = left + TWO_THIRD * width;
            pts[idxX][5] = left + ONE_THIRD * width;
            pts[idxX][6] = left + ONE_THIRD * width;
            pts[idxX][7] = left;
            pts[idxY][0] = top + ONE_THIRD * height;
            pts[idxY][1] = top;
            pts[idxY][2] = top + ONE_THIRD * height;
            pts[idxY][3] = top + ONE_THIRD * height;
            pts[idxY][4] = bottom;
            pts[idxY][5] = bottom;
            pts[idxY][6] = top + ONE_THIRD * height;
            pts[idxY][7] = top + ONE_THIRD * height;
            this.setActualPoints(pts);
            Gridded3DSet theData = new Gridded3DSet((MathType)mathType, pts, pts[0].length);
            this.lineDisplayable.setData(this.tryToFill(pts, theData));
        } else if (this.shapeType == 3) {
            float[][] pts = new float[3][5];
            pts[0][0] = lineVals[0][0] + (lineVals[0][1] - lineVals[0][0]) / 2.0f;
            pts[1][0] = lineVals[1][0];
            pts[2][0] = lineVals[2][0];
            pts[0][1] = lineVals[0][1];
            pts[1][1] = lineVals[1][0] + (lineVals[1][1] - lineVals[1][0]) / 2.0f;
            pts[2][1] = lineVals[2][1];
            pts[0][2] = pts[0][0];
            pts[1][2] = lineVals[1][1];
            pts[2][2] = lineVals[2][1];
            pts[0][3] = lineVals[0][0];
            pts[1][3] = pts[1][1];
            pts[2][3] = lineVals[2][0];
            for (int i = 0; i < 3; ++i) {
                pts[i][4] = pts[i][0];
            }
            this.setActualPoints(pts);
            Gridded3DSet theData = new Gridded3DSet((MathType)mathType, pts, 5);
            this.lineDisplayable.setData(this.tryToFill(pts, theData));
        } else if (this.shapeType == 1) {
            // empty if block
        }
        super.updateLocation();
    }

    public static float[][] makeRectangle(float[][] lineVals) {
        float[][] pts = new float[lineVals.length][5];
        for (int i = 0; i < lineVals.length; ++i) {
            pts[i][0] = lineVals[i][0];
            pts[i][4] = lineVals[i][0];
            pts[i][2] = lineVals[i][1];
        }
        pts[0][1] = lineVals[0][1];
        pts[1][1] = lineVals[1][0];
        pts[0][3] = lineVals[0][0];
        pts[1][3] = lineVals[1][1];
        if (lineVals.length > 2) {
            pts[2][1] = lineVals[2][0];
            pts[2][3] = lineVals[2][1];
        }
        return pts;
    }

    public static Rectangle2D.Float makeRectangle2D(float[][] pts) {
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < pts[0].length; ++i) {
            minX = Math.min(minX, pts[1][i]);
            maxX = Math.max(maxX, pts[1][i]);
            minY = Math.min(minY, pts[0][i]);
            maxY = Math.max(maxY, pts[0][i]);
        }
        float width = maxX - minX;
        float height = maxY - minY;
        return new Rectangle2D.Float(minX, minY, width, height);
    }

    @Override
    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        this.points.add(this.getPoint(event));
        return this;
    }

    @Override
    public String getTypeName() {
        return "Shape";
    }

    @Override
    public String getDescription() {
        for (int i = 0; i < SHAPES.length; ++i) {
            if (this.shapeType != SHAPES[i]) continue;
            return (this.getFilled() ? "Filled " : "") + SHAPE_NAMES[i];
        }
        return this.getTypeName();
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(int s) {
        this.shapeType = s;
    }
}

