/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.LineGlyph;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import visad.Data;
import visad.DateTime;
import visad.DisplayEvent;
import visad.Gridded3DDoubleSet;
import visad.MathType;
import visad.RealTupleType;
import visad.VisADException;
import visad.georef.EarthLocation;

public class PolyGlyph
extends LineGlyph {
    public static final int IDX_X = 0;
    public static final int IDX_Y = 1;
    public static final int IDX_Z = 2;
    public static final String ATTR_SMOOTH = "smooth";
    public static final String ATTR_EXTRUDE = "extrude";
    private boolean extrude = false;
    private boolean smooth = false;
    private Object lastPoint = null;
    private boolean closed = false;

    public PolyGlyph() {
    }

    public PolyGlyph(DrawingControl control, DisplayEvent event, boolean smooth) throws VisADException, RemoteException {
        super(control, event);
        this.smooth = smooth;
        this.setFilled(control.getFilled());
    }

    @Override
    public boolean isValid() {
        return this.points != null && this.points.size() >= 2;
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        super.getPropertiesComponents(comps, compMap);
        comps.add(new JLabel(""));
        comps.add(GuiUtils.makeButton("Start Flythrough", this, "doFlythrough"));
    }

    @Override
    public void doDeletePoint(DisplayEvent event) throws VisADException, RemoteException {
        if (this.stretchIndex < 0 || this.stretchIndex >= this.points.size()) {
            return;
        }
        this.points.remove(this.stretchIndex);
        this.updateLocation();
    }

    @Override
    public void doStretch(DisplayEvent event) throws VisADException, RemoteException {
        block5: {
            block4: {
                KeyEvent keyEvent;
                InputEvent inputEvent = event.getInputEvent();
                if (inputEvent instanceof KeyEvent && GuiUtils.isDeleteEvent(keyEvent = (KeyEvent)inputEvent)) {
                    this.doDeletePoint(event);
                    return;
                }
                if (!this.smooth) break block4;
                if ((event.getModifiers() & 2) == 0) break block5;
            }
            super.doStretch(event);
            return;
        }
        this.doInterpolatedStretch(event);
    }

    @Override
    public boolean canShowDistance() {
        return true;
    }

    @Override
    public boolean canShowArea() {
        return true;
    }

    public void doFlythrough() throws VisADException, RemoteException {
        ViewManager vm = this.control.getViewManager();
        if (vm instanceof MapViewManager) {
            if (this.isInLatLonSpace()) {
                ArrayList<FlythroughPoint> pts = new ArrayList<FlythroughPoint>();
                for (EarthLocation el : this.points) {
                    pts.add(new FlythroughPoint(el));
                }
                ((MapViewManager)vm).flythrough(pts);
            } else {
                ((MapViewManager)vm).flythrough(this.getPointValues(true));
            }
        }
        if (this.propDialog != null) {
            this.propDialog.dispose();
        }
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        super.initFromXml(control, node);
        this.smooth = XmlUtil.getAttribute((Node)node, ATTR_SMOOTH, false);
        this.extrude = XmlUtil.getAttribute((Node)node, ATTR_EXTRUDE, false);
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        e.setAttribute(ATTR_SMOOTH, "" + this.smooth);
        if (this.extrude) {
            e.setAttribute(ATTR_EXTRUDE, "" + this.extrude);
        }
    }

    @Override
    protected List getSelectionPoints() {
        if (this.actualPoints == null || !this.getSmooth()) {
            return super.getSelectionPoints();
        }
        if (this.actualPoints.size() > 2) {
            return Misc.newList(this.actualPoints.get(0), this.actualPoints.get(this.actualPoints.size() - 1));
        }
        return this.actualPoints;
    }

    @Override
    public String getTagName() {
        return "polygon";
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        if (this.points.size() == 0) {
            return;
        }
        RealTupleType mathType = null;
        double[][] lineVals = this.getPointValuesDouble();
        if (this.isInXYSpace()) {
            mathType = RealTupleType.SpatialCartesian3DTuple;
        } else if (this.isInLatLonSpace()) {
            mathType = RealTupleType.LatitudeLongitudeAltitude;
        }
        if (this.smooth) {
            // empty if block
        }
        Data theData = new Gridded3DDoubleSet((MathType)mathType, lineVals, this.points.size());
        try {
            Data filledData = this.tryToFill(Misc.toFloat(lineVals), theData);
            if (filledData != null) {
                theData = filledData;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.lineDisplayable != null && this.getTimeValues() != null && this.getTimeValues().size() > 0) {
            this.lineDisplayable.setData(this.getTimeField(theData));
        } else if (this.lineDisplayable != null) {
            this.lineDisplayable.setData(theData);
        }
        super.updateLocation();
    }

    @Override
    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        return this;
    }

    @Override
    public DrawingGlyph handleMouseDragged(DisplayEvent event) throws VisADException, RemoteException {
        if (this.smooth) {
            this.points.add(this.getPoint(event));
        } else {
            this.lastPoint = this.getPoint(event);
            if (this.points.size() < 2) {
                this.points.add(this.getPoint(event));
            } else {
                this.points.set(this.points.size() - 1, this.getPoint(event));
            }
        }
        this.updateLocation();
        return this;
    }

    @Override
    public DrawingGlyph handleMouseReleased(DisplayEvent event) throws VisADException, RemoteException {
        if (this.closed && this.points.size() > 0) {
            this.points.add(this.points.get(0));
            this.updateLocation();
        }
        return super.handleMouseReleased(event);
    }

    @Override
    public void doneBeingCreated() {
        super.doneBeingCreated();
    }

    @Override
    public DrawingGlyph handleKeyPressed(DisplayEvent event) throws VisADException, RemoteException {
        if (this.smooth || this.points.size() < 2 || this.lastPoint == null) {
            return this;
        }
        InputEvent inputEvent = event.getInputEvent();
        if (!(inputEvent instanceof KeyEvent)) {
            return this;
        }
        KeyEvent keyEvent = (KeyEvent)inputEvent;
        if (keyEvent.getKeyCode() != 32) {
            return this;
        }
        this.points.add(this.lastPoint);
        this.lastPoint = null;
        this.updateLocation();
        return this;
    }

    @Override
    public String getTypeName() {
        return this.smooth ? "Smooth Polygon" : "Polygon";
    }

    public boolean getSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean v) {
        this.smooth = v;
    }

    public void setExtrude(boolean value) {
        this.extrude = value;
    }

    public boolean getExtrude() {
        return this.extrude;
    }

    public void setClosed(boolean value) {
        this.closed = value;
    }

    public boolean getClosed() {
        return this.closed;
    }

    @Override
    protected Data getTimeField(Data data) throws VisADException, RemoteException {
        return Util.makeTimeRangeField(data, new ArrayList());
    }

    protected static void setAnimationSet(Displayable d, List timeValues) throws VisADException, RemoteException {
        ArrayList<DateTime> animationSet = null;
        if (timeValues != null) {
            DateTime startTime = (DateTime)timeValues.get(0);
            DateTime endTime = (DateTime)timeValues.get(timeValues.size() - 1);
            double newTime = startTime.getValue() + (endTime.getValue() - startTime.getValue()) / (double)timeValues.size();
            animationSet = new ArrayList<DateTime>();
            animationSet.add(new DateTime(newTime, startTime.getUnit()));
        }
        d.setOverrideAnimationSet(animationSet);
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        if (this.lineDisplayable != null && this.getTimeValues() != null && this.getTimeValues().size() > 0) {
            this.setCoordType(3);
            PolyGlyph.setAnimationSet(this.lineDisplayable, this.getTimeValues());
        }
        return true;
    }
}

