/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.media.Buffer;
import javax.media.CannotRealizeException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.display.ImageRGBDisplayable;
import visad.ConstantMap;
import visad.Display;
import visad.DisplayEvent;
import visad.FieldImpl;
import visad.FlatField;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.VisADException;
import visad.util.DataUtility;

public class MovieGlyph
extends DrawingGlyph {
    public static final String ATTR_MOVIE = "movie";
    private ImageRGBDisplayable movieDisplay;
    private Player player;
    FramePositioningControl fpc;
    FrameGrabbingControl fgc;
    private FlatField movieData;
    private boolean inError = false;
    private Dimension movieSize;
    private String movieFile = "/home/jeffmc/test.mov";
    private int frame = 0;
    private boolean runningMovie = false;
    private double seconds = 0.0;
    private double frameRate = 2.0;
    private boolean realTime = false;
    private boolean loop = true;
    private JCheckBox realTimeCbx;
    private JCheckBox loopCbx;
    private JCheckBox runningCbx;
    private int timestamp = 0;

    public MovieGlyph() {
    }

    public MovieGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        super(control, event);
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    @Override
    public boolean initFromUser(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        this.setCoordType(control.getCoordType());
        this.movieFile = FileManager.getReadFileOrURL("Movie Selection", Misc.newList(FileManager.FILTER_MOV), null);
        if (this.movieFile == null) {
            return false;
        }
        this.points.add(this.getPoint(event));
        return super.initFromUser(control, event);
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        super.initFromXml(control, node);
        this.movieFile = XmlUtil.getAttribute(node, ATTR_MOVIE);
    }

    @Override
    public DrawingGlyph handleCreation(DisplayEvent event) throws VisADException, RemoteException {
        super.handleCreation(event);
        this.points = Misc.newList(this.getPoint(event));
        this.updateLocation();
        return null;
    }

    @Override
    public void doStretch(DisplayEvent event) throws VisADException, RemoteException {
    }

    @Override
    protected boolean constrainedTo2D() {
        return true;
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        e.setAttribute(ATTR_MOVIE, this.movieFile);
    }

    @Override
    public String getTagName() {
        return ATTR_MOVIE;
    }

    @Override
    public DrawingGlyph handleMouseReleased(DisplayEvent event) throws VisADException, RemoteException {
        return null;
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        super.updateLocation();
    }

    @Override
    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        return this;
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        if (new File(this.movieFile).exists()) {
            this.movieFile = "file:" + this.movieFile;
        }
        MediaLocator mrl = null;
        mrl = new MediaLocator(this.movieFile);
        if (mrl == null) {
            LogUtil.userMessage("Can't build URL for " + this.movieFile);
            return false;
        }
        try {
            Manager.setHint((int)4, (Object)new Boolean(true));
            this.player = Manager.createRealizedPlayer((URL)new URL(this.movieFile));
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    MovieGlyph.this.initPlayer();
                }
            });
        }
        catch (CannotRealizeException cre) {
            if (this.movieFile.indexOf(".mov") >= 0) {
                LogUtil.userErrorMessage("The IDV cannot process the given Quicktime movie.\n Not all Quicktime formats are supported.");
            } else {
                LogUtil.userErrorMessage("The IDV cannot process the given movie.");
            }
            return false;
        }
        catch (Exception e) {
            LogUtil.logException("Could not create player for " + mrl, e);
            return false;
        }
        this.movieDisplay = new ImageRGBDisplayable("ImageGlyph." + typeCnt++);
        ColorTable colorTable = this.control.getRGBColorTable();
        this.movieDisplay.setRangeForColor(0.0, 255.0);
        this.movieDisplay.setColorPalette(colorTable.getAlphaTable());
        if (!this.getFullLatLon() || this.isInXYSpace()) {
            this.movieDisplay.addConstantMap(new ConstantMap(this.getZPosition(), Display.ZAxis));
        } else {
            this.movieDisplay.addConstantMap(new ConstantMap(this.getZPosition(), Display.ZAxis));
        }
        this.addDisplayable(this.movieDisplay);
        return true;
    }

    @Override
    protected boolean shouldShowColorSelector() {
        return false;
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        super.getPropertiesComponents(comps, compMap);
        this.runningCbx = new JCheckBox("Running", this.runningMovie);
        this.realTimeCbx = new JCheckBox("Real Time", this.runningMovie);
        this.loopCbx = new JCheckBox("Loop", this.loop);
        comps.add(GuiUtils.rLabel("Movie Playback:"));
        JPanel comp = GuiUtils.hbox((Component)this.runningCbx, (Component)this.realTimeCbx, this.loopCbx);
        comps.add(GuiUtils.left(comp));
        comps.add(GuiUtils.rLabel("Runtime:"));
        comps.add(new JLabel("" + (int)this.seconds + " seconds"));
    }

    @Override
    protected boolean applyProperties(Hashtable compMap) throws VisADException, RemoteException {
        if (!super.applyProperties(compMap)) {
            return false;
        }
        this.realTime = this.realTimeCbx.isSelected();
        this.loop = this.loopCbx.isSelected();
        if (this.runningMovie != this.runningCbx.isSelected()) {
            this.runningMovie = this.runningCbx.isSelected();
            if (this.runningMovie) {
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        System.err.println("running ");
                        MovieGlyph.this.runMovie(++MovieGlyph.this.timestamp);
                    }
                });
            }
        }
        return true;
    }

    private void initPlayer() {
        this.player.prefetch();
        for (int cnt = 0; (this.fpc == null || this.fgc == null) && cnt < 100; ++cnt) {
            this.fpc = (FramePositioningControl)this.player.getControl("javax.media.control.FramePositioningControl");
            this.fgc = (FrameGrabbingControl)this.player.getControl("javax.media.control.FrameGrabbingControl");
            if (this.fpc != null && this.fgc != null) break;
            Misc.sleep(100L);
        }
        if (this.fpc == null) {
            LogUtil.userErrorMessage("Failed to load movie");
            return;
        }
        this.seconds = this.player.getDuration().getSeconds();
        this.frame = 0;
        this.runMovie(++this.timestamp);
    }

    private void runMovie(int myTime) {
        this.runningMovie = true;
        while (this.runningMovie && myTime == this.timestamp && !this.getBeenRemoved()) {
            if (this.isVisible()) {
                BufferToImage bufferToImage;
                Image im;
                this.fpc.seek(this.frame);
                Buffer buf = this.fgc.grabFrame();
                if (buf == null) {
                    Misc.sleep(250L);
                    continue;
                }
                VideoFormat vf = (VideoFormat)buf.getFormat();
                if (vf == null) {
                    Misc.sleep(250L);
                    continue;
                }
                this.frame = this.realTime ? (int)((double)this.frame + (double)vf.getFrameRate() / this.frameRate) : ++this.frame;
                if ((double)((float)this.frame / vf.getFrameRate()) > this.seconds) {
                    this.frame = 0;
                    if (!this.loop) break;
                }
                if ((im = (bufferToImage = new BufferToImage(vf)).createImage(buf)) != null) {
                    this.gotImage(im);
                }
            }
            if (this.frameRate == 0.0) break;
            long ms = (long)(1000.0 / this.frameRate);
            Misc.sleep(ms);
        }
        this.runningMovie = false;
    }

    private void gotImage(Image img) {
        try {
            FlatField imageData = DataUtility.makeField(img);
            Linear2DSet imageDomain = (Linear2DSet)imageData.getDomainSet();
            int[] pt = this.control.boxToScreen(this.getBoxPoint(0));
            int x = pt[0];
            int y = pt[1];
            int width = imageDomain.getX().getLength();
            int height = imageDomain.getY().getLength();
            int left = x;
            int right = x + width;
            int top = y;
            int bottom = y + height;
            double[] origin = this.control.screenToBox(left, top);
            double[] lr = this.control.screenToBox(right, bottom);
            lr[2] = origin[2] = (double)this.getZPosition();
            Linear2DSet domain = new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float)origin[0], (float)lr[0], imageDomain.getX().getLength(), (float)origin[1], (float)lr[1], imageDomain.getY().getLength());
            FlatField newImageData = (FlatField)GridUtil.setSpatialDomain(imageData, domain);
            this.movieDisplay.loadData((FieldImpl)this.getTimeField(newImageData));
            this.actualPoints = this.getBoundingBox(Misc.newList(origin, lr));
        }
        catch (Exception exc) {
            LogUtil.logException("Rendering image", exc);
            this.player = null;
            return;
        }
    }

    @Override
    public String getTypeName() {
        return "Movie";
    }

    public void setMovieFile(String value) {
        this.movieFile = value;
    }

    public String getMovieFile() {
        return this.movieFile;
    }

    public void setLoop(boolean value) {
        this.loop = value;
    }

    public boolean getLoop() {
        return this.loop;
    }

    public void setFrameRate(double value) {
        this.frameRate = value;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setRealTime(boolean value) {
        this.realTime = value;
    }

    public boolean getRealTime() {
        return this.realTime;
    }

    public void setRunningMovie(boolean value) {
        this.runningMovie = value;
    }

    public boolean getRunningMovie() {
        return this.runningMovie;
    }
}

