/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.display.LineDrawing;
import visad.DisplayEvent;
import visad.VisADException;

public abstract class LineGlyph
extends DrawingGlyph {
    private float lineWidth = 1.0f;
    LineDrawing lineDisplayable;

    public LineGlyph() {
    }

    public LineGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        super(control, event);
        this.lineWidth = control.getLineWidth();
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        this.createDisplayable();
        return true;
    }

    protected void createDisplayable() throws VisADException, RemoteException {
        this.lineDisplayable = new LineDrawing("DrawingControl.ShapeGlyph" + uniqueCnt++);
        this.lineDisplayable.setLineWidth(this.getLineWidth());
        this.addDisplayable(this.lineDisplayable);
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        super.initFromXml(control, node);
        this.lineWidth = XmlUtil.getAttribute((Node)node, "linewidth", 1.0f);
    }

    @Override
    public boolean initFromUser(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        this.lineWidth = control.getLineWidth();
        return super.initFromUser(control, event);
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        e.setAttribute("linewidth", "" + this.lineWidth);
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
        try {
            if (this.lineDisplayable != null) {
                this.lineDisplayable.setLineWidth(this.lineWidth);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Setting color", exc);
        }
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    protected boolean applyProperties(Hashtable compMap) throws VisADException, RemoteException {
        if (!super.applyProperties(compMap)) {
            return false;
        }
        JComboBox box = (JComboBox)compMap.get("linewidth");
        if (box == null) {
            return true;
        }
        Integer value = (Integer)box.getSelectedItem();
        this.setLineWidth(value.intValue());
        return true;
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        if (this.lineDisplayable != null) {
            JComboBox box = DrawingControl.doMakeLineWidthBox((int)this.lineWidth);
            comps.add(GuiUtils.rLabel("Line Width:"));
            comps.add(GuiUtils.left(box));
            compMap.put("linewidth", box);
        }
        super.getPropertiesComponents(comps, compMap);
    }
}

