/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.imagery.ImageXmlDataSource;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.display.ImageRGBDisplayable;
import ucar.visad.display.LineDrawing;
import visad.ConstantMap;
import visad.Display;
import visad.DisplayEvent;
import visad.FlatField;
import visad.Gridded3DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.VisADException;
import visad.georef.EarthLocation;

public class ImageGlyph
extends DrawingGlyph {
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_UPDATE = "update";
    private FlatField imageData;
    private ImageRGBDisplayable imageDisplay;
    private LineDrawing outline;
    int update = -1;
    private String image;
    private double aspectRatio = 1.0;
    private double scale = 0.5;

    public ImageGlyph() {
    }

    public ImageGlyph(DrawingControl control, DisplayEvent event, String image) throws VisADException, RemoteException {
        super(control, event);
        this.image = image;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    @Override
    public boolean initFromUser(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        this.setCoordType(control.getCoordType());
        this.image = FileManager.getReadFileOrURL("Image Selection", Misc.newList(FileManager.FILTER_IMAGE), null);
        if (this.image == null) {
            return false;
        }
        this.points.add(this.getPoint(event));
        return super.initFromUser(control, event);
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        super.initFromXml(control, node);
        this.image = XmlUtil.getAttribute(node, ATTR_IMAGE);
        this.update = XmlUtil.getAttribute((Node)node, ATTR_UPDATE, -1);
    }

    @Override
    public String getExtraDescription() {
        return this.image;
    }

    @Override
    public DrawingGlyph handleCreation(DisplayEvent event) throws VisADException, RemoteException {
        super.handleCreation(event);
        return null;
    }

    @Override
    public void doMove(DisplayEvent event) throws VisADException, RemoteException {
        this.beingDragged = true;
        this.moveTo(event);
        this.updateLocation();
    }

    @Override
    public void doStretch(DisplayEvent event) throws VisADException, RemoteException {
        this.beingDragged = true;
        this.points.set(this.stretchIndex, this.getPoint(event));
        if (event.getInputEvent().isControlDown()) {
            this.updateLocation();
            return;
        }
        this.checkAspectRatio(event, this.stretchIndex);
    }

    private void checkAspectRatio(DisplayEvent event, int indexToMove) throws VisADException, RemoteException {
        double[] pt1 = this.getBoxPoint(indexToMove);
        double[] pt2 = this.getBoxPoint(indexToMove == 0 ? 1 : 0);
        double height = Math.abs(pt2[1] - pt1[1]);
        double width = this.aspectRatio * height;
        pt1[0] = pt1[0] < pt2[0] ? pt2[0] - width : pt2[0] + width;
        Object point = this.isInXYSpace() ? pt1 : (Object)this.control.boxToEarth(pt1);
        this.points.set(indexToMove, point);
        this.updateLocation();
    }

    private double[] getLowerRight() throws VisADException, RemoteException {
        Linear2DSet imageDomain = (Linear2DSet)this.imageData.getDomainSet();
        int width = imageDomain.getX().getLength();
        int height = imageDomain.getY().getLength();
        double[] origin = this.getBoxPoint(0);
        int[] tmp = this.control.boxToScreen(origin);
        tmp[0] = tmp[0] + width;
        tmp[1] = tmp[1] + height;
        double[] lr = this.control.screenToBox(tmp[0], tmp[1]);
        this.aspectRatio = Math.abs(origin[0] - lr[0]) / Math.abs(origin[1] - lr[1]);
        return lr;
    }

    @Override
    protected boolean constrainedTo2D() {
        return true;
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        e.setAttribute(ATTR_IMAGE, this.image);
        if (this.update > 0) {
            e.setAttribute(ATTR_UPDATE, "" + this.update);
        }
    }

    @Override
    public String getTagName() {
        return ATTR_IMAGE;
    }

    @Override
    public DrawingGlyph handleMouseReleased(DisplayEvent event) throws VisADException, RemoteException {
        boolean wasBeingDragged = this.beingDragged;
        super.handleMouseReleased(event);
        if (this.outline != null) {
            this.removeDisplayable(this.outline);
            this.outline = null;
        }
        if (wasBeingDragged) {
            this.updateLocation();
        }
        return null;
    }

    @Override
    public void initMove(DisplayEvent event) throws VisADException, RemoteException {
        super.initMove(event);
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        if (this.points.size() < 2) {
            return;
        }
        if (!this.beingDragged) {
            Linear2DSet newDomain;
            boolean swapY;
            double[] lr;
            Linear2DSet imageDomain = (Linear2DSet)this.imageData.getDomainSet();
            double[] origin = this.getBoxPoint(0);
            boolean swapX = origin[0] > (lr = this.getBoxPoint(1))[0];
            boolean bl = swapY = origin[1] < lr[1];
            if (!this.getFullLatLon() || this.isInXYSpace()) {
                if (swapX) {
                    this.swap(origin, lr, 0);
                }
                if (swapY) {
                    this.swap(origin, lr, 1);
                }
                this.actualPoints = this.getBoundingBox(Misc.newList(origin, lr));
                newDomain = new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float)origin[0], (float)lr[0], imageDomain.getX().getLength(), (float)origin[1], (float)lr[1], imageDomain.getY().getLength());
            } else {
                float[] originLLA = this.toLatLonAlt((EarthLocation)this.points.get(0));
                float[] lrLLA = this.toLatLonAlt((EarthLocation)this.points.get(1));
                if (swapX) {
                    this.swap(originLLA, lrLLA, 1);
                }
                if (swapY) {
                    this.swap(originLLA, lrLLA, 0);
                }
                this.actualPoints = this.control.boxToEarth(this.getBoundingBox(this.control.earthToBox(this.points)));
                newDomain = new Linear2DSet((MathType)RealTupleType.SpatialEarth2DTuple, originLLA[1], lrLLA[1], imageDomain.getX().getLength(), originLLA[0], lrLLA[0], imageDomain.getY().getLength());
                double d = this.getFixedAltitude();
            }
            FlatField newImageData = (FlatField)GridUtil.setSpatialDomain(this.imageData, newDomain);
            this.imageDisplay.loadData(newImageData);
            super.updateLocation();
            return;
        }
        if (this.outline == null) {
            this.control.setDisplayInactive();
            this.outline = new LineDrawing("DrawingControl.ImageGlyph");
            this.addDisplayable(this.outline);
            this.outline.setColor(Color.blue);
            this.control.setDisplayActive();
        }
        RealTupleType mathType = null;
        if (this.isInXYSpace()) {
            mathType = RealTupleType.SpatialCartesian3DTuple;
        } else if (this.isInLatLonSpace()) {
            mathType = RealTupleType.LatitudeLongitudeAltitude;
        }
        float[][] lineVals = this.getPointValues();
        float[][] pts = new float[3][5];
        for (int i = 0; i < 3; ++i) {
            pts[i][0] = lineVals[i][0];
            pts[i][4] = lineVals[i][0];
            pts[i][2] = lineVals[i][1];
        }
        pts[0][1] = lineVals[0][1];
        pts[1][1] = lineVals[1][0];
        pts[2][1] = lineVals[2][0];
        pts[0][3] = lineVals[0][0];
        pts[1][3] = lineVals[1][1];
        pts[2][3] = lineVals[2][1];
        this.outline.setData(new Gridded3DSet((MathType)mathType, pts, 5));
        super.updateLocation();
    }

    @Override
    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        super.handleMousePressed(event);
        return this;
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        if (this.image == null) {
            return false;
        }
        this.imageData = this.loadImage();
        if (this.imageData == null) {
            return false;
        }
        this.imageDisplay = new ImageRGBDisplayable("ImageGlyph." + typeCnt++, true);
        ColorTable colorTable = this.control.getRGBColorTable();
        this.imageDisplay.setRangeForColor(0.0, 255.0);
        this.imageDisplay.setColorPalette(colorTable.getAlphaTable());
        if (!this.getFullLatLon() || this.isInXYSpace()) {
            this.imageDisplay.addConstantMap(new ConstantMap(this.getZPosition(), Display.ZAxis));
        } else {
            this.imageDisplay.addConstantMap(new ConstantMap(this.getZPosition(), Display.ZAxis));
        }
        this.addDisplayable(this.imageDisplay);
        if (this.points.size() == 1) {
            double[] lr = this.getLowerRight();
            if (this.isInXYSpace()) {
                this.points.add(lr);
            } else {
                this.points.add(this.control.boxToEarth(lr));
            }
        }
        if (this.update > 0) {
            Misc.runInABit(this.update * 1000, new Runnable(){

                @Override
                public void run() {
                    ImageGlyph.this.doUpdate();
                }
            });
        }
        return true;
    }

    private FlatField loadImage() throws VisADException, RemoteException {
        FlatField imageData = null;
        try {
            Image theImage = ImageUtils.readImage(this.image);
            if (theImage != null) {
                if (this.scale != 1.0) {
                    theImage = theImage.getScaledInstance((int)((double)theImage.getWidth(null) * this.scale), (int)((double)theImage.getHeight(null) * this.scale), 16);
                }
                imageData = Util.makeField(theImage, 0.0f, true, true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (imageData == null) {
            LogUtil.userMessage("Unable to open image:" + this.image);
        }
        return imageData;
    }

    private void doUpdate() {
        try {
            if (!this.control.getActive() || this.getBeenRemoved()) {
                return;
            }
            FlatField tmp = this.loadImage();
            if (tmp == null) {
                return;
            }
            this.imageData = tmp;
            this.updateLocation();
            if (this.update > 0) {
                Misc.runInABit(this.update * 1000, new Runnable(){

                    @Override
                    public void run() {
                        ImageGlyph.this.doUpdate();
                    }
                });
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Updating image:" + this.image, exc);
        }
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        super.getPropertiesComponents(comps, compMap);
        comps.add(GuiUtils.rLabel(" "));
        comps.add(GuiUtils.left(GuiUtils.makeButton("Export", this, "doExport")));
    }

    public void doExport() {
        String filename = FileManager.getWriteFile(Misc.newList(ImageXmlDataSource.FILTER_XIMG, KmlDataSource.FILTER_KML), ".ximg");
        if (filename == null) {
            return;
        }
        try {
            double[] xyz1 = this.getBoxPoint(0, this.getPoints());
            double[] xyz2 = this.getBoxPoint(1, this.getPoints());
            EarthLocation el1 = this.control.boxToEarth(xyz1);
            EarthLocation el2 = this.control.boxToEarth(xyz2);
            GeoLocationInfo bounds = new GeoLocationInfo(el1.getLatLonPoint().getLatitude().getValue(), el1.getLatLonPoint().getLongitude().getValue(), el2.getLatLonPoint().getLatitude().getValue(), el2.getLatLonPoint().getLongitude().getValue());
            if (filename.endsWith(".ximg")) {
                ImageXmlDataSource.writeToFile(filename, bounds, this.image);
            } else if (filename.endsWith(".kml")) {
                KmlDataSource.writeToFile(filename, bounds, this.image);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Exporting XIMG file", exc);
        }
    }

    @Override
    public String getTypeName() {
        return "Image";
    }

    public void setImage(String value) {
        this.image = value;
    }

    public String getImage() {
        return this.image;
    }
}

