/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.Color;
import java.awt.Font;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.TextDisplayable;
import visad.Data;
import visad.DateTime;
import visad.DisplayEvent;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.Tuple;
import visad.VisADException;
import visad.georef.EarthLocationTuple;

public class HighLowGlyph
extends DrawingGlyph {
    public static final String ATTR_PRESSURE = "pressure";
    private double pressure;
    private boolean high = true;
    private TextType textType1;
    private TextType textType2;
    private TextDisplayable textDisplayable;
    private TextDisplayable pressureDisplayable;
    JTextField pressureFld;

    public HighLowGlyph() {
    }

    public HighLowGlyph(boolean high) {
        this.high = high;
    }

    public HighLowGlyph(DrawingControl control, DisplayEvent event, boolean high) {
        super(control, event);
        this.high = high;
    }

    @Override
    public String getExtraDescription() {
        return this.high ? "High " + this.pressure : "Low " + this.pressure;
    }

    @Override
    protected Data getTimeField(Data data) throws VisADException, RemoteException {
        return Util.makeTimeRangeField(data, this.isFrontDisplay() ? this.getTimeValues() : new ArrayList());
    }

    @Override
    public DrawingGlyph handleCreation(DisplayEvent event) throws VisADException, RemoteException {
        super.handleCreation(event);
        this.points = Misc.newList(this.getPoint(event));
        this.updateLocation();
        return null;
    }

    @Override
    public boolean initFromUser(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        String pressureString = GuiUtils.getInput("Please enter a pressure", "Pressure:", "1000");
        if (pressureString == null) {
            return false;
        }
        this.pressure = (pressureString = pressureString.trim()).length() == 0 ? Double.NaN : Misc.parseNumber(pressureString);
        return super.initFromUser(control, event);
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        super.initFromXml(control, node);
        this.pressure = XmlUtil.getAttribute((Node)node, ATTR_PRESSURE, 0.0);
    }

    @Override
    public String getTagName() {
        return this.high ? "high" : "low";
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        e.setAttribute(ATTR_PRESSURE, "" + this.pressure);
    }

    protected static void setAnimationSet(Displayable d, List timeValues) throws VisADException, RemoteException {
        ArrayList<DateTime> animationSet = null;
        if (timeValues != null && timeValues.size() == 2) {
            DateTime startTime = (DateTime)timeValues.get(0);
            DateTime endTime = (DateTime)timeValues.get(1);
            double newTime = startTime.getValue() + (endTime.getValue() - startTime.getValue()) / 2.0;
            animationSet = new ArrayList<DateTime>();
            animationSet.add(new DateTime(newTime, startTime.getUnit()));
        }
        d.setOverrideAnimationSet(animationSet);
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        this.setCoordType(3);
        this.textType1 = TextType.getTextType("HighLowGlyph_" + typeCnt++);
        this.textDisplayable = new TextDisplayable("HighLowGlyph_" + typeCnt++, this.textType1);
        this.textDisplayable.setJustification(TextControl.Justification.CENTER);
        this.textDisplayable.setVerticalJustification(TextControl.Justification.BOTTOM);
        this.textDisplayable.setColor(this.high ? Color.BLUE : Color.RED);
        Font font1 = new Font("times", 0, 24);
        this.textDisplayable.setFont(font1);
        this.textDisplayable.setTextSize(this.control.getDisplayScale() * ((float)font1.getSize() / 12.0f));
        this.textDisplayable.setSphere(this.control.inGlobeDisplay());
        this.addDisplayable(this.textDisplayable);
        if (this.isFrontDisplay()) {
            HighLowGlyph.setAnimationSet(this.textDisplayable, this.getTimeValues());
        }
        this.textType2 = TextType.getTextType("HighLowGlyph_" + typeCnt++);
        this.pressureDisplayable = new TextDisplayable("HighLowGlyph_" + typeCnt++, this.textType2);
        this.pressureDisplayable.setJustification(TextControl.Justification.RIGHT);
        this.pressureDisplayable.setVerticalJustification(TextControl.Justification.TOP);
        this.pressureDisplayable.setColor(this.high ? Color.BLUE : Color.RED);
        Font font2 = new Font("times", 0, 14);
        this.pressureDisplayable.setFont(font2);
        this.pressureDisplayable.setTextSize(this.control.getDisplayScale() * ((float)font2.getSize() / 12.0f));
        this.pressureDisplayable.setSphere(this.control.inGlobeDisplay());
        this.addDisplayable(this.pressureDisplayable);
        if (this.isFrontDisplay()) {
            HighLowGlyph.setAnimationSet(this.pressureDisplayable, this.getTimeValues());
        }
        return true;
    }

    @Override
    protected void setColor(Displayable displayable, Color c) throws VisADException, RemoteException {
    }

    @Override
    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        return null;
    }

    @Override
    public DrawingGlyph handleMouseMoved(DisplayEvent event) throws VisADException, RemoteException {
        this.points = Misc.newList(this.getPoint(event));
        this.updateLocation();
        return this;
    }

    @Override
    protected boolean applyProperties(Hashtable compMap) throws VisADException, RemoteException {
        if (!super.applyProperties(compMap)) {
            return false;
        }
        String txt = this.pressureFld.getText().trim();
        this.pressure = txt.length() == 0 ? Double.NaN : Misc.parseNumber(txt);
        return true;
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        super.getPropertiesComponents(new ArrayList(), compMap);
        this.getTimePropertiesComponents(comps, compMap);
        String label = this.pressure == this.pressure ? Misc.format(this.pressure) : "";
        this.pressureFld = new JTextField(label, 8);
        comps.add(GuiUtils.rLabel("Pressure:"));
        comps.add(GuiUtils.left(this.pressureFld));
    }

    @Override
    public String getTypeName() {
        return this.high ? "High" : "Low";
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        super.updateLocation();
        if (this.points.size() == 0 || this.textDisplayable == null) {
            return;
        }
        Text t1 = new Text(this.textType1, this.high ? "H" : "L");
        Tuple theData1 = null;
        Text t2 = new Text(this.textType2, this.pressure == this.pressure ? Misc.format(this.pressure) : " ");
        Tuple theData2 = null;
        if (this.isInLatLonSpace()) {
            EarthLocationTuple el = (EarthLocationTuple)this.points.get(0);
            Real alt = el.getAltitude();
            el = new EarthLocationTuple(el.getLatLonPoint(), new Real((RealType)alt.getType(), this.getFixedAltitude()));
            theData1 = new Tuple(new Data[]{el, t1});
            theData2 = new Tuple(new Data[]{el, t2});
        } else {
            theData1 = new Tuple(new Data[]{new RealTuple(RealTupleType.SpatialCartesian3DTuple, (double[])this.points.get(0)), t1});
            theData2 = new Tuple(new Data[]{new RealTuple(RealTupleType.SpatialCartesian3DTuple, (double[])this.points.get(0)), t2});
        }
        this.textDisplayable.setData(this.getTimeField(theData1));
        this.pressureDisplayable.setData(this.getTimeField(theData2));
    }

    public void setPressure(double value) {
        this.pressure = value;
    }

    public double getPressure() {
        return this.pressure;
    }

    public void setHigh(boolean value) {
        this.high = value;
    }

    public boolean getHigh() {
        return this.high;
    }
}

