/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.rmi.RemoteException;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.ArrowGlyph;
import ucar.unidata.idv.control.drawing.DrawingCommand;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.HighLowGlyph;
import ucar.unidata.idv.control.drawing.ImageGlyph;
import ucar.unidata.idv.control.drawing.MovieGlyph;
import ucar.unidata.idv.control.drawing.PolyGlyph;
import ucar.unidata.idv.control.drawing.ShapeGlyph;
import ucar.unidata.idv.control.drawing.SymbolGlyph;
import ucar.unidata.idv.control.drawing.TextGlyph;
import ucar.unidata.idv.control.drawing.TransectGlyph;
import visad.DisplayEvent;
import visad.VisADException;

public abstract class GlyphCreatorCommand
extends DrawingCommand {
    public static final DrawingCommand CMD_SMOOTHPOLYGON = new GlyphCreatorCommand("Create a polygon", "Click and drag: create a polygon", "/auxdata/ui/icons/SmoothPoly16.gif", 10){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new PolyGlyph(control, event, !control.getStraight());
        }
    };
    public static final DrawingCommand CMD_CLOSEDPOLYGON = new GlyphCreatorCommand("Create a closed polygon", "Click and drag: create a closed polygon", "/auxdata/ui/icons/Poly16.gif", 8){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            PolyGlyph glyph = new PolyGlyph(control, event, !control.getStraight());
            glyph.setClosed(true);
            return glyph;
        }
    };
    public static final DrawingCommand CMD_POLYGON = new GlyphCreatorCommand("Create a polygon", "Click and drag: create a polygon. Space key to add points", "/auxdata/ui/icons/Poly16.gif", 10){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new PolyGlyph(control, event, !control.getStraight());
        }
    };
    public static final DrawingCommand CMD_LINE = new GlyphCreatorCommand("Create a line", "Click and drag: create a line segment", "/auxdata/ui/icons/Line16.gif"){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new ShapeGlyph(control, event, 2);
        }
    };
    public static final DrawingCommand CMD_SYMBOL = new GlyphCreatorCommand("Create a symbol", "Click to create symbol", "/auxdata/ui/icons/Symbol16.gif"){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new SymbolGlyph(control, event);
        }
    };
    public static final DrawingCommand CMD_TRANSECT = new GlyphCreatorCommand("Create a transect", "Click and drag: create a transect", "/auxdata/ui/icons/Transect16.gif"){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new TransectGlyph(control, event, true);
        }
    };
    public static final DrawingCommand CMD_RECTANGLE = new GlyphCreatorCommand("Create a rectangle", "Click and drag: create a rectangle", "/auxdata/ui/icons/Rectangle16.gif", 2){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new ShapeGlyph(control, event, 0);
        }
    };
    public static final DrawingCommand CMD_ARROW = new GlyphCreatorCommand("Create an arrow", "Click and drag: create an arrow", "/auxdata/ui/icons/Arrow16.gif", 8){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new ArrowGlyph(control, event, !control.getStraight());
        }
    };
    public static final DrawingCommand CMD_HARROW = new GlyphCreatorCommand("Create a horizontal arrow", "Click and drag: create an horizontal arrow", "/auxdata/ui/icons/HorArrow16.gif", 2){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new ShapeGlyph(control, event, 4);
        }
    };
    public static final DrawingCommand CMD_VARROW = new GlyphCreatorCommand("Create a vertical arrow", "Click and drag: create a vertical arrow", "/auxdata/ui/icons/VertArrow16.gif", 2){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new ShapeGlyph(control, event, 5);
        }
    };
    public static final DrawingCommand CMD_DIAMOND = new GlyphCreatorCommand("Create a diamond", "Click and drag: create a diamond", "/auxdata/ui/icons/Diamond16.gif", 2){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new ShapeGlyph(control, event, 3);
        }
    };
    public static final DrawingCommand CMD_OVAL = new GlyphCreatorCommand("Create an oval", "Click and drag: create an oval", "/auxdata/ui/icons/Circle16.gif", 2){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new ShapeGlyph(control, event, 1);
        }
    };
    public static final DrawingCommand CMD_TEXT = new GlyphCreatorCommand("Create text", "Click to create text", "/auxdata/ui/icons/Text16.gif", false){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new TextGlyph(control, event, "");
        }
    };
    public static final DrawingCommand CMD_WAYPOINT = new GlyphCreatorCommand("Create waypoint", "Click to create waypoint", "/auxdata/ui/icons/Placemark16.gif", false){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            TextGlyph glyph = new TextGlyph(control, event, "");
            glyph.setShowMarker(true);
            return glyph;
        }
    };
    public static final DrawingCommand CMD_IMAGE = new GlyphCreatorCommand("Create image", "Click to add an image", "/auxdata/ui/icons/Image16.gif", 4, false){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new ImageGlyph(control, event, null);
        }
    };
    public static final DrawingCommand CMD_MOVIE = new GlyphCreatorCommand("Create quicktime movie", "Click to add a movie", "/auxdata/ui/icons/Movie.gif", false){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new MovieGlyph(control, event);
        }
    };
    public static final DrawingCommand CMD_HIGH = new GlyphCreatorCommand("Create high pressure symbol", "Click to create a high pressure symbol", "/auxdata/ui/icons/High16.gif", false){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new HighLowGlyph(control, event, true);
        }
    };
    public static final DrawingCommand CMD_LOW = new GlyphCreatorCommand("Create low pressure symbol", "Click to create a low pressure symbol", "/auxdata/ui/icons/Low16.gif", false){

        @Override
        public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
            return new HighLowGlyph(control, event, false);
        }
    };
    private boolean needsMouse = true;

    public GlyphCreatorCommand(String label, String message, String iconPath) {
        this(label, message, iconPath, 0);
    }

    public GlyphCreatorCommand(String label, String message, String iconPath, boolean needsMouse) {
        this(label, message, iconPath, 0, needsMouse);
    }

    public GlyphCreatorCommand(String label, String message, String iconPath, int flags) {
        super(label, message, iconPath, flags);
    }

    public GlyphCreatorCommand(String label, String message, String iconPath, int flags, boolean needsMouse) {
        super(label, message, iconPath, flags);
        this.needsMouse = needsMouse;
    }

    public boolean getNeedsMouse() {
        return this.needsMouse;
    }

    public abstract DrawingGlyph createGlyph(DrawingControl var1, DisplayEvent var2) throws VisADException, RemoteException;
}

