/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.Color;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.HighLowGlyph;
import ucar.unidata.idv.control.drawing.PolyGlyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.display.Displayable;
import ucar.visad.display.FrontDrawer;
import visad.DisplayEvent;
import visad.VisADException;
import visad.georef.EarthLocation;

public class FrontGlyph
extends PolyGlyph {
    public static final String ATTR_FRONTTYPE = "fronttype";
    public static final String ATTR_FRONTSCALE = "frontscale";
    public static final String ATTR_FRONTFLIP = "frontflip";
    private FrontDrawer frontDrawer;
    private String frontType = "COLD_FRONT";
    private Object lastPoint = null;
    private JComboBox typeBox;
    private JTextField scaleFld;
    private JCheckBox flipItCbx;
    private boolean flipIt = false;
    private double frontScale = 1.0;

    public FrontGlyph() {
    }

    public FrontGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        this(control, event, "COLD_FRONT", false);
    }

    public FrontGlyph(DrawingControl control, DisplayEvent event, String type, boolean smooth) throws VisADException, RemoteException {
        super(control, event, smooth);
        this.frontType = type;
        this.frontScale = control.getFrontScale();
    }

    protected FrontDrawer getFrontDrawer() {
        return this.frontDrawer;
    }

    @Override
    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (!super.initFinalInner()) {
            return false;
        }
        this.setCoordType(3);
        this.frontDrawer = this.doMakeFrontDrawer();
        if (this.isFrontDisplay()) {
            HighLowGlyph.setAnimationSet(this.frontDrawer, this.getTimeValues());
        }
        this.addDisplayable(this.frontDrawer);
        return true;
    }

    protected FrontDrawer doMakeFrontDrawer() throws VisADException, RemoteException {
        FrontDrawer frontDrawer = new FrontDrawer(8, this.frontType);
        frontDrawer.setFlipTheFlip(this.flipIt);
        return frontDrawer;
    }

    protected void xxxxsetColor(Displayable displayable, Color c) throws VisADException, RemoteException {
    }

    @Override
    public void doStretch(DisplayEvent event) throws VisADException, RemoteException {
        if ((event.getModifiers() & 2) != 0) {
            super.doStretch(event);
            return;
        }
        this.doInterpolatedStretch(event);
    }

    @Override
    public String getExtraDescription() {
        List times = this.getTimeValues();
        if (times != null && times.size() > 0) {
            if (times.size() == 1) {
                return "Time:" + StringUtil.join(" ", times);
            }
            return "Times:" + StringUtil.join(" ", times);
        }
        return "";
    }

    @Override
    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        if (this.shouldAddFrontProperties()) {
            TwoFacedObject selected = null;
            Vector<TwoFacedObject> items = new Vector<TwoFacedObject>();
            for (int i = 0; i < FrontDrawer.TYPES.length; ++i) {
                String type = FrontDrawer.TYPES[i];
                TwoFacedObject tfo = new TwoFacedObject((Object)FrontDrawer.getLabel(type), type);
                if (type.equals(this.frontType)) {
                    selected = tfo;
                }
                items.add(tfo);
            }
            this.flipItCbx = new JCheckBox("Flip the front orientation", this.flipIt);
            this.typeBox = new JComboBox(items);
            if (selected != null) {
                this.typeBox.setSelectedItem(selected);
            }
            comps.add(GuiUtils.rLabel("Front Type:"));
            comps.add(GuiUtils.left(this.typeBox));
            comps.add(GuiUtils.filler());
            comps.add(GuiUtils.left(this.flipItCbx));
        }
        this.scaleFld = new JTextField("" + this.frontScale, 5);
        comps.add(GuiUtils.rLabel("Scale:"));
        comps.add(GuiUtils.left(this.scaleFld));
        super.getPropertiesComponents(comps, compMap);
    }

    @Override
    protected void createDisplayable() throws VisADException, RemoteException {
    }

    protected boolean shouldAddFrontProperties() {
        return this.getCreatedByUser();
    }

    @Override
    protected boolean shouldShowColorSelector() {
        return false;
    }

    @Override
    protected boolean applyProperties(Hashtable compMap) throws VisADException, RemoteException {
        if (this.typeBox != null) {
            String newType;
            if (this.flipIt != this.flipItCbx.isSelected()) {
                this.flipIt = this.flipItCbx.isSelected();
                if (this.frontDrawer != null) {
                    this.frontDrawer.setFlipTheFlip(this.flipIt);
                }
            }
            this.frontType = newType = TwoFacedObject.getIdString(this.typeBox.getSelectedItem());
            if (this.frontDrawer != null) {
                this.frontDrawer.setFrontType(this.frontType);
            }
        }
        if (this.scaleFld != null) {
            this.frontScale = Double.parseDouble(this.scaleFld.getText().trim());
        }
        return super.applyProperties(compMap);
    }

    @Override
    public boolean canShowArea() {
        return false;
    }

    @Override
    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        super.initFromXml(control, node);
        this.frontType = XmlUtil.getAttribute((Node)node, ATTR_FRONTTYPE, this.frontType);
        this.frontScale = XmlUtil.getAttribute((Node)node, ATTR_FRONTSCALE, this.frontScale);
        this.flipIt = XmlUtil.getAttribute((Node)node, ATTR_FRONTFLIP, this.flipIt);
        this.setName(FrontDrawer.getLabel(this.frontType));
    }

    @Override
    protected void addAttributes(Element e) {
        super.addAttributes(e);
        e.setAttribute(ATTR_FRONTFLIP, Boolean.toString(this.flipIt));
        e.setAttribute(ATTR_FRONTTYPE, this.frontType);
        e.setAttribute(ATTR_FRONTSCALE, this.frontScale + "");
    }

    @Override
    public void viewpointChanged() throws VisADException, RemoteException {
        if (this.frontDrawer != null) {
            this.updateLocation();
        }
    }

    @Override
    public void projectionChanged() throws VisADException, RemoteException {
        if (this.frontDrawer != null) {
            this.updateLocation();
        }
    }

    protected void setBaseScale(DrawingControl control, FrontDrawer frontDrawer) throws VisADException, RemoteException {
        EarthLocation el1 = control.boxToEarth(new double[]{-1.0, 0.0, 0.0});
        EarthLocation el2 = control.boxToEarth(new double[]{1.0, 0.0, 0.0});
        double width = Math.abs(el1.getLatLonPoint().getLongitude().getValue() - el2.getLatLonPoint().getLongitude().getValue());
        frontDrawer.setScale(this.frontScale * (width / 4.0));
    }

    @Override
    protected List getSelectionPoints() {
        if (this.actualPoints == null) {
            return super.getSelectionPoints();
        }
        if (this.actualPoints.size() > 2) {
            return Misc.newList(this.actualPoints.get(0), this.actualPoints.get(this.actualPoints.size() - 1));
        }
        return this.actualPoints;
    }

    @Override
    protected float getDefaultZPosition() {
        return this.control == null ? -0.98f : super.getDefaultZPosition();
    }

    @Override
    public void updateLocation() throws VisADException, RemoteException {
        if (this.points.size() == 0) {
            return;
        }
        this.setBaseScale(this.control, this.frontDrawer);
        this.frontDrawer.setConstantPosition(this.control.getVerticalValue(this.getZPosition()), this.control.getNavigatedDisplay().getDisplayAltitudeType());
        this.frontDrawer.setCurve(this.getCurve(), this.isFrontDisplay() ? this.getTimeValues() : new ArrayList());
        super.updateLocation();
    }

    protected float[][] getCurve() throws VisADException, RemoteException {
        return this.getPointValues();
    }

    @Override
    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        return this;
    }

    public DrawingGlyph xxhandleMouseDragged(DisplayEvent event) throws VisADException, RemoteException {
        this.points.add(this.getPoint(event));
        this.updateLocation();
        return this;
    }

    @Override
    public String getTagName() {
        return "front";
    }

    @Override
    public String getTypeName() {
        return "Front";
    }

    public void setFrontType(String value) {
        this.frontType = value;
    }

    public String getFrontType() {
        return this.frontType;
    }

    public void setFlipIt(boolean value) {
        this.flipIt = value;
    }

    public boolean getFlipIt() {
        return this.flipIt;
    }

    public void setFrontScale(double value) {
        this.frontScale = value;
    }

    public double getFrontScale() {
        return this.frontScale;
    }
}

