/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.ShapeUtility;
import ucar.visad.UtcDate;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.Displayable;
import ucar.visad.display.SelectorPoint;
import visad.Data;
import visad.DateTime;
import visad.DelaunayCustom;
import visad.DisplayEvent;
import visad.Irregular3DSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;

public abstract class DrawingGlyph {
    protected static int uniqueCnt = 0;
    public static final String TAG_POLYGON = "polygon";
    public static final String TAG_ARROW = "arrow";
    public static final String TAG_FRONT = "front";
    public static final String TAG_TEXT = "text";
    public static final String TAG_HIGH = "high";
    public static final String TAG_LOW = "low";
    public static final String TAG_SHAPE = "shape";
    public static final String TAG_SYMBOL = "symbol";
    public static final String TAG_IMAGE = "image";
    public static final String TAG_MOVIE = "movie";
    public static final String ATTR_COLOR = "color";
    public static final String ATTR_BGCOLOR = "bgcolor";
    public static final String ATTR_FILLED = "filled";
    public static final String ATTR_PICKABLE = "pickable";
    public static final String ATTR_FULLLATLON = "fulllatlon";
    public static final String ATTR_TIMES = "times";
    public static final String ATTR_TIMEFORMAT = "timeformat";
    public static final String ATTR_ZPOSITION = "zposition";
    public static final String ATTR_COORDTYPE = "coordtype";
    public static final String ATTR_POINTS = "points";
    public static final String ATTR_LINEWIDTH = "linewidth";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_NAME = "name";
    public static final int COORD_NONE = -1;
    public static final int COORD_XYZ = 0;
    public static final int COORD_XY = 1;
    public static final int COORD_LATLONALT = 2;
    public static final int COORD_LATLON = 3;
    public static final int[] COORD_TYPES = new int[]{0, 1, 2, 3};
    public static final String[] COORD_TYPENAMES = new String[]{"XYZ", "XY", "LATLONALT", "LATLON"};
    public static final String[] COORD_LABELS = new String[]{"X/Y/Z", "X/Y", "Lat/Lon/Alt", "Lat/Lon"};
    private String name;
    private boolean beenRemoved = false;
    private boolean createdByUser = true;
    private boolean visibleFlag = true;
    public boolean oldVisibility;
    protected boolean propertiesUp = false;
    protected JDialog propDialog;
    protected JTabbedPane tabbedPane;
    JTextField nameFld;
    JCheckBox visibleCbx;
    JTextField jythonFld;
    private List tmpPoints;
    boolean beingDragged = false;
    private boolean filled = false;
    private boolean pickable = true;
    boolean editable = true;
    private boolean fullLatLon = false;
    protected List points = new ArrayList();
    protected int stretchIndex = -1;
    protected double[] firstMoveLocation;
    protected List actualPoints;
    protected EarthLocation firstMoveEarthLocation;
    static int typeCnt = 0;
    public static final int PT_X = 0;
    public static final int PT_Y = 1;
    public static final int PT_Z = 2;
    public static final int IDX_X = 0;
    public static final int IDX_Y = 1;
    public static final int IDX_Z = 2;
    public static final int IDX_LAT = 0;
    public static final int IDX_LON = 1;
    public static final int IDX_ALT = 2;
    protected int coordType = -1;
    protected float zPosition = 0.0f;
    protected CompositeDisplayable parentDisplayable;
    protected CompositeDisplayable selectionDisplayable;
    private Color color = Color.blue;
    private Color bgcolor = null;
    protected DrawingControl control;
    private List timeValues = new ArrayList();
    private Set timeSet;
    private boolean beingCreated = false;
    private GuiUtils.ColorSwatch colorSwatch;
    private GuiUtils.ColorSwatch bgColorSwatch;
    private AbstractTableModel pointTableModel;
    private double[] tmp;

    public DrawingGlyph() {
    }

    public DrawingGlyph(DrawingControl control, DisplayEvent event) {
        this(control, event, false);
    }

    public DrawingGlyph(DrawingControl control, DisplayEvent event, boolean filled) {
        this.control = control;
        this.filled = filled;
    }

    public final boolean initFinal() throws VisADException, RemoteException {
        if (!this.initFinalInner()) {
            return false;
        }
        this.updateLocation();
        return true;
    }

    protected boolean initFinalInner() throws VisADException, RemoteException {
        if (this.color != null) {
            this.setColor(this.getParent(), this.color);
        }
        return true;
    }

    public boolean initFromUser(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
        this.control = control;
        this.setCoordType(control.getCoordType());
        this.setZPosition((float)control.getZPosition());
        this.setColor(control.getColor());
        this.fullLatLon = control.getFullLatLon();
        Real time = control.getTimeForGlyph();
        if (time != null) {
            this.addTime(time);
        }
        return true;
    }

    public void initFromBundle(DrawingControl control) throws VisADException, RemoteException {
        this.control = control;
    }

    public void initFromXml(DrawingControl control, Element node) throws VisADException, RemoteException {
        List<String> timeStrings;
        this.control = control;
        this.createdByUser = false;
        this.name = XmlUtil.getAttribute((Node)node, ATTR_NAME, "");
        this.zPosition = XmlUtil.getAttribute((Node)node, ATTR_ZPOSITION, this.getDefaultZPosition());
        String coordTypeName = XmlUtil.getAttribute((Node)node, ATTR_COORDTYPE, "LATLONALT");
        coordTypeName = coordTypeName.toUpperCase();
        this.setCoordType(2);
        for (int i = 0; i < COORD_TYPES.length; ++i) {
            if (!coordTypeName.equals(COORD_TYPENAMES[i])) continue;
            this.setCoordType(COORD_TYPES[i]);
            break;
        }
        String timeAttr = XmlUtil.getAttribute((Node)node, ATTR_TIMES, (String)null);
        String timeFormat = XmlUtil.getAttribute((Node)node, ATTR_TIMEFORMAT, (String)null);
        SimpleDateFormat sdf = null;
        if (timeAttr != null && (timeStrings = StringUtil.split(timeAttr, ",", true, true)).size() > 0) {
            this.timeValues = new ArrayList();
            this.timeSet = null;
            for (int i = 0; i < timeStrings.size(); ++i) {
                String s = timeStrings.get(i).toString();
                if (s.equals("NEGATIVE_INFINITY")) {
                    this.timeValues.add(new DateTime(Double.NEGATIVE_INFINITY));
                    continue;
                }
                if (s.equals("POSITIVE_INFINITY")) {
                    this.timeValues.add(new DateTime(Double.POSITIVE_INFINITY));
                    continue;
                }
                if (timeFormat != null) {
                    if (sdf == null) {
                        sdf = new SimpleDateFormat();
                        sdf.applyPattern(timeFormat);
                        sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
                    }
                    try {
                        this.timeValues.add(new DateTime(sdf.parse(s)));
                        continue;
                    }
                    catch (Exception exc) {
                        throw new RuntimeException(exc);
                    }
                }
                this.timeValues.add(UtcDate.createDateTime(s));
            }
        }
        List<String> pointStrings = StringUtil.split(XmlUtil.getAttribute(node, ATTR_POINTS), ",", true, true);
        int stride = 3;
        if (this.coordType == 1 || this.coordType == 3) {
            stride = 2;
        }
        if (this.isInXYSpace()) {
            for (int i = 0; i < pointStrings.size(); i += stride) {
                double[] da = new double[]{Double.parseDouble(pointStrings.get(i).toString()), Double.parseDouble(pointStrings.get(i + 1).toString()), this.coordType == 1 ? (double)this.zPosition : Double.parseDouble(pointStrings.get(i + 2).toString())};
                this.points.add(da);
            }
        } else {
            this.processPointStrings(pointStrings);
        }
        this.bgcolor = XmlUtil.getAttribute((Node)node, ATTR_BGCOLOR, (Color)null);
        Color c = XmlUtil.getAttribute((Node)node, ATTR_COLOR, this.getColor());
        if (c != null) {
            this.setColor(c);
        } else if (this.colorSwatch != null) {
            this.setColor(this.colorSwatch.getSwatchColor());
        }
        this.setFilled(XmlUtil.getAttribute((Node)node, ATTR_FILLED, this.filled));
        this.setPickable(XmlUtil.getAttribute((Node)node, ATTR_PICKABLE, this.pickable));
        this.setFullLatLon(XmlUtil.getAttribute((Node)node, ATTR_FULLLATLON, this.fullLatLon));
    }

    public boolean isSelectable() {
        return true;
    }

    protected boolean isFrontDisplay() {
        return this.control.getFrontDisplay();
    }

    protected float getDefaultZPosition() {
        return this.control == null ? 0.0f : (float)this.control.getZPosition();
    }

    public boolean isValid() {
        return true;
    }

    public void processPointStrings(List pointStrings) throws VisADException, RemoteException {
        int stride = 3;
        if (this.coordType == 1 || this.coordType == 3) {
            stride = 2;
        }
        double fixedAlt = this.control != null ? this.getFixedAltitude() : 0.0;
        this.points = new ArrayList();
        for (int i = 0; i < pointStrings.size(); i += stride) {
            double lat = Misc.decodeLatLon(pointStrings.get(i).toString());
            double lon = Misc.decodeLatLon(pointStrings.get(i + 1).toString());
            double alt = this.coordType == 2 ? Double.parseDouble((String)pointStrings.get(i + 2)) : fixedAlt;
            this.points.add(new EarthLocationTuple(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), new Real(RealType.Altitude, alt)));
        }
    }

    public void processPointStrings(List pointStrings, boolean normalize360) throws VisADException, RemoteException {
        int stride = 3;
        if (this.coordType == 1 || this.coordType == 3) {
            stride = 2;
        }
        double fixedAlt = this.control != null ? this.getFixedAltitude() : 0.0;
        this.points = new ArrayList();
        for (int i = 0; i < pointStrings.size(); i += stride) {
            double lat = Misc.decodeLatLon(pointStrings.get(i).toString());
            double lon = Misc.decodeLatLon(pointStrings.get(i + 1).toString());
            if (normalize360) {
                lon = LatLonPointImpl.lonNormal360(lon);
            }
            double alt = this.coordType == 2 ? Double.parseDouble((String)pointStrings.get(i + 2)) : fixedAlt;
            this.points.add(new EarthLocationTuple(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), new Real(RealType.Altitude, alt)));
        }
    }

    public boolean mousePressed(DisplayEvent event) throws VisADException, RemoteException {
        return false;
    }

    public void setSelected(boolean selected) throws VisADException, RemoteException {
        if (!selected) {
            if (this.selectionDisplayable == null) {
                return;
            }
            this.removeDisplayable(this.selectionDisplayable);
            this.selectionDisplayable = null;
        } else {
            if (this.selectionDisplayable != null) {
                return;
            }
            this.selectionDisplayable = new CompositeDisplayable();
            VisADGeometryArray marker = ShapeUtility.setSize(ShapeUtility.createShape("FILLED_SQUARE")[0], 0.02f);
            List thePoints = this.getTrimmedSelectionPoints();
            for (int i = 0; i < thePoints.size(); ++i) {
                SelectorPoint point = new SelectorPoint("Probe point " + uniqueCnt++, RealTupleType.SpatialCartesian3DTuple);
                point.setAutoSize(true);
                point.setMarker(marker);
                point.setManipulable(false);
                point.setPointSize(this.control.getDisplayScale());
                this.selectionDisplayable.addDisplayable(point);
            }
            this.setSelectionPosition();
            this.addDisplayable(this.selectionDisplayable);
            this.selectionDisplayable.setColor(Color.magenta);
        }
    }

    protected List getSelectionPoints() {
        if (this.actualPoints != null && this.actualPoints.size() > 0) {
            return this.actualPoints;
        }
        return this.points;
    }

    private List getTrimmedSelectionPoints() {
        List pts = this.getSelectionPoints();
        if (pts.size() < 10) {
            return pts;
        }
        ArrayList newPts = new ArrayList();
        int i = 0;
        int step = pts.size() / 10;
        for (i = 0; i < pts.size(); i += step) {
            newPts.add(pts.get(i));
        }
        if (i > pts.size()) {
            newPts.add(pts.get(pts.size() - 1));
        }
        return newPts;
    }

    private void setSelectionPosition() throws VisADException, RemoteException {
        if (this.selectionDisplayable == null) {
            return;
        }
        List thePoints = this.getTrimmedSelectionPoints();
        this.getParent().setDisplayInactive();
        for (int i = 0; i < thePoints.size() && i < this.selectionDisplayable.displayableCount(); ++i) {
            double[] loc = this.getBoxPoint(i, thePoints);
            if (this.isInFlatSpace()) {
                loc[2] = this.getZPosition();
            }
            RealTuple rt = new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{loc[0], loc[1], loc[2]});
            ((SelectorPoint)this.selectionDisplayable.getDisplayable(i)).setPoint(rt);
        }
        this.getParent().setDisplayActive();
    }

    public final Element getElement(Document doc) {
        Element e = doc.createElement(this.getTagName());
        this.addAttributes(e);
        return e;
    }

    protected Data getTimeField(Data data) throws VisADException, RemoteException {
        return Util.makeTimeField(data, this.timeValues);
    }

    protected void addAttributes(Element e) {
        if (this.timeValues != null && this.timeValues.size() > 0) {
            StringBuffer timesBuff = null;
            for (int i = 0; i < this.timeValues.size(); ++i) {
                if (timesBuff == null) {
                    timesBuff = new StringBuffer();
                } else {
                    timesBuff.append(",");
                }
                timesBuff.append(this.timeValues.get(i).toString());
            }
            if (timesBuff != null) {
                e.setAttribute(ATTR_TIMES, timesBuff.toString());
            }
        }
        if (this.name != null && this.name.length() > 0) {
            e.setAttribute(ATTR_NAME, this.name);
        }
        e.setAttribute(ATTR_FILLED, "" + this.filled);
        e.setAttribute(ATTR_PICKABLE, "" + this.pickable);
        e.setAttribute(ATTR_FULLLATLON, "" + this.fullLatLon);
        XmlUtil.setAttribute(e, ATTR_COLOR, this.color);
        if (this.bgcolor != null) {
            XmlUtil.setAttribute(e, ATTR_BGCOLOR, this.bgcolor);
        }
        e.setAttribute(ATTR_ZPOSITION, "" + this.zPosition);
        for (int i = 0; i < COORD_TYPES.length; ++i) {
            if (this.coordType != COORD_TYPES[i]) continue;
            e.setAttribute(ATTR_COORDTYPE, COORD_TYPENAMES[i]);
            break;
        }
        try {
            StringBuffer ptBuff = new StringBuffer();
            float[][] pts = this.getPointValues();
            for (int i = 0; i < pts[0].length; ++i) {
                if (i > 0) {
                    ptBuff.append(",");
                }
                if (this.isInXYSpace()) {
                    ptBuff.append(pts[0][i]);
                    ptBuff.append(",");
                    ptBuff.append(pts[1][i]);
                    if (this.coordType != 0 && this.coordType != 2) continue;
                    ptBuff.append(",");
                    ptBuff.append(pts[2][i]);
                    continue;
                }
                ptBuff.append(pts[0][i]);
                ptBuff.append(",");
                ptBuff.append(pts[1][i]);
                if (this.coordType != 2) continue;
                ptBuff.append(",");
                ptBuff.append(pts[2][i]);
            }
            e.setAttribute(ATTR_POINTS, ptBuff.toString());
        }
        catch (Exception exc) {
            LogUtil.logException("Setting attributes", exc);
        }
    }

    public abstract String getTagName();

    public abstract String getTypeName();

    public String getDescription() {
        return this.getTypeName();
    }

    public String getAreaString() throws Exception {
        double squareFeet = this.getArea();
        double acres = squareFeet / 43560.0;
        double hectares = acres * 0.404685642;
        double squareKM = acres * 0.00404685642;
        double squareMiles = squareFeet / 2.78784E7;
        StringBuffer desc = new StringBuffer();
        desc.append("  ");
        if (squareKM > 1.0) {
            desc.append(this.control.getDisplayConventions().formatDistance(squareKM));
            desc.append("[km^2] ");
        } else {
            desc.append(this.control.getDisplayConventions().formatDistance(hectares));
            desc.append("[hectares] ");
        }
        desc.append("  ");
        if (squareMiles > 1.0) {
            desc.append(this.control.getDisplayConventions().formatDistance(squareMiles));
            desc.append("[miles^2] ");
        } else {
            desc.append(this.control.getDisplayConventions().formatDistance(acres));
            desc.append("[acres] ");
        }
        return desc.toString();
    }

    public String getExtraDescription() {
        if (this.canShowArea()) {
            try {
                Real distance = this.getDistance();
                StringBuffer desc = new StringBuffer();
                if (distance != null) {
                    desc.append(this.control.formatDistance(distance));
                }
                desc.append(this.getAreaString());
                return desc.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public Displayable getDisplayable() throws VisADException, RemoteException {
        return this.getParent();
    }

    protected CompositeDisplayable getParent() throws VisADException, RemoteException {
        if (this.parentDisplayable == null) {
            this.parentDisplayable = new CompositeDisplayable();
            this.parentDisplayable.setVisible(this.visibleFlag);
        }
        return this.parentDisplayable;
    }

    protected void addDisplayable(Displayable displayable) throws VisADException, RemoteException {
        this.getParent().addDisplayable(displayable);
        displayable.setUseTimesInAnimation(this.control.getUseTimesInAnimation());
        if (this.getColor() != null) {
            this.setColor(displayable, this.getColor());
        }
    }

    protected void removeDisplayable(Displayable displayable) throws VisADException, RemoteException {
        this.getParent().removeDisplayable(displayable);
        this.control.getNavigatedDisplay().removeDisplayable(displayable);
    }

    public void addTime(Real time) {
        if (this.timeValues == null) {
            this.timeValues = new ArrayList();
        }
        this.timeValues.add(time);
        this.timeSet = null;
    }

    public void setTimeValues(List value) {
        this.timeValues = value;
        this.timeSet = null;
    }

    public List getTimeValues() {
        return this.timeValues;
    }

    public void checkTimeVisibility() throws VisADException, RemoteException {
        if (this.timeValues == null || this.timeValues.size() == 0) {
            this.setVisible(true);
            return;
        }
        Animation animation = this.control.getSomeAnimation();
        if (animation == null) {
            this.setVisible(true);
            return;
        }
        Real currentAnimationTime = animation.getAniValue();
        if (currentAnimationTime == null || currentAnimationTime.isMissing()) {
            this.setVisible(true);
            return;
        }
        if (this.timeSet == null) {
            this.timeSet = Util.makeTimeSet(this.timeValues);
        }
        if (this.timeSet.getLength() == 1) {
            Real myTime = (Real)this.timeValues.get(0);
            this.setVisible(myTime.equals(currentAnimationTime));
        } else {
            float timeValueFloat = (float)currentAnimationTime.getValue(this.timeSet.getSetUnits()[0]);
            float[][] value = new float[][]{{timeValueFloat}};
            int[] index = this.timeSet.valueToIndex(value);
            this.setVisible(index[0] >= 0);
        }
    }

    public void setVisible(boolean visible) throws VisADException, RemoteException {
        if (this.parentDisplayable == null) {
            return;
        }
        this.parentDisplayable.setVisible(visible && this.visibleFlag);
    }

    public boolean isVisible() {
        if (this.parentDisplayable == null) {
            return false;
        }
        return this.parentDisplayable.getVisible();
    }

    public void checkVisibility() {
        if (this.parentDisplayable != null && !this.visibleFlag) {
            try {
                this.parentDisplayable.setVisible(false);
            }
            catch (Exception exc) {
                LogUtil.logException("Setting visibility", exc);
            }
        }
    }

    protected boolean constrainedTo2D() {
        return this.filled;
    }

    public void setCoordType(int value) {
        this.coordType = value;
        if (this.constrainedTo2D()) {
            if (this.coordType == 0) {
                this.coordType = 1;
            } else if (this.coordType == 2) {
                this.coordType = 3;
            }
        }
    }

    public int getCoordType() {
        return this.coordType;
    }

    public boolean isInXYSpace() {
        return this.coordType == 0 || this.coordType == 1;
    }

    public boolean isInFlatSpace() {
        return this.coordType == 1 || this.coordType == 3;
    }

    public boolean isInLatLonSpace() {
        return this.coordType == 2 || this.coordType == 3;
    }

    private DrawingGlyph getMe() {
        return this;
    }

    protected Object getPoint(DisplayEvent event) throws VisADException, RemoteException {
        if (this.isInXYSpace()) {
            double[] point = this.control.toBox(event);
            if (this.isInFlatSpace()) {
                point[2] = this.control.getVerticalValue(this.zPosition);
            }
            return point;
        }
        if (this.isInLatLonSpace()) {
            EarthLocation el = this.control.toEarth(event);
            LatLonPoint llp = el.getLatLonPoint();
            if (this.isInFlatSpace()) {
                Real alt = el.getAltitude();
                el = new EarthLocationTuple(el.getLatLonPoint(), new Real((RealType)alt.getType(), this.getFixedAltitude()));
            }
            return el;
        }
        System.err.println("Unknown coordinate:" + this.coordType);
        return null;
    }

    public final synchronized void setProperties() {
        if (this.propertiesUp) {
            return;
        }
        this.propertiesUp = true;
        ArrayList comps = new ArrayList();
        final Hashtable compMap = new Hashtable();
        this.getPropertiesComponents(comps, compMap);
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel propsPanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        propsPanel = GuiUtils.inset((Component)propsPanel, 5);
        this.propDialog = new JDialog((Frame)null, this.getName() + " Properties", true);
        this.tabbedPane = new JTabbedPane();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_APPLY) || cmd.equals(GuiUtils.CMD_OK)) {
                    try {
                        if (!DrawingGlyph.this.applyProperties(compMap)) {
                            return;
                        }
                        DrawingGlyph.this.checkTimeVisibility();
                        DrawingGlyph.this.updateLocation();
                        DrawingGlyph.this.control.glyphChanged(DrawingGlyph.this);
                    }
                    catch (Exception exc) {
                        LogUtil.logException("Applying properties", exc);
                    }
                }
                if (cmd.equals(GuiUtils.CMD_CANCEL) || cmd.equals(GuiUtils.CMD_OK)) {
                    DrawingGlyph.this.propDialog.dispose();
                }
            }
        };
        JPanel buttons = GuiUtils.makeApplyOkCancelButtons(listener);
        JPanel contents = GuiUtils.top(propsPanel);
        if (comps.size() > 0) {
            this.tabbedPane.add("Properties", contents);
        }
        this.tmpPoints = new ArrayList(this.points);
        this.pointTableModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public int getRowCount() {
                return DrawingGlyph.this.tmpPoints.size();
            }

            @Override
            public int getColumnCount() {
                if (DrawingGlyph.this.isInFlatSpace()) {
                    return 2;
                }
                return 3;
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                double value = Misc.parseNumber(aValue.toString().trim());
                if (DrawingGlyph.this.isInXYSpace()) {
                    double[] d = (double[])DrawingGlyph.this.tmpPoints.get(row);
                    d[col] = value;
                } else {
                    try {
                        EarthLocation el = (EarthLocation)DrawingGlyph.this.tmpPoints.get(row);
                        Real lat = el.getLatLonPoint().getLatitude();
                        Real lon = el.getLatLonPoint().getLongitude();
                        Real alt = el.getAltitude();
                        Real newLat = new Real((RealType)lat.getType(), col == 0 ? value : lat.getValue(), lat.getUnit());
                        Real newLon = new Real((RealType)lon.getType(), col == 1 ? value : lon.getValue(), lon.getUnit());
                        Real newAlt = DrawingGlyph.this.coordType == 2 ? new Real((RealType)alt.getType(), col == 2 ? value : alt.getValue(), alt.getUnit()) : alt;
                        EarthLocationTuple newEl = new EarthLocationTuple(newLat, newLon, newAlt);
                        int idx = DrawingGlyph.this.tmpPoints.indexOf(el);
                        DrawingGlyph.this.tmpPoints.remove(idx);
                        DrawingGlyph.this.tmpPoints.add(idx, newEl);
                    }
                    catch (Exception exc) {
                        LogUtil.logException("Setting points", exc);
                    }
                }
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row < DrawingGlyph.this.tmpPoints.size()) {
                    if (DrawingGlyph.this.isInXYSpace()) {
                        double[] d = (double[])DrawingGlyph.this.tmpPoints.get(row);
                        return DrawingGlyph.this.control.getDisplayConventions().format(d[column]);
                    }
                    EarthLocation el = (EarthLocation)DrawingGlyph.this.tmpPoints.get(row);
                    String value = null;
                    value = column == 0 ? DrawingGlyph.this.control.getDisplayConventions().formatLatLon(el.getLatitude()) : (column == 1 ? DrawingGlyph.this.control.getDisplayConventions().formatLatLon(el.getLongitude()) : DrawingGlyph.this.control.getDisplayConventions().formatAltitude(el.getAltitude()));
                    return value;
                }
                return "";
            }

            @Override
            public String getColumnName(int column) {
                if (DrawingGlyph.this.isInXYSpace()) {
                    if (column == 0) {
                        return "X";
                    }
                    if (column == 1) {
                        return "Y";
                    }
                    return "Z";
                }
                if (column == 0) {
                    return "Latitude";
                }
                if (column == 1) {
                    return "Longitude";
                }
                return "Altitude";
            }
        };
        JTable pointTable = new JTable(this.pointTableModel);
        JButton writeBtn = GuiUtils.makeButton("Write Points", this, "writePoints");
        int width = 300;
        int height = 200;
        JScrollPane scroller = GuiUtils.makeScrollPane(pointTable, width, height);
        scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        scroller.setPreferredSize(new Dimension(width, height));
        scroller.setMinimumSize(new Dimension(width, height));
        this.tabbedPane.add("Points", GuiUtils.centerBottom(scroller, GuiUtils.left(writeBtn)));
        this.jythonFld = new JTextField(this.control.getGlyphJython());
        JButton jythonBtn = GuiUtils.makeButton("Evaluate:", this, "evaluateJython");
        JPanel jythonPanel = GuiUtils.inset((Component)GuiUtils.top(GuiUtils.hbox(jythonBtn, this.jythonFld)), 5);
        this.propDialog.getContentPane().add(GuiUtils.centerBottom(this.tabbedPane, buttons));
        GuiUtils.showInCenter(this.propDialog);
        this.propertiesUp = false;
    }

    public void writePoints() {
        String filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_CSV, FileManager.FILTER_XLS), ".csv", null);
        if (filename == null) {
            return;
        }
        GuiUtils.exportAsCsv("", (TableModel)this.pointTableModel, filename);
    }

    public void evaluateJython() {
        this.control.evaluateGlyphJython(this, this.jythonFld.getText());
    }

    protected boolean applyProperties(Hashtable compMap) throws VisADException, RemoteException {
        this.setName(this.nameFld.getText());
        this.points = new ArrayList(this.tmpPoints);
        if (this.colorSwatch != null) {
            this.setColor(this.colorSwatch.getSwatchColor());
        }
        if (this.bgColorSwatch != null) {
            this.setBgcolor(this.bgColorSwatch.getSwatchColor());
        }
        JList timeList = (JList)compMap.get(ATTR_TIMES);
        if (this.createdByUser && timeList != null) {
            this.timeValues = Misc.toList(timeList.getSelectedValues());
            this.timeSet = null;
            this.checkVisibility();
        }
        this.setVisibleFlag(this.visibleCbx.isSelected());
        return true;
    }

    public void hide() throws VisADException, RemoteException {
        this.setVisibleFlag(false);
    }

    public void show() throws VisADException, RemoteException {
        this.setVisibleFlag(true);
    }

    protected boolean shouldShowColorSelector() {
        return true;
    }

    protected boolean shouldShowBgColorSelector() {
        return false;
    }

    protected void getPropertiesComponents(List comps, Hashtable compMap) {
        comps.add(GuiUtils.rLabel("Name:"));
        this.nameFld = new JTextField(this.getName());
        comps.add(this.nameFld);
        comps.add(GuiUtils.filler());
        this.visibleCbx = new JCheckBox("Visible", this.visibleFlag);
        comps.add(this.visibleCbx);
        if (this.shouldShowColorSelector()) {
            comps.add(GuiUtils.rLabel("Color:"));
            this.colorSwatch = new GuiUtils.ColorSwatch(this.color, "", false);
            this.colorSwatch.setMinimumSize(new Dimension(20, 20));
            this.colorSwatch.setPreferredSize(new Dimension(20, 20));
            comps.add(GuiUtils.left(this.colorSwatch));
        }
        if (this.shouldShowBgColorSelector()) {
            comps.add(GuiUtils.rLabel("BG Color:"));
            this.bgColorSwatch = new GuiUtils.ColorSwatch(this.bgcolor, "", false);
            this.bgColorSwatch.setMinimumSize(new Dimension(20, 20));
            this.bgColorSwatch.setPreferredSize(new Dimension(20, 20));
            comps.add(GuiUtils.left(this.bgColorSwatch.getPanel()));
        }
        this.getTimePropertiesComponents(comps, compMap);
        try {
            Real distance = this.getDistance();
            if (distance != null) {
                comps.add(GuiUtils.rLabel("Distance:"));
                comps.add(new JLabel(this.control.formatDistance(distance)));
            }
            if (this.canShowArea()) {
                comps.add(GuiUtils.rLabel("Area:"));
                comps.add(new JLabel(this.getAreaString()));
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Setting distance", exc);
        }
    }

    protected void getTimePropertiesComponents(List comps, Hashtable compMap) {
        try {
            ArrayList allTimes = new ArrayList();
            Object[] animTimes = this.control.getAllTimes();
            JList timeList = null;
            if (this.createdByUser && animTimes != null) {
                allTimes.addAll(Misc.toList(animTimes));
            }
            if (this.timeValues != null) {
                for (int i = 0; i < this.timeValues.size(); ++i) {
                    Object time = this.timeValues.get(i);
                    if (allTimes.contains(time)) continue;
                    allTimes.add(time);
                }
            }
            if (allTimes.size() > 0) {
                timeList = new JList();
                timeList.setListData(new Vector(allTimes));
                timeList.setSelectionMode(2);
                timeList.setVisibleRowCount(5);
                if (this.timeValues != null && this.timeValues.size() > 0) {
                    int[] selected = new int[this.timeValues.size()];
                    for (int i = 0; i < this.timeValues.size(); ++i) {
                        Object time = this.timeValues.get(i);
                        selected[i] = allTimes.indexOf(time);
                    }
                    timeList.setSelectedIndices(selected);
                }
                if (!this.createdByUser) {
                    timeList.setEnabled(false);
                }
                compMap.put(ATTR_TIMES, timeList);
                comps.add(GuiUtils.top(GuiUtils.rLabel("Times:")));
                comps.add(GuiUtils.makeScrollPane(timeList, 200, 300));
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Setting times list", exc);
        }
    }

    public Real getDistance() throws Exception {
        if (!this.isInLatLonSpace() || !this.canShowDistance()) {
            return null;
        }
        double distance = 0.0;
        float[][] pts = this.getPointValues();
        for (int i = 1; i < pts[0].length; ++i) {
            float lat1 = pts[0][i - 1];
            float lon1 = pts[1][i - 1];
            float lat2 = pts[0][i];
            float lon2 = pts[1][i];
            Bearing result = Bearing.calculateBearing(new LatLonPointImpl(lat1, lon1), new LatLonPointImpl(lat2, lon2));
            if (Double.isNaN(result.getDistance())) continue;
            distance += result.getDistance();
        }
        Unit kmUnit = Util.parseUnit("km");
        return new Real(RealType.getRealType("distance", kmUnit), distance, kmUnit);
    }

    public double getArea() throws Exception {
        double area = 0.0;
        float[][] pts = this.getLatLons(this.actualPoints != null ? this.actualPoints : this.points);
        double minLat = Double.POSITIVE_INFINITY;
        double minLon = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < pts[0].length; ++i) {
            if (i == 0) {
                minLat = pts[0][i];
                minLon = pts[1][i];
                continue;
            }
            minLat = Math.min(minLat, (double)pts[0][i]);
            minLon = Math.min(minLon, (double)pts[1][i]);
        }
        int len = pts[0].length;
        for (int i = 0; i < len; ++i) {
            double x1 = this.distance(minLat, minLon, minLat, pts[1][i]);
            double y1 = this.distance(minLat, minLon, pts[0][i], minLon);
            double x2 = this.distance(minLat, minLon, minLat, i < len - 1 ? pts[1][i + 1] : pts[1][0]);
            double y2 = this.distance(minLat, minLon, i < len - 1 ? pts[0][i + 1] : pts[0][0], minLon);
            area += x1 * y2 - x2 * y1;
        }
        area = 0.5 * area;
        return Math.abs(area);
    }

    private double distance(double lat1, double lon1, double lat2, double lon2) throws Exception {
        Bearing result = Bearing.calculateBearing(new LatLonPointImpl(lat1, lon1), new LatLonPointImpl(lat2, lon2));
        double distance = result.getDistance();
        Unit kmUnit = Util.parseUnit("km");
        Unit feetUnit = Util.parseUnit("feet");
        Real kmDistance = new Real(RealType.getRealType("distance", kmUnit), distance, kmUnit);
        return kmDistance.getValue(feetUnit);
    }

    public boolean canShowDistance() {
        return false;
    }

    public boolean canShowArea() {
        return false;
    }

    public boolean getBeingCreated() {
        return this.beingCreated;
    }

    public void doneBeingCreated() {
        this.beingCreated = false;
    }

    public DrawingGlyph handleCreation(DisplayEvent event) throws VisADException, RemoteException {
        this.beingCreated = true;
        return this;
    }

    public DrawingGlyph handleMousePressed(DisplayEvent event) throws VisADException, RemoteException {
        return this;
    }

    public DrawingGlyph handleMouseMoved(DisplayEvent event) throws VisADException, RemoteException {
        return this;
    }

    public void initStretch(DisplayEvent event) throws VisADException, RemoteException {
        this.stretchIndex = this.closestPoint(this.control.toBox(event), this.points);
    }

    public void doStretch(DisplayEvent event) throws VisADException, RemoteException {
        this.beingDragged = true;
        if (this.stretchIndex < 0 || this.stretchIndex >= this.points.size()) {
            return;
        }
        this.points.set(this.stretchIndex, this.getPoint(event));
        this.updateLocation();
    }

    public void doDeletePoint(DisplayEvent event) throws VisADException, RemoteException {
    }

    public void doMove(DisplayEvent event) throws VisADException, RemoteException {
        this.beingDragged = true;
        this.moveTo(event);
        this.updateLocation();
    }

    protected void moveTo(DisplayEvent event) throws VisADException, RemoteException {
        if (this.isInXYSpace()) {
            double[] loc = this.control.toBox(event);
            for (int i = 0; i < this.points.size(); ++i) {
                double[] point = (double[])this.points.get(i);
                point[0] = point[0] + (loc[0] - this.firstMoveLocation[0]);
                point[1] = point[1] + (loc[1] - this.firstMoveLocation[1]);
                if (this.coordType != 0) continue;
                point[2] = point[2] + (loc[2] - this.firstMoveLocation[2]);
            }
            this.firstMoveLocation = loc;
        } else if (this.isInLatLonSpace()) {
            List oldPoints = this.points;
            this.points = new ArrayList();
            EarthLocation currentLoc = this.control.toEarth(event);
            double deltaLon = currentLoc.getLatLonPoint().getLongitude().getValue() - this.firstMoveEarthLocation.getLatLonPoint().getLongitude().getValue();
            double deltaLat = currentLoc.getLatLonPoint().getLatitude().getValue() - this.firstMoveEarthLocation.getLatLonPoint().getLatitude().getValue();
            double deltaAlt = currentLoc.getAltitude().getValue() - this.firstMoveEarthLocation.getAltitude().getValue();
            for (int i = 0; i < oldPoints.size(); ++i) {
                EarthLocation el = (EarthLocation)oldPoints.get(i);
                Real lat = el.getLatLonPoint().getLatitude();
                Real lon = el.getLatLonPoint().getLongitude();
                Real alt = el.getAltitude();
                Real newLon = new Real((RealType)lon.getType(), lon.getValue() + deltaLon, lon.getUnit());
                Real newLat = new Real((RealType)lat.getType(), lat.getValue() + deltaLat, lat.getUnit());
                Real newAlt = this.coordType == 2 ? new Real((RealType)alt.getType(), alt.getValue() + deltaAlt, alt.getUnit()) : alt;
                EarthLocationTuple newEl = new EarthLocationTuple(newLat, newLon, newAlt);
                this.points.add(newEl);
            }
            this.firstMoveEarthLocation = currentLoc;
        }
    }

    protected float[][] getPointValues() throws VisADException, RemoteException {
        return this.getPointValues(false);
    }

    protected float[][] getPointValues(boolean convertToXY) throws VisADException, RemoteException {
        float[][] pts;
        block4: {
            block3: {
                pts = new float[3][this.points.size()];
                if (!this.isInXYSpace()) break block3;
                for (int i = 0; i < this.points.size(); ++i) {
                    double[] point = (double[])this.points.get(i);
                    pts[0][i] = (float)point[0];
                    pts[1][i] = (float)point[1];
                    pts[2][i] = this.coordType == 0 ? (float)point[2] : this.zPosition;
                }
                break block4;
            }
            if (!this.isInLatLonSpace()) break block4;
            double fixedAlt = this.getFixedAltitude();
            for (int i = 0; i < this.points.size(); ++i) {
                EarthLocation el = (EarthLocation)this.points.get(i);
                if (convertToXY) {
                    double[] point = this.getSpatialCoordinates(el);
                    pts[0][i] = (float)point[0];
                    pts[1][i] = (float)point[1];
                    if (this.coordType != 3) continue;
                    pts[2][i] = (float)this.control.getVerticalValue(this.zPosition);
                    continue;
                }
                pts[0][i] = (float)el.getLatLonPoint().getLatitude().getValue();
                pts[1][i] = (float)el.getLatLonPoint().getLongitude().getValue();
                pts[2][i] = this.coordType == 2 ? (float)el.getAltitude().getValue() : (float)fixedAlt;
            }
        }
        return pts;
    }

    public float[][] getLatLons() throws Exception {
        return this.getLatLons(this.actualPoints != null ? this.actualPoints : this.points);
    }

    protected float[][] getLatLons(List points) throws VisADException, RemoteException {
        float[][] pts;
        block3: {
            block2: {
                pts = new float[2][points.size()];
                if (!this.isInXYSpace()) break block2;
                for (int i = 0; i < points.size(); ++i) {
                    double[] point = (double[])points.get(i);
                    EarthLocation el = this.control.boxToEarth(new double[]{point[0], point[1], 0.0});
                    pts[0][i] = (float)el.getLatLonPoint().getLatitude().getValue();
                    pts[1][i] = (float)el.getLatLonPoint().getLongitude().getValue();
                }
                break block3;
            }
            if (!this.isInLatLonSpace()) break block3;
            for (int i = 0; i < points.size(); ++i) {
                EarthLocation el = (EarthLocation)points.get(i);
                pts[0][i] = (float)el.getLatLonPoint().getLatitude().getValue();
                pts[1][i] = (float)el.getLatLonPoint().getLongitude().getValue();
            }
        }
        return pts;
    }

    protected double[][] getPointValuesDouble() throws VisADException, RemoteException {
        return this.getPointValuesDouble(false);
    }

    protected double[][] getPointValuesDouble(boolean convertToXY) throws VisADException, RemoteException {
        double[][] pts;
        block4: {
            block3: {
                pts = new double[3][this.points.size()];
                if (!this.isInXYSpace()) break block3;
                for (int i = 0; i < this.points.size(); ++i) {
                    double[] point = (double[])this.points.get(i);
                    pts[0][i] = point[0];
                    pts[1][i] = point[1];
                    pts[2][i] = this.coordType == 0 ? point[2] : (double)this.zPosition;
                }
                break block4;
            }
            if (!this.isInLatLonSpace()) break block4;
            double fixedAlt = this.getFixedAltitude();
            for (int i = 0; i < this.points.size(); ++i) {
                EarthLocation el = (EarthLocation)this.points.get(i);
                if (convertToXY) {
                    double[] point = this.getSpatialCoordinates(el);
                    pts[0][i] = point[0];
                    pts[1][i] = point[1];
                    if (this.coordType != 3) continue;
                    pts[2][i] = this.control.getVerticalValue(this.zPosition);
                    continue;
                }
                pts[0][i] = el.getLatLonPoint().getLatitude().getValue();
                pts[1][i] = el.getLatLonPoint().getLongitude().getValue();
                pts[2][i] = this.coordType == 2 ? el.getAltitude().getValue() : fixedAlt;
            }
        }
        return pts;
    }

    protected Data tryToFill(float[][] pts, Data dflt) throws VisADException, RemoteException {
        if (!this.getFilled()) {
            return dflt;
        }
        RealTupleType mathType2D = null;
        if (this.isInXYSpace()) {
            mathType2D = RealTupleType.SpatialCartesian2DTuple;
        } else if (this.isInLatLonSpace()) {
            mathType2D = RealTupleType.LatitudeLongitudeTuple;
        }
        float[][] rect2d = new float[][]{pts[0], pts[1]};
        try {
            int[][] tri = DelaunayCustom.fill(rect2d);
            if (tri == null) {
                return dflt;
            }
            DelaunayCustom da = new DelaunayCustom(rect2d, tri);
            RealTupleType mathType3D = null;
            if (this.isInXYSpace()) {
                mathType3D = RealTupleType.SpatialCartesian3DTuple;
            } else if (this.isInLatLonSpace()) {
                mathType3D = RealTupleType.LatitudeLongitudeAltitude;
            }
            return new Irregular3DSet(mathType3D, pts, null, null, null, da);
        }
        catch (VisADException vexc) {
            return dflt;
        }
    }

    protected float[] toLatLonAlt(EarthLocation el) throws VisADException, RemoteException {
        float[] a = new float[]{(float)el.getLatLonPoint().getLatitude().getValue(), (float)el.getLatLonPoint().getLongitude().getValue(), (float)el.getAltitude().getValue()};
        return a;
    }

    protected double getFixedAltitude() throws VisADException, RemoteException {
        return this.control.boxToEarth(new double[]{0.0, 0.0, this.control.getVerticalValue(this.zPosition)}, false).getAltitude().getValue();
    }

    public void projectionChanged() throws VisADException, RemoteException {
        if (!this.isInXYSpace() || this.getFullLatLon()) {
            this.updateLocation();
        }
    }

    public void viewpointChanged() throws VisADException, RemoteException {
    }

    public void updateLocation() throws VisADException, RemoteException {
        this.setSelectionPosition();
    }

    public void initMove(DisplayEvent event) throws VisADException, RemoteException {
        this.firstMoveLocation = this.control.toBox(event);
        this.firstMoveEarthLocation = this.control.toEarth(event);
    }

    public DrawingGlyph handleKeyPressed(DisplayEvent event) throws VisADException, RemoteException {
        return this;
    }

    public DrawingGlyph handleMouseDragged(DisplayEvent event) throws VisADException, RemoteException {
        return null;
    }

    public DrawingGlyph handleMouseReleased(DisplayEvent event) throws VisADException, RemoteException {
        this.beingDragged = false;
        return null;
    }

    public void setColor(Color value) {
        try {
            this.color = value;
            if (this.color != null && this.parentDisplayable != null) {
                this.setColor(this.parentDisplayable, this.color);
                if (this.selectionDisplayable != null) {
                    this.selectionDisplayable.setColor(Color.magenta);
                }
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Setting color", exc);
        }
    }

    protected void setColor(Displayable displayable, Color c) throws VisADException, RemoteException {
        if (displayable != null && c != null) {
            displayable.setColor(c);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setBgcolor(Color value) {
        this.bgcolor = value;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    protected void setActualPoints(float[][] pts) throws VisADException, RemoteException {
        this.actualPoints = new ArrayList();
        if (this.isInXYSpace()) {
            for (int i = 0; i < pts[0].length; ++i) {
                this.actualPoints.add(new double[]{pts[0][i], pts[1][i], pts[2][i]});
            }
        } else {
            for (int i = 0; i < pts[0].length; ++i) {
                double lat = pts[0][i];
                double lon = pts[1][i];
                double alt = pts[2][i];
                this.actualPoints.add(this.makePoint(lat, lon, alt));
            }
        }
    }

    protected EarthLocation makePoint(double lat, double lon, double alt) throws VisADException, RemoteException {
        return new EarthLocationTuple(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), new Real(RealType.Altitude, alt));
    }

    public double distance(double[] location, double[] direction) throws VisADException, RemoteException {
        if (!this.isVisible() || !this.getPickable()) {
            return Double.MAX_VALUE;
        }
        if (this.actualPoints != null && this.actualPoints.size() > 0) {
            return this.distance(location, direction, this.actualPoints);
        }
        return this.distance(location, direction, this.points);
    }

    public static double distanceBetween(double[] origin, double[] loc2) {
        return Math.sqrt(DrawingGlyph.squared(origin[0] - loc2[0]) + DrawingGlyph.squared(origin[1] - loc2[1]) + DrawingGlyph.squared(origin[2] - loc2[2]));
    }

    public double distanceBetween(double[] loc1, EarthLocation el) throws VisADException, RemoteException {
        this.tmp = this.control.getNavigatedDisplay().getSpatialCoordinates(el, this.tmp);
        return DrawingGlyph.distanceBetween(loc1, this.tmp);
    }

    protected void doInterpolatedStretch(DisplayEvent event) throws VisADException, RemoteException {
        this.beingDragged = true;
        if (this.stretchIndex < 0 || this.stretchIndex >= this.points.size()) {
            return;
        }
        int startPts = this.stretchIndex - 1;
        int endPts = this.points.size() - this.stretchIndex;
        double percent = 1.0;
        if (this.isInLatLonSpace()) {
            EarthLocation newEl;
            EarthLocation pt;
            int i;
            EarthLocation oldPt = (EarthLocation)this.points.get(this.stretchIndex);
            EarthLocation newPt = (EarthLocation)this.getPoint(event);
            double deltaY = oldPt.getLatitude().getValue() - newPt.getLatitude().getValue();
            double deltaX = oldPt.getLongitude().getValue() - newPt.getLongitude().getValue();
            for (i = this.stretchIndex - 1; i >= 0 && !((percent -= 1.0 / (double)startPts) <= 0.0); --i) {
                pt = (EarthLocation)this.points.get(i);
                newEl = this.makePoint(pt.getLatitude().getValue() - deltaY * percent, pt.getLongitude().getValue() - deltaX * percent, pt.getAltitude().getValue());
                this.points.set(i, newEl);
            }
            percent = 1.0;
            for (i = this.stretchIndex + 1; i < this.points.size() && !((percent -= 1.0 / (double)endPts) <= 0.0); ++i) {
                pt = (EarthLocation)this.points.get(i);
                newEl = this.makePoint(pt.getLatitude().getValue() - deltaY * percent, pt.getLongitude().getValue() - deltaX * percent, pt.getAltitude().getValue());
                this.points.set(i, newEl);
            }
        } else {
            double[] pt;
            int i;
            double[] oldPt = (double[])this.points.get(this.stretchIndex);
            double[] newPt = (double[])this.getPoint(event);
            double deltaY = oldPt[1] - newPt[1];
            double deltaX = oldPt[0] - newPt[0];
            for (i = this.stretchIndex - 1; i >= 0 && !((percent -= 1.0 / (double)startPts) <= 0.0); --i) {
                pt = (double[])this.points.get(i);
                pt[1] = pt[1] - deltaY * percent;
                pt[0] = pt[0] - deltaX * percent;
            }
            percent = 1.0;
            for (i = this.stretchIndex + 1; i < this.points.size() && !((percent -= 1.0 / (double)endPts) <= 0.0); ++i) {
                pt = (double[])this.points.get(i);
                pt[1] = pt[1] - deltaY * percent;
                pt[0] = pt[0] - deltaX * percent;
            }
        }
        this.points.set(this.stretchIndex, this.getPoint(event));
        this.updateLocation();
    }

    private double distance(double[] origin, double[] direction, List points) throws VisADException, RemoteException {
        double minDistance = Double.MAX_VALUE;
        if (points.size() == 0) {
            return minDistance;
        }
        double o_x = origin[0];
        double o_y = origin[1];
        double o_z = origin[2];
        double d_x = direction[0];
        double d_y = direction[1];
        double d_z = direction[2];
        double minx = 0.0;
        double miny = 0.0;
        double minz = 0.0;
        double[] buff = new double[3];
        boolean isDouble = points.get(0) instanceof double[];
        for (int i = 0; i < points.size(); ++i) {
            double tmp;
            double[] d = isDouble ? (double[])points.get(i) : this.control.getNavigatedDisplay().getSpatialCoordinates((EarthLocation)points.get(i), buff);
            double x = d[0] - o_x;
            double y = d[1] - o_y;
            double z = d[2] - o_z;
            double dot = x * d_x + y * d_y + z * d_z;
            if (!((tmp = Math.sqrt((x -= dot * d_x) * x + (y -= dot * d_y) * y + (z -= dot * d_z) * z)) < minDistance)) continue;
            minDistance = tmp;
            minx = x;
            miny = y;
            minz = z;
        }
        return minDistance;
    }

    double[] getSpatialCoordinates(EarthLocation el) throws VisADException, RemoteException {
        return this.control.getNavigatedDisplay().getSpatialCoordinates(el, null);
    }

    public static double squared(double v1) {
        return v1 * v1;
    }

    public int closestPoint(double[] location, List points) throws VisADException, RemoteException {
        int minIndex;
        block4: {
            double minDistance;
            block3: {
                minIndex = -1;
                minDistance = Double.MAX_VALUE;
                if (points.size() == 0) {
                    return minIndex;
                }
                if (!(points.get(0) instanceof double[])) break block3;
                for (int i = 0; i < points.size(); ++i) {
                    double[] d = (double[])points.get(i);
                    double tmp = DrawingGlyph.distanceBetween(location, d);
                    if (!(tmp < minDistance)) continue;
                    minDistance = tmp;
                    minIndex = i;
                }
                break block4;
            }
            if (!(points.get(0) instanceof EarthLocation)) break block4;
            for (int i = 0; i < points.size(); ++i) {
                EarthLocation el = (EarthLocation)points.get(i);
                double tmp = this.distanceBetween(location, el);
                if (!(tmp < minDistance)) continue;
                minDistance = tmp;
                minIndex = i;
            }
        }
        return minIndex;
    }

    public static double[][] smoothCurve(double[][] curve, int window) {
        int length2 = curve[0].length;
        int length1 = curve.length;
        double[][] newcurve = new double[length1][length2];
        for (int i = 0; i < length2; ++i) {
            int ii;
            int win = window;
            if (i < win) {
                win = i;
            }
            if ((ii = length2 - 1 - i) < win) {
                win = ii;
            }
            double runx = 0.0;
            double runy = 0.0;
            double runz = 0.0;
            for (int j = i - win; j <= i + win; ++j) {
                runx += curve[0][j];
                runy += curve[1][j];
                if (length1 <= 2) continue;
                runz += curve[2][j];
            }
            newcurve[0][i] = runx / (double)(2 * win + 1);
            newcurve[1][i] = runy / (double)(2 * win + 1);
            if (length1 <= 2) continue;
            newcurve[2][i] = runz / (double)(2 * win + 1);
        }
        return newcurve;
    }

    public void setZPosition(float value) {
        this.zPosition = value;
    }

    public float getZPosition() {
        return this.zPosition;
    }

    public void setPoints(List value) {
        this.points = value;
    }

    public List getPoints() {
        return this.points;
    }

    protected double[] getBoxPoint(int i) throws VisADException, RemoteException {
        return this.getBoxPoint(i, this.points);
    }

    protected double[] getBoxPoint(int i, List l) throws VisADException, RemoteException {
        return this.getBoxPoint(l.get(i));
    }

    protected double[] getBoxPoint(Object point) throws VisADException, RemoteException {
        if (point instanceof double[]) {
            return (double[])point;
        }
        return this.control.earthToBox((EarthLocation)point);
    }

    protected void swap(double[] a1, double[] a2, int index) {
        double tmp = a1[index];
        a1[index] = a2[index];
        a2[index] = tmp;
    }

    protected void swap(float[] a1, float[] a2, int index) {
        float tmp = a1[index];
        a1[index] = a2[index];
        a2[index] = tmp;
    }

    protected List getBoundingBox(List points) throws VisADException, RemoteException {
        double[] min = new double[3];
        double[] max = new double[3];
        for (int i = 0; i < points.size(); ++i) {
            double[] pt = (double[])points.get(i);
            for (int j = 0; j < 3; ++j) {
                if (i == 0 || pt[j] < min[j]) {
                    min[j] = pt[j];
                }
                if (i != 0 && !(pt[j] > max[j])) continue;
                max[j] = pt[j];
            }
        }
        ArrayList<double[]> bbox = new ArrayList<double[]>();
        bbox.add(new double[]{min[0], min[1], min[2]});
        bbox.add(new double[]{max[0], min[1], min[2]});
        bbox.add(new double[]{max[0], max[1], min[2]});
        bbox.add(new double[]{min[0], max[1], min[2]});
        return bbox;
    }

    public void setFilled(boolean value) {
        this.filled = value;
    }

    public boolean getFilled() {
        return this.filled;
    }

    public void setPickable(boolean value) {
        this.pickable = value;
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public void setFullLatLon(boolean value) {
        this.fullLatLon = value;
    }

    public boolean getFullLatLon() {
        return this.fullLatLon;
    }

    public void setBeenRemoved(boolean value) {
        this.beenRemoved = value;
    }

    public boolean getBeenRemoved() {
        return this.beenRemoved;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setEditable(boolean value) {
        this.editable = value;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setVisibleFlag(boolean value) throws VisADException, RemoteException {
        this.visibleFlag = value;
        this.setVisible(value);
    }

    public boolean getVisibleFlag() {
        return this.visibleFlag;
    }

    public boolean getIsRaster() {
        return false;
    }

    public void setCreatedByUser(boolean value) {
        this.createdByUser = value;
    }

    public boolean getCreatedByUser() {
        return this.createdByUser;
    }
}

