/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.drawing;

import java.rmi.RemoteException;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.FrontGlyph;
import ucar.unidata.util.LogUtil;
import ucar.visad.display.FrontDrawer;
import visad.DisplayEvent;
import visad.VisADException;

public class ArrowGlyph
extends FrontGlyph {
    public ArrowGlyph() {
    }

    public ArrowGlyph(DrawingControl control, DisplayEvent event, boolean smooth) throws VisADException, RemoteException {
        super(control, event, "UPPER_LEVEL_JET", smooth);
    }

    @Override
    protected FrontDrawer doMakeFrontDrawer() throws VisADException, RemoteException {
        return new FrontDrawer(8, "UPPER_LEVEL_JET", false);
    }

    @Override
    public void setLineWidth(float value) {
        try {
            if (this.getFrontDrawer() != null) {
                this.getFrontDrawer().setLineWidth(value);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Setting line width", exc);
        }
    }

    @Override
    protected float[][] getCurve() throws VisADException, RemoteException {
        float[][] curve = this.getLatLons(this.points);
        int length = curve[0].length;
        float[][] inverse = new float[curve.length][length];
        for (int i = 0; i < curve.length; ++i) {
            for (int j = 0; j < curve[i].length; ++j) {
                inverse[i][length - j - 1] = curve[i][j];
            }
        }
        return inverse;
    }

    @Override
    protected boolean shouldAddFrontProperties() {
        return false;
    }

    @Override
    protected boolean shouldShowColorSelector() {
        return true;
    }

    @Override
    public String getTagName() {
        return "arrow";
    }

    @Override
    public String getTypeName() {
        return "Arrow";
    }
}

