/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.general.Series;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.RectangleEdge;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.chart.ChartHolder;
import ucar.unidata.idv.control.chart.ChartManager;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.ui.symbol.WindBarbSymbol;
import ucar.unidata.util.Misc;
import ucar.visad.quantities.CommonUnits;
import visad.Unit;
import visad.VisADException;

public abstract class XYChartManager
extends ChartManager {
    private XYAnnotation emptyChartAnnotation;
    private String emptyChartLabel = "";

    public XYChartManager() {
    }

    public XYChartManager(DisplayControlImpl control) {
        super(control);
    }

    public XYChartManager(DisplayControlImpl control, String chartName) {
        super(control, chartName);
    }

    protected XYItemRenderer getRenderer(LineState lineState) {
        return this.getRenderer(lineState, true);
    }

    protected XYItemRenderer getRenderer(LineState lineState, boolean showLegend) {
        int lineType = lineState.getLineType();
        MyXYAreaRenderer renderer = null;
        if (lineType == 6) {
            return new MyXYBarRenderer();
        }
        if (lineType == 1) {
            renderer = new MyXYAreaRenderer(lineState, 1, showLegend);
        } else {
            if (lineType == 2) {
                return new MyXYAreaRenderer(lineState, 2, showLegend);
            }
            if (lineType == 4) {
                return new MyXYAreaRenderer(lineState, 4, showLegend);
            }
            renderer = lineType == 5 ? new MyXYAreaRenderer(lineState, 5, showLegend) : new MyXYAreaRenderer(lineState, 3);
        }
        Shape shape = lineState.getPaintShape();
        if (shape != null) {
            renderer.setShape(shape);
            renderer.setBaseShape(shape);
            if (renderer instanceof XYAreaRenderer) {
                ((XYAreaRenderer)renderer).setLegendArea(shape);
            }
        }
        return renderer;
    }

    public void setEmptyChartLabel(String label) {
        boolean signalChange;
        boolean bl = signalChange = !Misc.equals(this.emptyChartLabel, label);
        if (this.emptyChartAnnotation == null) {
            signalChange = true;
            this.emptyChartAnnotation = new XYAnnotation(){

                public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
                    if (!XYChartManager.this.hasStuff()) {
                        g2.setColor(Color.black);
                        g2.drawString(XYChartManager.this.emptyChartLabel, 100, 50);
                    }
                }

                public void addChangeListener(AnnotationChangeListener arg0) {
                }

                public void removeChangeListener(AnnotationChangeListener arg0) {
                }
            };
            for (int plotIdx = 0; plotIdx < this.chartHolders.size(); ++plotIdx) {
                ChartHolder chartHolder = (ChartHolder)this.chartHolders.get(plotIdx);
                ((XYPlot)chartHolder.getPlot()).addAnnotation(this.emptyChartAnnotation);
            }
        }
        this.emptyChartLabel = label;
        if (signalChange) {
            this.signalChartChanged();
        }
    }

    @Override
    protected void addChart(ChartHolder chartHolder) {
        super.addChart(chartHolder);
        if (this.emptyChartAnnotation != null) {
            ((XYPlot)chartHolder.getPlot()).addAnnotation(this.emptyChartAnnotation);
        }
    }

    public class MyXYPlot
    extends XYPlot {
        public MyXYPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
            super(dataset, domainAxis, rangeAxis, renderer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
            block5: {
                try {
                    if (XYChartManager.this.getSettingData()) break block5;
                    Object object = XYChartManager.this.getMutex();
                    synchronized (object) {
                        super.draw(g2, area, anchor, parentState, info);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    protected static class WindbarbRenderer
    extends AbstractXYItemRenderer {
        WindBarbSymbol.WindDrawer drawer;
        Series speedSeries;
        Series dirSeries;
        Unit speedUnit;
        LineState lineState;
        boolean polarWind = true;
        boolean isSouth = false;

        public WindbarbRenderer(LineState lineState, Series speedSeries, Series dirSeries, Unit unit) {
            this(lineState, speedSeries, dirSeries, unit, true);
        }

        public WindbarbRenderer(LineState lineState, Series speedSeries, Series dirSeries, Unit unit, boolean polarWind) {
            this.lineState = lineState;
            this.speedUnit = unit;
            this.speedSeries = speedSeries;
            this.dirSeries = dirSeries;
            this.polarWind = polarWind;
        }

        public LegendItem getLegendItem(int datasetIndex, int series) {
            GeneralPath path = new GeneralPath();
            path.moveTo(0.0f, 0.0f);
            path.lineTo(10.0f, 10.0f);
            path.moveTo(0.0f, 0.0f);
            path.lineTo(3.0f, -3.0f);
            path.moveTo(3.0f, 3.0f);
            path.lineTo(5.0f, 1.0f);
            path.closePath();
            LegendItem l = super.getLegendItem(datasetIndex, series);
            l = new LegendItem(l.getLabel(), l.getDescription(), l.getToolTipText(), l.getURLText(), true, (Shape)path, false, (Paint)Color.black, true, (Paint)Color.black, l.getOutlineStroke(), false, l.getLine(), l.getLineStroke(), (Paint)Color.black);
            return l;
        }

        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            int yPos;
            int xPos;
            double x;
            if (!this.getItemVisible(series, item)) {
                return;
            }
            if (item >= this.speedSeries.getItemCount()) {
                return;
            }
            if (item >= this.dirSeries.getItemCount()) {
                return;
            }
            double speed = Double.NaN;
            double dir = Double.NaN;
            boolean isXY = this.speedSeries instanceof XYSeries;
            if (isXY) {
                speed = ((XYSeries)this.speedSeries).getY(item).doubleValue();
                dir = ((XYSeries)this.dirSeries).getY(item).doubleValue();
            } else {
                speed = ((TimeSeries)this.speedSeries).getValue(item).doubleValue();
                dir = ((TimeSeries)this.dirSeries).getValue(item).doubleValue();
            }
            if (!this.polarWind) {
                double u = speed;
                double v = dir;
                speed = Math.sqrt(u * u + v * v);
                dir = Math.toDegrees(Math.atan2(-u, -v));
                if (dir < 0.0) {
                    dir += 360.0;
                }
            }
            double d = x = isXY ? dataset.getYValue(series, item) : dataset.getXValue(series, item);
            if (Double.isNaN(x) || Double.isNaN(speed) || Double.isNaN(dir)) {
                return;
            }
            int top = (int)dataArea.getY();
            int bottom = (int)((double)top + dataArea.getHeight());
            int left = (int)dataArea.getX();
            int right = (int)((double)left + dataArea.getWidth());
            int midW = left + (right - left) / 2;
            int mid = top + (bottom - top) / 2;
            int w = 20;
            int w2 = w / 2;
            int wiggle = 15;
            if (isXY) {
                double y = dataset.getXValue(series, item);
                int horizontalPosition = this.lineState.getHorizontalPosition();
                int hAnchor = horizontalPosition == 0 ? left + wiggle : (horizontalPosition == 1 ? midW : (horizontalPosition == 2 ? right - wiggle : midW));
                xPos = hAnchor;
                yPos = (int)domainAxis.valueToJava2D(y, dataArea, plot.getDomainAxisEdge());
            } else {
                int sX = (int)domainAxis.valueToJava2D(x, dataArea, plot.getDomainAxisEdge());
                int sY = (int)rangeAxis.valueToJava2D(speed, dataArea, plot.getRangeAxisEdge());
                int verticalPosition = this.lineState.getVerticalPosition();
                int vAnchor = verticalPosition == 0 ? top + wiggle : (verticalPosition == 1 ? mid - w2 : (verticalPosition == 2 ? bottom - w - wiggle : sY));
                xPos = sX - w2;
                yPos = vAnchor;
            }
            try {
                speed = CommonUnits.KNOT.toThis(speed, this.speedUnit);
            }
            catch (VisADException vex) {
                System.err.println("error:" + vex);
            }
            if (this.drawer == null) {
                this.drawer = new WindBarbSymbol.WindDrawer(this.isSouth);
            }
            try {
                g2.setColor(Color.black);
                g2.setStroke(new BasicStroke());
                this.drawer.draw(g2, xPos, yPos, w, w, speed, dir);
            }
            catch (Exception exc) {
                System.err.println("oops:" + exc);
            }
        }
    }

    protected static class TextRenderer
    extends AbstractXYItemRenderer {
        List textList;
        LineState lineState;

        public TextRenderer(List textList, LineState lineState) {
            this.textList = textList;
            this.lineState = lineState;
        }

        public LegendItem getLegendItem(int datasetIndex, int series) {
            LegendItem l = super.getLegendItem(datasetIndex, series);
            l = new LegendItem(l.getLabel(), l.getDescription(), l.getToolTipText(), l.getURLText(), true, (Shape)new Rectangle(0, 0, 8, 8), true, this.getSeriesPaint(series), false, (Paint)Color.black, l.getOutlineStroke(), false, l.getLine(), l.getLineStroke(), (Paint)Color.black);
            return l;
        }

        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            if (!this.getItemVisible(series, item)) {
                return;
            }
            String text = (String)this.textList.get(item);
            double x = dataset.getXValue(series, item);
            if (Double.isNaN(x)) {
                return;
            }
            int sX = (int)domainAxis.valueToJava2D(x, dataArea, plot.getDomainAxisEdge());
            try {
                int top = (int)dataArea.getY();
                int bottom = (int)((double)top + dataArea.getHeight());
                int mid = top + (bottom - top) / 2;
                FontMetrics fm = g2.getFontMetrics();
                int width = fm.stringWidth(text);
                int height = fm.getMaxDescent() + fm.getMaxAscent();
                int verticalPosition = this.lineState.getVerticalPosition();
                int vAnchor = verticalPosition == 0 ? top + height : (verticalPosition == 1 ? mid - height / 2 : bottom);
                g2.setPaint(this.getSeriesPaint(series));
                g2.drawString(text, sX - width / 2, vAnchor);
            }
            catch (Exception exc) {
                System.err.println("oops:" + exc);
            }
        }
    }

    protected static class CloudCoverageRenderer
    extends AbstractXYItemRenderer {
        private double scale = 0.0;
        LineState lineState;

        public CloudCoverageRenderer(LineState lineState, double scale) {
            this.lineState = lineState;
            this.scale = scale;
        }

        public LegendItem getLegendItem(int datasetIndex, int series) {
            GeneralPath path = new GeneralPath();
            path.append(new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0), false);
            path.moveTo(5.0f, 0.0f);
            path.lineTo(5.0f, 10.0f);
            path.closePath();
            LegendItem l = super.getLegendItem(datasetIndex, series);
            l = new LegendItem(l.getLabel(), l.getDescription(), l.getToolTipText(), l.getURLText(), true, (Shape)path, false, (Paint)Color.black, true, (Paint)Color.black, l.getOutlineStroke(), false, l.getLine(), l.getLineStroke(), (Paint)Color.black);
            return l;
        }

        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            if (!this.getItemVisible(series, item)) {
                return;
            }
            double x = dataset.getXValue(series, item);
            double value = dataset.getYValue(series, item);
            if (this.scale != 0.0) {
                value *= this.scale;
            }
            if (Double.isNaN(x) || Double.isNaN(value)) {
                return;
            }
            int sX = (int)domainAxis.valueToJava2D(x, dataArea, plot.getDomainAxisEdge());
            try {
                int top = (int)dataArea.getY();
                int bottom = (int)((double)top + dataArea.getHeight());
                int mid = top + (bottom - top) / 2;
                int w = 16;
                int w2 = w / 2;
                int verticalPosition = this.lineState.getVerticalPosition();
                int vAnchor = verticalPosition == 0 ? top : (verticalPosition == 1 ? mid - w2 : bottom - w);
                int angle = 0;
                if (value != 0.0) {
                    angle = value < 2.0 ? 90 : (value < 4.0 ? 180 : (value < 6.0 ? 270 : 360));
                }
                g2.setColor(Color.black);
                g2.setStroke(new BasicStroke());
                g2.fillArc(sX - w2, vAnchor, w, w, 90, -angle);
                g2.drawArc(sX - w2, vAnchor, w, w, 0, 360);
            }
            catch (Exception exc) {
                System.err.println("oops:" + exc);
            }
        }
    }

    protected static class MyXYBarRenderer
    extends XYBarRenderer {
        protected MyXYBarRenderer() {
        }

        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            EntityCollection entities;
            double value1;
            double value0;
            if (!this.getItemVisible(series, item)) {
                return;
            }
            IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
            if (this.getUseYInterval()) {
                value0 = intervalDataset.getStartYValue(series, item);
                value1 = intervalDataset.getEndYValue(series, item);
            } else {
                value0 = this.getBase();
                value1 = intervalDataset.getYValue(series, item);
            }
            if (Double.isNaN(value0) || Double.isNaN(value1)) {
                return;
            }
            double translatedValue0 = rangeAxis.valueToJava2D(value0, dataArea, plot.getRangeAxisEdge());
            double translatedValue1 = rangeAxis.valueToJava2D(value1, dataArea, plot.getRangeAxisEdge());
            RectangleEdge location = plot.getDomainAxisEdge();
            double startX = intervalDataset.getStartXValue(series, item);
            if (Double.isNaN(startX)) {
                return;
            }
            double translatedStartX = domainAxis.valueToJava2D(startX, dataArea, location);
            double endX = intervalDataset.getEndXValue(series, item);
            if (Double.isNaN(endX)) {
                return;
            }
            double translatedEndX = domainAxis.valueToJava2D(endX, dataArea, location);
            double translatedWidth = Math.max(1.0, Math.abs(translatedEndX - translatedStartX));
            double translatedHeight = Math.abs(translatedValue1 - translatedValue0);
            if (this.getMargin() > 0.0) {
                double cut = translatedWidth * this.getMargin();
                translatedWidth -= cut;
                translatedStartX += cut / 2.0;
            }
            translatedStartX -= 4.0;
            translatedWidth += 8.0;
            Rectangle2D.Double bar = null;
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                bar = new Rectangle2D.Double(Math.min(translatedValue0, translatedValue1), Math.min(translatedStartX, translatedEndX), translatedHeight, translatedWidth);
            } else if (orientation == PlotOrientation.VERTICAL) {
                bar = new Rectangle2D.Double(Math.min(translatedStartX, translatedEndX), Math.min(translatedValue0, translatedValue1), translatedWidth, translatedHeight);
            }
            Paint itemPaint = this.getItemPaint(series, item);
            if (this.getGradientPaintTransformer() != null && itemPaint instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)itemPaint;
                itemPaint = this.getGradientPaintTransformer().transform(gp, (Shape)bar);
            }
            g2.setPaint(itemPaint);
            g2.fill(bar);
            if (this.isDrawBarOutline() && Math.abs(translatedEndX - translatedStartX) > 3.0) {
                Stroke stroke = this.getItemOutlineStroke(series, item);
                Paint paint = this.getItemOutlinePaint(series, item);
                if (stroke != null && paint != null) {
                    g2.setStroke(stroke);
                    g2.setPaint(paint);
                    g2.draw(bar);
                }
            }
            if (this.isItemLabelVisible(series, item)) {
                XYItemLabelGenerator generator = this.getItemLabelGenerator(series, item);
                this.drawItemLabel(g2, dataset, series, item, plot, generator, bar, value1 < 0.0);
            }
            double x1 = (startX + endX) / 2.0;
            double y1 = dataset.getYValue(series, item);
            double transX1 = domainAxis.valueToJava2D(x1, dataArea, location);
            double transY1 = rangeAxis.valueToJava2D(y1, dataArea, plot.getRangeAxisEdge());
            this.updateCrosshairValues(crosshairState, x1, y1, transX1, transY1, plot.getOrientation());
            if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
                String tip = null;
                XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
                if (generator != null) {
                    tip = generator.generateToolTip(dataset, series, item);
                }
                String url = null;
                if (this.getURLGenerator() != null) {
                    url = this.getURLGenerator().generateURL(dataset, series, item);
                }
                XYItemEntity entity = new XYItemEntity((Shape)bar, dataset, series, item, tip, url);
                entities.add((ChartEntity)entity);
            }
        }
    }

    protected class MyXYAreaRenderer
    extends XYAreaRenderer {
        LineState lineState;
        Shape shape;
        boolean hasShape;
        boolean showLegend;

        public MyXYAreaRenderer(LineState lineState, int type) {
            this(lineState, type, true);
        }

        public MyXYAreaRenderer(LineState lineState, int type, boolean showLegend) {
            super(type);
            this.showLegend = true;
            this.showLegend = showLegend;
            this.lineState = lineState;
            this.shape = lineState.getPaintShape();
            int lineType = lineState.getLineType();
            this.hasShape = lineType == 1 || lineType == 5 || lineType == 3;
        }

        public LegendItem getLegendItem(int datasetIndex, int series) {
            if (!this.showLegend) {
                return null;
            }
            LegendItem l = super.getLegendItem(datasetIndex, series);
            if (!this.hasShape) {
                return l;
            }
            Paint p = l.getFillPaint();
            l = new LegendItem(l.getLabel(), l.getDescription(), l.getToolTipText(), l.getURLText(), true, this.shape, false, p, true, p, l.getOutlineStroke(), true, this.shape, l.getLineStroke(), p);
            return l;
        }
    }
}

