/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;
import ucar.unidata.idv.control.chart.ChartAnnotation;
import ucar.unidata.idv.control.chart.TimeSeriesChartWrapper;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.MidiManager;
import ucar.unidata.util.MidiProperties;
import ucar.unidata.util.Misc;

public class WayPoint
extends ChartAnnotation {
    private MidiManager midiManager;
    private static Image clockImage;
    private static Image noteImage;
    public static final String PROP_WAYPOINTVALUE = "prop.waypointvalue";
    public static final int ANNOTATION_WIDTH = 10;
    private double domainValue = 0.0;
    private boolean isForAnimation = false;
    private double minutesSpan = 0.0;
    private JTextField spanFld;
    private MidiProperties midiProperties = new MidiProperties();

    public WayPoint() {
    }

    public WayPoint(double domainValue, TimeSeriesChartWrapper timeseries) {
        super(timeseries);
        this.domainValue = domainValue;
    }

    public MidiManager getMidiManager() {
        if (this.midiManager == null) {
            this.midiManager = new MidiManager(this.midiProperties);
        }
        return this.midiManager;
    }

    @Override
    public String getToolTipText() {
        return "<html>Way point: <b>" + new Date((long)this.domainValue) + "</b></html>";
    }

    @Override
    public String getTypeName() {
        return "Waypoint";
    }

    @Override
    public void setPosition(int x, int y) {
        TimeSeriesChartWrapper tscw = (TimeSeriesChartWrapper)this.getPlotWrapper();
        double domainValue = tscw.getDomainValue(x);
        this.setDomainValue(domainValue);
        this.x = x;
        this.y = y;
    }

    public Color getColorToUse() {
        if (this.getSelected()) {
            return COLOR_SELECTED;
        }
        return this.getColor();
    }

    @Override
    protected boolean showColorInProperties() {
        return true;
    }

    @Override
    public String[] getPropertyTabs() {
        return new String[]{"Display", "Sound"};
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx == 0) {
            comps.add(GuiUtils.rLabel("Span: "));
            this.spanFld = new JTextField("" + this.minutesSpan, 5);
            comps.add(GuiUtils.left(GuiUtils.hbox(this.spanFld, new JLabel(" (minutes)"))));
        } else {
            this.midiProperties.getPropertiesComponents(comps);
        }
    }

    public boolean canPlaySound() {
        return !this.getMidiProperties().getMuted();
    }

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.minutesSpan = Misc.parseNumber(this.spanFld.getText().trim());
        if (!this.midiProperties.applyProperties()) {
            return false;
        }
        if (!this.midiProperties.getMuted()) {
            this.getMidiManager().setInstrument(this.midiProperties.getInstrumentName());
            this.getMidiManager().play(64, 500L);
        }
        return true;
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        int bottom;
        super.setGraphicsState(g2);
        if (!this.getPlotWrapper().okToDraw(this)) {
            return;
        }
        g2.setStroke(new BasicStroke());
        g2.setColor(this.getColor());
        this.x = this.getXFromValue(dataArea, domainAxis);
        int width2 = 5;
        this.y = bottom = (int)(dataArea.getY() + dataArea.getHeight());
        int[] xs = new int[]{this.x - width2, this.x + width2, this.x, this.x - width2};
        int[] ys = new int[]{bottom - 10, bottom - 10, bottom, bottom - 10};
        g2.fillPolygon(xs, ys, xs.length);
        if (this.getName() != null && !this.isForAnimation) {
            FontMetrics fm = g2.getFontMetrics();
            int width = fm.stringWidth(this.getName());
            int textLeft = this.x - width / 2;
            g2.drawString(this.getName(), textLeft, bottom - 10 - 2);
        }
        if (this.getSelected()) {
            g2.setColor(COLOR_SELECTED);
            g2.drawPolygon(xs, ys, xs.length);
        }
        if (this.getPropertyListeners().hasListeners(PROP_WAYPOINTVALUE) || this.isForAnimation) {
            g2.setColor(Color.gray);
            g2.drawLine(this.x, this.y - 10, this.x, (int)dataArea.getY());
        }
        boolean playSound = this.canPlaySound();
        if (this.isForAnimation) {
            if (clockImage == null) {
                clockImage = GuiUtils.getImage("/auxdata/ui/icons/clock.gif");
            }
            if (playSound) {
                g2.drawImage(clockImage, this.x - 8, (int)dataArea.getY() + 1, null);
            } else {
                g2.drawImage(clockImage, this.x - 8, (int)dataArea.getY() + 1, null);
            }
        }
        if (this.canPlaySound()) {
            if (noteImage == null) {
                noteImage = GuiUtils.getImage("/auxdata/ui/icons/note.gif");
            }
            if (this.isForAnimation) {
                g2.drawImage(noteImage, this.x + 8, (int)dataArea.getY() + 1, null);
            } else {
                g2.drawImage(noteImage, this.x, (int)dataArea.getY() + 1, null);
            }
        }
        if (this.minutesSpan > 0.0) {
            int left = (int)domainAxis.valueToJava2D(this.domainValue - this.minutesSpan * 60000.0 / 2.0, dataArea, RectangleEdge.BOTTOM);
            int right = (int)domainAxis.valueToJava2D(this.domainValue + this.minutesSpan * 60000.0 / 2.0, dataArea, RectangleEdge.BOTTOM);
            g2.setPaint(Color.black);
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(left, this.y, right, this.y);
        }
    }

    protected int getXFromValue(Rectangle2D dataArea, ValueAxis domainAxis) {
        return (int)domainAxis.valueToJava2D(this.domainValue, dataArea, RectangleEdge.BOTTOM);
    }

    public void setDomainValue(double value) {
        boolean different = value != this.domainValue;
        this.domainValue = value;
        if (different) {
            this.firePropertyChange(PROP_WAYPOINTVALUE, null, new Double(value));
        }
    }

    public double getDomainValue() {
        return this.domainValue;
    }

    public void setIsForAnimation(boolean value) {
        this.isForAnimation = value;
    }

    public boolean getIsForAnimation() {
        return this.isForAnimation;
    }

    public void setMinutesSpan(double value) {
        this.minutesSpan = value;
    }

    public double getMinutesSpan() {
        return this.minutesSpan;
    }

    public void setMidiProperties(MidiProperties value) {
        this.midiProperties = value;
    }

    public MidiProperties getMidiProperties() {
        return this.midiProperties;
    }

    public void addChangeListener(AnnotationChangeListener arg0) {
    }

    public void removeChangeListener(AnnotationChangeListener arg0) {
    }
}

