/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.VerticalProfileInfo;
import ucar.unidata.idv.control.chart.ChartHolder;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.idv.control.chart.XYChartManager;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.FieldImpl;
import visad.FlatField;
import visad.Real;
import visad.Unit;
import visad.VisADException;

public class VerticalProfileChart
extends XYChartManager {
    NumberFormat numberFormat;
    Real time;
    List profiles;
    boolean isConservedSounding = false;

    public VerticalProfileChart() {
    }

    public VerticalProfileChart(DisplayControlImpl control) {
        this(control, "Vertical Profile");
    }

    public VerticalProfileChart(DisplayControlImpl control, String chartName) {
        super(control, chartName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Axis addSeries(XYSeries series, LineState lineState, int paramIdx, XYItemRenderer renderer, boolean rangeVisible) {
        if (lineState.getRange() != null) {
            this.addRange(lineState.getRange().getMin(), lineState.getRange().getMax(), "Fixed range from: " + lineState.getName());
        }
        if (this.numberFormat == null) {
            this.numberFormat = new DecimalFormat(){

                @Override
                public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
                    String s = VerticalProfileChart.this.control.getDisplayConventions().format(number);
                    result.append(s);
                    return result;
                }
            };
        }
        String name = lineState.getName();
        Unit unit = lineState.unit;
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        NumberAxis domainAxis = null;
        String axisLabel = name + (unit != null ? " [" + unit + "]" : "");
        if (lineState.getUseLogarithmicRange()) {
            // empty if block
        }
        NumberAxis rangeAxis = new NumberAxis(axisLabel);
        rangeAxis.setAutoRangeIncludesZero(lineState.getRangeIncludesZero());
        VerticalProfileInfo vpInfo = (VerticalProfileInfo)this.profiles.get(0);
        Unit altUnit = vpInfo.getAltitudeUnit();
        if (altUnit != null && paramIdx == 0 && !altUnit.equals(CommonUnit.meter)) {
            String dlabel = "Altitude [" + altUnit + "]";
            domainAxis = new NumberAxis(dlabel);
            if (altUnit.isConvertible(CommonUnits.HECTOPASCAL)) {
                domainAxis.setInverted(true);
            }
        }
        rangeAxis.setVisible(rangeVisible);
        ucar.unidata.util.Range r = lineState.getRange();
        if (r != null) {
            rangeAxis.setRange(new Range(r.getMin(), r.getMax()));
        }
        if (renderer == null) {
            renderer = this.getRenderer(lineState);
        }
        Color c = lineState.getColor(paramIdx);
        rangeAxis.setLabelPaint((Paint)Color.black);
        renderer.setSeriesPaint(0, (Paint)c);
        renderer.setSeriesStroke(0, (Stroke)lineState.getStroke());
        if (!lineState.getAxisVisible()) {
            rangeAxis.setVisible(false);
        }
        AxisLocation side = null;
        ChartHolder chartHolder = this.getChartHolder(lineState);
        if (rangeAxis.isVisible()) {
            side = lineState.getSide() == 0 ? AxisLocation.BOTTOM_OR_RIGHT : (lineState.getSide() == 1 ? AxisLocation.TOP_OR_LEFT : AxisLocation.BOTTOM_OR_RIGHT);
            chartHolder.lastSide = side;
        }
        Object object = this.MUTEX;
        synchronized (object) {
            if (domainAxis == null) {
                if (this.isConservedSounding) {
                    chartHolder.add((XYDataset)dataset, renderer, side);
                } else {
                    chartHolder.add((XYDataset)dataset, (ValueAxis)rangeAxis, renderer, side);
                }
            } else {
                chartHolder.add((XYDataset)dataset, (ValueAxis)rangeAxis, (ValueAxis)domainAxis, renderer, side);
            }
        }
        return rangeAxis;
    }

    @Override
    public void timeChanged(Real time) {
        this.time = time;
        try {
            this.updateCharts();
        }
        catch (Exception ve) {
            DisplayControlImpl.logException("timeChanged", ve);
        }
        super.timeChanged(time);
    }

    public void setProfiles(List vpInfos) throws VisADException, RemoteException {
        this.profiles = vpInfos;
        this.updateCharts();
        VerticalProfileInfo vpi = (VerticalProfileInfo)this.profiles.get(0);
        DataChoice dc = vpi.getDataInstance().getDataChoice();
        if (dc instanceof DerivedDataChoice && dc.toString().startsWith("Conserved Sounding")) {
            this.isConservedSounding = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCharts() throws VisADException, RemoteException {
        if (this.profiles == null) {
            return;
        }
        this.clearLineStates();
        this.startLoadingData();
        try {
            this.initCharts();
            if (this.profiles != null && !this.profiles.isEmpty()) {
                XYSeries speedSeries = null;
                XYSeries dirSeries = null;
                LineState speedLineState = null;
                LineState dirLineState = null;
                Unit speedUnit = null;
                boolean polarWind = true;
                int lineIdx = 0;
                block6: for (int paramIdx = 0; paramIdx < this.profiles.size(); ++paramIdx) {
                    VerticalProfileInfo vpInfo = (VerticalProfileInfo)this.profiles.get(paramIdx);
                    LineState lineState = vpInfo.getLineState();
                    lineState.setUseVerticalPosition(false);
                    this.addLineState(lineState);
                    lineState.setName(vpInfo.getDataInstance().getParamName());
                    lineState.unit = vpInfo.getUnit();
                    FieldImpl profile = vpInfo.getProfile();
                    if (profile == null) continue;
                    boolean isTimeSequence = GridUtil.isTimeSequence(profile);
                    FlatField oneTime = isTimeSequence ? (this.time == null ? (FlatField)profile.getSample(0) : (FlatField)profile.evaluate(this.time)) : (FlatField)profile;
                    String canonical = DataAlias.aliasToCanonical(lineState.getName());
                    float[] alts = oneTime.getDomainSet().getSamples(false)[0];
                    float[][] values = oneTime.getFloats(true);
                    Unit[] rawUnits = Util.getDefaultRangeUnits(oneTime);
                    boolean haveWinds = values.length > 1 && Unit.canConvert(rawUnits[0], CommonUnit.meterPerSecond) && Unit.canConvert(rawUnits[1], CommonUnit.meterPerSecond);
                    for (int j = 0; j < values.length; ++j) {
                        if (j > 0 && !haveWinds) continue;
                        if (j > 1 && haveWinds) continue block6;
                        if (haveWinds) {
                            canonical = j == 0 ? "U" : "V";
                        }
                        XYSeries series = new XYSeries((Comparable)((Object)lineState.getName()));
                        float[] vals = values[j];
                        Unit rawUnit = rawUnits[j];
                        if (lineState.unit != null && Unit.canConvert(lineState.unit, rawUnit)) {
                            vals = lineState.unit.toThis(vals, rawUnit);
                        }
                        for (int i = 0; i < alts.length; ++i) {
                            series.add((double)alts[i], (double)vals[i]);
                        }
                        if (series == null) continue;
                        Object object = this.MUTEX;
                        synchronized (object) {
                            XYItemRenderer renderer = null;
                            if (Misc.equals(canonical, "SPEED")) {
                                speedUnit = lineState.unit;
                                speedSeries = series;
                                speedLineState = lineState;
                                continue;
                            }
                            if (Misc.equals(canonical, "DIR")) {
                                dirSeries = series;
                                dirLineState = lineState;
                                continue;
                            }
                            if (Misc.equals(canonical, "U") || Misc.equals(canonical, "UREL")) {
                                speedUnit = lineState.unit;
                                speedSeries = series;
                                polarWind = false;
                                speedLineState = lineState;
                                continue;
                            }
                            if (Misc.equals(canonical, "V") || Misc.equals(canonical, "VREL")) {
                                dirSeries = series;
                                dirLineState = lineState;
                                polarWind = false;
                                continue;
                            }
                            this.addSeries(series, lineState, lineIdx, renderer, true);
                        }
                        ++lineIdx;
                    }
                }
                if (speedSeries != null && dirSeries != null) {
                    XYChartManager.WindbarbRenderer renderer = new XYChartManager.WindbarbRenderer(speedLineState, (Series)speedSeries, (Series)dirSeries, speedUnit, polarWind);
                    Axis axis = this.addSeries(speedSeries, speedLineState, lineIdx++, (XYItemRenderer)renderer, true);
                    if (speedLineState.getVerticalPosition() != 3) {
                        axis.setVisible(false);
                    }
                    speedSeries = null;
                    dirSeries = null;
                }
                if (speedSeries != null) {
                    this.addSeries(speedSeries, speedLineState, lineIdx++, null, true);
                }
                if (dirSeries != null) {
                    this.addSeries(dirSeries, dirLineState, lineIdx, null, true);
                }
            }
            this.updateContents();
        }
        finally {
            this.doneLoadingData();
        }
    }

    @Override
    protected void initPlot(Plot plot) {
        XYPlot xyPlot = (XYPlot)plot;
        xyPlot.setOrientation(PlotOrientation.HORIZONTAL);
        int count = xyPlot.getDatasetCount();
        for (int i = 0; i < count; ++i) {
            xyPlot.setDataset(i, null);
            xyPlot.setRenderer(i, null);
        }
        xyPlot.clearRangeAxes();
        XYSeriesCollection dummyDataset = new XYSeriesCollection();
        NumberAxis rangeAxis = new NumberAxis();
        xyPlot.setRangeAxis(0, (ValueAxis)rangeAxis, false);
        xyPlot.setDataset(0, (XYDataset)dummyDataset);
        xyPlot.mapDatasetToRangeAxis(0, 0);
        xyPlot.setRenderer(0, (XYItemRenderer)new XYLineAndShapeRenderer());
    }

    @Override
    protected Dimension getPreferredChartSize() {
        return new Dimension(100, 300);
    }

    @Override
    public Plot doMakePlot() {
        return new XYChartManager.MyXYPlot(this, (XYDataset)new XYSeriesCollection(), (ValueAxis)new NumberAxis("Altitude (m)"), (ValueAxis)new NumberAxis(""), null);
    }

    public XYDataset getDummyDataset() {
        return new XYSeriesCollection();
    }

    public boolean getIsConservedSounding() {
        return this.isConservedSounding;
    }

    public void setIsConservedSounding(boolean isConservedSounding) {
        this.isConservedSounding = isConservedSounding;
    }
}

