/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import ucar.unidata.idv.control.chart.ChartAnnotation;
import ucar.unidata.idv.control.chart.PlotWrapper;
import ucar.unidata.idv.control.chart.TimeSeriesChartWrapper;
import ucar.unidata.idv.control.chart.WayPoint;

public class TrackSegment
extends ChartAnnotation {
    boolean lastDistanceCheckToRight = false;
    boolean lastDistanceCheckToLeft = false;
    private WayPoint wayPoint1;
    private WayPoint wayPoint2;

    public TrackSegment() {
    }

    public TrackSegment(WayPoint wayPoint1, WayPoint wayPoint2, PlotWrapper plotWrapper) {
        super(plotWrapper);
        this.wayPoint1 = wayPoint1;
        this.wayPoint2 = wayPoint2;
    }

    @Override
    public String getToolTipText() {
        return "<html> Track Segment: <b>" + new Date((long)this.getLeft().getDomainValue()) + " - " + new Date((long)this.getRight().getDomainValue()) + "</b> </html>";
    }

    @Override
    public String getTypeName() {
        return "Track Segment";
    }

    @Override
    public void setPosition(int x, int y) {
        if (this.lastDistanceCheckToLeft) {
            this.getLeft().setPosition(x, y);
        } else if (this.lastDistanceCheckToRight) {
            this.getRight().setPosition(x, y);
        } else {
            TimeSeriesChartWrapper tscw = (TimeSeriesChartWrapper)this.getPlotWrapper();
            double domainValue = tscw.getDomainValue(x);
            double mid = this.getCenterValue();
            double delta = domainValue - mid;
            this.getLeft().setDomainValue(this.getLeft().getDomainValue() + delta);
            this.getRight().setDomainValue(this.getRight().getDomainValue() + delta);
        }
    }

    public double getCenterValue() {
        return this.getLeft().getDomainValue() + (this.getRight().getDomainValue() - this.getLeft().getDomainValue()) / 2.0;
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        super.setGraphicsState(g2);
        if (!this.getPlotWrapper().okToDraw(this)) {
            return;
        }
        WayPoint leftWayPoint = this.getLeft();
        WayPoint rightWayPoint = this.getRight();
        g2.setStroke(new BasicStroke());
        int x1 = leftWayPoint.getXFromValue(dataArea, domainAxis);
        int x2 = rightWayPoint.getXFromValue(dataArea, domainAxis);
        int top = (int)dataArea.getY();
        int bottom = (int)(dataArea.getY() + dataArea.getHeight());
        FontMetrics fm = g2.getFontMetrics();
        int width = fm.stringWidth(this.getName());
        int height = fm.getAscent() + fm.getDescent();
        if (this.getSelected()) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.black);
        }
        this.y = top - 2;
        int textLeft = x1 + (x2 - x1) / 2 - width / 2;
        g2.drawString(this.getName(), textLeft, this.y);
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawLine(x1, top + 1, x2, top + 1);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.gray);
        g2.drawLine(x1, top, x1, bottom - 10);
        g2.drawLine(x2, top, x2, bottom - 10);
    }

    public WayPoint getLeft() {
        if (this.wayPoint1.getDomainValue() < this.wayPoint2.getDomainValue()) {
            return this.wayPoint1;
        }
        return this.wayPoint2;
    }

    public WayPoint getRight() {
        if (this.wayPoint1.getDomainValue() > this.wayPoint2.getDomainValue()) {
            return this.wayPoint1;
        }
        return this.wayPoint2;
    }

    public void setWayPoint1(WayPoint value) {
        this.wayPoint1 = value;
    }

    public WayPoint getWayPoint1() {
        return this.wayPoint1;
    }

    public void setWayPoint2(WayPoint value) {
        this.wayPoint2 = value;
    }

    public WayPoint getWayPoint2() {
        return this.wayPoint2;
    }

    @Override
    public double distance(int x, int y) {
        this.lastDistanceCheckToRight = false;
        this.lastDistanceCheckToLeft = false;
        Point leftP = (Point)this.transform.transform(new Point(this.getLeft().getX(), this.y), new Point());
        Point rightP = (Point)this.transform.transform(new Point(this.getRight().getX(), this.y), new Point());
        if (x <= leftP.x) {
            this.lastDistanceCheckToLeft = true;
            return TrackSegment.distance(x, y, leftP.x, leftP.y);
        }
        if (x >= rightP.x) {
            this.lastDistanceCheckToRight = true;
            return TrackSegment.distance(x, y, rightP.x, rightP.y);
        }
        return Math.abs(leftP.y - y);
    }

    public void addChangeListener(AnnotationChangeListener arg0) {
    }

    public void removeChangeListener(AnnotationChangeListener arg0) {
    }
}

