/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.python.util.PythonInterpreter;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.chart.ChartAnnotation;
import ucar.unidata.idv.control.chart.DataChoiceWrapper;
import ucar.unidata.idv.control.chart.MyTimeSeriesPlot;
import ucar.unidata.idv.control.chart.PlotWrapper;
import ucar.unidata.idv.control.chart.RangeFilter;
import ucar.unidata.idv.control.chart.TrackSegment;
import ucar.unidata.idv.control.chart.WayPoint;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.MidiManager;
import ucar.unidata.util.MidiProperties;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.PickableLineDrawing;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.Real;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationTuple;

public class TimeSeriesChartWrapper
extends PlotWrapper {
    public static final String PROP_TIMERANGE = "prop.timerange";
    private CompositeDisplayable dotsHolder;
    private List wayPoints = new ArrayList();
    private WayPoint timeWayPoint;
    private List rangeFilters = new ArrayList();
    private List segments = new ArrayList();
    List datas = new ArrayList();
    List ranges = new ArrayList();
    double[] times;
    double[] lats;
    double[] lons;
    double[] alts;
    private MyTimeSeriesPlot plot;
    private TimeSeriesCollection dataset;
    private double lastTimeClick = 0.0;
    private ChartAnnotation draggedAnnotation;
    private ChartAnnotation closestAnnotation;
    private boolean dragging = false;
    private boolean showDots = true;
    private long lastTimeWeDrove = 0L;
    private JCheckBox showDotsCbx;
    private boolean inSetTime = false;

    public TimeSeriesChartWrapper() {
    }

    public TimeSeriesChartWrapper(String name, List dataChoices) {
        super(name, dataChoices);
    }

    private void createChart() {
        WayPoint waypoint;
        if (this.chartPanel != null) {
            return;
        }
        this.dataset = new TimeSeriesCollection();
        DateAxis timeAxis = this.doMakeDateAxis();
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis("Data");
        valueAxis.setAutoRangeIncludesZero(false);
        this.plot = new MyTimeSeriesPlot(this, (XYDataset)this.dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis);
        this.plot.setRenderer(this.doMakeRenderer());
        this.chart = new JFreeChart(this.getName(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, true);
        this.addAnnotations(this.segments);
        this.addAnnotations(this.wayPoints);
        for (int i = 0; i < this.wayPoints.size(); ++i) {
            waypoint = (WayPoint)this.wayPoints.get(i);
            waypoint.addPropertyChangeListener(this);
        }
        this.addAnnotations(this.rangeFilters);
        this.initXYPlot(this.plot);
        XYItemRenderer r = this.plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            waypoint = (XYLineAndShapeRenderer)r;
        }
        DateAxis axis = (DateAxis)this.plot.getDomainAxis();
        this.chartPanel = this.doMakeChartPanel(this.chart);
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    private XYItemRenderer doMakeRenderer() {
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        return renderer;
    }

    @Override
    public String getTypeName() {
        return "Time Series";
    }

    @Override
    protected JComponent doMakeContents() {
        this.createChart();
        return this.chartPanel;
    }

    @Override
    public List getDisplayables() {
        List l = super.getDisplayables();
        if (this.dotsHolder != null) {
            l.add(this.dotsHolder);
        }
        return l;
    }

    @Override
    public void loadData() throws VisADException, RemoteException {
        long t1 = System.currentTimeMillis();
        this.loadDatax();
        long t2 = System.currentTimeMillis();
    }

    public void loadDatax() throws VisADException, RemoteException {
        this.createChart();
        this.times = null;
        ArrayList<Unit> unitList = new ArrayList<Unit>();
        List dataChoiceWrappers = this.getDataChoiceWrappers();
        this.datas.clear();
        this.ranges.clear();
        try {
            this.plot.setIgnoreDataSetChanges(true);
            this.plot.clearRangeAxes();
            this.plot.setRangeAxis(0, (ValueAxis)new NumberAxis(""), false);
            for (int dataSetIdx = 0; dataSetIdx < this.plot.getDatasetCount(); ++dataSetIdx) {
                TimeSeriesCollection dataset = (TimeSeriesCollection)this.plot.getDataset(dataSetIdx);
                dataset.removeAllSeries();
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("track type", "id.timetrace");
            AxisLocation lastSide = AxisLocation.BOTTOM_OR_RIGHT;
            for (int paramIdx = 0; paramIdx < dataChoiceWrappers.size(); ++paramIdx) {
                DataChoiceWrapper wrapper = (DataChoiceWrapper)dataChoiceWrappers.get(paramIdx);
                DataChoice dataChoice = wrapper.getDataChoice();
                FlatField data = this.getFlatField((FieldImpl)dataChoice.getData(null, props));
                Set domainSet = data.getDomainSet();
                double[][] domain = domainSet.getDoubles(false);
                double[][] samples = data.getValues(false);
                double[] var = samples[0];
                Unit unit = Util.getDefaultRangeUnits(data)[0];
                Unit displayUnit = null;
                if (unit != null && (displayUnit = this.getDisplayControl().getDisplayConventions().getDisplayUnit(dataChoice.getName(), null)) != null && !displayUnit.equals(unit)) {
                    var = displayUnit.toThis(var, unit);
                    unit = displayUnit;
                }
                unitList.add(unit);
                double[] timeValues = this.getTimeValues(samples, data);
                double[][] result = this.filterData(var, timeValues);
                var = result[0];
                timeValues = result[1];
                TimeSeries series = new TimeSeries((Comparable)((Object)(dataChoice.getName() + (unit == null ? "" : " [" + unit + "]"))), FixedMillisecond.class);
                this.times = timeValues;
                this.lats = domain[0];
                this.lons = domain[1];
                this.alts = domain[2];
                this.datas.add(var);
                long t1 = System.currentTimeMillis();
                double min = 0.0;
                double max = 0.0;
                for (int i = 0; i < var.length; ++i) {
                    Date dttm = new Date((long)timeValues[i]);
                    series.add((RegularTimePeriod)new FixedMillisecond(dttm), var[i]);
                    if (i == 0 || var[i] < min) {
                        min = var[i];
                    }
                    if (i != 0 && !(var[i] > max)) continue;
                    max = var[i];
                }
                this.ranges.add(new ucar.unidata.util.Range(min, max));
                long t2 = System.currentTimeMillis();
                TimeSeriesCollection dataset = new TimeSeriesCollection();
                dataset.setDomainIsPointsInTime(true);
                dataset.addSeries(series);
                NumberAxis rangeAxis = new NumberAxis(wrapper.getLabel(unit));
                this.plot.setRangeAxis(paramIdx, (ValueAxis)rangeAxis, false);
                this.plot.setDataset(paramIdx, (XYDataset)dataset);
                XYItemRenderer renderer = this.doMakeRenderer();
                this.plot.setRenderer(paramIdx, renderer);
                this.plot.mapDatasetToRangeAxis(paramIdx, paramIdx);
                Color c = wrapper.getColor(paramIdx);
                rangeAxis.setLabelPaint((Paint)c);
                renderer.setSeriesPaint(0, (Paint)c);
                renderer.setSeriesStroke(0, (Stroke)wrapper.getLineState().getStroke());
                AxisLocation side = wrapper.getSide() == 0 ? (lastSide == AxisLocation.TOP_OR_LEFT ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT) : (wrapper.getSide() == 1 ? AxisLocation.TOP_OR_LEFT : AxisLocation.BOTTOM_OR_RIGHT);
                lastSide = side;
                this.plot.setRangeAxisLocation(paramIdx, side);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating data set", exc);
            return;
        }
        if (dataChoiceWrappers.size() == 0) {
            NumberAxis axis = new NumberAxis("");
            this.plot.setRangeAxis(0, (ValueAxis)axis, false);
            DateAxis timeAxis = this.doMakeDateAxis();
            this.plot.setDomainAxis(0, (ValueAxis)timeAxis, false);
        }
        this.plot.setIgnoreDataSetChanges(false);
        try {
            this.setLocationPositions();
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating wayPoints", exc);
        }
    }

    private DateAxis doMakeDateAxis() {
        TimeZone timeZone = this.displayControl.getControlContext().getIdv().getPreferenceManager().getDefaultTimeZone();
        return new DateAxis("Time (" + timeZone.getID() + ")", timeZone);
    }

    @Override
    public String toString() {
        return "Time Series: " + this.getName();
    }

    public void setSelectedAnnotation(ChartAnnotation annotation, List list, boolean dontClear) {
        boolean anyWereWayPoints = false;
        if (!dontClear) {
            for (int i = 0; i < list.size(); ++i) {
                ChartAnnotation ann = (ChartAnnotation)list.get(i);
                if (ann.getSelected()) {
                    anyWereWayPoints |= ann instanceof WayPoint;
                }
                ann.setSelected(false);
            }
        }
        if (annotation != null) {
            anyWereWayPoints |= annotation instanceof WayPoint;
            annotation.setSelected(true);
        }
        if (anyWereWayPoints) {
            try {
                this.setLocationPositions();
            }
            catch (Exception exc) {
                LogUtil.logException("Setting locations", exc);
            }
        }
    }

    public void removeAnnotations(List annotations) {
        ArrayList tmp = new ArrayList(annotations);
        boolean didWaypoint = false;
        boolean didSegment = false;
        for (int i = 0; i < tmp.size(); ++i) {
            ChartAnnotation annotation = (ChartAnnotation)tmp.get(i);
            if (annotation instanceof WayPoint) {
                didWaypoint = true;
                if (((WayPoint)annotation).getMinutesSpan() > 0.0) {
                    didSegment = true;
                }
            }
            if (annotation instanceof TrackSegment) {
                didSegment = true;
            }
            this.removeAnnotation(annotation);
        }
        if (didSegment) {
            this.firePropertyChange(PROP_TIMERANGE, null, this.segments);
        }
        try {
            if (didWaypoint) {
                this.setLocationPositions();
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating wayPoints", exc);
        }
    }

    private void addAnnotations(List l) {
        for (int i = 0; i < l.size(); ++i) {
            this.plot.addAnnotation((ChartAnnotation)l.get(i));
        }
    }

    private List getList(ChartAnnotation annotation) {
        if (annotation instanceof WayPoint) {
            return this.wayPoints;
        }
        if (annotation instanceof TrackSegment) {
            return this.segments;
        }
        return this.rangeFilters;
    }

    public void removeAnnotation(ChartAnnotation annotation) {
        RangeFilter attached;
        annotation.doRemove();
        this.getList(annotation).remove(annotation);
        if (this.timeWayPoint == annotation) {
            this.setTimeWayPoint(null);
        }
        this.plot.removeAnnotation(annotation);
        if (annotation instanceof RangeFilter && (attached = ((RangeFilter)annotation).getAttached()) != null) {
            this.removeAnnotation(attached);
        }
        if (annotation instanceof WayPoint) {
            ArrayList tmp = new ArrayList(this.segments);
            for (int i = 0; i < tmp.size(); ++i) {
                TrackSegment segment = (TrackSegment)tmp.get(i);
                if (segment.getWayPoint1() != annotation && segment.getWayPoint2() != annotation) continue;
                this.removeAnnotation(segment);
            }
        }
    }

    public void editAnnotation(ChartAnnotation annotation) {
        if (!annotation.showProperties((JComponent)((Object)this.chartPanel), this.chartPanel.lastEventX, this.chartPanel.lastEventX)) {
            return;
        }
        this.signalChartChanged();
        if (annotation instanceof WayPoint) {
            try {
                this.setLocationPositions();
            }
            catch (Exception exc) {
                LogUtil.logException("Setting location positions", exc);
            }
        }
    }

    public void removeSelectedAnnotations(List annotations) {
        this.removeAnnotations(this.getSelected(annotations));
    }

    @Override
    public boolean chartPanelMousePressed(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            this.closestAnnotation = this.findClosestAnnotation(this.getAllAnnotations(), event.getX(), event.getY(), false, false);
        }
        return false;
    }

    @Override
    public boolean chartPanelMouseClicked(MouseEvent event) {
        block9: {
            if (SwingUtilities.isRightMouseButton(event)) {
                this.closestAnnotation = this.findClosestAnnotation(this.getAllAnnotations(), event.getX(), event.getY(), false, false);
                return false;
            }
            if (event.getClickCount() <= 1) {
                ChartAnnotation annotation = this.findClosestAnnotation(this.getAllAnnotations(), event.getX(), event.getY(), true, event.isShiftDown());
                if (annotation == null) {
                    return false;
                }
                this.signalChartChanged();
                return true;
            }
            try {
                if (this.isOnBottomDomainAxis(event)) {
                    WayPoint waypoint = new WayPoint(this.getDomainValue(event.getX()), this);
                    waypoint.addPropertyChangeListener(this);
                    if (!waypoint.showProperties((JComponent)((Object)this.chartPanel), event.getX(), event.getY())) {
                        return true;
                    }
                    this.wayPoints.add(waypoint);
                    this.setSelectedAnnotation(waypoint, this.wayPoints, event.isShiftDown());
                    this.setLocationPositions();
                    this.plot.addAnnotation(waypoint);
                    break block9;
                }
                if (this.isOnLeftRangeAxis(event)) {
                    RangeFilter rangeFilter = new RangeFilter(this.getRangeValue(event.getY()), this);
                    if (!rangeFilter.showProperties((JComponent)((Object)this.chartPanel), event.getX(), event.getY())) {
                        return true;
                    }
                    this.rangeFilters.add(rangeFilter);
                    this.setSelectedAnnotation(rangeFilter, this.rangeFilters, event.isShiftDown());
                    this.plot.addAnnotation(rangeFilter);
                    RangeFilter attached = rangeFilter.doMakeAttached(event);
                    this.rangeFilters.add(attached);
                    this.plot.addAnnotation(attached);
                    this.rangeFiltersChanged();
                    break block9;
                }
                return false;
            }
            catch (Exception exc) {
                LogUtil.logException("Error creating wayPoints", exc);
            }
        }
        return true;
    }

    public double getDomainValue(int x) {
        return this.plot.getDomainAxis().java2DToValue((double)x, this.getChartPanel().getScreenDataArea(), this.plot.getDomainAxisEdge());
    }

    public double getRangeValue(int y) {
        return this.plot.getRangeAxis().java2DToValue((double)y, this.getChartPanel().getScreenDataArea(), this.plot.getRangeAxisEdge());
    }

    private void setLocationPositions() throws VisADException, RemoteException {
        if (!this.showDots || this.wayPoints.size() == 0) {
            return;
        }
        if (this.dotsHolder == null) {
            this.dotsHolder = new CompositeDisplayable();
            this.getDisplayControl().addDisplayable(this.dotsHolder);
            if (!this.showDots) {
                this.dotsHolder.setVisible(false);
            }
        }
        this.dotsHolder.setDisplayInactive();
        while (this.dotsHolder.displayableCount() < this.wayPoints.size()) {
            PickableLineDrawing lineDrawing = new PickableLineDrawing("Line");
            lineDrawing.setColor(Color.blue);
            lineDrawing.setPointSize(5.0f);
            this.dotsHolder.addDisplayable(lineDrawing);
        }
        while (this.dotsHolder.displayableCount() > this.wayPoints.size()) {
            this.dotsHolder.removeDisplayable(this.dotsHolder.lastDisplayable());
        }
        ArrayList locs = new ArrayList();
        for (int i = 0; i < this.wayPoints.size(); ++i) {
            WayPoint waypoint = (WayPoint)this.wayPoints.get(i);
            PickableLineDrawing lineDrawing = (PickableLineDrawing)this.dotsHolder.getDisplayable(i);
            lineDrawing.setColor(waypoint.getColorToUse());
            int idx = this.findTimeIndex(waypoint.getDomainValue());
            if (idx < 0) continue;
            Data[] latLonsAlts = new EarthLocationTuple[]{new EarthLocationTuple(this.lats[idx], this.lons[idx], this.alts[idx])};
            lineDrawing.setData(Util.indexedField(latLonsAlts, false));
        }
        if (this.wayPoints.size() == 0) {
            this.dotsHolder.setVisible(false);
        } else {
            this.dotsHolder.setVisible(true);
        }
        this.dotsHolder.setDisplayActive();
    }

    @Override
    public List getTimeRanges() {
        int i;
        if (this.times == null) {
            return null;
        }
        ArrayList<ucar.unidata.util.Range> result = new ArrayList<ucar.unidata.util.Range>();
        for (i = 0; i < this.segments.size(); ++i) {
            TrackSegment segment = (TrackSegment)this.segments.get(i);
            result.add(new ucar.unidata.util.Range(segment.getLeft().getDomainValue(), segment.getRight().getDomainValue()));
        }
        for (i = 0; i < this.wayPoints.size(); ++i) {
            WayPoint wayPoint = (WayPoint)this.wayPoints.get(i);
            double span = wayPoint.getMinutesSpan();
            if (span <= 0.0) continue;
            result.add(new ucar.unidata.util.Range(wayPoint.getDomainValue() - span * 30000.0, wayPoint.getDomainValue() + span * 30000.0));
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public void setTimeFromAnimation(Real time) {
        if (this.getShowTime() && System.currentTimeMillis() - this.lastTimeWeDrove <= 1000L) {
            return;
        }
        this.setTime(time.getValue() * 1000.0, false);
    }

    protected void setTime(double value, boolean andDriveAnimation) {
        if (this.inSetTime) {
            return;
        }
        this.inSetTime = true;
        if (this.timeWayPoint == null) {
            this.setTimeWayPoint(new WayPoint(value, this));
            this.timeWayPoint.setIsForAnimation(true);
            this.timeWayPoint.setName("Time");
            this.wayPoints.add(this.timeWayPoint);
            this.plot.addAnnotation(this.timeWayPoint);
        }
        this.timeWayPoint.setDomainValue(value);
        ValueAxis axis = this.plot.getDomainAxis();
        axis.centerRange(value);
        this.firePropertyChange(PROP_TIMERANGE, null, this.segments);
        if (andDriveAnimation && this.getDriveTime() && this.animationWidget != null) {
            this.lastTimeWeDrove = System.currentTimeMillis();
            this.animationWidget.setTimeFromUser(new Real(RealType.Time, value / 1000.0));
        }
        this.inSetTime = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Double dttm;
        if (event.getPropertyName().equals("prop.waypointvalue")) {
            WayPoint source = (WayPoint)event.getSource();
            if (source.canPlaySound()) {
                this.playSound(source);
            }
            if (this.getDriveTime() && this.animationWidget != null) {
                this.lastTimeWeDrove = System.currentTimeMillis();
                this.animationWidget.setTimeFromUser(new Real(RealType.Time, source.getDomainValue() / 1000.0));
            }
        } else if (event.getPropertyName().equals("prop.selectedtime") && (dttm = (Double)event.getNewValue()) != null) {
            this.setTime(dttm, true);
        }
    }

    public void zoomTo(TrackSegment segment) {
        ValueAxis axis = this.plot.getDomainAxis();
        Range range = new Range(segment.getLeft().getDomainValue(), segment.getRight().getDomainValue());
        axis.setRange(range);
    }

    public void zoomTo(RangeFilter rangeFilter) {
        RangeFilter other = rangeFilter.getAttached();
        double min = Math.min(other.getRangeValue(), rangeFilter.getRangeValue());
        double max = Math.max(other.getRangeValue(), rangeFilter.getRangeValue());
        ValueAxis axis = this.plot.getRangeAxis();
        Range range = new Range(min, max);
        axis.setRange(range);
    }

    public void centerOn(WayPoint wayPoint) {
        ValueAxis axis = this.plot.getDomainAxis();
        axis.centerRange(wayPoint.getDomainValue());
    }

    public void centerOn(RangeFilter rangeFilter) {
        ValueAxis axis = this.plot.getRangeAxis();
        axis.centerRange(rangeFilter.getRangeValue());
    }

    private int findTimeIndex(double value) {
        int idx = -1;
        if (this.times == null) {
            return -1;
        }
        double minDistance = 0.0;
        double f = 0.0;
        for (int i = 0; i < this.times.length; ++i) {
            double distance = Math.abs(value - this.times[i]);
            if (i != 0 && !(distance < minDistance)) continue;
            f = this.times[i];
            minDistance = distance;
            idx = i;
        }
        return idx;
    }

    @Override
    public boolean chartPanelMouseReleased(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            return false;
        }
        this.closestAnnotation = null;
        this.dragging = false;
        if (this.draggedAnnotation != null) {
            if (this.draggedAnnotation instanceof WayPoint || this.draggedAnnotation instanceof TrackSegment) {
                this.firePropertyChange(PROP_TIMERANGE, null, this.segments);
            }
            if (this.getDriveTime() && this.animationWidget != null && this.draggedAnnotation instanceof WayPoint) {
                this.lastTimeWeDrove = System.currentTimeMillis();
                double value = ((WayPoint)this.draggedAnnotation).getDomainValue();
                this.animationWidget.setTimeFromUser(new Real(RealType.Time, value / 1000.0));
            }
        }
        this.draggedAnnotation = null;
        return this.isOnAxis(event) && SwingUtilities.isRightMouseButton(event);
    }

    private boolean isOnAxis(MouseEvent mouseEvent) {
        return this.isOnBottomDomainAxis(mouseEvent) || this.isOnTopDomainAxis(mouseEvent) || this.isOnLeftRangeAxis(mouseEvent);
    }

    private boolean isOnBottomDomainAxis(MouseEvent mouseEvent) {
        Rectangle2D dataArea = this.chartPanel.getScreenDataArea();
        if ((double)mouseEvent.getX() < dataArea.getX()) {
            return false;
        }
        if ((double)mouseEvent.getX() > dataArea.getX() + dataArea.getWidth()) {
            return false;
        }
        double bottom = dataArea.getY() + dataArea.getHeight();
        return (double)mouseEvent.getY() >= bottom - 20.0;
    }

    private boolean isOnTopDomainAxis(MouseEvent mouseEvent) {
        Rectangle2D dataArea = this.chartPanel.getScreenDataArea();
        if ((double)mouseEvent.getX() < dataArea.getX()) {
            return false;
        }
        if ((double)mouseEvent.getX() > dataArea.getX() + dataArea.getWidth()) {
            return false;
        }
        double top = dataArea.getY();
        return (double)mouseEvent.getY() <= top + 20.0;
    }

    private boolean isOnLeftRangeAxis(MouseEvent mouseEvent) {
        Rectangle2D dataArea = this.chartPanel.getScreenDataArea();
        if ((double)mouseEvent.getY() < dataArea.getY()) {
            return false;
        }
        if ((double)mouseEvent.getY() > dataArea.getY() + dataArea.getHeight()) {
            return false;
        }
        double left = dataArea.getX();
        if ((double)mouseEvent.getX() < left) {
            return true;
        }
        return !((double)mouseEvent.getX() > left + 20.0);
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx != 1) {
            return;
        }
        this.showDotsCbx = new JCheckBox("", this.showDots);
        comps.add(GuiUtils.rLabel("Show Dots: "));
        comps.add(GuiUtils.left(this.showDotsCbx));
    }

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.setShowDots(this.showDotsCbx.isSelected());
        return true;
    }

    @Override
    public void annotationChanged(ChartAnnotation chartAnnotation) {
        super.annotationChanged(chartAnnotation);
        if (chartAnnotation instanceof WayPoint) {
            this.firePropertyChange(PROP_TIMERANGE, null, this.segments);
        }
    }

    public void addSegment(WayPoint[] wps) {
        TrackSegment segment = new TrackSegment(wps[0], wps[1], this);
        if (!segment.showProperties((JComponent)((Object)this.chartPanel), this.chartPanel.lastEventX, this.chartPanel.lastEventX)) {
            return;
        }
        this.segments.add(segment);
        this.plot.addAnnotation(segment);
    }

    @Override
    public boolean okToDraw(ChartAnnotation annotation) {
        return this.times != null;
    }

    public List getSelected(List annotations) {
        ArrayList<ChartAnnotation> selected = new ArrayList<ChartAnnotation>();
        for (int i = 0; i < annotations.size(); ++i) {
            ChartAnnotation annotation = (ChartAnnotation)annotations.get(i);
            if (!annotation.getSelected()) continue;
            selected.add(annotation);
        }
        return selected;
    }

    @Override
    protected List getPopupMenuItems(List items) {
        List selected;
        JMenu menu;
        List selectedWaypoints = this.getSelected(this.wayPoints);
        if (this.closestAnnotation != null) {
            items.add(GuiUtils.makeMenuItem("Edit " + this.closestAnnotation.getTypeName() + ": " + this.closestAnnotation.getName(), this, "editAnnotation", this.closestAnnotation));
            items.add(GuiUtils.makeMenuItem("Remove " + this.closestAnnotation.getTypeName() + ": " + this.closestAnnotation.getName(), this, "removeAnnotations", Misc.newList(this.closestAnnotation)));
            if (this.closestAnnotation instanceof TrackSegment) {
                items.add(GuiUtils.makeMenuItem("Zoom Domain Axis To", this, "zoomTo", this.closestAnnotation));
            }
            if (this.closestAnnotation instanceof WayPoint) {
                items.add(GuiUtils.makeMenuItem("Center Domain Axis To", this, "centerOn", this.closestAnnotation));
            }
            if (this.closestAnnotation instanceof RangeFilter) {
                if (((RangeFilter)this.closestAnnotation).getAttached() != null) {
                    items.add(GuiUtils.makeMenuItem("Zoom Range Axis To", this, "zoomTo", this.closestAnnotation));
                }
                items.add(GuiUtils.makeMenuItem("Center Range Axis To", this, "centerOn", this.closestAnnotation));
            }
            items.add("separator");
        }
        if (selectedWaypoints.size() == 2) {
            items.add(GuiUtils.makeMenuItem("Add Segment", this, "addSegment", new WayPoint[]{(WayPoint)selectedWaypoints.get(0), (WayPoint)selectedWaypoints.get(1)}));
            items.add("separator");
        }
        JMenu markers = null;
        if (this.wayPoints.size() != 0) {
            if (markers == null) {
                markers = new JMenu("Markers");
                items.add(markers);
            }
            menu = new JMenu("Way Points");
            markers.add(menu);
            menu.add(GuiUtils.makeMenuItem("Remove All Way Points", this, "removeAnnotations", this.wayPoints));
            if (selectedWaypoints.size() > 0) {
                menu.add(GuiUtils.makeMenuItem("Remove Selected Way Points", this, "removeSelectedAnnotations", this.wayPoints));
            }
            JMenu editMenu = new JMenu("Edit Way Points");
            menu.add(editMenu);
            for (int i = 0; i < this.wayPoints.size(); ++i) {
                WayPoint waypoint = (WayPoint)this.wayPoints.get(i);
                editMenu.add(GuiUtils.makeMenuItem("#" + (i + 1) + " " + waypoint.getName() + " ", this, "editAnnotation", waypoint));
            }
        }
        if (this.segments.size() != 0) {
            if (markers == null) {
                markers = new JMenu("Markers");
                items.add(markers);
            }
            menu = new JMenu("Segments");
            markers.add(menu);
            menu.add(GuiUtils.makeMenuItem("Remove All Segments", this, "removeAnnotations", this.segments));
            selected = this.getSelected(this.segments);
            if (selected.size() > 0) {
                menu.add(GuiUtils.makeMenuItem("Remove Selected Segments", this, "removeSelectedAnnotations", this.segments));
            }
            JMenu editMenu = new JMenu("Edit Segments");
            menu.add(editMenu);
            for (int i = 0; i < this.segments.size(); ++i) {
                TrackSegment segment = (TrackSegment)this.segments.get(i);
                editMenu.add(GuiUtils.makeMenuItem("#" + (i + 1) + " " + segment.getName() + " ", this, "editAnnotation", segment));
            }
        }
        if (this.rangeFilters.size() != 0) {
            if (markers == null) {
                markers = new JMenu("Markers");
                items.add(markers);
            }
            menu = new JMenu("Range Filters");
            markers.add(menu);
            menu.add(GuiUtils.makeMenuItem("Remove All Range Filters", this, "removeAnnotations", this.rangeFilters));
            selected = this.getSelected(this.rangeFilters);
            if (selected.size() > 0) {
                menu.add(GuiUtils.makeMenuItem("Remove Selected Range Filters", this, "removeSelectedAnnotations", this.rangeFilters));
            }
            JMenu editMenu = new JMenu("Edit Range Filters");
            menu.add(editMenu);
            for (int i = 0; i < this.rangeFilters.size(); ++i) {
                ChartAnnotation annotation = (ChartAnnotation)this.rangeFilters.get(i);
                editMenu.add(GuiUtils.makeMenuItem("#" + (i + 1) + " " + annotation.getName() + " ", this, "editAnnotation", annotation));
            }
        }
        return super.getPopupMenuItems(items);
    }

    public ChartAnnotation findClosestAnnotation(List list, int x, int y, boolean andSetSelected, boolean addToSelected) {
        double minDistance = 20.0;
        ChartAnnotation closest = null;
        for (int i = 0; i < list.size(); ++i) {
            ChartAnnotation annotation = (ChartAnnotation)list.get(i);
            double distance = annotation.distance(x, y);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closest = annotation;
        }
        if (andSetSelected) {
            this.setSelectedAnnotation(closest, list, addToSelected);
        }
        return closest;
    }

    @Override
    protected boolean canDoDriveTime() {
        return true;
    }

    @Override
    protected boolean canDoTimeSelect() {
        return true;
    }

    @Override
    protected boolean canDoJython() {
        return true;
    }

    @Override
    protected void initializeJython(PythonInterpreter interpreter) {
        super.initializeJython(interpreter);
        interpreter.set("waypoints", this.wayPoints);
        interpreter.set("segments", this.segments);
        interpreter.set("rangefilters", this.rangeFilters);
        interpreter.set("rangefilters", this.rangeFilters);
    }

    @Override
    protected boolean canDoColors() {
        return true;
    }

    @Override
    protected boolean canDoTimeFilters() {
        return false;
    }

    @Override
    public boolean canDoWrapperColor() {
        return true;
    }

    @Override
    public boolean canDoWrapperSide() {
        return true;
    }

    public boolean valuesOk(int dataset, double domainValue, double rangeValue) {
        return this.rangeValueOk(dataset, rangeValue);
    }

    public List getRangeValues(int dataset) {
        ArrayList<RangeFilter> l = new ArrayList<RangeFilter>();
        for (int i = 0; i < this.rangeFilters.size(); ++i) {
            RangeFilter rangeFilter = (RangeFilter)this.rangeFilters.get(i);
            l.add(rangeFilter);
        }
        return l;
    }

    public boolean rangeValueOk(int dataset, double value) {
        for (int i = 0; i < this.rangeFilters.size(); ++i) {
            if (((RangeFilter)this.rangeFilters.get(i)).valueOk(value)) continue;
            return false;
        }
        return true;
    }

    private List getAllAnnotations() {
        ArrayList all = new ArrayList(this.wayPoints);
        all.addAll(this.segments);
        all.addAll(this.rangeFilters);
        return all;
    }

    @Override
    public boolean chartPanelMouseDragged(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            return true;
        }
        this.closestAnnotation = null;
        if (event.isShiftDown()) {
            return false;
        }
        if (this.dragging && this.draggedAnnotation == null) {
            return false;
        }
        this.dragging = true;
        if (this.draggedAnnotation == null) {
            this.draggedAnnotation = this.findClosestAnnotation(this.getAllAnnotations(), event.getX(), event.getY(), true, event.isShiftDown());
        }
        if (this.draggedAnnotation == null) {
            return false;
        }
        this.draggedAnnotation.setPosition(event);
        if (this.draggedAnnotation instanceof RangeFilter) {
            this.rangeFiltersChanged();
        }
        if (this.draggedAnnotation instanceof WayPoint || this.draggedAnnotation instanceof TrackSegment) {
            Rectangle2D r = this.getChartPanel().getScreenDataArea();
            if ((double)event.getX() < r.getX()) {
                this.panPlot(false, 0.02);
            } else if ((double)event.getX() > r.getX() + r.getWidth()) {
                this.panPlot(true, 0.02);
            }
        }
        this.signalChartChanged();
        try {
            this.setLocationPositions();
        }
        catch (Exception exc) {
            LogUtil.logException("Setting locations", exc);
        }
        return true;
    }

    private void playSound(WayPoint wp) {
        if (!wp.canPlaySound()) {
            return;
        }
        MidiManager midiManager = wp.getMidiManager();
        MidiProperties mp = wp.getMidiProperties();
        int idx = this.findTimeIndex(wp.getDomainValue());
        double[] darray = (double[])this.datas.get(0);
        double d = darray[idx];
        if (!this.rangeValueOk(0, d)) {
            return;
        }
        ucar.unidata.util.Range range = (ucar.unidata.util.Range)this.ranges.get(0);
        int note = (int)((double)mp.getLowNote() + range.getPercent(d) * (double)(mp.getHighNote() - mp.getLowNote()));
        midiManager.play(note, 500L);
    }

    @Override
    public String chartPanelGetToolTipText(MouseEvent event) {
        ChartAnnotation annotation = this.findClosestAnnotation(this.getAllAnnotations(), event.getX(), event.getY(), false, false);
        if (annotation == null) {
            return null;
        }
        return annotation.getToolTipText();
    }

    public void rangeFiltersChanged() {
        if (this.rangeFilters.size() == 0 || this.dataChoiceWrappers.size() == 0) {
            return;
        }
        DataChoice dataChoice = ((DataChoiceWrapper)this.dataChoiceWrappers.get(0)).getDataChoice();
        double min = Double.NEGATIVE_INFINITY;
        double max = Double.POSITIVE_INFINITY;
        int greaterThanCnt = 0;
        int lessThanCnt = 0;
        for (int i = 0; i < this.rangeFilters.size(); ++i) {
            RangeFilter rangeFilter = (RangeFilter)this.rangeFilters.get(i);
            if (rangeFilter.getType() == RangeFilter.TYPE_LESSTHAN) {
                max = lessThanCnt == 0 ? rangeFilter.getRangeValue() : Math.max(max, rangeFilter.getRangeValue());
                ++lessThanCnt;
                continue;
            }
            min = greaterThanCnt == 0 ? rangeFilter.getRangeValue() : Math.min(min, rangeFilter.getRangeValue());
            ++greaterThanCnt;
        }
        this.getDisplayControl().doShare((Object)"DisplayControlImpl.SHARE_SELECTRANGE", new Object[]{dataChoice, new ucar.unidata.util.Range(min, max)});
    }

    private void clearAnnotations(List l) {
        for (int i = 0; i < l.size(); ++i) {
            ChartAnnotation anno = (ChartAnnotation)l.get(i);
            anno.doRemove();
        }
        l.clear();
    }

    @Override
    public void doRemove() {
        super.doRemove();
        this.clearAnnotations(this.segments);
        this.clearAnnotations(this.wayPoints);
        this.clearAnnotations(this.rangeFilters);
        this.firePropertyChange(PROP_TIMERANGE, null, this.segments);
        if (this.rangeFilters.size() == 0 || this.dataChoiceWrappers.size() == 0) {
            return;
        }
        DataChoice dataChoice = ((DataChoiceWrapper)this.dataChoiceWrappers.get(0)).getDataChoice();
        this.getDisplayControl().doShare((Object)"DisplayControlImpl.SHARE_SELECTRANGE", new Object[]{dataChoice, new ucar.unidata.util.Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)});
    }

    @Override
    public void initDone() {
        super.initDone();
        Misc.runInABit(2000L, this, "rangeFiltersChanged", null);
    }

    public void setWayPoints(List value) {
        this.wayPoints = value;
    }

    public List getWayPoints() {
        return this.wayPoints;
    }

    public void setSegments(List value) {
        this.segments = value;
    }

    public List getSegments() {
        return this.segments;
    }

    public void setRangeFilters(List value) {
        this.rangeFilters = value;
    }

    public List getRangeFilters() {
        return this.rangeFilters;
    }

    public void setTimeWayPoint(WayPoint value) {
        if (this.timeWayPoint != null) {
            this.timeWayPoint.removePropertyChangeListener(this);
        }
        this.timeWayPoint = value;
        if (this.timeWayPoint != null) {
            this.timeWayPoint.addPropertyChangeListener(this);
        }
    }

    public WayPoint getTimeWayPoint() {
        return this.timeWayPoint;
    }

    public void setShowDots(boolean value) {
        if (value == this.showDots) {
            return;
        }
        this.showDots = value;
        if (this.dotsHolder != null) {
            try {
                this.dotsHolder.setVisible(value);
                this.setLocationPositions();
            }
            catch (Exception exc) {
                LogUtil.logException("Setting locations", exc);
            }
        }
    }

    public boolean getShowDots() {
        return this.showDots;
    }
}

