/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.general.Series;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.ProbeRowInfo;
import ucar.unidata.idv.control.chart.ChartHolder;
import ucar.unidata.idv.control.chart.ChartManager;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.idv.control.chart.PointParam;
import ucar.unidata.idv.control.chart.XYChartManager;
import ucar.unidata.idv.ui.IdvTimeline;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.MathType;
import visad.Real;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;

public class TimeSeriesChart
extends XYChartManager {
    public static final String MACRO_PARAMETER = "%parameter%";
    private XYAnnotation animationTimeAnnotation;
    private boolean showAnimationTime;
    private static Image clockImage;
    NumberFormat numberFormat;
    private List sunriseDates;
    private LatLonPoint sunriseLocation;
    private Date lastStartDate;
    private Date lastEndDate;
    private String dateFormat;
    long lastTime = -1L;
    List<ProbeRowInfo> currentProbeData;
    boolean updatePending = false;

    public TimeSeriesChart() {
        this.showAnimationTime(this.showAnimationTime);
    }

    public TimeSeriesChart(DisplayControlImpl control) {
        this(control, "Time Series");
    }

    public TimeSeriesChart(DisplayControlImpl control, String chartName) {
        super(control, chartName);
    }

    @Override
    public Plot doMakePlot() {
        IdvPreferenceManager pref = this.control.getControlContext().getIdv().getPreferenceManager();
        TimeZone timeZone = pref.getDefaultTimeZone();
        ChartManager.FixedWidthNumberAxis valueAxis = new ChartManager.FixedWidthNumberAxis("");
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat != null ? this.dateFormat : pref.getDefaultDateFormat());
        sdf.setTimeZone(timeZone);
        DateAxis timeAxis = new DateAxis("Time (" + timeZone.getID() + ")", timeZone){

            protected List xxxxxrefreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
                List ticks = super.refreshTicksHorizontal(g2, dataArea, edge);
                ArrayList<DateTick> result = new ArrayList<DateTick>();
                Font tickLabelFont = this.getTickLabelFont();
                g2.setFont(tickLabelFont);
                if (this.isAutoTickUnitSelection()) {
                    this.selectAutoTickUnit(g2, dataArea, edge);
                }
                DateTickUnit unit = this.getTickUnit();
                Date tickDate = this.calculateLowestVisibleTickValue(unit);
                Date upperDate = this.getMaximumDate();
                Date firstDate = null;
                block5: while (tickDate.before(upperDate)) {
                    double angle;
                    TextAnchor rotationAnchor;
                    TextAnchor anchor;
                    String tickLabel;
                    if (!this.isHiddenValue(tickDate.getTime())) {
                        DateFormat formatter = this.getDateFormatOverride();
                        if (firstDate == null) {
                            tickLabel = formatter != null ? formatter.format(tickDate) : this.getTickUnit().dateToString(tickDate);
                            firstDate = tickDate;
                        } else {
                            double msdiff = tickDate.getTime() - firstDate.getTime();
                            int hours = (int)(msdiff / 1000.0 / 60.0 / 60.0);
                            tickLabel = hours + "H";
                        }
                        anchor = null;
                        rotationAnchor = null;
                        angle = 0.0;
                        if (this.isVerticalTickLabels()) {
                            anchor = TextAnchor.CENTER_RIGHT;
                            rotationAnchor = TextAnchor.CENTER_RIGHT;
                            angle = edge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                        } else if (edge == RectangleEdge.TOP) {
                            anchor = TextAnchor.BOTTOM_CENTER;
                            rotationAnchor = TextAnchor.BOTTOM_CENTER;
                        } else {
                            anchor = TextAnchor.TOP_CENTER;
                            rotationAnchor = TextAnchor.TOP_CENTER;
                        }
                    } else {
                        tickDate = unit.rollDate(tickDate, this.getTimeZone());
                        continue;
                    }
                    DateTick tick = new DateTick(tickDate, tickLabel, anchor, rotationAnchor, angle);
                    result.add(tick);
                    tickDate = unit.addToDate(tickDate, this.getTimeZone());
                    switch (unit.getUnit()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            continue block5;
                        }
                        case 1: {
                            tickDate = this.calculateDateForPositionX((RegularTimePeriod)new Month(tickDate, this.getTimeZone()), this.getTickMarkPosition());
                            continue block5;
                        }
                        case 0: {
                            tickDate = this.calculateDateForPositionX((RegularTimePeriod)new Year(tickDate, this.getTimeZone()), this.getTickMarkPosition());
                            continue block5;
                        }
                    }
                }
                return result;
            }

            private Date calculateDateForPositionX(RegularTimePeriod period, DateTickMarkPosition position) {
                if (position == null) {
                    throw new IllegalArgumentException("Null 'position' argument.");
                }
                Date result = null;
                if (position == DateTickMarkPosition.START) {
                    result = new Date(period.getFirstMillisecond());
                } else if (position == DateTickMarkPosition.MIDDLE) {
                    result = new Date(period.getMiddleMillisecond());
                } else if (position == DateTickMarkPosition.END) {
                    result = new Date(period.getLastMillisecond());
                }
                return result;
            }
        };
        timeAxis.setDateFormatOverride((DateFormat)sdf);
        final XYPlot[] xyPlotHolder = new XYPlot[]{null};
        xyPlotHolder[0] = new XYChartManager.MyXYPlot((XYDataset)new TimeSeriesCollection(), (ValueAxis)timeAxis, (ValueAxis)valueAxis, null){

            public void drawBackground(Graphics2D g2, Rectangle2D area) {
                super.drawBackground(g2, area);
                TimeSeriesChart.this.drawSunriseSunset(g2, xyPlotHolder[0], area);
            }
        };
        if (this.animationTimeAnnotation != null) {
            xyPlotHolder[0].addAnnotation(this.animationTimeAnnotation);
        }
        return xyPlotHolder[0];
    }

    public void showAnimationTime(boolean value) {
        this.showAnimationTime = value;
        if (this.animationTimeAnnotation == null) {
            this.animationTimeAnnotation = new XYAnnotation(){

                public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
                    if (TimeSeriesChart.this.showAnimationTime) {
                        TimeSeriesChart.this.drawTime(g2, plot, dataArea, domainAxis, rangeAxis, rendererIndex, info);
                    }
                }

                public void addChangeListener(AnnotationChangeListener arg0) {
                }

                public void removeChangeListener(AnnotationChangeListener arg0) {
                }
            };
            List plots = this.getPlots();
            for (int plotIdx = 0; plotIdx < plots.size(); ++plotIdx) {
                ChartHolder chartHolder = (ChartHolder)plots.get(plotIdx);
                ((XYPlot)chartHolder.getPlot()).addAnnotation(this.animationTimeAnnotation);
            }
        }
    }

    protected Axis addSeries(TimeSeries series, LineState lineState, int paramIdx, XYItemRenderer renderer, boolean rangeVisible) {
        return this.addSeries(series, lineState, paramIdx, renderer, rangeVisible, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Axis addSeries(TimeSeries series, LineState lineState, int paramIdx, XYItemRenderer renderer, boolean rangeVisible, boolean addAxis) {
        if (series instanceof MyTimeSeries) {
            ((MyTimeSeries)series).finish();
        }
        if (addAxis && lineState.getRange() != null) {
            this.addRange(lineState.getRange().getMin(), lineState.getRange().getMax(), "Fixed range from: " + lineState.getName());
        }
        if (this.numberFormat == null) {
            this.numberFormat = new DecimalFormat(){

                @Override
                public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
                    String s = TimeSeriesChart.this.control.getDisplayConventions().format(number);
                    result.append(s);
                    return result;
                }
            };
        }
        String name = lineState.getName();
        Unit unit = lineState.unit;
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.setDomainIsPointsInTime(true);
        dataset.addSeries(series);
        String axisLabel = lineState.getAxisLabel();
        if (axisLabel == null) {
            axisLabel = name + (unit != null ? " [" + unit + "]" : "");
        }
        if (lineState.getUseLogarithmicRange()) {
            // empty if block
        }
        ChartManager.FixedWidthNumberAxis rangeAxis = new ChartManager.FixedWidthNumberAxis(axisLabel);
        rangeAxis.setAutoRangeIncludesZero(lineState.getRangeIncludesZero());
        rangeAxis.setVisible(rangeVisible);
        ucar.unidata.util.Range r = lineState.getRange();
        if (r != null) {
            rangeAxis.setRange(new Range(r.getMin(), r.getMax()));
        }
        if (renderer == null) {
            renderer = this.getRenderer(lineState, addAxis);
        }
        Color c = lineState.getColor(paramIdx);
        rangeAxis.setLabelPaint(Color.black);
        renderer.setSeriesPaint(0, (Paint)c);
        renderer.setSeriesStroke(0, (Stroke)lineState.getStroke());
        renderer.setSeriesVisibleInLegend(0, Boolean.valueOf(lineState.getVisibleInLegend()));
        if (!lineState.getAxisVisible()) {
            rangeAxis.setVisible(false);
        } else {
            rangeAxis.setVisible(addAxis);
        }
        ChartHolder chartHolder = this.getChartHolder(lineState);
        AxisLocation side = null;
        if (rangeAxis.isVisible()) {
            side = lineState.getSide() == 0 ? (chartHolder.lastSide == AxisLocation.TOP_OR_LEFT ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT) : (lineState.getSide() == 1 ? AxisLocation.TOP_OR_LEFT : AxisLocation.BOTTOM_OR_RIGHT);
            chartHolder.lastSide = side;
        }
        Object object = this.MUTEX;
        synchronized (object) {
            chartHolder.add((XYDataset)dataset, (ValueAxis)rangeAxis, renderer, side);
        }
        return rangeAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProbeSamples(List<ProbeRowInfo> rowInfos) throws VisADException, RemoteException {
        this.lastTime = System.currentTimeMillis();
        this.currentProbeData = rowInfos;
        this.updatePending = true;
        Object object = this.MUTEX;
        synchronized (object) {
            this.settingData = true;
            this.setProbeSamplesInner();
        }
    }

    @Override
    protected void initPlot(Plot plot) {
        XYPlot xyPlot = (XYPlot)plot;
        int count = xyPlot.getDatasetCount();
        for (int i = 0; i < count; ++i) {
            xyPlot.setDataset(i, null);
            xyPlot.setRenderer(i, null);
        }
        xyPlot.clearRangeAxes();
        XYDataset dummyDataset = this.getDummyDataset();
        ChartManager.FixedWidthNumberAxis rangeAxis = new ChartManager.FixedWidthNumberAxis();
        xyPlot.setRangeAxis(0, (ValueAxis)rangeAxis, false);
        xyPlot.setDataset(0, dummyDataset);
        xyPlot.mapDatasetToRangeAxis(0, 0);
        xyPlot.setRenderer(0, (XYItemRenderer)new XYLineAndShapeRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProbeSamplesInner() throws VisADException, RemoteException {
        this.clearLineStates();
        this.updatePending = false;
        ArrayList<ProbeRowInfo> rowInfos = this.currentProbeData == null ? null : new ArrayList<ProbeRowInfo>(this.currentProbeData);
        try {
            this.initCharts();
            if (rowInfos != null && rowInfos.size() > 0) {
                MyTimeSeries speedSeries = null;
                MyTimeSeries dirSeries = null;
                LineState speedLineState = null;
                LineState dirLineState = null;
                Unit speedUnit = null;
                double speedMin = 0.0;
                double speedMax = 0.0;
                double dirMin = 0.0;
                double dirMax = 0.0;
                boolean polarWind = true;
                int speedIdx = 0;
                int dirIdx = 0;
                block6: for (int paramIdx = 0; paramIdx < rowInfos.size(); ++paramIdx) {
                    String macro;
                    boolean isTimeSequence;
                    ProbeRowInfo info = (ProbeRowInfo)rowInfos.get(paramIdx);
                    LineState lineState = info.getLineState();
                    this.addLineState(lineState);
                    FieldImpl field = info.getPointSample();
                    if (field == null || !(isTimeSequence = GridUtil.isTimeSequence(field))) continue;
                    lineState.unit = info.getUnit();
                    if (info.isPoint()) {
                        if (!lineState.hasName()) {
                            lineState.setNameMacro(MACRO_PARAMETER);
                        }
                        String pointParam = info.getPointParameterName();
                        if (lineState.getNameMacro() != null) {
                            macro = lineState.getNameMacro();
                            macro = macro.replace(MACRO_PARAMETER, pointParam);
                            lineState.setName(macro);
                        } else {
                            lineState.setName(pointParam);
                        }
                    } else {
                        if (!lineState.hasName()) {
                            lineState.setNameMacro(MACRO_PARAMETER);
                        }
                        String paramName = info.getDataInstance().getParamName();
                        if (lineState.getNameMacro() != null) {
                            macro = lineState.getNameMacro();
                            macro = macro.replace(MACRO_PARAMETER, paramName);
                            lineState.setName(macro);
                        } else {
                            lineState.setNameIfNeeded(paramName);
                        }
                    }
                    String name = lineState.getName();
                    String canonical = DataAlias.aliasToCanonical(name);
                    if (info.getLevel() != null) {
                        name = name + "@" + Util.formatReal(info.getLevel()) + info.getLevel().getUnit();
                    }
                    Set timeSet = field.getDomainSet();
                    Unit[] timeUnits = timeSet.getSetUnits();
                    double[][] times = timeSet.getDoubles();
                    double[][] values = field.getValues(false);
                    if (values == null) continue;
                    Unit[] rawUnits = Util.getDefaultRangeUnits(field);
                    boolean haveWinds = values.length > 1 && this.checkWindUnits(rawUnits);
                    for (int j = 0; j < values.length; ++j) {
                        if (j > 0 && !haveWinds) continue;
                        if (j > 1 && haveWinds) continue block6;
                        if (haveWinds && values.length > 1) {
                            canonical = j == 0 ? "U" : "V";
                        }
                        ArrayList<MyTimeSeries> timeSeriesList = new ArrayList<MyTimeSeries>();
                        MyTimeSeries series = new MyTimeSeries(name, FixedMillisecond.class);
                        double[] valueArray = values[j];
                        Unit rawUnit = rawUnits[j];
                        if (lineState.unit != null && rawUnit != null) {
                            valueArray = lineState.unit.toThis(valueArray, rawUnit);
                        }
                        int numTimes = times[0].length;
                        double min = 0.0;
                        double max = 0.0;
                        for (int i = 0; i < numTimes; ++i) {
                            Date date = Util.makeDate(new DateTime(times[0][i], timeUnits[0]));
                            if (!(valueArray[i] == valueArray[i] || Misc.equals(canonical, "U") || Misc.equals(canonical, "UREL") || Misc.equals(canonical, "V") || Misc.equals(canonical, "VREL") || Misc.equals(canonical, "DIR") || Misc.equals(canonical, "SPEED"))) {
                                if (series == null) continue;
                                timeSeriesList.add(series);
                                series = null;
                                continue;
                            }
                            if (series == null) {
                                series = new MyTimeSeries(name, FixedMillisecond.class);
                            }
                            series.add((RegularTimePeriod)new FixedMillisecond(date), valueArray[i]);
                            if (i == 0 || valueArray[i] > max) {
                                max = valueArray[i];
                            }
                            if (i != 0 && !(valueArray[i] < min)) continue;
                            min = valueArray[i];
                        }
                        Object i = this.MUTEX;
                        synchronized (i) {
                            if (Misc.equals(canonical, "U") || Misc.equals(canonical, "UREL")) {
                                speedIdx = paramIdx;
                                speedMin = min;
                                speedMax = max;
                                speedUnit = lineState.unit;
                                speedSeries = series;
                                polarWind = false;
                                speedLineState = lineState;
                                continue;
                            }
                            if (Misc.equals(canonical, "V") || Misc.equals(canonical, "VREL")) {
                                dirIdx = paramIdx;
                                dirSeries = series;
                                dirLineState = lineState;
                                dirMin = min;
                                dirMax = max;
                                polarWind = false;
                                continue;
                            }
                            if (Misc.equals(canonical, "SPEED")) {
                                speedIdx = paramIdx;
                                speedMin = min;
                                speedMax = max;
                                speedUnit = lineState.unit;
                                speedSeries = series;
                                polarWind = true;
                                speedLineState = lineState;
                                continue;
                            }
                            if (Misc.equals(canonical, "DIR")) {
                                dirIdx = paramIdx;
                                dirSeries = series;
                                dirLineState = lineState;
                                dirMin = min;
                                dirMax = max;
                                polarWind = true;
                                continue;
                            }
                        }
                        if (series != null) {
                            timeSeriesList.add(series);
                        }
                        boolean first = true;
                        if (lineState.getRange() == null) {
                            lineState.setRange(new ucar.unidata.util.Range(min, max));
                        }
                        for (MyTimeSeries tmp : timeSeriesList) {
                            this.addSeries(tmp, lineState, paramIdx, null, true, first);
                            first = false;
                        }
                        this.addRange(min, max, "Data range from: " + lineState.getName());
                    }
                }
                if (speedSeries != null && dirSeries != null) {
                    speedSeries.finish();
                    dirSeries.finish();
                    XYChartManager.WindbarbRenderer renderer = new XYChartManager.WindbarbRenderer(speedLineState, (Series)speedSeries, (Series)dirSeries, speedUnit, polarWind);
                    Axis axis = this.addSeries(speedSeries, speedLineState, speedIdx, (XYItemRenderer)renderer, true);
                    if (speedLineState.getVerticalPosition() != 3) {
                        axis.setVisible(false);
                    }
                    speedSeries = null;
                    dirSeries = null;
                }
                if (speedSeries != null) {
                    this.addSeries(speedSeries, speedLineState, speedIdx, null, true);
                    this.addRange(speedMin, speedMax, "Data range from: " + speedLineState.getName());
                }
                if (dirSeries != null) {
                    this.addSeries(dirSeries, dirLineState, dirIdx, null, true);
                    this.addRange(dirMin, dirMax, "Data range from: " + dirLineState.getName());
                }
            }
            this.updateContents();
        }
        finally {
            this.doneLoadingData();
        }
    }

    private boolean checkWindUnits(Unit[] units) {
        if (units == null || units.length < 2) {
            return false;
        }
        if (Unit.canConvert(units[0], CommonUnit.meterPerSecond) && Unit.canConvert(units[1], CommonUnit.meterPerSecond)) {
            return true;
        }
        if (Unit.canConvert(units[0], CommonUnit.meterPerSecond) && Unit.canConvert(units[1], CommonUnit.degree)) {
            return true;
        }
        return Unit.canConvert(units[0], CommonUnit.degree) && Unit.canConvert(units[1], CommonUnit.meterPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPointObs(List<PointOb> obs, List plotVars) throws VisADException, RemoteException {
        try {
            Object object = this.MUTEX;
            synchronized (object) {
                this.clearLineStates();
                this.settingData = true;
                int paramIdx = 0;
                this.initCharts();
                if (obs != null && obs.size() > 0) {
                    String canonical;
                    ArrayList<PointParam> goodVars = new ArrayList<PointParam>();
                    for (int varIdx = 0; varIdx < plotVars.size(); ++varIdx) {
                        PointParam plotVar = (PointParam)plotVars.get(varIdx);
                        LineState lineState = plotVar.getLineState();
                        this.addLineState(lineState);
                        String var = lineState.getName();
                        PointOb ob = obs.get(0);
                        Tuple tuple = (Tuple)ob.getData();
                        TupleType tupleType = (TupleType)tuple.getType();
                        MathType[] types = tupleType.getComponents();
                        boolean isValid = false;
                        for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
                            String name = Util.cleanTypeName(types[typeIdx].toString());
                            canonical = DataAlias.aliasToCanonical(name);
                            if (!Misc.equals(name, var) && !Misc.equals(canonical, var)) continue;
                            lineState.index = typeIdx;
                            Data dataElement = tuple.getComponent(lineState.index);
                            if (dataElement instanceof Real) {
                                Real obsReal = (Real)dataElement;
                                Unit displayUnit = this.control.getDisplayConventions().getDisplayUnit(name, obsReal.getUnit());
                                Unit unit = lineState.unit = displayUnit != null ? displayUnit : obsReal.getUnit();
                            }
                            if (lineState.getVisible()) {
                                goodVars.add(plotVar);
                            }
                            isValid = true;
                            break;
                        }
                        lineState.setValid(isValid);
                    }
                    MyTimeSeries speedSeries = null;
                    MyTimeSeries dirSeries = null;
                    LineState speedLineState = null;
                    LineState dirLineState = null;
                    Unit speedUnit = null;
                    boolean polarWind = true;
                    for (int varIdx = 0; varIdx < goodVars.size(); ++varIdx) {
                        PointParam plotVar = (PointParam)goodVars.get(varIdx);
                        LineState lineState = plotVar.getLineState();
                        if (!lineState.getVisible()) continue;
                        MyTimeSeries series = null;
                        ArrayList<String> textList = null;
                        canonical = DataAlias.aliasToCanonical(lineState.getName());
                        Unit unit = null;
                        double min = 0.0;
                        double max = 0.0;
                        for (int obIdx = 0; obIdx < obs.size(); ++obIdx) {
                            double value;
                            PointOb ob = obs.get(obIdx);
                            Tuple tuple = (Tuple)ob.getData();
                            TupleType tupleType = (TupleType)tuple.getType();
                            MathType[] types = tupleType.getComponents();
                            Data dataElement = tuple.getComponent(lineState.index);
                            Date dttm = Util.makeDate(ob.getDateTime());
                            if (series == null) {
                                series = new MyTimeSeries(lineState.getName(), FixedMillisecond.class);
                            }
                            if (!(dataElement instanceof Real)) {
                                if (textList == null) {
                                    textList = new ArrayList<String>();
                                }
                                try {
                                    series.add((RegularTimePeriod)new FixedMillisecond(dttm), 0.0);
                                    textList.add(dataElement.toString());
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            Real obsReal = (Real)dataElement;
                            if (unit == null) {
                                unit = lineState.unit != null ? lineState.unit : obsReal.getUnit();
                            }
                            double d = value = lineState.unit != null ? obsReal.getValue(lineState.unit) : obsReal.getValue();
                            if (value != value && !Misc.equals(canonical, "DIR")) continue;
                            if (obIdx == 0 || value > max) {
                                max = value;
                            }
                            if (obIdx == 0 || value < min) {
                                min = value;
                            }
                            series.addOrUpdate((RegularTimePeriod)new FixedMillisecond(dttm), value);
                        }
                        this.addRange(min, max, "Data range from: " + lineState.getName());
                        if (series == null) continue;
                        Object object2 = this.MUTEX;
                        synchronized (object2) {
                            AbstractXYItemRenderer renderer = null;
                            if (Misc.equals(canonical, "SPEED")) {
                                speedUnit = unit;
                                speedSeries = series;
                                speedLineState = lineState;
                                continue;
                            }
                            if (Misc.equals(canonical, "DIR")) {
                                dirSeries = series;
                                dirLineState = lineState;
                                continue;
                            }
                            if (Misc.equals(canonical, "U")) {
                                speedUnit = unit;
                                speedSeries = series;
                                polarWind = false;
                                speedLineState = lineState;
                                continue;
                            }
                            if (Misc.equals(canonical, "V")) {
                                dirSeries = series;
                                dirLineState = lineState;
                                polarWind = false;
                                continue;
                            }
                            if (Misc.equals(canonical, "CC")) {
                                double scale = 0.0;
                                String n = lineState.getName();
                                if (n.equals("CC1") || n.equals("CC2") || n.equals("CC3") || n.equals("CC4")) {
                                    scale = 2.0;
                                }
                                renderer = new XYChartManager.CloudCoverageRenderer(lineState, scale);
                            }
                            if (textList != null) {
                                renderer = new XYChartManager.TextRenderer(textList, lineState);
                            }
                            Axis axis = this.addSeries(series, lineState, paramIdx, (XYItemRenderer)renderer, true);
                            if (Misc.equals(canonical, "CC") || textList != null) {
                                axis.setVisible(false);
                            }
                        }
                        ++paramIdx;
                    }
                    if (speedSeries != null && dirSeries != null) {
                        XYChartManager.WindbarbRenderer renderer = new XYChartManager.WindbarbRenderer(speedLineState, (Series)speedSeries, (Series)dirSeries, speedUnit, polarWind);
                        renderer.isSouth = obs != null && obs.size() > 0 ? obs.get(0).getEarthLocation().getLatitude().getValue() < 0.0 : false;
                        Axis axis = this.addSeries(speedSeries, speedLineState, paramIdx++, (XYItemRenderer)renderer, true);
                        if (speedLineState.getVerticalPosition() != 3) {
                            axis.setVisible(false);
                        }
                        speedSeries = null;
                        dirSeries = null;
                    }
                    if (speedSeries != null) {
                        this.addSeries(speedSeries, speedLineState, paramIdx++, null, true);
                    }
                    if (dirSeries != null) {
                        this.addSeries(dirSeries, dirLineState, paramIdx, null, true);
                    }
                }
            }
            this.updateContents();
        }
        finally {
            this.doneLoadingData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTracks(List<LineState> lines) throws VisADException, RemoteException {
        try {
            Object object = this.MUTEX;
            synchronized (object) {
                int paramIdx = 0;
                this.clearLineStates();
                this.settingData = true;
                this.initCharts();
                for (LineState lineState : lines) {
                    if (!lineState.getVisible()) continue;
                    this.addLineState(lineState);
                    MyTimeSeries series = new MyTimeSeries(lineState.getName(), FixedMillisecond.class);
                    List<DateTime> dates = lineState.getTimes();
                    List<Real> values = lineState.getValues();
                    if (dates == null || values == null) continue;
                    for (int pointIdx = 0; pointIdx < dates.size(); ++pointIdx) {
                        Date dttm = Util.makeDate(dates.get(pointIdx));
                        double value = values.get(pointIdx).getValue();
                        series.addOrUpdate((RegularTimePeriod)new FixedMillisecond(dttm), value);
                    }
                    XYItemRenderer renderer = null;
                    Axis axis = this.addSeries(series, lineState, paramIdx, renderer, true);
                    ++paramIdx;
                }
            }
            this.updateContents();
        }
        finally {
            this.doneLoadingData();
        }
    }

    public void setShowAnimationTime(boolean value) {
        this.showAnimationTime = value;
    }

    public boolean getShowAnimationTime() {
        return this.showAnimationTime;
    }

    public XYDataset getDummyDataset() {
        TimeSeriesCollection dummy = new TimeSeriesCollection();
        return dummy;
    }

    public void setLocation(LatLonPoint llp) {
        this.sunriseLocation = llp;
        this.sunriseDates = null;
        this.getContents().repaint();
    }

    private void drawSunriseSunset(Graphics2D g2, XYPlot plot, Rectangle2D dataArea) {
        if (this.sunriseLocation == null) {
            return;
        }
        DateAxis domainAxis = (DateAxis)plot.getDomainAxis();
        Date startDate = domainAxis.getMinimumDate();
        Date endDate = domainAxis.getMaximumDate();
        if (this.sunriseDates == null || !Misc.equals(startDate, this.lastStartDate) || !Misc.equals(endDate, this.lastEndDate)) {
            this.lastStartDate = startDate;
            this.lastEndDate = endDate;
            this.sunriseDates = IdvTimeline.makeSunriseDates(this.sunriseLocation, startDate, endDate);
        }
        int top = (int)dataArea.getY();
        int bottom = (int)(dataArea.getY() + dataArea.getHeight());
        int height = bottom - top;
        g2.setColor(Color.yellow);
        Shape originalClip = g2.getClip();
        g2.clip(dataArea);
        for (int i = 0; i < this.sunriseDates.size(); i += 2) {
            Date d1 = (Date)this.sunriseDates.get(i + 1);
            Date d2 = (Date)this.sunriseDates.get(i);
            int x1 = (int)domainAxis.valueToJava2D((double)d1.getTime(), dataArea, RectangleEdge.BOTTOM);
            int x2 = (int)domainAxis.valueToJava2D((double)d2.getTime(), dataArea, RectangleEdge.BOTTOM);
            g2.fillRect(x1, top, x2 - x1, height);
        }
        g2.setClip(originalClip);
    }

    private void drawTime(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        try {
            Animation animation = this.control.getSomeAnimation();
            if (animation == null) {
                return;
            }
            Real dttm = animation.getAniValue();
            if (dttm == null) {
                return;
            }
            g2.setStroke(new BasicStroke());
            g2.setColor(Color.black);
            double timeValue = dttm.getValue(CommonUnit.secondsSinceTheEpoch);
            int x = (int)domainAxis.valueToJava2D(timeValue * 1000.0, dataArea, RectangleEdge.BOTTOM);
            if ((double)x < dataArea.getX() || (double)x > dataArea.getX() + dataArea.getWidth()) {
                return;
            }
            int bottom = (int)(dataArea.getY() + dataArea.getHeight());
            int top = (int)dataArea.getY();
            boolean offset = false;
            int w = 8;
            int w2 = w / 2;
            int[] xs = new int[]{x - w2, x, x + w2, x};
            int[] ys = new int[]{top, top + w, top, top};
            g2.fillPolygon(xs, ys, xs.length);
            if (clockImage != null) {
                g2.drawImage(clockImage, x - clockImage.getWidth(null) / 2, bottom - clockImage.getHeight(null), null);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    private static class MyTimeSeries
    extends TimeSeries {
        List<TimeSeriesDataItem> items = new ArrayList<TimeSeriesDataItem>();
        HashSet<TimeSeriesDataItem> seen = new HashSet();

        public MyTimeSeries(String name, Class c) {
            super((Comparable)((Object)name), c);
        }

        public void add(TimeSeriesDataItem item) {
            if (this.seen.contains(item)) {
                return;
            }
            this.seen.add(item);
            this.items.add(item);
        }

        public void add(RegularTimePeriod period, double value) {
            TimeSeriesDataItem item = new TimeSeriesDataItem(period, value);
            this.add(item);
        }

        public void finish() {
            this.items = new ArrayList<TimeSeriesDataItem>(Misc.sort(this.items));
            for (TimeSeriesDataItem item : this.items) {
                this.data.add(item);
            }
            this.fireSeriesChanged();
        }
    }
}

