/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.control.chart.ChartWrapper;
import ucar.unidata.ui.TableSorter;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.FieldImpl;
import visad.FlatField;
import visad.Unit;
import visad.VisADException;

public class TableChartWrapper
extends ChartWrapper {
    private JTable table;
    private AbstractTableModel tableModel;
    private TableSorter sorter;
    private List data = new ArrayList();
    private List times = new ArrayList();
    boolean showTimes = true;
    private int maxRows = 0;
    private List unitList = new ArrayList();
    private boolean showRawData = false;

    public TableChartWrapper() {
    }

    public TableChartWrapper(String name, List dataChoices) {
        super(name, dataChoices);
    }

    @Override
    public String getTypeName() {
        return "Table";
    }

    private void createChart() {
        if (this.table != null) {
            return;
        }
        this.tableModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public int getRowCount() {
                return TableChartWrapper.this.maxRows;
            }

            @Override
            public int getColumnCount() {
                return TableChartWrapper.this.dataChoiceWrappers.size() + (TableChartWrapper.this.showTimes ? 1 : 0);
            }

            @Override
            public Object getValueAt(int row, int column) {
                List dataList;
                if (TableChartWrapper.this.showTimes) {
                    if (column == 0) {
                        if (row < TableChartWrapper.this.times.size()) {
                            return TableChartWrapper.this.times.get(row);
                        }
                        return "";
                    }
                    --column;
                }
                if (row < (dataList = (List)TableChartWrapper.this.data.get(column)).size()) {
                    return dataList.get(row);
                }
                return new Float(Float.NaN);
            }

            @Override
            public String getColumnName(int column) {
                if (TableChartWrapper.this.showTimes) {
                    if (column == 0) {
                        return "Time";
                    }
                    --column;
                }
                if (column < TableChartWrapper.this.dataChoiceWrappers.size()) {
                    Unit unit;
                    String unitString = "";
                    if (column < TableChartWrapper.this.unitList.size() && (unit = (Unit)TableChartWrapper.this.unitList.get(column)) != null) {
                        unitString = " [" + unit + "]";
                    }
                    return TableChartWrapper.this.dataChoiceWrappers.get(column).toString() + unitString;
                }
                return "";
            }
        };
        this.sorter = new TableSorter(this.tableModel){

            @Override
            protected Comparator getComparator(int column) {
                if (TableChartWrapper.this.showTimes && column == 0) {
                    return super.getComparator(column);
                }
                return COMPARABLE_COMAPRATOR;
            }
        };
        this.table = new JTable(this.sorter);
        JTableHeader header = this.table.getTableHeader();
        header.setToolTipText("Click to sort");
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    if (e.getClickCount() > 1 && TableChartWrapper.this.showTimes) {
                        int row = TableChartWrapper.this.table.rowAtPoint(e.getPoint());
                        System.err.println("row:" + row + " " + TableChartWrapper.this.times.size());
                        if (row >= 0 && row < TableChartWrapper.this.times.size()) {
                            Date dttm = (Date)TableChartWrapper.this.times.get(row);
                            TableChartWrapper.this.firePropertyChange("prop.selectedtime", null, new Double(dttm.getTime()));
                        }
                    }
                    return;
                }
                TableChartWrapper.this.showPopup(TableChartWrapper.this.table, e.getX(), e.getY());
            }
        });
        this.table.setToolTipText("Right click to show menu; Double click to set time in other charts");
    }

    @Override
    protected JComponent doMakeContents() {
        this.createChart();
        JScrollPane scrollPane = new JScrollPane(this.table);
        return GuiUtils.topCenter(this.getDisplayLabel(), scrollPane);
    }

    @Override
    protected List getPopupMenuItems(List items) {
        final JCheckBoxMenuItem mi = new JCheckBoxMenuItem("Show Raw Data", this.showRawData);
        mi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                TableChartWrapper.this.setShowRawData(mi.isSelected());
                try {
                    TableChartWrapper.this.loadData();
                }
                catch (Exception exc) {
                    LogUtil.logException("Error creating data set", exc);
                }
            }
        });
        items.add(mi);
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Export Table...", this, "exportData"));
        return super.getPopupMenuItems(items);
    }

    public void exportData() {
        GuiUtils.exportAsCsv("", this.sorter);
    }

    @Override
    public void loadData() throws VisADException, RemoteException {
        try {
            this.createChart();
            List timeRanges = this.getTimeFilterRanges();
            List dataChoices = this.getDataChoices();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("track type", "id.timetrace");
            this.unitList.clear();
            this.times.clear();
            this.data.clear();
            this.showTimes = true;
            DisplayConventions dc = this.getDisplayControl().getDisplayConventions();
            this.maxRows = 0;
            for (int paramIdx = 0; paramIdx < dataChoices.size(); ++paramIdx) {
                ArrayList<Double> dataList = new ArrayList<Double>();
                ArrayList<Date> timeList = new ArrayList<Date>();
                this.data.add(dataList);
                DataChoice dataChoice = (DataChoice)dataChoices.get(paramIdx);
                FlatField data = this.getFlatField((FieldImpl)dataChoice.getData(null, props));
                Unit[] units = Util.getDefaultRangeUnits(data);
                this.unitList.add(units[0]);
                double[][] samples = ((FieldImpl)data).getValues(false);
                double[] timeValues = this.getTimeValues(samples, data);
                double[][] result = this.filterData(samples[0], timeValues);
                double[] values = result[0];
                timeValues = result[1];
                for (int i = 0; i < values.length; ++i) {
                    if (this.showRawData) {
                        dataList.add(new Double(values[i]));
                    } else {
                        dataList.add(Misc.parseNumber(dc.format(values[i])));
                    }
                    if (!this.showTimes) continue;
                    timeList.add(new Date((long)timeValues[i]));
                }
                this.maxRows = Math.max(this.maxRows, dataList.size());
                if (!this.showTimes) continue;
                if (this.times.size() > 0) {
                    if (this.times.equals(timeList)) continue;
                    this.showTimes = false;
                    continue;
                }
                this.times = timeList;
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating data set", exc);
        }
        this.tableModel.fireTableStructureChanged();
    }

    @Override
    protected boolean canDoResolution() {
        return false;
    }

    @Override
    protected boolean canBeASourceForTimeSelectionEvents() {
        return true;
    }

    @Override
    public String toString() {
        return "Table Plot: " + this.getName();
    }

    public void setShowRawData(boolean value) {
        this.showRawData = value;
    }

    public boolean getShowRawData() {
        return this.showRawData;
    }
}

