/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.control.chart.ChartWrapper;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.visad.Util;
import visad.FieldImpl;
import visad.FlatField;
import visad.Unit;
import visad.VisADException;

public class StatisticsChartWrapper
extends ChartWrapper {
    private JTable table;
    private List expressions = Misc.newList("'<html>'+name + ' [<b>' + unit.toString()+'</b>]'+'</html>'", "values.__len__()", "str(min)+'/'+str(max)+'/'+str(average)");
    private List labels = Misc.newList("Name", "# Points", "Min/Max/Avg");
    private AbstractTableModel tableModel;
    private List stats = new ArrayList();
    private JTextArea expressionText;
    private JTextArea labelText;

    public StatisticsChartWrapper() {
    }

    public StatisticsChartWrapper(String name, List dataChoices) {
        super(name, dataChoices);
    }

    @Override
    public String getTypeName() {
        return "Statistics Table";
    }

    private void createChart() {
        if (this.table != null) {
            return;
        }
        this.tableModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public int getRowCount() {
                return StatisticsChartWrapper.this.dataChoiceWrappers.size();
            }

            @Override
            public int getColumnCount() {
                return StatisticsChartWrapper.this.labels.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row >= StatisticsChartWrapper.this.dataChoiceWrappers.size() || row >= StatisticsChartWrapper.this.stats.size()) {
                    return "";
                }
                Stat stat = (Stat)StatisticsChartWrapper.this.stats.get(row);
                if (column >= 0 && column < stat.values.size()) {
                    return stat.values.get(column);
                }
                return "";
            }

            @Override
            public String getColumnName(int column) {
                if (column >= 0 && column < StatisticsChartWrapper.this.labels.size()) {
                    return (String)StatisticsChartWrapper.this.labels.get(column);
                }
                return "";
            }
        };
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                StatisticsChartWrapper.this.showPopup(StatisticsChartWrapper.this.table, e.getX(), e.getY());
            }
        });
        this.table.setToolTipText("Right click to edit");
    }

    @Override
    protected JComponent doMakeContents() {
        this.createChart();
        JScrollPane scrollPane = new JScrollPane(this.table);
        return GuiUtils.topCenter(this.getDisplayLabel(), scrollPane);
    }

    @Override
    public void loadData() throws VisADException, RemoteException {
        this.createChart();
        List dataChoices = this.getDataChoices();
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("track type", "id.timetrace");
            this.stats.clear();
            DisplayConventions dc = this.getDisplayControl().getDisplayConventions();
            for (int paramIdx = 0; paramIdx < dataChoices.size(); ++paramIdx) {
                DataChoice dataChoice = (DataChoice)dataChoices.get(paramIdx);
                FlatField data = this.getFlatField((FieldImpl)dataChoice.getData(null, props));
                Stat stat = new Stat();
                this.stats.add(stat);
                Unit[] units = Util.getDefaultRangeUnits(data);
                Range[] ranges = GridUtil.getMinMax(data);
                double[][] samples = ((FieldImpl)data).getValues(false);
                double[] timeValues = this.getTimeValues(samples, data);
                double[][] results = this.filterData(samples[0], timeValues);
                double[] values = results[0];
                timeValues = results[1];
                Date[] timeArray = new Date[timeValues.length];
                for (int i = 0; i < timeValues.length; ++i) {
                    timeArray[i] = new Date((long)timeValues[i]);
                }
                stat.min = Misc.parseNumber(dc.format(ranges[0].getMin()));
                stat.max = Misc.parseNumber(dc.format(ranges[0].getMax()));
                double total = 0.0;
                for (int i = 0; i < values.length; ++i) {
                    total += values[i];
                }
                if (values.length > 0) {
                    stat.average = Misc.parseNumber(dc.format(total / (double)values.length));
                }
                stat.points = new Integer(values.length);
                stat.unit = units[0];
                stat.values.clear();
                PythonInterpreter interpreter = this.getInterpreter();
                interpreter.set("field", data);
                interpreter.set("max", stat.max);
                interpreter.set("min", stat.min);
                interpreter.set("average", stat.average);
                interpreter.set("values", values);
                interpreter.set("times", timeArray);
                interpreter.set("name", dataChoice.getName());
                interpreter.set("description", dataChoice.getDescription());
                interpreter.set("unit", stat.unit);
                for (int i = 0; i < this.expressions.size(); ++i) {
                    PyObject pyResult = interpreter.eval((String)this.expressions.get(i));
                    Object resultObject = pyResult.__tojava__(Object.class);
                    stat.values.add(resultObject);
                }
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating data set", exc);
        }
        this.tableModel.fireTableStructureChanged();
    }

    @Override
    protected boolean applyProperties() {
        boolean result = super.applyProperties();
        if (!result) {
            return false;
        }
        System.err.println("text:" + this.expressionText.getText());
        List<String> labelLines = StringUtil.split(this.labelText.getText(), "\n", true, true);
        List<String> expressionLines = StringUtil.split(this.expressionText.getText(), "\n", true, true);
        if (labelLines.size() != expressionLines.size()) {
            LogUtil.userErrorMessage("There must be the same number of labels as expressions");
            return false;
        }
        if (!Misc.equals(labelLines, this.labels) || !Misc.equals(expressionLines, this.expressions)) {
            this.labels = labelLines;
            this.expressions = expressionLines;
            try {
                this.loadData();
            }
            catch (Exception exc) {
                LogUtil.logException("Error loading data", exc);
                return false;
            }
        }
        return result;
    }

    @Override
    public String[] getPropertyTabs() {
        return new String[]{"Data", "Columns"};
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx != 1) {
            return;
        }
        StringBuffer expSB = new StringBuffer();
        StringBuffer labelSB = new StringBuffer();
        for (int i = 0; i < this.labels.size(); ++i) {
            labelSB.append(this.labels.get(i) + "\n");
            expSB.append(this.expressions.get(i) + "\n");
        }
        this.labelText = new JTextArea(labelSB.toString(), 10, 10);
        this.expressionText = new JTextArea(expSB.toString(), 10, 40);
        this.expressionText.setToolTipText("<html>Available fields:<ul><li>name (field short name)<li>description (field long name)<li>unit (value unit)<li>values (array of float values)<li>times (array of Date values)<li>max<li>min<li>average</ul></html>");
        JScrollPane sp1 = new JScrollPane(this.labelText, 22, 30);
        JScrollPane sp2 = new JScrollPane(this.expressionText, 22, 30);
        JPanel textPanel = GuiUtils.doLayout(new Component[]{GuiUtils.topCenter(GuiUtils.cLabel("Labels"), sp1), GuiUtils.topCenter(GuiUtils.cLabel("Expressions"), sp2)}, 2, new double[]{1.0, 3.0}, GuiUtils.WT_Y);
        comps.add(GuiUtils.top(GuiUtils.rLabel("Columns: ")));
        comps.add(textPanel);
    }

    @Override
    protected boolean canDoResolution() {
        return false;
    }

    @Override
    public String toString() {
        return "Statistics Plot: " + this.getName();
    }

    public void setExpressions(List value) {
        this.expressions = value;
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void setLabels(List value) {
        this.labels = value;
    }

    public List getLabels() {
        return this.labels;
    }

    private static class Stat {
        List values = new ArrayList();
        Integer points;
        Unit unit;
        Double min;
        Double max;
        Double average;

        private Stat() {
        }
    }
}

