/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.chart.ChartWrapper;
import ucar.unidata.idv.control.chart.DataChoiceWrapper;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.idv.control.chart.MyScatterPlot;
import ucar.unidata.idv.control.chart.PlotWrapper;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.FieldImpl;
import visad.FlatField;
import visad.Unit;
import visad.VisADException;

public class ScatterPlotChartWrapper
extends PlotWrapper {
    private MyScatterPlot plot;
    private XYSeriesCollection dataset;
    double[] timeValues1;
    double[] timeValues2;

    public ScatterPlotChartWrapper() {
    }

    public ScatterPlotChartWrapper(String name, List dataChoices) {
        super(name, dataChoices);
    }

    @Override
    public String getTypeName() {
        return "Scatter Plot";
    }

    @Override
    public boolean chartPanelMouseClicked(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event) || event.getClickCount() < 2) {
            return super.chartPanelMousePressed(event);
        }
        List series = this.plot.getSeries();
        double minDistance = 100.0;
        int minIdx = -1;
        double minTime = -1.0;
        for (int seriesIdx = 0; seriesIdx < series.size(); ++seriesIdx) {
            NumberAxis rangeAxis = (NumberAxis)this.plot.getRangeAxis(seriesIdx);
            NumberAxis domainAxis = (NumberAxis)this.plot.getDomainAxis(seriesIdx);
            double[][] data = (double[][])series.get(seriesIdx);
            for (int i = 0; i < data[0].length; ++i) {
                double x = domainAxis.valueToJava2D(data[0][i], this.getChartPanel().getScreenDataArea(), this.plot.getDomainAxisEdge());
                double y = rangeAxis.valueToJava2D(data[1][i], this.getChartPanel().getScreenDataArea(), this.plot.getRangeAxisEdge());
                double distance = Math.sqrt((x - (double)event.getX()) * (x - (double)event.getX()) + (y - (double)event.getY()) * (y - (double)event.getY()));
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minIdx = i;
            }
            if (minIdx < 0) continue;
            minTime = this.timeValues1[minIdx];
        }
        if (minIdx < 0) {
            return false;
        }
        this.firePropertyChange("prop.selectedtime", null, new Double(minTime));
        return false;
    }

    @Override
    public List getCategories() {
        List cats = DataCategory.parseCategories("trace;IMAGE-2D-*", false);
        return Misc.newList(cats, cats);
    }

    private void createChart() {
        if (this.chartPanel != null) {
            return;
        }
        XYSeries series1 = new XYSeries((Comparable)((Object)"Series 1"));
        this.dataset = new XYSeriesCollection(series1);
        String name = this.getName();
        if (name == null) {
            name = "Scatter Plot";
        }
        this.chart = this.createScatterPlot(name, "Domain", "Range", PlotOrientation.VERTICAL, true, false, false);
        this.initXYPlot(this.plot);
        this.plot.setRenderer((XYItemRenderer)new MyRenderer(3));
        this.doMakeChartPanel(this.chart);
    }

    @Override
    protected JComponent doMakeContents() {
        this.createChart();
        return this.chartPanel;
    }

    @Override
    public String chartPanelGetToolTipText(MouseEvent event) {
        return "Right click to show menu; Double click to set time in other charts";
    }

    private JFreeChart createScatterPlot(String title, String xAxisLabel, String yAxisLabel, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setAutoRangeIncludesZero(false);
        this.plot = new MyScatterPlot((XYDataset)this.dataset, null, (ValueAxis)xAxis, (ValueAxis)yAxis);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, legend);
        return chart;
    }

    @Override
    protected boolean applyProperties() {
        return super.applyProperties();
    }

    @Override
    public void loadData() throws VisADException, RemoteException {
        try {
            this.createChart();
            for (int dataSetIdx = 0; dataSetIdx < this.plot.getDatasetCount(); ++dataSetIdx) {
                XYSeriesCollection dataset = (XYSeriesCollection)this.plot.getDataset(dataSetIdx);
                dataset.removeAllSeries();
            }
            this.plot.removeAllSeries();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("track type", "id.timetrace");
            List dataChoiceWrappers = this.getDataChoiceWrappers();
            int dataSetCnt = 0;
            for (int paramIdx = 0; paramIdx < dataChoiceWrappers.size() && paramIdx + 1 < dataChoiceWrappers.size(); paramIdx += 2) {
                DataChoiceWrapper wrapper1 = (DataChoiceWrapper)dataChoiceWrappers.get(paramIdx);
                DataChoiceWrapper wrapper2 = (DataChoiceWrapper)dataChoiceWrappers.get(paramIdx + 1);
                DataChoice dataChoice1 = wrapper1.getDataChoice();
                DataChoice dataChoice2 = wrapper2.getDataChoice();
                FlatField data1 = this.getFlatField((FieldImpl)dataChoice1.getData(null, props));
                FlatField data2 = this.getFlatField((FieldImpl)dataChoice2.getData(null, props));
                Unit unit1 = Util.getDefaultRangeUnits(data1)[0];
                Unit unit2 = Util.getDefaultRangeUnits(data2)[0];
                NumberAxis rangeAxis = new NumberAxis(wrapper2.getLabel(unit2));
                NumberAxis domainAxis = new NumberAxis(wrapper1.getLabel(unit1));
                domainAxis.setAutoRange(this.getAutoRange());
                Color c = wrapper1.getColor(paramIdx);
                MyRenderer renderer = new MyRenderer(wrapper1.getLineState().getShape());
                domainAxis.setLabelPaint((Paint)c);
                rangeAxis.setLabelPaint((Paint)c);
                renderer.setSeriesPaint(0, c);
                double[][] samples1 = data1.getValues(false);
                double[][] samples2 = data2.getValues(false);
                double[] timeValues1 = this.getTimeValues(samples1, data1);
                double[] timeValues2 = this.getTimeValues(samples2, data2);
                double[][] values1 = this.filterData(samples1[0], timeValues1);
                double[][] values2 = this.filterData(samples2[0], timeValues2);
                if (values1.length > 1) {
                    this.timeValues1 = values1[1];
                    this.timeValues2 = values2[1];
                }
                double[][] values = new double[][]{values1[0], values2[0]};
                this.plot.addSeries(values);
                XYSeriesCollection dataset = new XYSeriesCollection(new XYSeries((Comparable)((Object)"")));
                if (!this.getAutoRange()) {
                    NumberAxis oldRangeAxis = (NumberAxis)this.plot.getRangeAxis(dataSetCnt);
                    NumberAxis oldDomainAxis = (NumberAxis)this.plot.getDomainAxis(dataSetCnt);
                    if (oldRangeAxis != null && oldDomainAxis != null) {
                        rangeAxis.setRange(oldRangeAxis.getRange());
                        domainAxis.setRange(oldDomainAxis.getRange());
                    }
                }
                this.plot.setDataset(dataSetCnt, (XYDataset)dataset);
                this.plot.setRenderer(dataSetCnt, (XYItemRenderer)renderer);
                this.plot.setRangeAxis(dataSetCnt, (ValueAxis)rangeAxis, false);
                this.plot.setDomainAxis(dataSetCnt, (ValueAxis)domainAxis, false);
                this.plot.mapDatasetToRangeAxis(dataSetCnt, dataSetCnt);
                this.plot.mapDatasetToDomainAxis(dataSetCnt, dataSetCnt);
                if (!this.getAutoRange()) {
                    rangeAxis.setAutoRange(false);
                    domainAxis.setAutoRange(false);
                }
                ++dataSetCnt;
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating data set", exc);
        }
    }

    @Override
    protected JComponent doMakeWrapperDisplayComponent(int idx, ChartWrapper.FieldProperties fieldProperty) {
        if (idx % 2 != 0) {
            return new JLabel(" ");
        }
        LineState ls = fieldProperty.wrapper.getLineState();
        ls.getPropertyContents();
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(GuiUtils.inset((Component)ls.colorSwatch, 4));
        comps.add(ls.shapeBox);
        return GuiUtils.left(GuiUtils.hbox(comps, 4));
    }

    @Override
    public List getFieldSelectionLabels() {
        return Misc.newList("X Axis Field", "Y Axis Field");
    }

    @Override
    public boolean doMultipleAddFields() {
        return false;
    }

    @Override
    public boolean canDoParameters() {
        return true;
    }

    @Override
    protected boolean canBeASourceForTimeSelectionEvents() {
        return true;
    }

    @Override
    protected boolean canDoColors() {
        return true;
    }

    @Override
    public boolean canDoWrapperColor() {
        return true;
    }

    @Override
    public String toString() {
        return "Scatter Plot: " + this.getName();
    }

    public static class MyRenderer
    extends XYLineAndShapeRenderer {
        int shape;

        public MyRenderer(int shape) {
            super(false, true);
            this.shape = shape;
        }

        public boolean isSeriesVisibleInLegend(int i) {
            return false;
        }
    }
}

