/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.control.chart.ChartWrapper;
import ucar.unidata.idv.control.chart.DataChoiceWrapper;
import ucar.unidata.idv.control.chart.TimeSeriesChartWrapper;
import ucar.unidata.idv.control.chart.WayPoint;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.Unit;
import visad.VisADException;

public class ReadoutTable
extends ChartWrapper {
    private JTable table;
    private JLabel dateLabel;
    private JPanel topPanel;
    private AbstractTableModel tableModel;
    private List dataList = new ArrayList();
    private List unitList = new ArrayList();
    private boolean showRawData = false;
    private WayPoint wayPoint;

    public ReadoutTable() {
    }

    public ReadoutTable(String name, List dataChoices) {
        super(name, dataChoices);
    }

    @Override
    public String getTypeName() {
        return "Readout Table";
    }

    @Override
    public void doRemove() {
        super.doRemove();
        if (this.wayPoint != null) {
            this.wayPoint.removePropertyChangeListener(this);
            this.wayPoint = null;
        }
    }

    private void createChart() {
        if (this.table != null) {
            return;
        }
        this.dateLabel = new JLabel(" ");
        this.topPanel = GuiUtils.left(GuiUtils.label("Date: ", this.dateLabel));
        this.tableModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public int getRowCount() {
                return ReadoutTable.this.getDataChoiceWrappers().size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row >= ReadoutTable.this.getDataChoiceWrappers().size()) {
                    return "";
                }
                if (row >= ReadoutTable.this.dataList.size()) {
                    return "";
                }
                if (column == 0) {
                    return "<html>" + ((DataChoiceWrapper)ReadoutTable.this.getDataChoiceWrappers().get(row)).getName() + " [<b>" + ReadoutTable.this.unitList.get(row) + "</b>]</html>";
                }
                if (column == 1) {
                    double value = Double.NaN;
                    double[][] d = (double[][])ReadoutTable.this.dataList.get(row);
                    ReadoutTable.this.checkWayPoint();
                    if (ReadoutTable.this.wayPoint == null) {
                        value = d[0][0];
                    } else {
                        double time = ReadoutTable.this.wayPoint.getDomainValue();
                        int length = d[1].length;
                        for (int i = 0; i < length; ++i) {
                            if (!(time <= d[1][i]) && i != length - 1) continue;
                            value = d[0][i];
                            break;
                        }
                        if (ReadoutTable.this.showRawData) {
                            return new Double(value);
                        }
                        DisplayConventions dc = ReadoutTable.this.getDisplayControl().getDisplayConventions();
                        return Misc.parseNumber(dc.format(value));
                    }
                }
                return "";
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Field";
                }
                if (column == 1) {
                    return "Value";
                }
                return "";
            }
        };
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                ReadoutTable.this.showPopup(ReadoutTable.this.table, e.getX(), e.getY());
            }
        });
        this.table.setToolTipText("Right click to edit");
    }

    @Override
    protected JComponent doMakeContents() {
        this.createChart();
        JScrollPane scrollPane = new JScrollPane(this.table);
        return GuiUtils.topCenter(this.getDisplayLabel(), GuiUtils.topCenter(this.topPanel, scrollPane));
    }

    private void wayPointChanged() {
        if (this.table != null) {
            this.table.repaint();
        }
        if (this.dateLabel != null) {
            if (this.wayPoint != null) {
                try {
                    this.dateLabel.setText("" + new DateTime(this.wayPoint.getDomainValue() / 1000.0));
                }
                catch (VisADException ve) {
                    this.dateLabel.setText("" + new Date((long)this.wayPoint.getDomainValue()));
                }
            } else {
                this.dateLabel.setText(" ");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("prop.waypointvalue")) {
            try {
                this.wayPointChanged();
            }
            catch (Exception exc) {
                LogUtil.logException("Error creating data set", exc);
            }
            return;
        }
        super.propertyChange(event);
    }

    @Override
    protected List getPopupMenuItems(List items) {
        final JCheckBoxMenuItem mi = new JCheckBoxMenuItem("Show Raw Data", this.showRawData);
        mi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ReadoutTable.this.setShowRawData(mi.isSelected());
                try {
                    ReadoutTable.this.loadData();
                }
                catch (Exception exc) {
                    LogUtil.logException("Error creating data set", exc);
                }
            }
        });
        items.add(mi);
        if (this.getDisplayGroup() != null) {
            List comps = this.getDisplayGroup().getAncestorGroup().findDisplayComponents(TimeSeriesChartWrapper.class);
            JMenu selectMenu = null;
            this.checkWayPoint();
            if (this.wayPoint != null) {
                selectMenu = new JMenu("Select Way Point");
                items.add(selectMenu);
                selectMenu.add(GuiUtils.makeMenuItem("Remove Way Point: " + this.wayPoint, this, "removeWayPoint"));
            }
            for (int i = 0; i < comps.size(); ++i) {
                TimeSeriesChartWrapper tscw = (TimeSeriesChartWrapper)comps.get(i);
                if (tscw.getWayPoints().size() == 0) continue;
                if (selectMenu == null) {
                    selectMenu = new JMenu("Select Way Point");
                    items.add(selectMenu);
                }
                JMenu timeSeriesMenu = new JMenu(tscw.getName());
                selectMenu.add(timeSeriesMenu);
                for (int wayPointIdx = 0; wayPointIdx < tscw.getWayPoints().size(); ++wayPointIdx) {
                    WayPoint wayPoint = (WayPoint)tscw.getWayPoints().get(wayPointIdx);
                    timeSeriesMenu.add(GuiUtils.makeMenuItem("# " + (wayPointIdx + 1) + " " + wayPoint.getName(), this, "setWayPoint", wayPoint));
                }
            }
        }
        return super.getPopupMenuItems(items);
    }

    private void checkWayPoint() {
        if (this.wayPoint != null && !this.wayPoint.isActive()) {
            this.removeWayPoint();
        }
    }

    public void removeWayPoint() {
        this.setWayPoint(null);
    }

    @Override
    public void loadData() throws VisADException, RemoteException {
        try {
            this.createChart();
            List dataChoices = this.getDataChoices();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("track type", "id.timetrace");
            this.unitList.clear();
            this.dataList.clear();
            DisplayConventions dc = this.getDisplayControl().getDisplayConventions();
            for (int paramIdx = 0; paramIdx < dataChoices.size(); ++paramIdx) {
                DataChoice dataChoice = (DataChoice)dataChoices.get(paramIdx);
                FlatField data = this.getFlatField((FieldImpl)dataChoice.getData(null, props));
                Unit[] units = Util.getDefaultRangeUnits(data);
                double[][] samples = ((FieldImpl)data).getValues(false);
                double[] timeValues = this.getTimeValues(samples, data);
                double[][] results = this.filterData(samples[0], timeValues);
                double[] values = results[0];
                timeValues = results[1];
                this.unitList.add(units[0]);
                this.dataList.add(new double[][]{values, timeValues});
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating data set", exc);
        }
        this.wayPointChanged();
        this.tableModel.fireTableStructureChanged();
    }

    @Override
    public String toString() {
        return "Readout Table: " + this.getName();
    }

    public void setShowRawData(boolean value) {
        this.showRawData = value;
    }

    public boolean getShowRawData() {
        return this.showRawData;
    }

    public void setWayPoint(WayPoint value) {
        if (this.wayPoint != null) {
            this.wayPoint.removePropertyChangeListener(this);
        }
        this.wayPoint = value;
        if (this.wayPoint != null) {
            this.wayPoint.addPropertyChangeListener(this);
        }
        this.wayPointChanged();
    }

    public WayPoint getWayPoint() {
        return this.wayPoint;
    }
}

