/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;
import ucar.unidata.idv.control.chart.ChartAnnotation;
import ucar.unidata.idv.control.chart.TimeSeriesChartWrapper;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public class RangeFilter
extends ChartAnnotation {
    public static int TYPE_LESSTHAN = 0;
    public static int TYPE_GREATERTHAN = 1;
    public static final int ANNOTATION_WIDTH = 10;
    private int type = TYPE_LESSTHAN;
    private double rangeValue = 0.0;
    private JRadioButton lessThanButton;
    private JRadioButton greaterThanButton;
    private JTextField valueFld;
    private RangeFilter attached;

    public RangeFilter() {
    }

    public RangeFilter(double rangeValue, TimeSeriesChartWrapper timeseries) {
        super(timeseries);
        this.rangeValue = rangeValue;
    }

    @Override
    public String getToolTipText() {
        if (this.attached == null) {
            return "<html>Range Filter: <b>" + this.formatValue(this.getRangeValue()) + "</b></html>";
        }
        String lessThan = this.type == TYPE_LESSTHAN ? this.formatValue(this.getRangeValue()) : this.formatValue(this.attached.getRangeValue());
        String greaterThan = this.type == TYPE_GREATERTHAN ? this.formatValue(this.getRangeValue()) : this.formatValue(this.attached.getRangeValue());
        return "<html> Range Filter: <b>" + lessThan + " - " + greaterThan + " </b></html>";
    }

    @Override
    public void doRemove() {
        super.doRemove();
        if (this.attached != null) {
            this.attached.attached = null;
        }
    }

    @Override
    public String getTypeName() {
        return "Range Filter";
    }

    public boolean valueOk(double value) {
        if (this.type == TYPE_LESSTHAN) {
            return value <= this.rangeValue;
        }
        return value >= this.rangeValue;
    }

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.type = this.lessThanButton.isSelected() ? TYPE_LESSTHAN : TYPE_GREATERTHAN;
        this.rangeValue = Misc.parseNumber(this.valueFld.getText().trim());
        return true;
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx != 0) {
            return;
        }
        comps.add(GuiUtils.rLabel("Type: "));
        this.lessThanButton = new JRadioButton("Less Than", this.type == TYPE_LESSTHAN);
        this.greaterThanButton = new JRadioButton("Greater Than", this.type == TYPE_GREATERTHAN);
        GuiUtils.buttonGroup(this.lessThanButton, this.greaterThanButton);
        comps.add(GuiUtils.left(GuiUtils.hbox(this.lessThanButton, this.greaterThanButton)));
        comps.add(GuiUtils.rLabel("Range Value: "));
        this.valueFld = new JTextField("" + this.rangeValue);
        comps.add(this.valueFld);
    }

    @Override
    public void setPosition(int x, int y) {
        TimeSeriesChartWrapper tscw = (TimeSeriesChartWrapper)this.getPlotWrapper();
        double rangeValue = tscw.getRangeValue(y);
        this.setRangeValue(rangeValue);
    }

    @Override
    public void setPosition(MouseEvent event) {
        int diff = event.getY() - this.y;
        this.setPosition(event.getX(), event.getY());
        if (this.attached != null && event.isShiftDown()) {
            this.attached.setPosition(event.getX(), this.attached.y + diff);
        }
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        int[] ys;
        int[] xs;
        super.setGraphicsState(g2);
        if (!this.getPlotWrapper().okToDraw(this)) {
            return;
        }
        g2.setStroke(new BasicStroke());
        boolean selected = this.getSelected();
        if (this.attached != null) {
            selected |= this.attached.getSelected();
        }
        if (selected) {
            g2.setColor(COLOR_SELECTED);
        } else {
            g2.setColor(this.getColor());
        }
        this.y = (int)rangeAxis.valueToJava2D(this.rangeValue, dataArea, RectangleEdge.LEFT);
        int width = 10;
        int width2 = 5;
        this.x = (int)dataArea.getX();
        if (this.type == TYPE_LESSTHAN) {
            xs = new int[]{this.x, this.x + width, this.x + width2, this.x};
            ys = new int[]{this.y, this.y, this.y + width, this.y};
        } else {
            xs = new int[]{this.x, this.x + width, this.x + width2, this.x};
            ys = new int[]{this.y, this.y, this.y - width, this.y};
        }
        g2.fillPolygon(xs, ys, xs.length);
        g2.setColor(Color.gray);
        g2.drawLine(this.x + width, this.y, (int)(dataArea.getX() + dataArea.getWidth()), this.y);
        if (this.attached != null && this.type == TYPE_LESSTHAN) {
            int otherY = (int)rangeAxis.valueToJava2D(this.attached.rangeValue, dataArea, RectangleEdge.LEFT);
            g2.drawLine(this.x + width2, this.y + width, this.x + width2, otherY - width);
        }
    }

    public void setRangeValue(double value) {
        this.rangeValue = value;
    }

    public double getRangeValue() {
        return this.rangeValue;
    }

    public void setType(int value) {
        this.type = value;
    }

    public int getType() {
        return this.type;
    }

    public RangeFilter doMakeAttached(MouseEvent event) {
        if (this.attached != null) {
            return this.attached;
        }
        TimeSeriesChartWrapper tscw = (TimeSeriesChartWrapper)this.getPlotWrapper();
        if (this.type == TYPE_GREATERTHAN) {
            this.attached = new RangeFilter(tscw.getRangeValue(event.getY() - 30), tscw);
            this.attached.setType(TYPE_LESSTHAN);
        } else {
            this.attached = new RangeFilter(tscw.getRangeValue(event.getY() + 30), tscw);
            this.attached.setType(TYPE_GREATERTHAN);
        }
        this.attached.setAttached(this);
        return this.attached;
    }

    public void setAttached(RangeFilter value) {
        this.attached = value;
    }

    public RangeFilter getAttached() {
        return this.attached;
    }

    public void addChangeListener(AnnotationChangeListener arg0) {
    }

    public void removeChangeListener(AnnotationChangeListener arg0) {
    }
}

