/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import ucar.unidata.idv.control.chart.ChartAnnotation;
import ucar.unidata.idv.control.chart.ChartWrapper;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public abstract class PlotWrapper
extends ChartWrapper
implements KeyListener {
    protected static final boolean EVENT_PASSON = false;
    protected static final boolean EVENT_DONTPASSON = true;
    private Color backgroundColor = Color.lightGray;
    private Color dataAreaColor = Color.white;
    private LineState domainLineState = new LineState();
    private LineState rangeLineState = new LineState();
    protected MyChartPanel chartPanel;
    protected JFreeChart chart;
    private JComponent backgroundSwatch;
    private JComponent dataAreaSwatch;
    private JCheckBox autoRangeCbx;
    private boolean autoRange = true;

    public PlotWrapper() {
    }

    public PlotWrapper(String name, List dataChoices) {
        super(name, dataChoices);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean okToDraw(ChartAnnotation annotation) {
        return true;
    }

    protected boolean canDoColors() {
        return true;
    }

    public void annotationChanged(ChartAnnotation chartAnnotation) {
        this.signalChartChanged();
    }

    @Override
    public String[] getPropertyTabs() {
        return new String[]{"Data", "Display"};
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx != 1) {
            this.autoRangeCbx = new JCheckBox("", this.autoRange);
            comps.add(GuiUtils.rLabel("Auto Range: "));
            comps.add(this.autoRangeCbx);
            return;
        }
        if (this.canDoColors()) {
            this.backgroundSwatch = GuiUtils.makeColorSwatchWidget(this.backgroundColor, "")[0];
            this.dataAreaSwatch = GuiUtils.makeColorSwatchWidget(this.dataAreaColor, "")[0];
            comps.add(GuiUtils.rLabel("Color: "));
            List colorComps = Misc.newList(new JLabel("Background:"), this.backgroundSwatch, new JLabel("Data Area:"), this.dataAreaSwatch);
            comps.add(GuiUtils.left(GuiUtils.hbox(colorComps, 4)));
            comps.add(GuiUtils.rLabel("Domain Lines: "));
            comps.add(this.domainLineState.getPropertyContents());
            comps.add(GuiUtils.rLabel("Range Lines: "));
            comps.add(this.rangeLineState.getPropertyContents());
        }
    }

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        if (!this.domainLineState.applyProperties()) {
            return false;
        }
        if (!this.rangeLineState.applyProperties()) {
            return false;
        }
        if (this.autoRangeCbx.isSelected() != this.autoRange) {
            this.autoRange = this.autoRangeCbx.isSelected();
            this.resetPlot();
        }
        this.backgroundColor = this.backgroundSwatch.getBackground();
        this.dataAreaColor = this.dataAreaSwatch.getBackground();
        Plot plot = this.chart.getPlot();
        plot.setBackgroundPaint((Paint)this.dataAreaColor);
        if (plot instanceof XYPlot) {
            ((XYPlot)plot).setDomainGridlinesVisible(this.domainLineState.getVisible());
            ((XYPlot)plot).setRangeGridlinesVisible(this.rangeLineState.getVisible());
            ((XYPlot)plot).setDomainGridlinePaint((Paint)this.domainLineState.getColor());
            ((XYPlot)plot).setRangeGridlinePaint((Paint)this.rangeLineState.getColor());
            ((XYPlot)plot).setDomainGridlineStroke((Stroke)this.domainLineState.getStroke());
            ((XYPlot)plot).setRangeGridlineStroke((Stroke)this.rangeLineState.getStroke());
        }
        return true;
    }

    @Override
    protected List getPopupMenuItems(List items) {
        super.getPopupMenuItems(items);
        this.chartPanel.addChartMenuItems(items);
        return items;
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        if (this.chart != null) {
            this.chart.setTitle(value);
        }
    }

    public String chartPanelGetToolTipText(MouseEvent event) {
        return null;
    }

    public boolean chartPanelMousePressed(MouseEvent e) {
        return false;
    }

    public boolean chartPanelMouseClicked(MouseEvent e) {
        return false;
    }

    public boolean chartPanelMouseDragged(MouseEvent event) {
        return SwingUtilities.isRightMouseButton(event);
    }

    public boolean chartPanelMouseReleased(MouseEvent event) {
        return false;
    }

    protected ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void signalChartChanged() {
        if (this.chartPanel != null) {
            this.chartPanel.chartChanged(new ChartChangeEvent((Object)this));
        }
    }

    protected MyChartPanel doMakeChartPanel(JFreeChart chart) {
        if (this.chartPanel == null) {
            this.chartPanel = new MyChartPanel(chart);
            this.chartPanel.addKeyListener(this);
            this.chartPanel.setPreferredSize(this.getPreferredChartSize());
            this.chartPanel.setMouseZoomable(true, false);
        }
        return this.chartPanel;
    }

    protected void panPlot(boolean right) {
        this.panPlot(right, 0.1);
    }

    protected void panPlot(boolean right, double percent) {
        if (!(this.chart.getPlot() instanceof XYPlot)) {
            return;
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        int cnt = plot.getDomainAxisCount();
        for (int i = 0; i < cnt; ++i) {
            ValueAxis axis = plot.getDomainAxis(i);
            Range range = axis.getRange();
            double width = range.getUpperBound() - range.getLowerBound();
            double width2 = width / 2.0;
            double step = right ? width * percent : -width * percent;
            axis.centerRange(range.getLowerBound() + step + width2);
        }
    }

    private void upDownPlot(boolean up) {
        if (!(this.chart.getPlot() instanceof XYPlot)) {
            return;
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        int cnt = plot.getRangeAxisCount();
        for (int i = 0; i < cnt; ++i) {
            ValueAxis axis = plot.getRangeAxis(i);
            Range range = axis.getRange();
            double width = range.getUpperBound() - range.getLowerBound();
            double width2 = width / 2.0;
            double step = up ? width * 0.1 : -width * 0.1;
            axis.centerRange(range.getLowerBound() + step + width2);
        }
    }

    private void resetPlot() {
        if (this.chart == null) {
            return;
        }
        if (!(this.chart.getPlot() instanceof XYPlot)) {
            return;
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        int rcnt = plot.getRangeAxisCount();
        for (int i = 0; i < rcnt; ++i) {
            ValueAxis axis = plot.getRangeAxis(i);
            System.err.println("range axis:" + axis);
            axis.setAutoRange(this.autoRange);
        }
        int dcnt = plot.getDomainAxisCount();
        for (int i = 0; i < dcnt; ++i) {
            ValueAxis axis = plot.getDomainAxis(i);
            System.err.println("domain axis:" + axis);
            axis.setAutoRange(this.autoRange);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 39) {
            this.panPlot(true);
        } else if (e.getKeyCode() == 37) {
            this.panPlot(false);
        } else if (e.getKeyCode() == 38) {
            this.upDownPlot(true);
        } else if (e.getKeyCode() == 40) {
            this.upDownPlot(false);
        } else if (e.getKeyCode() == 82 && e.isControlDown()) {
            this.resetPlot();
        } else {
            super.keyPressed(e);
        }
    }

    protected void initXYPlot(XYPlot plot) {
        plot.setBackgroundPaint((Paint)this.dataAreaColor);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.setDomainGridlinesVisible(this.domainLineState.getVisible());
        plot.setRangeGridlinesVisible(this.rangeLineState.getVisible());
        plot.setDomainGridlinePaint((Paint)this.domainLineState.getColor());
        plot.setRangeGridlinePaint((Paint)this.rangeLineState.getColor());
        plot.setDomainGridlineStroke((Stroke)this.domainLineState.getStroke());
        plot.setRangeGridlineStroke((Stroke)this.rangeLineState.getStroke());
    }

    protected Dimension getPreferredChartSize() {
        return new Dimension(500, 270);
    }

    @Override
    public void setBackgroundColor(Color value) {
        this.backgroundColor = value;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setDataAreaColor(Color value) {
        this.dataAreaColor = value;
    }

    public Color getDataAreaColor() {
        return this.dataAreaColor;
    }

    public void setDomainLineState(LineState value) {
        this.domainLineState = value;
    }

    public LineState getDomainLineState() {
        return this.domainLineState;
    }

    public void setRangeLineState(LineState value) {
        this.rangeLineState = value;
    }

    public LineState getRangeLineState() {
        return this.rangeLineState;
    }

    public void setAutoRange(boolean value) {
        this.autoRange = value;
    }

    public boolean getAutoRange() {
        return this.autoRange;
    }

    protected class MyChartPanel
    extends ChartPanel {
        public int lastEventX;
        public int lastEventY;

        public MyChartPanel(JFreeChart chart) {
            super(chart, true);
            this.lastEventX = 0;
            this.lastEventY = 0;
        }

        public String getToolTipText(MouseEvent event) {
            String fromChart = PlotWrapper.this.chartPanelGetToolTipText(event);
            if (fromChart == null) {
                return super.getToolTipText();
            }
            return fromChart;
        }

        protected void displayPopupMenu(int x, int y) {
            PlotWrapper.this.showPopup((JComponent)((Object)PlotWrapper.this.chartPanel), x, y);
        }

        protected JMenuItem addChartMenuItem(JMenu result, String label, String cmd) {
            JMenuItem mi = new JMenuItem(label);
            mi.setActionCommand(cmd);
            mi.addActionListener((ActionListener)((Object)this));
            result.add(mi);
            return mi;
        }

        protected void addChartMenuItems(List items) {
            items.add("separator");
            JMenu chartMenu = new JMenu("Zoom");
            items.add(chartMenu);
            JMenu[] menus = new JMenu[]{new JMenu("Zoom In"), new JMenu("Zoom Out"), new JMenu("Auto Range")};
            String[][] cmds = new String[][]{{"Both Axes", "ZOOM_IN_BOTH", "Domain Axis", "ZOOM_IN_DOMAIN", "Range Axis", "ZOOM_IN_RANGE"}, {"Both Axes", "ZOOM_OUT_BOTH", "Domain Axis", "ZOOM_DOMAIN_BOTH", "Range Axis", "ZOOM_RANGE_BOTH"}, {"Both Axes", "ZOOM_RESET_BOTH", "Domain Axis", "ZOOM_RESET_DOMAIN", "Range Axis", "ZOOM_RESET_RANGE"}};
            for (int i = 0; i < menus.length; ++i) {
                chartMenu.add(menus[i]);
                for (int j = 0; j < cmds[i].length; j += 2) {
                    this.addChartMenuItem(menus[i], cmds[i][j], cmds[i][j + 1]);
                }
            }
        }

        public void mouseDragged(MouseEvent event) {
            this.lastEventX = event.getX();
            this.lastEventY = event.getY();
            if (PlotWrapper.this.chartPanelMouseDragged(event)) {
                return;
            }
            super.mouseDragged(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.lastEventX = event.getX();
            this.lastEventY = event.getY();
            if (PlotWrapper.this.chartPanelMouseReleased(event)) {
                return;
            }
            super.mouseReleased(event);
        }

        public void mouseClicked(MouseEvent event) {
            this.lastEventX = event.getX();
            this.lastEventY = event.getY();
            if (PlotWrapper.this.chartPanelMouseClicked(event)) {
                return;
            }
            super.mouseClicked(event);
        }

        public void mousePressed(MouseEvent event) {
            this.lastEventX = event.getX();
            this.lastEventY = event.getY();
            this.requestFocus();
            if (PlotWrapper.this.chartPanelMousePressed(event)) {
                return;
            }
            super.mousePressed(event);
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("PROPERTIES")) {
                PlotWrapper.this.showProperties();
                return;
            }
            super.actionPerformed(event);
        }
    }
}

