/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import ucar.unidata.idv.control.chart.TimeSeriesChartWrapper;

public class MyTimeSeriesPlot
extends XYPlot {
    private TimeSeriesChartWrapper timeseries;
    private boolean ignoreDataSetChanges = false;

    public MyTimeSeriesPlot(TimeSeriesChartWrapper timeseries, XYDataset dataset, ValueAxis timeAxis, ValueAxis valueAxis) {
        super(dataset, timeAxis, valueAxis, null);
        this.timeseries = timeseries;
    }

    public boolean render(Graphics2D g2, Rectangle2D dataArea, int index, PlotRenderingInfo info, CrosshairState crosshairState) {
        XYDataset dataset = this.getDataset(index);
        if (DatasetUtilities.isEmptyOrNull((XYDataset)dataset)) {
            return false;
        }
        ValueAxis rangeAxis = this.getRangeAxisForDataset(index);
        ValueAxis domainAxis = this.getDomainAxisForDataset(index);
        AxisLocation rangeAxisLocation = this.getRangeAxisLocation(index);
        AxisLocation domainAxisLocation = this.getDomainAxisLocation(index);
        RectangleEdge rangeEdge = this.getRangeAxisEdge();
        RectangleEdge domainEdge = this.getDomainAxisEdge();
        int seriesCount = dataset.getSeriesCount();
        for (int series = seriesCount - 1; series >= 0; --series) {
            int itemCount = dataset.getItemCount(series);
            int[] xs = new int[itemCount];
            int[] ys = new int[itemCount];
            g2.setStroke(this.getRendererForDataset(dataset).getSeriesStroke(series));
            g2.setPaint(this.getRendererForDataset(dataset).getSeriesPaint(series));
            int pointCnt = 0;
            for (int item = 0; item < itemCount; ++item) {
                double transY;
                double y1;
                double x1 = dataset.getXValue(series, item);
                if (!this.timeseries.valuesOk(index, x1, y1 = dataset.getYValue(series, item))) {
                    if (pointCnt <= 0) continue;
                    g2.drawPolyline(xs, ys, pointCnt);
                    pointCnt = 0;
                    continue;
                }
                double transX = domainAxis.valueToJava2D(x1, dataArea, domainEdge);
                if (!dataArea.contains(transX, transY = rangeAxis.valueToJava2D(y1, dataArea, rangeEdge))) continue;
                xs[pointCnt] = (int)(transX + 0.5);
                ys[pointCnt] = (int)(transY + 0.5);
                if (++pointCnt <= 10) continue;
                g2.drawPolyline(xs, ys, pointCnt);
                xs[0] = xs[pointCnt - 1];
                ys[0] = ys[pointCnt - 1];
                pointCnt = 1;
            }
            if (pointCnt > 1) {
                g2.drawPolyline(xs, ys, pointCnt);
            }
            long l = System.currentTimeMillis();
        }
        return true;
    }

    public void drawOutline(Graphics2D g2, Rectangle2D dataArea) {
        super.drawOutline(g2, dataArea);
        Shape originalClip = g2.getClip();
        double y = dataArea.getY();
        Rectangle2D.Double newClip = new Rectangle2D.Double(dataArea.getX(), 0.0, dataArea.getWidth(), dataArea.getHeight() + y);
        g2.clip(newClip);
        this.drawAnnotations(g2, dataArea, null);
        g2.clip(originalClip);
    }

    public void datasetChanged(DatasetChangeEvent event) {
        if (this.ignoreDataSetChanges) {
            return;
        }
        super.datasetChanged(event);
    }

    public void setIgnoreDataSetChanges(boolean b) {
        boolean fireChange = b != this.ignoreDataSetChanges && !b;
        this.ignoreDataSetChanges = b;
        if (fireChange) {
            this.datasetChanged(new DatasetChangeEvent((Object)this, (Dataset)this.getDataset()));
        }
    }
}

