/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import ucar.unidata.idv.control.chart.ScatterPlotChartWrapper;

public class MyScatterPlot
extends XYPlot
implements ValueAxisPlot {
    private List series = new ArrayList();
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public MyScatterPlot(XYDataset dataset, double[][] data, ValueAxis domainAxis, ValueAxis rangeAxis) {
        super(dataset, domainAxis, rangeAxis, null);
        this.addSeries(data);
    }

    public void removeAllSeries() {
        this.series.clear();
    }

    public List getSeries() {
        return this.series;
    }

    public void addSeries(double[][] newData) {
        this.series.add(newData);
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (newData != null) {
            this.notifyListeners(new PlotChangeEvent((Plot)this));
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Fast_Scatter_Plot");
    }

    public PlotOrientation getOrientation() {
        return PlotOrientation.VERTICAL;
    }

    public boolean render(Graphics2D g2, Rectangle2D dataArea, int index, PlotRenderingInfo info, CrosshairState crosshairState) {
        if (index >= this.series.size()) {
            return false;
        }
        XYDataset dataset = this.getDataset(index);
        g2.setStroke(new BasicStroke());
        ScatterPlotChartWrapper.MyRenderer renderer = (ScatterPlotChartWrapper.MyRenderer)this.getRendererForDataset(dataset);
        g2.setPaint(renderer.getSeriesPaint(0));
        int shape = renderer.shape;
        PlotOrientation orientation = this.getOrientation();
        int seenCnt = 0;
        int xx = (int)dataArea.getMinX();
        int ww = (int)dataArea.getWidth();
        int yy = (int)dataArea.getMaxY();
        int hh = (int)dataArea.getHeight();
        ValueAxis rangeAxis = this.getRangeAxisForDataset(index);
        ValueAxis domainAxis = this.getDomainAxisForDataset(index);
        double domainMin = domainAxis.getLowerBound();
        double domainLength = domainAxis.getUpperBound() - domainMin;
        double rangeMin = rangeAxis.getLowerBound();
        double rangeLength = rangeAxis.getUpperBound() - rangeMin;
        int boxWidth = 6;
        double[][] data = (double[][])this.series.get(index);
        double[] d1 = data[0];
        double[] d2 = data[1];
        int size = d1.length;
        Hashtable<String, String> seen = new Hashtable<String, String>();
        int lastX = 0;
        int lastY = 0;
        GeneralPath path = new GeneralPath();
        long t1 = System.currentTimeMillis();
        block8: for (int i = 0; i < size; ++i) {
            int transX = (int)((double)xx + (double)ww * (d1[i] - domainMin) / domainLength);
            int transY = (int)((double)yy - (double)hh * (d2[i] - rangeMin) / rangeLength);
            String key = transX + "_" + transY;
            if (seen.get(key) != null) {
                ++seenCnt;
                continue;
            }
            seen.put(key, key);
            if (crosshairState != null) {
                crosshairState.updateCrosshairPoint(d1[i], d2[i], (double)transX, (double)transY, orientation);
            }
            switch (shape) {
                case 5: {
                    if (i > 1) {
                        g2.drawLine(lastX, lastY, transX, transY);
                    }
                    lastX = transX;
                    lastY = transY;
                }
                case 3: {
                    path.append(new Rectangle(transX, transY, 1, 1), false);
                    continue block8;
                }
                case 4: {
                    path.append(new Rectangle(transX, transY, 2, 2), false);
                    continue block8;
                }
                case 2: {
                    path.append(new Rectangle(transX - boxWidth / 2, transY - boxWidth / 2, boxWidth, boxWidth), false);
                    continue block8;
                }
                case 1: {
                    g2.drawLine(transX - boxWidth / 2, transY - boxWidth / 2, transX + boxWidth - boxWidth / 2, transY + boxWidth - boxWidth / 2);
                    g2.drawLine(transX + boxWidth - boxWidth / 2, transY - boxWidth / 2, transX - boxWidth / 2, transY + boxWidth - boxWidth / 2);
                    continue block8;
                }
                case 0: {
                    g2.drawLine(transX + boxWidth / 2, transY, transX + boxWidth / 2, transY + boxWidth);
                    g2.drawLine(transX, transY + boxWidth / 2, transX + boxWidth, transY + boxWidth / 2);
                }
            }
        }
        g2.fill(path);
        long t2 = System.currentTimeMillis();
        return true;
    }

    public Range getDataRange(ValueAxis axis) {
        int rangeIndex;
        if (this.series == null) {
            return new Range(0.0, 1.0);
        }
        boolean isDomainAxis = true;
        int index = -1;
        int domainIndex = this.getDomainAxisIndex(axis);
        if (domainIndex >= 0) {
            isDomainAxis = true;
            index = domainIndex;
        }
        if ((rangeIndex = this.getRangeAxisIndex(axis)) >= 0) {
            isDomainAxis = false;
            index = rangeIndex;
        }
        if (index < 0 || index >= this.series.size()) {
            return new Range(0.0, 1.0);
        }
        double[][] data = (double[][])this.series.get(index);
        if (isDomainAxis) {
            return this.calculateXDataRange(data);
        }
        return this.calculateYDataRange(data);
    }

    private Range calculateXDataRange(double[][] data) {
        Range result = null;
        if (data != null) {
            double lowest = Double.POSITIVE_INFINITY;
            double highest = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < data[0].length; ++i) {
                double v = data[0][i];
                if (v < lowest) {
                    lowest = v;
                }
                if (!(v > highest)) continue;
                highest = v;
            }
            if (lowest <= highest) {
                result = new Range(lowest, highest);
            }
        }
        return result;
    }

    private Range calculateYDataRange(double[][] data) {
        Range result = null;
        if (data != null) {
            double lowest = Double.POSITIVE_INFINITY;
            double highest = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < data[0].length; ++i) {
                double v = data[1][i];
                if (v < lowest) {
                    lowest = v;
                }
                if (!(v > highest)) continue;
                highest = v;
            }
            if (lowest <= highest) {
                result = new Range(lowest, highest);
            }
        }
        return result;
    }
}

