/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import visad.DateTime;
import visad.Real;
import visad.Unit;

public class LineState {
    public static final int VPOS_TOP = 0;
    public static final int VPOS_MIDDLE = 1;
    public static final int VPOS_BOTTOM = 2;
    public static final int VPOS_NONE = 3;
    public static final int HPOS_LEFT = 0;
    public static final int HPOS_MIDDLE = 1;
    public static final int HPOS_RIGHT = 2;
    public static final int HPOS_NONE = 3;
    public static int[] VPOS_VALUES = new int[]{0, 1, 2, 3};
    public static String[] VPOS_LABELS = new String[]{"Top", "Middle", "Bottom", "None (Use data if possible)"};
    public static int[] HPOS_VALUES = new int[]{0, 1, 2, 3};
    public static String[] HPOS_LABELS = new String[]{"Left", "Middle", "Right", "None (Use data if possible)"};
    public static final int LINETYPE_SHAPES = 1;
    public static final int LINETYPE_LINES = 2;
    public static final int LINETYPE_SHAPES_AND_LINES = 3;
    public static final int LINETYPE_AREA = 4;
    public static final int LINETYPE_AREA_AND_SHAPES = 5;
    public static final int LINETYPE_BAR = 6;
    public static final int[] LINETYPE_IDS = new int[]{2, 3, 1, 4, 5, 6};
    public static final String[] LINETYPE_LABELS = new String[]{"Lines", "Lines and shapes", "Shapes", "Area", "Area and shapes", "Bar Chart"};
    public static final int SIDE_UNDEFINED = 0;
    public static final int SIDE_LEFT = 1;
    public static final int SIDE_RIGHT = 2;
    public static final int[] SIDES = new int[]{0, 1, 2};
    public static final String[] SIDELABELS = new String[]{"Default", "Left", "Right"};
    private int side = 0;
    public static final int STROKE_SOLID = 0;
    public static final int STROKE_DOT = 1;
    public static final int STROKE_DASH = 2;
    public static final int STROKE_DOTDASH = 3;
    public static final int[] STROKE_IDS = new int[]{0, 1, 2, 3};
    public static final String[] STROKE_LABELS = new String[]{"_______", ". . . .", "- - - -", ". - . - ."};
    public static final int SHAPE_PLUS = 0;
    public static final int SHAPE_X = 1;
    public static final int SHAPE_RECTANGLE = 2;
    public static final int SHAPE_POINT = 3;
    public static final int SHAPE_LARGEPOINT = 4;
    public static final int SHAPE_VLINE = 5;
    public static final int SHAPE_HLINE = 6;
    public static int[] SHAPES = new int[]{3, 4, 2, 0, 1, 5, 6};
    public static String[] SHAPE_NAMES = new String[]{"Point", "Large Point", "Rectangle", "Plus", "X", "Vertical Line", "Hor. Line"};
    public static Color[] COLORS = new Color[]{Color.red, Color.cyan, Color.magenta, Color.green, Color.orange, Color.yellow};
    private int shape = 3;
    private boolean visible = true;
    private boolean valid = true;
    private boolean axisVisible = true;
    private Color color = Color.gray;
    private float width = 1.0f;
    private int strokeType = 0;
    JCheckBox visibleCbx;
    JCheckBox axisVisibleCbx;
    JComboBox sideCbx;
    GuiUtils.ColorSwatch colorSwatch;
    JComboBox strokeCbx;
    JComboBox typeCbx;
    JComboBox verticalPositionCbx;
    JComboBox horizontalPositionCbx;
    JRadioButton linearRangeBtn;
    JRadioButton logRangeBtn;
    JTextField widthFld;
    JComboBox shapeBox;
    JComboBox chartNameBox;
    JTextField nameField;
    JTextField minRangeFld;
    JTextField maxRangeFld;
    JButton popupRangeBtn;
    JCheckBox includesZeroCbx;
    boolean rangeIncludesZero = false;
    boolean useLogarithmicRange = false;
    Range range;
    private int lineType = 2;
    private int verticalPosition = 2;
    private int horizontalPosition = 1;
    private String chartName = null;
    private String name;
    private String nameMacro;
    private String axisLabel;
    protected int index;
    protected Unit unit;
    private boolean visibleInLegend = true;
    private boolean useVerticalPosition = true;
    private List<DateTime> times;
    private List<Real> values;

    public LineState() {
    }

    public LineState(Color color, float width, int strokeType) {
        this(color, width, strokeType, 2, 3);
    }

    public LineState(Color color, float width, int strokeType, int lineType, int shapeType) {
        this.color = color;
        this.width = width;
        this.strokeType = strokeType;
        this.lineType = lineType;
        this.shape = shapeType;
    }

    protected JComponent getPropertyContents() {
        return this.getPropertyContents(false, null, null);
    }

    public boolean showPropertiesDialog(PropertyChangeListener listener, List chartNames, List ranges) {
        return this.showPropertiesDialog(listener, true, true, chartNames, ranges);
    }

    public boolean showPropertiesDialog(final PropertyChangeListener propListener, boolean doVisible, boolean doRange, List chartNames, List sampleRanges) {
        JComponent comp = this.getPropertyContents(true, chartNames, sampleRanges);
        final JDialog dialog = GuiUtils.createDialog(null, this.getName() + " " + "Properties", true);
        final boolean[] ok = new boolean[]{false};
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
                    if (!LineState.this.applyProperties()) {
                        return;
                    }
                    ok[0] = true;
                    propListener.propertyChange(new PropertyChangeEvent(this, "properties", this, null));
                }
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                    dialog.dispose();
                }
            }
        };
        JPanel buttons = GuiUtils.makeApplyOkCancelButtons(listener);
        JPanel contents = GuiUtils.centerBottom(comp, buttons);
        dialog.getContentPane().add(contents);
        GuiUtils.showInCenter(dialog);
        return ok[0];
    }

    public List<DateTime> getTimes() {
        return this.times;
    }

    public List<Real> getValues() {
        return this.values;
    }

    public void setTrack(List<DateTime> times, List<Real> values) {
        this.times = times;
        this.values = values;
    }

    protected JComponent getPropertyContents(boolean full, List chartNames, List sampleRanges) {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        this.visibleCbx = new JCheckBox(full ? "Full Plot" : "Visible", this.visible);
        this.axisVisibleCbx = new JCheckBox("Axis", this.visible);
        if (full) {
            comps.add(GuiUtils.rLabel("Visiblity:"));
            comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.visibleCbx, (Component)this.axisVisibleCbx, 5)));
        }
        String nameToShow = this.name;
        if (this.nameMacro != null && this.nameMacro.length() > 0) {
            nameToShow = this.nameMacro;
        }
        this.nameField = new JTextField(nameToShow, 30);
        this.nameField.setToolTipText("Name of chart entry. Use \"%parameter%\" for parameter name");
        comps.add(GuiUtils.rLabel("Legend Label:"));
        comps.add(GuiUtils.left(this.nameField));
        if (chartNames != null) {
            this.chartNameBox = new JComboBox(new Vector(chartNames));
            if (this.chartName != null) {
                this.chartNameBox.setSelectedItem(this.chartName);
            }
            this.chartNameBox.setEditable(true);
            comps.add(GuiUtils.rLabel("Chart Name:"));
            comps.add(GuiUtils.left(this.chartNameBox));
        }
        this.sideCbx = GuiUtils.makeComboBox(SIDES, SIDELABELS, this.getSide());
        if (full) {
            comps.add(GuiUtils.rLabel("Axis Side:"));
            comps.add(GuiUtils.left(this.sideCbx));
        }
        if (full) {
            this.popupRangeBtn = GuiUtils.makeButton("...", this, "showRangePopup", sampleRanges);
            this.minRangeFld = new JTextField(this.range != null ? this.range.getMin() + "" : "", 5);
            this.maxRangeFld = new JTextField(this.range != null ? this.range.getMax() + "" : "", 5);
            List rangeComps = Misc.newList(new JLabel("Min:"), this.minRangeFld, new JLabel("Max:"), this.maxRangeFld);
            if (sampleRanges != null && sampleRanges.size() > 0) {
                rangeComps.add(this.popupRangeBtn);
            }
            this.includesZeroCbx = new JCheckBox("Includes Zero", this.rangeIncludesZero);
            rangeComps.add(this.includesZeroCbx);
            comps.add(GuiUtils.rLabel("Range:"));
            comps.add(GuiUtils.left(GuiUtils.hbox(rangeComps, 5)));
            this.linearRangeBtn = new JRadioButton("Linear", !this.useLogarithmicRange);
            this.logRangeBtn = new JRadioButton("Logarithmic", this.useLogarithmicRange);
            GuiUtils.buttonGroup(this.linearRangeBtn, this.logRangeBtn);
        }
        this.typeCbx = GuiUtils.makeComboBox(LINETYPE_IDS, LINETYPE_LABELS, this.lineType);
        this.shapeBox = GuiUtils.makeComboBox(SHAPES, SHAPE_NAMES, this.shape);
        if (full) {
            comps.add(GuiUtils.rLabel("Type:"));
            comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.typeCbx, (Component)new JLabel("  Shape:"), (Component)this.shapeBox, 5)));
        }
        this.strokeCbx = GuiUtils.makeComboBox(STROKE_IDS, STROKE_LABELS, this.strokeType);
        Font f = Font.decode("monospaced-BOLD");
        if (f != null) {
            this.strokeCbx.setFont(f);
        }
        this.widthFld = new JTextField("" + this.width, 3);
        JComponent[] bg = GuiUtils.makeColorSwatchWidget(this.color, "");
        this.colorSwatch = (GuiUtils.ColorSwatch)bg[0];
        comps.add(GuiUtils.rLabel("Line:"));
        ArrayList<JComponent> lineComps = new ArrayList<JComponent>();
        if (!full) {
            lineComps.add(this.visibleCbx);
        }
        lineComps.add(new JLabel("Stroke:"));
        lineComps.add(this.strokeCbx);
        lineComps.add(new JLabel("  "));
        lineComps.add(new JLabel("Width:"));
        lineComps.add(this.widthFld);
        lineComps.add(new JLabel("  "));
        lineComps.add(new JLabel("Color:"));
        lineComps.add(this.colorSwatch);
        comps.add(GuiUtils.left(GuiUtils.hbox(lineComps, 5)));
        if (full) {
            if (this.getUseVerticalPosition()) {
                comps.add(GuiUtils.rLabel("Vertical Position:"));
                this.verticalPositionCbx = GuiUtils.makeComboBox(VPOS_VALUES, VPOS_LABELS, this.verticalPosition);
                comps.add(GuiUtils.left(this.verticalPositionCbx));
            } else {
                comps.add(GuiUtils.rLabel("Horizontal Position:"));
                this.horizontalPositionCbx = GuiUtils.makeComboBox(HPOS_VALUES, HPOS_LABELS, this.horizontalPosition);
                comps.add(GuiUtils.left(this.horizontalPositionCbx));
            }
        }
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        return GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
    }

    public void showRangePopup(List ranges) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (int i = 0; i < ranges.size(); ++i) {
            Range r = (Range)ranges.get(i);
            items.add(GuiUtils.makeMenuItem(r.toString(), this, "setRangeInProperties", r));
        }
        GuiUtils.showPopupMenu(items, this.popupRangeBtn);
    }

    public void setRangeInProperties(Range r) {
        this.minRangeFld.setText(Misc.format(r.getMin()));
        this.maxRangeFld.setText(Misc.format(r.getMax()));
    }

    protected boolean applyProperties() {
        if (this.colorSwatch != null) {
            this.color = this.colorSwatch.getSwatchColor();
        }
        if (this.strokeCbx != null) {
            this.strokeType = GuiUtils.getValueFromBox(this.strokeCbx);
        }
        if (this.typeCbx != null) {
            this.lineType = GuiUtils.getValueFromBox(this.typeCbx);
        }
        if (this.sideCbx != null) {
            this.side = GuiUtils.getValueFromBox(this.sideCbx);
        }
        if (this.verticalPositionCbx != null) {
            this.verticalPosition = GuiUtils.getValueFromBox(this.verticalPositionCbx);
        }
        if (this.horizontalPositionCbx != null) {
            this.horizontalPosition = GuiUtils.getValueFromBox(this.horizontalPositionCbx);
        }
        if (this.shapeBox != null) {
            this.shape = GuiUtils.getValueFromBox(this.shapeBox);
        }
        if (this.nameMacro != null) {
            this.nameMacro = this.nameField.getText().trim();
        } else {
            this.name = this.nameField.getText().trim();
        }
        if (this.chartNameBox != null) {
            this.chartName = (String)this.chartNameBox.getSelectedItem();
        }
        if (this.includesZeroCbx != null) {
            this.rangeIncludesZero = this.includesZeroCbx.isSelected();
        }
        if (this.minRangeFld != null) {
            String minS = this.minRangeFld.getText().trim();
            String maxS = this.maxRangeFld.getText().trim();
            this.range = minS.length() == 0 || maxS.length() == 0 ? null : new Range(Misc.parseNumber(minS), Misc.parseNumber(maxS));
        }
        if (this.linearRangeBtn != null) {
            this.useLogarithmicRange = !this.linearRangeBtn.isSelected();
        }
        try {
            if (this.widthFld != null) {
                this.width = new Float(this.widthFld.getText().trim()).floatValue();
            }
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad width: " + this.widthFld.getText());
            return false;
        }
        if (this.visibleCbx != null) {
            this.visible = this.visibleCbx.isSelected();
        }
        if (this.axisVisibleCbx != null) {
            this.axisVisible = this.axisVisibleCbx.isSelected();
        }
        return true;
    }

    public static Color getFixedColor(int index) {
        int newIndex = index % COLORS.length;
        return COLORS[newIndex];
    }

    public BasicStroke getStroke() {
        return LineState.makeStroke(this.width, this.strokeType);
    }

    public static BasicStroke makeStroke(float width, int type) {
        float[] pattern = type == 0 ? new float[]{1000.0f} : (type == 2 ? new float[]{5.0f, 2.0f} : (type == 1 ? new float[]{2.0f, 2.0f} : new float[]{2.0f, 2.0f, 5.0f, 2.0f}));
        return new BasicStroke(width, 0, 2, 0.0f, pattern, 0.0f);
    }

    public Shape getPaintShape() {
        int w = 10;
        int w2 = w / 2;
        switch (this.shape) {
            case 5: {
                return new Polygon(new int[]{0, 0}, new int[]{-w, w}, 2);
            }
            case 6: {
                return new Polygon(new int[]{-w2, w}, new int[]{0, 0}, 2);
            }
            case 3: {
                return new Rectangle(-1, -1, 2, 2);
            }
            case 4: {
                return new Rectangle(-2, -2, 4, 4);
            }
            case 2: {
                return new Rectangle(-w2, -w2, w, w);
            }
            case 1: {
                GeneralPath path = new GeneralPath();
                path.append(new Polygon(new int[]{-w2, w2}, new int[]{-w2, w2}, 2), false);
                path.append(new Polygon(new int[]{w2, -w2}, new int[]{-w2, w2}, 2), false);
                return path;
            }
            case 0: {
                GeneralPath path = new GeneralPath();
                path.append(new Polygon(new int[]{0, 0}, new int[]{-w2, w2}, 2), false);
                path.append(new Polygon(new int[]{-w2, w2}, new int[]{0, 0}, 2), false);
                return path;
            }
        }
        return null;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColor(int index) {
        if (this.color == null) {
            this.color = LineState.getFixedColor(index);
        }
        return this.color;
    }

    public void setWidth(float value) {
        this.width = value;
    }

    public float getWidth() {
        return this.width;
    }

    public void setStrokeType(Integer value) {
        this.setStrokeType((int)value);
    }

    public void setStrokeType(int value) {
        this.strokeType = value;
    }

    public int getStrokeType() {
        return this.strokeType;
    }

    public void setShape(int value) {
        this.shape = value;
    }

    public int getShape() {
        return this.shape;
    }

    public void setRangeIncludesZero(boolean value) {
        this.rangeIncludesZero = value;
    }

    public boolean getRangeIncludesZero() {
        return this.rangeIncludesZero;
    }

    public void setRange(Range value) {
        this.range = value;
    }

    public Range getRange() {
        return this.range;
    }

    public void setUseLogarithmicRange(boolean value) {
        this.useLogarithmicRange = value;
    }

    public boolean getUseLogarithmicRange() {
        return this.useLogarithmicRange;
    }

    public void setLineType(int value) {
        this.lineType = value;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setChartName(String value) {
        this.chartName = value;
    }

    public String getChartName() {
        return this.chartName;
    }

    public void setNameIfNeeded(String value) {
        if (this.name == null || this.name.length() == 0) {
            this.setName(value);
        }
    }

    public boolean hasName() {
        return this.name != null && this.name.length() != 0;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setNameMacro(String value) {
        this.nameMacro = value;
    }

    public String getNameMacro() {
        return this.nameMacro;
    }

    public void setVerticalPosition(int value) {
        this.verticalPosition = value;
    }

    public int getVerticalPosition() {
        return this.verticalPosition;
    }

    public void setHorizontalPosition(int value) {
        this.horizontalPosition = value;
    }

    public int getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public void setSide(int value) {
        this.side = value;
    }

    public int getSide() {
        return this.side;
    }

    public void setAxisVisible(boolean value) {
        this.axisVisible = value;
    }

    public boolean getAxisVisible() {
        return this.axisVisible;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    public boolean getValid() {
        return this.valid;
    }

    public void setAxisLabel(String value) {
        this.axisLabel = value;
    }

    public String getAxisLabel() {
        return this.axisLabel;
    }

    public void setVisibleInLegend(boolean value) {
        this.visibleInLegend = value;
    }

    public boolean getVisibleInLegend() {
        return this.visibleInLegend;
    }

    public void setUseVerticalPosition(boolean value) {
        this.useVerticalPosition = value;
    }

    public boolean getUseVerticalPosition() {
        return this.useVerticalPosition;
    }

    public Unit getUnit() {
        return this.unit;
    }
}

