/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Color;
import java.awt.Paint;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.chart.DataChoiceWrapper;
import ucar.unidata.idv.control.chart.MyHistogramDataset;
import ucar.unidata.idv.control.chart.PlotWrapper;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.FieldImpl;
import visad.FlatField;
import visad.Unit;
import visad.VisADException;

public class HistogramWrapper
extends PlotWrapper {
    private XYPlot plot;
    private int bins = 100;
    private boolean stacked = false;
    private JTextField binFld;
    private JCheckBox stackedCbx;

    public HistogramWrapper() {
    }

    public HistogramWrapper(String name, List dataChoices) {
        super(name, dataChoices);
    }

    @Override
    public String getTypeName() {
        return "Histogram";
    }

    private void createChart() {
        if (this.chartPanel != null) {
            return;
        }
        MyHistogramDataset dataset = new MyHistogramDataset();
        this.chart = ChartFactory.createHistogram((String)"Histogram", null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.chart.getXYPlot().setForegroundAlpha(0.75f);
        this.plot = (XYPlot)this.chart.getPlot();
        this.initXYPlot(this.plot);
        this.chartPanel = this.doMakeChartPanel(this.chart);
    }

    @Override
    protected JComponent doMakeContents() {
        this.createChart();
        return this.chartPanel;
    }

    @Override
    public void loadData() throws VisADException, RemoteException {
        this.createChart();
        List dataChoiceWrappers = this.getDataChoiceWrappers();
        try {
            for (int dataSetIdx = 0; dataSetIdx < this.plot.getDatasetCount(); ++dataSetIdx) {
                MyHistogramDataset dataset = (MyHistogramDataset)this.plot.getDataset(dataSetIdx);
                dataset.removeAllSeries();
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("track type", "id.timetrace");
            for (int paramIdx = 0; paramIdx < dataChoiceWrappers.size(); ++paramIdx) {
                DataChoiceWrapper wrapper = (DataChoiceWrapper)dataChoiceWrappers.get(paramIdx);
                DataChoice dataChoice = wrapper.getDataChoice();
                FlatField data = this.getFlatField((FieldImpl)dataChoice.getData(null, props));
                Unit unit = Util.getDefaultRangeUnits(data)[0];
                double[][] samples = data.getValues(false);
                double[] actualValues = this.filterData(samples[0], this.getTimeValues(samples, data))[0];
                NumberAxis domainAxis = new NumberAxis(wrapper.getLabel(unit));
                Object renderer = this.stacked ? new StackedXYBarRenderer() : new XYBarRenderer();
                this.plot.setRenderer(paramIdx, (XYItemRenderer)renderer);
                Color c = wrapper.getColor(paramIdx);
                domainAxis.setLabelPaint((Paint)c);
                renderer.setSeriesPaint(0, (Paint)c);
                MyHistogramDataset dataset = new MyHistogramDataset();
                dataset.setType(HistogramType.FREQUENCY);
                dataset.addSeries((Comparable)((Object)(dataChoice.getName() + " [" + unit + "]")), actualValues, this.bins);
                this.plot.setDomainAxis(paramIdx, (ValueAxis)domainAxis, false);
                this.plot.mapDatasetToDomainAxis(paramIdx, paramIdx);
                this.plot.setDataset(paramIdx, (XYDataset)dataset);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating data set", exc);
            return;
        }
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx != 0) {
            return;
        }
        comps.add(GuiUtils.rLabel("Histogram: "));
        this.binFld = new JTextField("" + this.bins, 6);
        comps.add(GuiUtils.left(GuiUtils.hbox(Misc.newList(new JLabel("Number of Bins: "), this.binFld), 4)));
    }

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        try {
            this.bins = new Integer(this.binFld.getText().trim());
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad value for bins: " + this.binFld.getText());
            return false;
        }
        return true;
    }

    @Override
    protected boolean canDoColors() {
        return true;
    }

    @Override
    public boolean canDoWrapperColor() {
        return true;
    }

    public void setBins(int value) {
        this.bins = value;
    }

    public int getBins() {
        return this.bins;
    }

    public void setStacked(boolean value) {
        this.stacked = value;
    }

    public boolean getStacked() {
        return this.stacked;
    }
}

