/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Color;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.util.Misc;
import visad.Unit;

public class DataChoiceWrapper {
    public static final int SIDE_UNDEFINED = 0;
    public static final int SIDE_LEFT = 1;
    public static final int SIDE_RIGHT = 2;
    public static final int[] SIDES = new int[]{0, 1, 2};
    public static final String[] SIDELABELS = new String[]{"Default", "Left", "Right"};
    private DataChoice dataChoice;
    private int side = 0;
    private LineState lineState = new LineState(null, 1.0f, 0);
    private String myDescription;

    public DataChoiceWrapper() {
    }

    public DataChoiceWrapper(DataChoice dataChoice) {
        this.dataChoice = dataChoice;
    }

    public void setDataChoice(DataChoice value) {
        this.dataChoice = value;
    }

    public DataChoice getDataChoice() {
        return this.dataChoice;
    }

    public Color getColor(int index) {
        Color c = this.getColor();
        if (c == null) {
            c = LineState.getFixedColor(index);
        }
        return c;
    }

    public Color getColor() {
        return this.lineState.getColor();
    }

    public String getName() {
        return this.dataChoice.getName();
    }

    public String getDescription() {
        if (this.myDescription != null && this.myDescription.trim().length() > 0) {
            return this.myDescription;
        }
        if (this.dataChoice != null) {
            return this.dataChoice.getDescription();
        }
        return "";
    }

    public String getLabel(Unit unit) {
        return this.getDescription() + (unit == null ? " " : " [" + unit + "]");
    }

    public String toString() {
        return this.getDescription();
    }

    public void setSide(int value) {
        this.side = value;
    }

    public int getSide() {
        return this.side;
    }

    public void setMyDescription(String value) {
        if (value != null && this.dataChoice != null && Misc.equals(this.dataChoice.getDescription(), value)) {
            return;
        }
        this.myDescription = value;
    }

    public String getMyDescription() {
        return this.myDescription;
    }

    public void setLineState(LineState value) {
        this.lineState = value;
    }

    public LineState getLineState() {
        return this.lineState;
    }
}

