/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JViewport;
import org.python.util.PythonInterpreter;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.chart.DataChoiceWrapper;
import ucar.unidata.idv.control.chart.TimeSeriesChartWrapper;
import ucar.unidata.idv.control.multi.DisplayComponent;
import ucar.unidata.idv.control.multi.MultiDisplayHolder;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Range;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.AnimationWidget;
import visad.CommonUnit;
import visad.FieldImpl;
import visad.FlatField;
import visad.Real;
import visad.Unit;
import visad.VisADException;

public abstract class ChartWrapper
extends DisplayComponent
implements KeyListener {
    public static final String PROP_TIMERANGE = "prop.timerange";
    public static final String PROP_SELECTEDTIME = "prop.selectedtime";
    private double minDate = Double.NEGATIVE_INFINITY;
    private double maxDate = Double.POSITIVE_INFINITY;
    private double dataMinDate = Double.NEGATIVE_INFINITY;
    private double dataMaxDate = Double.POSITIVE_INFINITY;
    protected AnimationWidget animationWidget;
    protected List dataChoiceWrappers;
    private JSlider resolutionSlider;
    private double resolution = 1.0;
    private boolean chartOrderChanged;
    protected TimeSeriesChartWrapper timeFilterSource;
    protected ChartWrapper timeSelectSource;
    private boolean showTime = false;
    private boolean driveTime = false;
    private JComponent wrapperPanel;
    private List fieldProperties;
    private String jython = "";
    private PythonInterpreter interpreter;
    private JTextField jythonFld;
    private String animationShareGroup;

    public ChartWrapper() {
    }

    public ChartWrapper(String name, List dataChoices) {
        super(name);
        this.dataChoiceWrappers = this.wrapDataChoices(dataChoices);
    }

    public List getCategories() {
        List cats = DataCategory.parseCategories("trace", false);
        return Misc.newList(cats);
    }

    public void init(MultiDisplayHolder displayControl, List dataChoices) {
        this.dataChoiceWrappers = this.wrapDataChoices(dataChoices);
        this.displayControl = displayControl;
        if (this.getName() == null) {
            this.setName(this.getTypeName());
        }
    }

    @Override
    public void initDone() {
        super.initDone();
        if (this.canDoDriveTime()) {
            try {
                AnimationInfo animationInfo = new AnimationInfo();
                this.animationWidget = new AnimationWidget(animationInfo){

                    @Override
                    protected void handleSharedTime(Real time) {
                        if (!ChartWrapper.this.hasBeenInitialized) {
                            return;
                        }
                        super.handleSharedTime(time);
                        if (!time.isMissing()) {
                            ChartWrapper.this.animationTimeChanged(time);
                        }
                    }

                    public String toString() {
                        return "chart anim";
                    }
                };
                if (this.animationShareGroup != null) {
                    this.animationWidget.setShareGroup(this.animationShareGroup);
                }
                this.animationWidget.getContents();
                Animation animation = new Animation();
                this.animationWidget.setAnimation(animation);
            }
            catch (Exception exc) {
                LogUtil.logException("Creating animation widget", exc);
            }
        }
    }

    protected FlatField getFlatField(FieldImpl data) throws VisADException, RemoteException {
        FlatField ff = null;
        ff = GridUtil.isSequence(data) ? (FlatField)data.getSample(0) : (FlatField)data;
        return ff;
    }

    @Override
    public abstract String getTypeName();

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected List wrapDataChoices(List choices) {
        ArrayList<DataChoiceWrapper> result = new ArrayList<DataChoiceWrapper>();
        if (choices == null) {
            return result;
        }
        for (int i = 0; i < choices.size(); ++i) {
            DataChoice dataChoice = (DataChoice)choices.get(i);
            result.add(this.createDataChoiceWrapper(dataChoice));
        }
        return result;
    }

    protected DataChoiceWrapper createDataChoiceWrapper(DataChoice dataChoice) {
        return new DataChoiceWrapper(dataChoice);
    }

    protected List getTimeFilterRanges() {
        List filterRanges;
        List ranges = null;
        if (!(this.minDate == Double.NEGATIVE_INFINITY && this.maxDate == Double.POSITIVE_INFINITY || this.minDate == this.dataMinDate && this.maxDate == this.dataMaxDate)) {
            ranges = Misc.newList(new Range(this.minDate, this.maxDate));
        }
        if (this.timeFilterSource != null && (filterRanges = this.timeFilterSource.getTimeRanges()) != null) {
            if (ranges == null) {
                ranges = filterRanges;
            } else {
                ranges.addAll(filterRanges);
            }
        }
        return ranges;
    }

    public List getTimeRanges() {
        return null;
    }

    @Override
    protected List getPopupMenuItems(List items) {
        ChartWrapper chartWrapper;
        int i;
        boolean didSep;
        JMenu filterMenu;
        List comps;
        if (this.canDoParameters()) {
            items.add(GuiUtils.makeMenuItem("Add Field...", this, "addField"));
        }
        if (this.canDoJython() && this.jython != null && this.jython.trim().length() > 0) {
            items.add(GuiUtils.makeMenuItem("Apply Jython", this, "applyJython", this.jython));
        }
        items.add(GuiUtils.makeMenuItem("Remove Chart", this, "removeDisplayComponent"));
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Save Image...", this, "doSaveImage"));
        items.add(GuiUtils.makeMenuItem("Save Movie...", this, "doSaveMovie"));
        if (this.canDoDriveTime()) {
            items.add("separator");
            final JCheckBoxMenuItem mi1 = new JCheckBoxMenuItem("Show Animation Times", this.showTime);
            items.add(mi1);
            mi1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ChartWrapper.this.showTime = mi1.isSelected();
                }
            });
            final JCheckBoxMenuItem mi2 = new JCheckBoxMenuItem("Drive Animation Times", this.driveTime);
            items.add(mi2);
            mi2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ChartWrapper.this.driveTime = mi2.isSelected();
                }
            });
        }
        if (this.canDoTimeFilters() && this.getDisplayGroup() != null) {
            comps = this.getDisplayGroup().getAncestorGroup().findDisplayComponents(ChartWrapper.class);
            filterMenu = null;
            didSep = false;
            if (this.timeFilterSource != null) {
                filterMenu = new JMenu("Time Subset");
                didSep = true;
                items.add("separator");
                items.add(filterMenu);
                filterMenu.add(GuiUtils.makeMenuItem("Remove", this, "removeTimeFilterSource"));
            }
            for (i = 0; i < comps.size(); ++i) {
                chartWrapper = (ChartWrapper)comps.get(i);
                if (chartWrapper.getTimeRanges() == null) continue;
                if (filterMenu == null) {
                    filterMenu = new JMenu("Time Subset");
                    if (!didSep) {
                        items.add("separator");
                    }
                    didSep = true;
                    items.add(filterMenu);
                }
                filterMenu.add(GuiUtils.makeMenuItem("From: " + chartWrapper.getName(), this, "setTimeFilterSource", chartWrapper));
            }
        }
        if (this.canDoTimeSelect() && this.getDisplayGroup() != null) {
            comps = this.getDisplayGroup().getAncestorGroup().findDisplayComponents(ChartWrapper.class);
            filterMenu = null;
            didSep = false;
            if (this.timeSelectSource != null) {
                filterMenu = new JMenu("Time Select");
                didSep = true;
                items.add("separator");
                items.add(filterMenu);
                filterMenu.add(GuiUtils.makeMenuItem("Remove", this, "removeTimeSelectSource"));
            }
            for (i = 0; i < comps.size(); ++i) {
                chartWrapper = (ChartWrapper)comps.get(i);
                if (chartWrapper == this || !chartWrapper.canBeASourceForTimeSelectionEvents()) continue;
                if (filterMenu == null) {
                    filterMenu = new JMenu("Time Select");
                    if (!didSep) {
                        items.add("separator");
                    }
                    didSep = true;
                    items.add(filterMenu);
                }
                filterMenu.add(GuiUtils.makeMenuItem("From: " + chartWrapper.getName(), this, "setTimeSelectSource", chartWrapper));
            }
        }
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Properties...", this, "showProperties"));
        return items;
    }

    protected PythonInterpreter getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = this.getDisplayControl().getControlContext().getIdv().getJythonManager().createInterpreter();
        }
        return this.interpreter;
    }

    public void applyJython() {
        this.jython = this.jythonFld.getText();
        this.applyJython(this.jython);
    }

    protected void applyJython(String jython) {
        this.initializeJython(this.getInterpreter());
        try {
            this.interpreter.eval(jython);
        }
        catch (Exception exc) {
            LogUtil.logException("Error evaluating Jython", exc);
        }
    }

    protected void initializeJython(PythonInterpreter interpreter) {
        interpreter.set("chart", this);
    }

    protected boolean canDoJython() {
        return false;
    }

    protected boolean canBeASourceForTimeSelectionEvents() {
        return false;
    }

    protected boolean canDoTimeFilters() {
        return true;
    }

    protected boolean canDoTimeSelect() {
        return false;
    }

    protected boolean canDoDriveTime() {
        return false;
    }

    protected boolean canDoMinMaxDate() {
        return true;
    }

    protected boolean canDoResolution() {
        return true;
    }

    public boolean canDoParameters() {
        return true;
    }

    public boolean canDoRemoveParameters() {
        return true;
    }

    public boolean canDoDataChoiceList() {
        return true;
    }

    public boolean canDoWrapperColor() {
        return false;
    }

    public boolean canDoWrapperSide() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals(PROP_TIMERANGE)) {
            try {
                this.loadData();
            }
            catch (Exception exc) {
                LogUtil.logException("Error creating data set", exc);
            }
            return;
        }
        if (event.getPropertyName().equals("prop.removed")) {
            Object source = event.getSource();
            if (source == this.timeFilterSource) {
                this.setTimeFilterSource(null);
            }
            if (source == this.timeSelectSource) {
                this.setTimeSelectSource(null);
            }
        }
        super.propertyChange(event);
    }

    @Override
    public void doRemove() {
        super.doRemove();
        if (this.interpreter != null) {
            this.getDisplayControl().getControlContext().getIdv().getJythonManager().removeInterpreter(this.interpreter);
            this.interpreter = null;
        }
        if (this.timeFilterSource != null) {
            this.timeFilterSource.removePropertyChangeListener(this);
            this.timeFilterSource = null;
        }
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx != 0) {
            return;
        }
        if (this.canDoResolution()) {
            comps.add(GuiUtils.rLabel("Resolution: "));
            this.resolutionSlider = new JSlider(0, 100, (int)(100.0 * this.resolution));
            comps.add(GuiUtils.vbox(this.resolutionSlider, GuiUtils.leftRight(GuiUtils.lLabel("Low"), GuiUtils.rLabel("High"))));
        }
        if (this.canDoJython()) {
            comps.add(GuiUtils.rLabel("Jython: "));
            this.jythonFld = new JTextField(this.jython, 40);
            comps.add(GuiUtils.centerRight(this.jythonFld, GuiUtils.makeButton("Apply", this, "applyJython")));
        }
        if (this.canDoDataChoiceList()) {
            this.chartOrderChanged = false;
            this.fieldProperties = new ArrayList();
            for (int paramIdx = 0; paramIdx < this.dataChoiceWrappers.size(); ++paramIdx) {
                DataChoiceWrapper wrapper = (DataChoiceWrapper)this.dataChoiceWrappers.get(paramIdx);
                this.fieldProperties.add(new FieldProperties(wrapper));
            }
            this.wrapperPanel = new JPanel();
            this.updateWrapperPanel();
            JScrollPane sp = new JScrollPane(GuiUtils.left(this.wrapperPanel), 20, 30);
            sp.getVerticalScrollBar().setUnitIncrement(10);
            JViewport vp = sp.getViewport();
            sp.setPreferredSize(new Dimension(600, 200));
            comps.add(GuiUtils.top(GuiUtils.rLabel("Fields:")));
            comps.add(sp);
        }
    }

    private void moveFieldInProperties(int idx, boolean down) {
        if (down && idx == this.fieldProperties.size() - 1) {
            return;
        }
        if (!down && idx == 0) {
            return;
        }
        Object o2 = this.fieldProperties.remove(idx);
        int newIdx = down ? idx + 1 : idx - 1;
        this.fieldProperties.add(newIdx, o2);
        this.updateWrapperPanel();
    }

    private void updateWrapperPanel() {
        ArrayList<JComponent> wrapperComps = new ArrayList<JComponent>();
        wrapperComps.add(new JLabel("  "));
        wrapperComps.add(new JLabel("Remove   "));
        wrapperComps.add(new JLabel("Field    "));
        int columns = 3;
        if (this.canDoWrapperColor()) {
            wrapperComps.add(GuiUtils.cLabel("Width/Color/Style"));
            ++columns;
        }
        if (this.canDoWrapperSide()) {
            wrapperComps.add(GuiUtils.cLabel("Side"));
            ++columns;
        }
        for (int i = 0; i < this.fieldProperties.size(); ++i) {
            FieldProperties fieldProperty = (FieldProperties)this.fieldProperties.get(i);
            JButton upButton = GuiUtils.getImageButton("/auxdata/ui/icons/Up16.gif", this.getClass());
            JButton downButton = GuiUtils.getImageButton("/auxdata/ui/icons/Down16.gif", this.getClass());
            downButton.addActionListener(new ObjectListener(new Integer(i)){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ChartWrapper.this.moveFieldInProperties((Integer)this.theObject, true);
                }
            });
            upButton.addActionListener(new ObjectListener(new Integer(i)){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ChartWrapper.this.moveFieldInProperties((Integer)this.theObject, false);
                }
            });
            wrapperComps.add(GuiUtils.hbox(upButton, downButton));
            if (this.canDoRemoveParameters()) {
                wrapperComps.add(fieldProperty.removeCbx);
            }
            wrapperComps.add(GuiUtils.wrap(fieldProperty.nameFld));
            if (this.canDoWrapperColor()) {
                wrapperComps.add(this.doMakeWrapperDisplayComponent(i, fieldProperty));
            }
            if (!this.canDoWrapperSide()) continue;
            wrapperComps.add(GuiUtils.wrap(fieldProperty.sideCbx));
        }
        this.wrapperPanel.removeAll();
        this.wrapperPanel.setLayout(new BorderLayout());
        GuiUtils.tmpInsets = new Insets(0, 5, 0, 5);
        JPanel guts = GuiUtils.doLayout(wrapperComps, columns, GuiUtils.WT_NNN, GuiUtils.WT_N);
        this.wrapperPanel.add("North", guts);
        this.wrapperPanel.validate();
        this.wrapperPanel.repaint();
    }

    protected JComponent doMakeWrapperDisplayComponent(int idx, FieldProperties fieldProperty) {
        return GuiUtils.inset((Component)fieldProperty.displayComp, 4);
    }

    @Override
    protected boolean applyProperties() {
        double newResolution;
        if (!super.applyProperties()) {
            return false;
        }
        if (this.resolutionSlider != null && (newResolution = (double)this.resolutionSlider.getValue() / 100.0) != this.resolution) {
            this.resolution = newResolution;
        }
        if (this.canDoDataChoiceList()) {
            FieldProperties fieldProperty;
            int i;
            this.dataChoiceWrappers = new ArrayList();
            List tmpFields = this.fieldProperties;
            this.fieldProperties = new ArrayList();
            for (i = 0; i < tmpFields.size(); ++i) {
                fieldProperty = (FieldProperties)tmpFields.get(i);
                if (fieldProperty.applyProperties()) continue;
                return false;
            }
            for (i = 0; i < tmpFields.size(); ++i) {
                fieldProperty = (FieldProperties)tmpFields.get(i);
                if (fieldProperty.removeCbx.isSelected()) continue;
                this.dataChoiceWrappers.add(fieldProperty.wrapper);
                this.fieldProperties.add(fieldProperty);
            }
            this.updateWrapperPanel();
        }
        if (this.jythonFld != null) {
            this.jython = this.jythonFld.getText();
        }
        return true;
    }

    @Override
    protected boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        try {
            this.loadData();
        }
        catch (Exception exc) {
            LogUtil.logException("Error loading data", exc);
            return false;
        }
        return true;
    }

    public void addField() {
        this.getDisplayControl().addFieldToChartWrapper(this);
    }

    public List getFieldSelectionLabels() {
        return Misc.newList("Choose Fields for Chart: ");
    }

    public boolean doMultipleAddFields() {
        return true;
    }

    public String formatValue(double v) {
        return this.getDisplayControl().formatValue(v);
    }

    public void addDataChoice(DataChoice dataChoice) throws VisADException, RemoteException {
        this.dataChoiceWrappers.add(this.createDataChoiceWrapper(dataChoice));
        this.loadData();
    }

    public void addDataChoices(List newDataChoices) throws VisADException, RemoteException {
        this.dataChoiceWrappers.addAll(this.wrapDataChoices(newDataChoices));
        this.loadData();
    }

    @Override
    public void loadData() throws VisADException, RemoteException {
    }

    public void setTimeFromAnimation(Real time) {
    }

    @Override
    public void animationTimeChanged(Real time) {
        super.animationTimeChanged(time);
        if (this.showTime) {
            this.setTimeFromAnimation(time);
        }
    }

    public void setDataChoiceWrappers(List value) {
        this.dataChoiceWrappers = value;
    }

    public List getDataChoiceWrappers() {
        return this.dataChoiceWrappers;
    }

    public void setResolution(double value) {
        this.resolution = value;
    }

    public double getResolution() {
        return this.resolution;
    }

    public List getDataChoices() {
        ArrayList<DataChoice> result = new ArrayList<DataChoice>();
        for (int i = 0; i < this.dataChoiceWrappers.size(); ++i) {
            result.add(((DataChoiceWrapper)this.dataChoiceWrappers.get(i)).getDataChoice());
        }
        return result;
    }

    public void removeTimeFilterSource() {
        this.setTimeFilterSource(null);
    }

    public void setTimeFilterSource(TimeSeriesChartWrapper value) {
        if (this.timeFilterSource != null) {
            this.timeFilterSource.removePropertyChangeListener(this);
        }
        this.timeFilterSource = value;
        if (this.timeFilterSource != null) {
            this.timeFilterSource.addPropertyChangeListener(this);
        }
        try {
            if (this.hasBeenInitialized) {
                this.loadData();
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating data set", exc);
        }
    }

    public TimeSeriesChartWrapper getTimeFilterSource() {
        return this.timeFilterSource;
    }

    public void removeTimeSelectSource() {
        this.setTimeSelectSource(null);
    }

    public void setTimeSelectSource(ChartWrapper value) {
        if (this.timeSelectSource != null) {
            this.timeSelectSource.removePropertyChangeListener(this);
        }
        this.timeSelectSource = value;
        if (this.timeSelectSource != null) {
            this.timeSelectSource.addPropertyChangeListener(this);
        }
        try {
            if (this.hasBeenInitialized) {
                this.loadData();
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error creating data set", exc);
        }
    }

    public ChartWrapper getTimeSelectSource() {
        return this.timeSelectSource;
    }

    protected double[][] filterData(double[] samples, double[] timeValues) throws VisADException, RemoteException {
        if (timeValues == null) {
            return new double[][]{samples};
        }
        List timeRanges = this.getTimeFilterRanges();
        int size = samples.length;
        int resolutionCnt = (int)(this.getResolution() * (double)size);
        int stride = 1;
        while (size / stride > resolutionCnt) {
            ++stride;
        }
        int valueIdx = 0;
        double[] values = new double[size];
        double[] tmpTimeValues = new double[size];
        for (int i = 0; i < size; i += stride) {
            if (timeRanges != null) {
                boolean ok = false;
                double timeValue = timeValues[i];
                for (int rangeIdx = 0; !ok && rangeIdx < timeRanges.size(); ++rangeIdx) {
                    Range r = (Range)timeRanges.get(rangeIdx);
                    if (!(timeValue >= r.getMin()) || !(timeValue <= r.getMax())) continue;
                    ok = true;
                }
                if (!ok) continue;
            }
            tmpTimeValues[valueIdx] = timeValues[i];
            values[valueIdx++] = samples[i];
        }
        double[] actualValues = new double[valueIdx];
        double[] actualTimeValues = new double[valueIdx];
        for (int i = 0; i < valueIdx; ++i) {
            actualValues[i] = values[i];
            actualTimeValues[i] = tmpTimeValues[i];
        }
        return new double[][]{actualValues, actualTimeValues};
    }

    public double[] getTimeValues(double[][] samples, FlatField data) throws VisADException, RemoteException {
        if (samples.length < 2) {
            return null;
        }
        Unit[] units = Util.getDefaultRangeUnits(data);
        double[] timeValues = CommonUnit.secondsSinceTheEpoch.toThis(samples[1], units[1]);
        for (int i = 0; i < timeValues.length; ++i) {
            int n = i;
            timeValues[n] = timeValues[n] * 1000.0;
            if (i == 0 || timeValues[i] < this.dataMinDate) {
                this.dataMinDate = timeValues[i];
            }
            if (i != 0 && !(timeValues[i] > this.dataMaxDate)) continue;
            this.dataMaxDate = timeValues[i];
        }
        return timeValues;
    }

    public void setShowTime(boolean value) {
        this.showTime = value;
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    public void setDriveTime(boolean value) {
        this.driveTime = value;
    }

    public boolean getDriveTime() {
        return this.driveTime;
    }

    public void setMinDate(double value) {
        this.minDate = value;
    }

    public double getMinDate() {
        return this.minDate;
    }

    public void setMaxDate(double value) {
        this.maxDate = value;
    }

    public double getMaxDate() {
        return this.maxDate;
    }

    public void setJython(String value) {
        this.jython = value;
    }

    public String getJython() {
        return this.jython;
    }

    public void setAnimationShareGroup(String value) {
        this.animationShareGroup = value;
    }

    public String getAnimationShareGroup() {
        return this.animationShareGroup;
    }

    protected static class FieldProperties {
        DataChoiceWrapper wrapper;
        JCheckBox removeCbx;
        JComboBox sideCbx;
        JTextField nameFld;
        JComponent displayComp;

        public FieldProperties(DataChoiceWrapper wrapper) {
            this.wrapper = wrapper;
            this.nameFld = new JTextField(wrapper.getDescription(), 15);
            this.displayComp = this.wrapper.getLineState().getPropertyContents();
            this.removeCbx = new JCheckBox(" ", false);
            this.sideCbx = GuiUtils.makeComboBox(DataChoiceWrapper.SIDES, DataChoiceWrapper.SIDELABELS, wrapper.getSide());
        }

        public boolean applyProperties() {
            if (!this.wrapper.getLineState().applyProperties()) {
                return false;
            }
            this.wrapper.setMyDescription(this.nameFld.getText().trim());
            this.wrapper.setSide(GuiUtils.getValueFromBox(this.sideCbx));
            return true;
        }
    }
}

