/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.plot.Plot;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.chart.ChartHolder;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.ui.GraphPaperLayout;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import visad.Real;

public abstract class ChartManager
implements ImageObserver {
    public static final int LAYOUT_HSTACK = 0;
    public static final int LAYOUT_VSTACK = 1;
    public static final int LAYOUT_2COLGRID = 2;
    public static final int LAYOUT_3COLGRID = 3;
    public static final int LAYOUT_GRAPH = 4;
    public static final int LAYOUT_TAB = 6;
    public static final int LAYOUT_CARD = 7;
    public static final int AXIS_WIDTH = 30;
    protected Object MUTEX = new Object();
    private int layout = 4;
    private int gridLayoutDimension = Integer.MAX_VALUE;
    protected List<ChartHolder> chartHolders = new ArrayList<ChartHolder>();
    protected DisplayControlImpl control;
    protected JComponent contents;
    private JTabbedPane tab = null;
    private CardLayout cardLayout;
    private JComponent cardContainer;
    protected boolean settingData = false;
    protected boolean okToDraw = true;
    private List currentRanges = new ArrayList();
    private List currentLineStates = new ArrayList();
    private String defaultChartName;
    private JLabel chartThumb;
    private boolean showThumb = false;
    private boolean thumbUpdatePending = false;

    public ChartManager() {
    }

    public ChartManager(DisplayControlImpl control) {
        this.control = control;
    }

    public ChartManager(DisplayControlImpl control, String chartName) {
        this(control);
        this.defaultChartName = chartName;
    }

    protected void addLineState(LineState lineState) {
        this.currentLineStates.add(lineState);
    }

    public void saveImage() {
        JComboBox publishCbx = this.control.getIdv().getPublishManager().getSelector("nc.export");
        String filename = FileManager.getWriteFile(FileManager.FILTER_IMAGE, ".jpg", (JComponent)(publishCbx != null ? GuiUtils.top(publishCbx) : null));
        if (filename == null) {
            return;
        }
        try {
            ImageUtils.writeImageToFile(this.getContents(), filename);
            this.control.getIdv().getPublishManager().publishContent(filename, null, publishCbx);
        }
        catch (Exception exc) {
            LogUtil.logException("Capturing image", exc);
        }
    }

    protected void clearLineStates() {
        this.currentLineStates = new ArrayList();
    }

    protected void chartNameChanged(String oldName, String newName) {
        if (this.currentLineStates == null) {
            return;
        }
        for (int i = 0; i < this.currentLineStates.size(); ++i) {
            LineState lineState = (LineState)this.currentLineStates.get(i);
            if (!Misc.equals(lineState.getChartName(), oldName)) continue;
            lineState.setChartName(newName);
        }
    }

    public void setChartName(String newName) {
        if (this.currentLineStates == null) {
            return;
        }
        for (int i = 0; i < this.currentLineStates.size(); ++i) {
            LineState lineState = (LineState)this.currentLineStates.get(i);
            lineState.setChartName(newName);
        }
    }

    protected void initCharts() {
        this.currentRanges = new ArrayList();
        for (int plotIdx = 0; plotIdx < this.chartHolders.size(); ++plotIdx) {
            this.initChart(this.chartHolders.get(plotIdx));
        }
    }

    public List getCurrentRanges() {
        return this.currentRanges;
    }

    protected void addRange(double min, double max, String name) {
        if (min != min) {
            return;
        }
        if (max != max) {
            return;
        }
        min = Misc.parseNumber(this.control.getDisplayConventions().format(min));
        max = Misc.parseNumber(this.control.getDisplayConventions().format(max));
        this.currentRanges.add(new Range(min, max, name));
    }

    protected Object getMutex() {
        return this.MUTEX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initChart(ChartHolder chartHolder) {
        Object object = this.getMutex();
        synchronized (object) {
            chartHolder.initChart();
            this.initPlot(chartHolder.getPlot());
        }
    }

    protected void initPlot(Plot plot) {
    }

    public abstract Plot doMakePlot();

    protected List getPlots() {
        ArrayList<Plot> plots = new ArrayList<Plot>();
        for (ChartHolder chartHolder : this.chartHolders) {
            plots.add(chartHolder.getPlot());
        }
        return plots;
    }

    public void updateThumb() {
        this.updateThumb(false);
    }

    private void updateThumb(boolean force) {
        if (force) {
            this.updateThumbInner();
            return;
        }
        if (this.thumbUpdatePending) {
            return;
        }
        this.thumbUpdatePending = true;
        Misc.runInABit(500L, this, "updateThumbInner", null);
    }

    public void updateThumbInner() {
        try {
            if (!this.showThumb) {
                return;
            }
            if (this.getContents().getWidth() == 0 || this.getContents().getHeight() == 0) {
                return;
            }
            ArrayList images = new ArrayList();
            Image thumb = ImageUtils.getImage(this.getContents());
            if (thumb == null) {
                return;
            }
            if (thumb.getWidth(null) <= 0 || thumb.getHeight(null) <= 0) {
                return;
            }
            double ratio = (double)thumb.getWidth(null) / (double)thumb.getHeight(null);
            int width = 200;
            int height = (int)((double)width / ratio);
            thumb = ImageUtils.toBufferedImage(thumb.getScaledInstance(width, height, 16), 1);
            boolean chartsShowingSomething = false;
            for (ChartHolder chartHolder : this.chartHolders) {
                if (!chartHolder.getBeingShown() || !chartHolder.hasParameters()) continue;
                chartsShowingSomething = true;
                break;
            }
            if (chartsShowingSomething) {
                this.getThumb().setIcon(new ImageIcon(thumb));
            } else {
                this.getThumb().setIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/OnePixel.gif"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thumbUpdatePending = false;
    }

    public void signalChartChanged() {
        for (ChartHolder chartHolder : this.chartHolders) {
            if (chartHolder.getChartPanel() == null) continue;
            chartHolder.getChartPanel().chartChanged(new ChartChangeEvent((Object)this));
        }
    }

    private void setRefresh() {
        for (ChartHolder chartHolder : this.chartHolders) {
            chartHolder.getChartPanel().setRefreshBuffer(true);
        }
    }

    protected void doneLoadingData() {
        this.settingData = false;
        this.signalChartChanged();
        this.updateThumb(false);
    }

    protected void startLoadingData() {
        this.settingData = true;
    }

    protected void getPopupMenuItems(ChartHolder chartHolder, List items) {
    }

    protected void showPropertiesDialog(final ChartHolder chartHolder) {
        ArrayList comps = new ArrayList();
        this.getPropertiesComponents(chartHolder, comps);
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        final JDialog propertiesDialog = GuiUtils.createDialog(chartHolder.getName() + " Properties", true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
                    if (!ChartManager.this.applyProperties(chartHolder)) {
                        return;
                    }
                    ChartManager.this.updateThumb(true);
                }
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                    propertiesDialog.dispose();
                }
            }
        };
        JPanel buttons = GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_APPLY, GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL});
        contents = GuiUtils.centerBottom(contents, buttons);
        contents = GuiUtils.inset((Component)contents, 5);
        propertiesDialog.getContentPane().add(GuiUtils.top(contents));
        propertiesDialog.pack();
        propertiesDialog.setLocation(200, 200);
        propertiesDialog.setVisible(true);
    }

    protected void getPropertiesComponents(ChartHolder chartHolder, List comps) {
        chartHolder.nameFld = new JTextField(chartHolder.getName());
        comps.add(GuiUtils.rLabel("Name: "));
        comps.add(chartHolder.nameFld);
        chartHolder.backgroundSwatch = GuiUtils.makeColorSwatchWidget(chartHolder.getBackgroundColor(), "")[0];
        chartHolder.dataAreaSwatch = GuiUtils.makeColorSwatchWidget(chartHolder.getDataAreaColor(), "")[0];
        comps.add(GuiUtils.rLabel("Color: "));
        List colorComps = Misc.newList(new JLabel("Background:"), chartHolder.backgroundSwatch, GuiUtils.filler(10, 5), new JLabel("Chart:"), chartHolder.dataAreaSwatch);
        comps.add(GuiUtils.left(GuiUtils.hbox(colorComps, 5)));
        comps.add(GuiUtils.rLabel("Domain Lines: "));
        comps.add(chartHolder.getDomainLineState().getPropertyContents());
        comps.add(GuiUtils.rLabel("Range Lines: "));
        comps.add(chartHolder.getRangeLineState().getPropertyContents());
        chartHolder.getPropertiesComponents(comps);
        comps.add(GuiUtils.rLabel("Date Format: "));
        String df = this.getControl().getIdv().getPreferenceManager().getDefaultDateFormat();
        LinkedList<String> l = new LinkedList<String>(IdvPreferenceManager.DATE_FORMATS);
        if (!l.contains(df)) {
            l.add(df);
        }
        chartHolder.dateFormatBox = GuiUtils.getEditableBox(new LinkedList<String>(IdvPreferenceManager.DATE_FORMATS), chartHolder.getDateFormat() == null ? df : chartHolder.getDateFormat());
        comps.add(GuiUtils.leftRight(chartHolder.dateFormatBox, GuiUtils.filler()));
    }

    protected boolean applyProperties(ChartHolder chartHolder) {
        if (!chartHolder.getDomainLineState().applyProperties()) {
            return false;
        }
        if (!chartHolder.getRangeLineState().applyProperties()) {
            return false;
        }
        if (!chartHolder.applyProperties()) {
            return false;
        }
        String newName = chartHolder.nameFld.getText();
        if (!Misc.equals(newName, chartHolder.getName())) {
            this.chartNameChanged(chartHolder.getName(), newName);
            chartHolder.setName(newName);
        }
        chartHolder.applyPlotProperties();
        return true;
    }

    private List getLocations() {
        ArrayList<GraphPaperLayout.Location> locations = new ArrayList<GraphPaperLayout.Location>();
        for (ChartHolder chartHolder : this.chartHolders) {
            if (!chartHolder.getBeingShown()) continue;
            locations.add(new GraphPaperLayout.Location((JComponent)chartHolder.getChartPanel(), chartHolder, chartHolder.getName(), chartHolder.getLayoutRect()));
        }
        return locations;
    }

    private void applyLocations(List locations) {
        for (int i = 0; i < locations.size(); ++i) {
            GraphPaperLayout.Location loc = (GraphPaperLayout.Location)locations.get(i);
            ChartHolder chartHolder = (ChartHolder)loc.getObject();
            chartHolder.setLayoutRect(loc.getRect());
        }
    }

    public void setLayoutType(Integer i) {
        this.layout = i;
        this.updateContents(true);
    }

    public void editLayout() {
        List locations = this.getLocations();
        GraphPaperLayout.showDialog(locations, "Edit Chart Layout");
        this.applyLocations(locations);
        this.updateContents(true);
    }

    public void addViewMenuItems(List items) {
        JMenu layoutMenu = new JMenu("Layout");
        items.add(layoutMenu);
        int[] types = new int[]{4, 1, 0, 2, 3, 6};
        String[] names = new String[]{"Grid", "Vertical", "Horizontal", "2 Columns", "3 Columns", "Tabs"};
        JMenuItem mi = GuiUtils.makeMenuItem("Change Grid Layout", this, "editLayout");
        layoutMenu.add(mi);
        layoutMenu.addSeparator();
        mi.setEnabled(this.layout == 4);
        for (int i = 0; i < types.length; ++i) {
            mi = GuiUtils.makeMenuItem(names[i], this, "setLayoutType", new Integer(types[i]));
            layoutMenu.add(mi);
            if (types[i] != this.layout) continue;
            mi.setEnabled(false);
        }
        items.add("separator");
        for (ChartHolder chartHolder : this.chartHolders) {
            if (!chartHolder.getBeingShown()) continue;
            ArrayList chartItems = new ArrayList();
            chartHolder.getMenuItems(chartItems);
            items.add(GuiUtils.makeMenu("Chart: " + chartHolder.getName(), chartItems));
        }
    }

    public boolean getOkToDraw() {
        return this.okToDraw;
    }

    public boolean getSettingData() {
        return this.settingData;
    }

    public void timeChanged() {
        this.timeChanged(null);
    }

    public void timeChanged(Real value) {
        this.signalChartChanged();
        this.updateThumb(true);
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        boolean all;
        boolean bl = all = (flags & 0x20) != 0;
        if (all) {
            this.getContents().repaint();
            return false;
        }
        return true;
    }

    public boolean hasStuff() {
        for (ChartHolder chartHolder : this.chartHolders) {
            if (!chartHolder.hasParameters()) continue;
            return true;
        }
        return false;
    }

    public JComponent getContents() {
        if (this.contents == null) {
            this.doMakeContents();
            this.MUTEX = this.contents.getTreeLock();
        }
        return this.contents;
    }

    public List getPlotNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ChartHolder chartHolder : this.chartHolders) {
            names.add(chartHolder.getName());
        }
        return names;
    }

    protected ChartHolder getChartHolder(LineState lineState) {
        String chartName = lineState.getChartName();
        ChartHolder chartHolder = this.getChartHolder(chartName);
        if (chartName == null) {
            lineState.setChartName(chartHolder.getName());
        }
        return chartHolder;
    }

    protected ChartHolder findChartHolder(String name) {
        for (ChartHolder tmp : this.chartHolders) {
            if (name != null && !Misc.equals(name, tmp.getName())) continue;
            return tmp;
        }
        return null;
    }

    protected ChartHolder getChartHolder(String name) {
        ChartHolder chartHolder = this.findChartHolder(name);
        if (chartHolder == null) {
            chartHolder = new ChartHolder(this, name, this.getPreferredChartSize());
            this.addChart(chartHolder);
        }
        return chartHolder;
    }

    protected void addChart(ChartHolder chartHolder) {
        this.initChart(chartHolder);
        this.chartHolders.add(chartHolder);
    }

    protected Dimension getPreferredChartSize() {
        return new Dimension(300, 200);
    }

    protected void doMakeContents() {
        this.contents = new JPanel(new BorderLayout());
        ChartHolder chartHolder = this.findChartHolder(null);
        if (chartHolder == null) {
            this.makeInitialChart();
        }
        this.initCharts();
        this.updateContents(true);
    }

    protected void makeInitialChart() {
        this.getChartHolder(this.getDefaultChartName());
    }

    protected String getDefaultChartName() {
        if (this.defaultChartName != null) {
            return this.defaultChartName;
        }
        return "Chart";
    }

    protected void updateContents() {
        this.updateContents(false);
    }

    protected void updateContents(boolean force) {
        ChartHolder chartHolder2;
        if (this.contents == null) {
            return;
        }
        ArrayList<ChartPanel> comps = new ArrayList<ChartPanel>();
        boolean tabIndex = false;
        boolean needToUpdate = false;
        int goodCharts = 0;
        for (ChartHolder chartHolder2 : this.chartHolders) {
            if (!chartHolder2.hasParameters()) continue;
            ++goodCharts;
        }
        for (int plotIdx = 0; plotIdx < this.chartHolders.size(); ++plotIdx) {
            chartHolder2 = this.chartHolders.get(plotIdx);
            if (chartHolder2.hasParameters() || plotIdx == 0 && goodCharts == 0) {
                if (chartHolder2.getBeingShown()) continue;
                needToUpdate = true;
                continue;
            }
            if (!chartHolder2.getBeingShown()) continue;
            needToUpdate = true;
        }
        if (!force && !needToUpdate) {
            return;
        }
        this.contents.removeAll();
        if (this.layout == 6) {
            if (this.tab == null) {
                this.tab = new JTabbedPane();
            } else {
                this.tab.removeAll();
            }
        } else {
            this.tab = null;
        }
        for (ChartHolder chartHolder2 : this.chartHolders) {
            chartHolder2.resetChartPanel();
        }
        for (int plotIdx = 0; plotIdx < this.chartHolders.size(); ++plotIdx) {
            chartHolder2 = this.chartHolders.get(plotIdx);
            if (!(plotIdx == 0 && goodCharts == 0 || chartHolder2.hasParameters())) {
                chartHolder2.setBeingShown(false);
                continue;
            }
            chartHolder2.setBeingShown(true);
            if (this.layout == 6) {
                this.tab.addTab(chartHolder2.getName(), (Component)chartHolder2.getChartPanel());
                continue;
            }
            comps.add(chartHolder2.getChartPanel());
        }
        JComponent inner = null;
        inner = this.layout == 1 ? GuiUtils.doLayout(comps, 1, GuiUtils.WT_Y, GuiUtils.WT_Y) : (this.layout == 0 ? GuiUtils.doLayout(comps, comps.size(), GuiUtils.WT_Y, GuiUtils.WT_Y) : (this.layout == 2 ? GuiUtils.doLayout(comps, 2, GuiUtils.WT_Y, GuiUtils.WT_Y) : (this.layout == 3 ? GuiUtils.doLayout(comps, 3, GuiUtils.WT_Y, GuiUtils.WT_Y) : (this.layout == 4 ? GraphPaperLayout.layout(this.getLocations()) : (this.layout == 6 ? this.tab : GuiUtils.doLayout(comps, 1, GuiUtils.WT_Y, GuiUtils.WT_Y))))));
        this.contents.add("Center", inner);
        this.contents.invalidate();
        this.contents.validate();
        this.contents.repaint();
    }

    public JLabel getThumb() {
        if (this.chartThumb == null) {
            this.chartThumb = new JLabel("");
            this.chartThumb.setVisible(this.showThumb);
        }
        return this.chartThumb;
    }

    public void setLayout(int value) {
        this.layout = value;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setGridLayoutDimension(int value) {
        this.gridLayoutDimension = value;
    }

    public int getGridLayoutDimension() {
        return this.gridLayoutDimension;
    }

    public void setChartHolders(List value) {
        this.chartHolders = value;
    }

    public List getChartHolders() {
        return this.chartHolders;
    }

    public void setControl(DisplayControlImpl value) {
        this.control = value;
    }

    public DisplayControlImpl getControl() {
        return this.control;
    }

    public void setShowThumb(boolean value) {
        if (this.showThumb == value) {
            return;
        }
        this.showThumb = value;
        if (this.chartThumb != null) {
            this.getThumb().setVisible(value);
            this.updateThumb(true);
        }
    }

    public boolean getShowThumb() {
        return this.showThumb;
    }

    public static class FixedWidthNumberAxis
    extends NumberAxis {
        public FixedWidthNumberAxis() {
            this(null);
        }

        public FixedWidthNumberAxis(String theLabel) {
            super(theLabel);
            this.setFixedDimension(30.0);
        }

        protected double findMaximumTickLabelWidth(List ticks, Graphics2D g2, Rectangle2D drawArea, boolean vertical) {
            return 30.0;
        }
    }

    public static class FixedWidthLogarithmicAxis
    extends LogarithmicAxis {
        public FixedWidthLogarithmicAxis() {
            this(null);
        }

        public FixedWidthLogarithmicAxis(String theLabel) {
            super(theLabel);
            this.setFixedDimension(30.0);
        }

        protected double findMaximumTickLabelWidth(List ticks, Graphics2D g2, Rectangle2D drawArea, boolean vertical) {
            return 30.0;
        }
    }
}

