/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import ucar.unidata.idv.control.chart.ChartManager;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class ChartHolder {
    private ChartManager chartManager;
    protected AxisLocation lastSide;
    private int paramCount = 0;
    private boolean beingShown = false;
    private boolean showThumbnail = true;
    private String name = "Plot";
    private JFreeChart chart;
    private Plot plot;
    private ChartPanel chartPanel;
    private boolean showTitle = true;
    private Rectangle layoutRect;
    private LineState domainLineState = new LineState();
    private LineState rangeLineState = new LineState();
    private Color backgroundColor = null;
    private Color dataAreaColor = Color.white;
    private String dateFormat = null;
    protected JCheckBox showThumbnailCbx;
    protected JCheckBox showTitleCbx;
    protected JComponent backgroundSwatch;
    protected JComponent dataAreaSwatch;
    protected JTextField nameFld;
    private Dimension preferredSize;
    JComboBox dateFormatBox;
    Hashtable<Integer, Boolean> legendVisible = new Hashtable();

    public ChartHolder() {
    }

    public ChartHolder(ChartManager chartManager, String name, Dimension preferredSize) {
        this.chartManager = chartManager;
        this.name = name;
        this.preferredSize = preferredSize;
        this.init();
        this.resetChartPanel();
        this.applyPlotProperties();
    }

    protected boolean applyProperties() {
        if (this.backgroundSwatch != null) {
            this.backgroundColor = this.backgroundSwatch.getBackground();
        }
        if (this.dataAreaSwatch != null) {
            this.dataAreaColor = this.dataAreaSwatch.getBackground();
        }
        if (this.showThumbnailCbx != null) {
            this.setShowThumbnail(this.showThumbnailCbx.isSelected());
        }
        if (this.showTitleCbx != null) {
            this.setShowTitle(this.showTitleCbx.isSelected());
        }
        if (this.dateFormatBox != null) {
            this.dateFormat = (String)this.dateFormatBox.getSelectedItem();
        }
        return true;
    }

    protected void getPropertiesComponents(List comps) {
        this.showTitleCbx = new JCheckBox("Title", this.showTitle);
        comps.add(GuiUtils.rLabel("Show:"));
        comps.add(GuiUtils.left(this.showTitleCbx));
    }

    protected void applyPlotProperties() {
        if (this.plot == null) {
            return;
        }
        if (this.dataAreaColor != null) {
            this.plot.setBackgroundPaint((Paint)this.dataAreaColor);
        }
        if (this.backgroundColor != null) {
            this.chart.setBackgroundPaint((Paint)this.backgroundColor);
        }
        if (this.backgroundColor != null && this.chartPanel != null) {
            this.chartPanel.setBackground(this.backgroundColor);
        }
        if (this.showTitle) {
            this.chart.setTitle(this.getName());
        } else {
            this.chart.setTitle((String)null);
        }
        if (this.plot instanceof XYPlot) {
            XYPlot p = (XYPlot)this.plot;
            p.setDomainGridlinesVisible(this.domainLineState.getVisible());
            p.setRangeGridlinesVisible(this.rangeLineState.getVisible());
            p.setDomainGridlinePaint((Paint)this.domainLineState.getColor());
            p.setRangeGridlinePaint((Paint)this.rangeLineState.getColor());
            p.setDomainGridlineStroke((Stroke)this.domainLineState.getStroke());
            p.setRangeGridlineStroke((Stroke)this.rangeLineState.getStroke());
            if (p.getDomainAxis() instanceof DateAxis && this.dateFormat != null) {
                DateAxis ax = (DateAxis)p.getDomainAxis();
                TimeZone tz = this.getChartManager().getControl().getIdv().getPreferenceManager().getDefaultTimeZone();
                SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
                df.setTimeZone(tz);
                ax.setDateFormatOverride((DateFormat)df);
            }
        }
    }

    protected void init() {
        if (this.plot == null) {
            this.plot = this.chartManager.doMakePlot();
            this.chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, this.plot, true);
            if (this.backgroundColor != null) {
                this.chart.setBackgroundPaint((Paint)this.backgroundColor);
            }
            this.applyPlotProperties();
        }
    }

    protected void setBeingShown(boolean value) {
        this.beingShown = value;
    }

    protected boolean getBeingShown() {
        return this.beingShown;
    }

    protected ChartPanel getChartPanel() {
        if (this.plot == null) {
            this.init();
        }
        return this.chartPanel;
    }

    public Plot getPlot() {
        if (this.plot == null) {
            this.init();
        }
        return this.plot;
    }

    public void doSaveAs() {
        String filename = FileManager.getWriteFile(FileManager.FILTER_IMAGEWRITE, ".jpg");
        if (filename == null) {
            return;
        }
        try {
            ImageUtils.writeImageToFile((Component)this.chartPanel, filename);
        }
        catch (Exception exc) {
            LogUtil.logException("Capturing image", exc);
        }
    }

    public void showPropertiesDialog() {
        this.chartManager.showPropertiesDialog(this);
    }

    protected void getMenuItems(List items) {
        this.chartManager.getPopupMenuItems(this, items);
        if (items.size() > 0) {
            items.add("separator");
        }
        this.addZoomMenuItems(items);
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Save Chart As...", this, "doSaveAs"));
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Properties...", this, "showPropertiesDialog"));
    }

    private void showPopupMenu(MouseEvent event) {
        ArrayList items = new ArrayList();
        this.getMenuItems(items);
        JPopupMenu popupMenu = GuiUtils.makePopupMenu(items);
        popupMenu.show((Component)this.chartPanel, event.getX(), event.getY());
    }

    private void addZoomMenuItems(List items) {
        JMenu menu = new JMenu("Zoom In");
        items.add(menu);
        JMenuItem mi = new JMenuItem("All Axes");
        menu.add(mi);
        mi.setActionCommand("ZOOM_IN_BOTH");
        mi.addActionListener((ActionListener)this.chartPanel);
        menu.addSeparator();
        mi = new JMenuItem("Domain Axis");
        menu.add(mi);
        mi.setActionCommand("ZOOM_IN_DOMAIN");
        mi.addActionListener((ActionListener)this.chartPanel);
        mi = new JMenuItem("Range Axis");
        menu.add(mi);
        mi.setActionCommand("ZOOM_IN_RANGE");
        mi.addActionListener((ActionListener)this.chartPanel);
        menu = new JMenu("Zoom Out");
        items.add(menu);
        mi = new JMenuItem("All Axes");
        menu.add(mi);
        mi.setActionCommand("ZOOM_OUT_BOTH");
        mi.addActionListener((ActionListener)this.chartPanel);
        menu.addSeparator();
        mi = new JMenuItem("Domain Axis");
        menu.add(mi);
        mi.setActionCommand("ZOOM_DOMAIN_BOTH");
        mi.addActionListener((ActionListener)this.chartPanel);
        mi = new JMenuItem("Range Axis");
        menu.add(mi);
        mi.setActionCommand("ZOOM_RANGE_BOTH");
        mi.addActionListener((ActionListener)this.chartPanel);
        menu = new JMenu("Auto Range");
        items.add(menu);
        mi = new JMenuItem("All Axes");
        menu.add(mi);
        mi.setActionCommand("ZOOM_RESET_BOTH");
        mi.addActionListener((ActionListener)this.chartPanel);
        menu.addSeparator();
        mi = new JMenuItem("Domain Axis");
        menu.add(mi);
        mi.setActionCommand("ZOOM_RESET_DOMAIN");
        mi.addActionListener((ActionListener)this.chartPanel);
        mi = new JMenuItem("Range Axis");
        menu.add(mi);
        mi.setActionCommand("ZOOM_RESET_RANGE");
        mi.addActionListener((ActionListener)this.chartPanel);
    }

    protected void resetChartPanel() {
        if (this.plot == null) {
            this.init();
        }
        if (this.chartPanel != null) {
            this.chartPanel.setChart(null);
        }
        this.chartPanel = new ChartPanel(this.chart, true){

            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ChartHolder.this.showPopupMenu(e);
                } else {
                    super.mouseReleased(e);
                }
            }

            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
                super.mouseClicked(event);
            }

            public void mousePressed(MouseEvent event) {
                this.requestFocus();
                if (!SwingUtilities.isRightMouseButton(event)) {
                    super.mousePressed(event);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintComponent(Graphics g) {
                Object object = ChartHolder.this.chartManager.getMutex();
                synchronized (object) {
                    if (ChartHolder.this.chartManager.getOkToDraw() && !ChartHolder.this.chartManager.getSettingData()) {
                        super.paintComponent(g);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void chartChanged(ChartChangeEvent event) {
                Object object = ChartHolder.this.chartManager.getMutex();
                synchronized (object) {
                    if (!ChartHolder.this.chartManager.getSettingData()) {
                        super.chartChanged(event);
                    } else {
                        this.setRefreshBuffer(true);
                    }
                }
                Misc.runInABit(20L, ChartHolder.this.chartManager, "updateThumb", null);
            }
        };
        this.chartPanel.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ChartHolder.this.keyPressed(e);
            }
        });
        if (this.preferredSize != null) {
            this.chartPanel.setPreferredSize(this.preferredSize);
        } else {
            this.chartPanel.setPreferredSize(new Dimension(300, 200));
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 39) {
            this.panPlot(true);
        } else if (e.getKeyCode() == 37) {
            this.panPlot(false);
        } else if (e.getKeyCode() == 38) {
            this.upDownPlot(true);
        } else if (e.getKeyCode() == 40) {
            this.upDownPlot(false);
        } else if (e.getKeyCode() == 82 && e.isControlDown()) {
            this.chartPanel.restoreAutoBounds();
        }
    }

    private void upDownPlot(boolean up) {
        if (!(this.plot instanceof XYPlot)) {
            return;
        }
        XYPlot xyPlot = (XYPlot)this.plot;
        int cnt = xyPlot.getRangeAxisCount();
        for (int i = 0; i < cnt; ++i) {
            ValueAxis axis = xyPlot.getRangeAxis(i);
            Range range = axis.getRange();
            double width = range.getUpperBound() - range.getLowerBound();
            double width2 = width / 2.0;
            double step = up ? width * 0.1 : -width * 0.1;
            axis.centerRange(range.getLowerBound() + step + width2);
        }
    }

    protected void panPlot(boolean right) {
        this.panPlot(right, 0.1);
    }

    protected void panPlot(boolean right, double percent) {
        if (!(this.plot instanceof XYPlot)) {
            return;
        }
        XYPlot xyPlot = (XYPlot)this.plot;
        int cnt = xyPlot.getDomainAxisCount();
        for (int i = 0; i < cnt; ++i) {
            ValueAxis axis = xyPlot.getDomainAxis(i);
            Range range = axis.getRange();
            double width = range.getUpperBound() - range.getLowerBound();
            double width2 = width / 2.0;
            double step = right ? width * percent : -width * percent;
            axis.centerRange(range.getLowerBound() + step + width2);
        }
    }

    protected void initChart() {
        this.lastSide = null;
        this.paramCount = 0;
    }

    private boolean isLegendVisible(int param) {
        Boolean b = this.legendVisible.get(param);
        if (b != null) {
            return b;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(XYDataset dataset, XYItemRenderer renderer, AxisLocation side) {
        Object object = this.chartManager.getMutex();
        synchronized (object) {
            XYPlot xyPlot = (XYPlot)this.plot;
            ValueAxis rangeAxis1 = ((XYPlot)this.plot).getRangeAxis();
            xyPlot.setRangeAxis(0, rangeAxis1, false);
            xyPlot.setDataset(this.paramCount, dataset);
            xyPlot.mapDatasetToRangeAxis(this.paramCount, 0);
            xyPlot.setRenderer(this.paramCount, renderer);
            if (side != null) {
                xyPlot.setRangeAxisLocation(this.paramCount, side);
            }
            ++this.paramCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(XYDataset dataset, ValueAxis rangeAxis, XYItemRenderer renderer, AxisLocation side) {
        Object object = this.chartManager.getMutex();
        synchronized (object) {
            XYPlot xyPlot = (XYPlot)this.plot;
            xyPlot.setRangeAxis(this.paramCount, rangeAxis, false);
            xyPlot.setDataset(this.paramCount, dataset);
            xyPlot.mapDatasetToRangeAxis(this.paramCount, this.paramCount);
            xyPlot.setRenderer(this.paramCount, renderer);
            if (side != null) {
                xyPlot.setRangeAxisLocation(this.paramCount, side);
            }
            ++this.paramCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(XYDataset dataset, ValueAxis rangeAxis, ValueAxis domainAxis, XYItemRenderer renderer, AxisLocation side) {
        Object object = this.chartManager.getMutex();
        synchronized (object) {
            XYPlot xyPlot = (XYPlot)this.plot;
            xyPlot.setRangeAxis(this.paramCount, rangeAxis, false);
            xyPlot.setDomainAxis(this.paramCount, domainAxis, false);
            xyPlot.setDataset(this.paramCount, dataset);
            xyPlot.mapDatasetToRangeAxis(this.paramCount, this.paramCount);
            xyPlot.setRenderer(this.paramCount, renderer);
            if (side != null) {
                xyPlot.setRangeAxisLocation(this.paramCount, side);
            }
            ++this.paramCount;
        }
    }

    public boolean hasParameters() {
        return this.paramCount > 0;
    }

    public void setLayoutRect(Rectangle value) {
        this.layoutRect = value;
    }

    public Rectangle getLayoutRect() {
        return this.layoutRect;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setChartManager(ChartManager value) {
        this.chartManager = value;
    }

    public ChartManager getChartManager() {
        return this.chartManager;
    }

    public void setDomainLineState(LineState value) {
        this.domainLineState = value;
    }

    public LineState getDomainLineState() {
        return this.domainLineState;
    }

    public void setRangeLineState(LineState value) {
        this.rangeLineState = value;
    }

    public LineState getRangeLineState() {
        return this.rangeLineState;
    }

    public void setShowThumbnail(boolean value) {
        this.showThumbnail = value;
    }

    public boolean getShowThumbnail() {
        return this.showThumbnail;
    }

    public void setBackgroundColor(Color value) {
        this.backgroundColor = value;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setDataAreaColor(Color value) {
        this.dataAreaColor = value;
    }

    public Color getDataAreaColor() {
        return this.dataAreaColor;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setShowTitle(boolean value) {
        this.showTitle = value;
    }

    public boolean getShowTitle() {
        return this.showTitle;
    }

    public void setPreferredSize(Dimension value) {
        this.preferredSize = value;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }
}

