/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jfree.chart.annotations.XYAnnotation;
import ucar.unidata.collab.PropertiedThing;
import ucar.unidata.idv.control.chart.PlotWrapper;
import ucar.unidata.util.GuiUtils;

public abstract class ChartAnnotation
extends PropertiedThing
implements XYAnnotation {
    public static final Color COLOR_SELECTED = Color.red;
    private boolean selected = false;
    private Color color = Color.blue;
    private PlotWrapper plotWrapper;
    private String name = "";
    protected int x;
    protected int y;
    private JTextField nameFld;
    JComponent colorSwatch;
    protected AffineTransform transform;
    private boolean active = true;

    public ChartAnnotation() {
        this.active = true;
    }

    public ChartAnnotation(PlotWrapper plotWrapper) {
        this.plotWrapper = plotWrapper;
    }

    public String formatValue(double v) {
        return this.getPlotWrapper().formatValue(v);
    }

    public String getToolTipText() {
        return null;
    }

    protected void setGraphicsState(Graphics2D g2) {
        this.transform = g2.getTransform();
    }

    public double distance(int x, int y) {
        if (this.transform != null) {
            Point p = (Point)this.transform.transform(new Point(this.getX(), this.getY()), new Point());
            return ChartAnnotation.distance(p.x, p.y, x, y);
        }
        return ChartAnnotation.distance(this.getX(), this.getY(), x, y);
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        int dy = y1 - y2;
        int dx = x1 - x2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public abstract String getTypeName();

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.setName(this.nameFld.getText());
        if (this.colorSwatch != null) {
            this.setColor(this.colorSwatch.getBackground());
        }
        return true;
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx != 0) {
            return;
        }
        comps.add(GuiUtils.rLabel("Name: "));
        this.nameFld = new JTextField(this.getName());
        comps.add(this.nameFld);
        if (this.showColorInProperties()) {
            JComponent[] colorSwatchComps = GuiUtils.makeColorSwatchWidget(this.color, "Chart Color: ");
            this.colorSwatch = colorSwatchComps[0];
            comps.add(GuiUtils.rLabel("Color: "));
            comps.add(GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.inset((Component)this.colorSwatch, 4), colorSwatchComps[1])));
        }
    }

    public void setPosition(int x, int y) {
    }

    public void setPosition(MouseEvent event) {
        this.setPosition(event.getX(), event.getY());
    }

    public void doRemove() {
        this.active = false;
    }

    public void setSelected(boolean value) {
        this.selected = value;
    }

    public boolean getSelected() {
        return this.selected;
    }

    protected boolean showColorInProperties() {
        return false;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public Color getColor() {
        return this.color;
    }

    public void setPlotWrapper(PlotWrapper value) {
        this.plotWrapper = value;
    }

    public PlotWrapper getPlotWrapper() {
        return this.plotWrapper;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.plotWrapper.annotationChanged(this);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.plotWrapper.annotationChanged(this);
    }
}

