/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public class ZSlider {
    private JSlider slider;
    private double zValue;
    private JComponent contents;
    private boolean ignoreSliderEvents = false;
    private JTextField valueFld;
    DecimalFormat format = new DecimalFormat("0.###");

    public ZSlider(double zValue) {
        this.zValue = zValue;
    }

    public JComponent getContents() {
        if (this.contents == null) {
            this.contents = this.doMakeContents();
        }
        return this.contents;
    }

    private JComponent doMakeContents() {
        this.valueFld = new JTextField(this.format.format(this.zValue), 5);
        this.valueFld.setToolTipText("Enter an exact value between -1 and 1 and hit return");
        this.valueFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ZSlider.this.ignoreSliderEvents) {
                    return;
                }
                ZSlider.this.setValue(Misc.toDouble(ZSlider.this.valueFld.getText().trim()));
                ZSlider.this.valueHasBeenSet();
            }
        });
        int min = -100;
        int max = 100;
        int sliderPos = (int)(this.zValue * 100.0);
        sliderPos = Math.min(Math.max(sliderPos, min), max);
        this.slider = new JSlider(min, max, sliderPos);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ZSlider.this.ignoreSliderEvents) {
                    return;
                }
                ZSlider.this.zValue = (double)ZSlider.this.slider.getValue() / 100.0;
                ZSlider.this.valueFld.setText(ZSlider.this.format.format(ZSlider.this.zValue));
                if (!ZSlider.this.slider.getValueIsAdjusting()) {
                    ZSlider.this.valueHasBeenSet();
                }
            }
        });
        JPanel labelPanel = GuiUtils.leftCenterRight(new JLabel("Bottom"), GuiUtils.cLabel("Middle"), GuiUtils.rLabel("Top"));
        JPanel sliderPanel = GuiUtils.doLayout(new Component[]{this.slider, this.valueFld, labelPanel, GuiUtils.filler()}, 2, GuiUtils.WT_YN, GuiUtils.WT_NN);
        return sliderPanel;
    }

    public double getValue() {
        return this.zValue;
    }

    public void setValue(double v) {
        this.ignoreSliderEvents = true;
        this.zValue = v;
        this.slider.setValue((int)(100.0 * v));
        this.valueFld.setText(this.format.format(this.zValue));
        this.ignoreSliderEvents = false;
    }

    public void valueHasBeenSet() {
    }
}

