/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.StationLocationControl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.display.PointProbe;
import visad.CommonUnit;
import visad.VisADException;
import visad.georef.EarthLocation;

public class YahooLocationControl
extends StationLocationControl {
    private String query = "";
    private boolean autoLoad = true;
    private boolean loading = false;
    private List stationList = new ArrayList();
    private JTextField queryField;

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        Container contents = super.doMakeContents();
        this.queryField = new JTextField(this.query);
        JCheckBox autoLoadCbx = GuiUtils.makeCheckbox("Auto-load", this, "autoLoad");
        this.queryField.addActionListener(GuiUtils.makeActionListener(this, "doSearch", null));
        JButton btn = GuiUtils.makeButton("Search", this, "doSearch");
        JPanel top = GuiUtils.leftCenterRight(GuiUtils.rLabel("Query: "), this.queryField, GuiUtils.hbox(btn, autoLoadCbx));
        top = GuiUtils.inset((Component)top, 5);
        return GuiUtils.topCenter(top, (JComponent)contents);
    }

    @Override
    public void viewpointChanged() {
        if (this.autoLoad) {
            super.viewpointChanged();
        }
    }

    @Override
    public void projectionChanged() {
        if (this.autoLoad) {
            super.projectionChanged();
        }
    }

    public void doSearch() {
        this.query = this.queryField.getText().trim();
        this.loadData();
    }

    @Override
    public void loadData() {
        try {
            if (this.query.length() == 0) {
                return;
            }
            this.createStationList();
            super.loadData();
        }
        catch (Exception excp) {
            YahooLocationControl.logException("loading data ", excp);
        }
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        PointProbe probe = new PointProbe(0.0, 0.0, 0.0);
        probe.setVisible(false);
        this.addDisplayable(probe);
        return super.init(dataChoice);
    }

    private void createStationList() {
        try {
            double lon;
            NavigatedDisplay navDisplay = this.getNavigatedDisplay();
            double[] sc = navDisplay.getScreenCenter();
            EarthLocation el = this.boxToEarth(sc);
            double lat = el.getLatitude().getValue(CommonUnit.degree);
            for (lon = el.getLongitude().getValue(CommonUnit.degree); lon < -180.0; lon += 180.0) {
            }
            while (lon > 180.0) {
                lon -= 180.0;
            }
            String fullQuery = "http://api.local.yahoo.com/LocalSearchService/V3/localSearch?appid=idvunidata&radius=100&results=20&latitude=" + lat + "&longitude=" + lon + "&query=" + this.query;
            NamedStationTable table = NamedStationTable.createStationTableFromFile(fullQuery);
            this.stationList = new ArrayList(table.values());
        }
        catch (Exception exc) {
            YahooLocationControl.logException("Error loading WorldWind locations", exc);
        }
    }

    @Override
    protected List getStationList() {
        return this.stationList;
    }

    public void setQuery(String value) {
        this.query = value;
    }

    public String getQuery() {
        return this.query;
    }

    public void setAutoLoad(boolean value) {
        this.autoLoad = value;
    }

    public boolean getAutoLoad() {
        return this.autoLoad;
    }
}

