/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import ucar.unidata.data.DataChoice;
import ucar.unidata.gis.WorldWindReader;
import ucar.unidata.idv.control.StationLocationControl;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.display.PointProbe;
import visad.CommonUnit;
import visad.VisADException;

public class WorldWindControl
extends StationLocationControl {
    private static final String TAG_MAXIMUMDISPLAYRANGE = "MaximumDisplayRange";
    private static final String TAG_MINIMUMDISPLAYRANGE = "MinimumDisplayRange";
    private static final String TAG_PLACENAMELISTFILEPATH = "PlacenameListFilePath";
    private static final String TAG_TILEDPLACENAMESET = "TiledPlacenameSet";
    private static Object MUTEX = new Object();
    private static List layers;
    private static Hashtable cache;
    private Hashtable layerVisibility = new Hashtable();
    private boolean loading = false;
    private List stationList = new ArrayList();
    private String wwPath;
    private boolean onlyShowVisible = true;
    private Hashtable seenLocations = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        PointProbe probe = new PointProbe(0.0, 0.0, 0.0);
        probe.setVisible(false);
        this.addDisplayable(probe);
        Object object = MUTEX;
        synchronized (object) {
            if (layers == null) {
                try {
                    this.loadLayers();
                    if (layers == null) {
                        return false;
                    }
                }
                catch (Exception exc) {
                    WorldWindControl.logException("Error loading layers", exc);
                    return false;
                }
            }
        }
        return super.init(dataChoice);
    }

    @Override
    public void loadData() {
        try {
            this.createStationList();
            super.loadData();
        }
        catch (Exception excp) {
            WorldWindControl.logException("loading data ", excp);
        }
    }

    protected void doMakeStationListPanel(List comps) {
        ArrayList<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            checkBoxes.add(GuiUtils.makeCheckbox(layer.name, this, "layerOn", layer));
        }
        JPanel layerPanel = GuiUtils.vbox(checkBoxes);
        JScrollPane layerScroller = GuiUtils.makeScrollPane(layerPanel, 200, 100);
        layerScroller.setPreferredSize(new Dimension(200, 100));
        comps.add(GuiUtils.top(GuiUtils.rLabel("Layers:")));
        comps.add(layerScroller);
    }

    public void setLayerOn(boolean b, Layer layer) {
        this.layerVisibility.put(layer.name, new Boolean(b));
        this.loadData();
    }

    public boolean getLayerOn(Layer layer) {
        Boolean b = (Boolean)this.layerVisibility.get(layer.name);
        if (b != null) {
            return b;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStationList() {
        try {
            WorldWindReader reader = new WorldWindReader();
            Rectangle2D.Double rect = this.getNavigatedDisplay().getLatLonBox();
            ArrayList layersToUse = new ArrayList();
            for (int i = 0; i < layers.size(); ++i) {
                Layer layer = (Layer)layers.get(i);
                if (!this.getLayerOn(layer)) continue;
                layersToUse.addAll(layer.wwps);
            }
            List wwps = reader.findWwps(layersToUse, rect);
            if (this.onlyShowVisible) {
                this.stationList = new ArrayList();
                this.seenLocations = new Hashtable();
            }
            for (int i = 0; i < wwps.size(); ++i) {
                String filename = wwps.get(i).toString();
                WorldWindReader.FeatureList features = null;
                Hashtable hashtable = cache;
                synchronized (hashtable) {
                    features = (WorldWindReader.FeatureList)cache.get(filename);
                    if (features == null) {
                        features = reader.readWWP(filename);
                        cache.put(filename, features);
                    }
                }
                for (int featureIdx = 0; featureIdx < features.names.length; ++featureIdx) {
                    if (!rect.contains(features.lons[featureIdx], features.lats[featureIdx])) continue;
                    String name = new String(features.names[featureIdx]);
                    if (!this.onlyShowVisible && this.seenLocations.get(name) != null) continue;
                    this.seenLocations.put(name, name);
                    NamedStationImpl station = new NamedStationImpl(name, name, features.lats[featureIdx], features.lons[featureIdx], 0.0, CommonUnit.meter);
                    this.stationList.add(station);
                }
            }
        }
        catch (Exception exc) {
            WorldWindControl.logException("Error loading WorldWind locations", exc);
        }
        this.loading = false;
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeMenuItem("Save Locations...", this, "saveLocations"));
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeCheckboxMenuItem("Only show visible locations", this, "onlyShowVisible", null));
    }

    public void saveLocations() {
        try {
            String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml");
            if (filename == null) {
                return;
            }
            String xml = NamedStationTable.getStationXml(IOUtil.getFileTail(IOUtil.stripExtension(filename)), null, this.stationList);
            IOUtil.writeFile(filename, xml);
        }
        catch (Exception exc) {
            WorldWindControl.logException("Error writing station file", exc);
        }
    }

    private String initWWPath() {
        this.wwPath = this.getControlContext().getResourceManager().getResourceUrlBase() + "/worldwind";
        String layersXml = null;
        try {
            layersXml = new String(IOUtil.readBytesAndCache(this.wwPath + "/Configuration/WorldLayers.xml", "WorldWind"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (layersXml == null) {
            WorldWindControl.userMessage("<html>Could not find the 'WorldLayers.xml' configuration file in:<br>" + this.wwPath + "</html>");
        }
        return layersXml;
    }

    private void loadLayers() throws Exception {
        String layersXml = this.initWWPath();
        if (layersXml == null) {
            return;
        }
        Element root = XmlUtil.getRoot(layersXml);
        List placeNames = XmlUtil.findDescendants(root, TAG_TILEDPLACENAMESET);
        WorldWindReader reader = new WorldWindReader();
        layers = new ArrayList();
        for (int i = 0; i < placeNames.size(); ++i) {
            Element placename = (Element)placeNames.get(i);
            String name = XmlUtil.getChildText(XmlUtil.getElement(placename, "Name"));
            double minRange = new Double(XmlUtil.getChildText(XmlUtil.getElement(placename, TAG_MINIMUMDISPLAYRANGE)));
            double maxRange = new Double(XmlUtil.getChildText(XmlUtil.getElement(placename, TAG_MAXIMUMDISPLAYRANGE)));
            String path = XmlUtil.getChildText(XmlUtil.getElement(placename, TAG_PLACENAMELISTFILEPATH));
            if (!(path = StringUtil.replace(path, "\\", "/")).startsWith("/")) {
                path = "/" + path;
            }
            List wwps = reader.readWPL(this.wwPath + path, minRange, maxRange);
            layers.add(new Layer(name, wwps));
        }
    }

    @Override
    protected List getStationList() {
        return this.stationList;
    }

    public Hashtable getLayerVisibility() {
        return this.layerVisibility;
    }

    public void setLayerVisibility(Hashtable v) {
        this.layerVisibility = v;
    }

    public void setOnlyShowVisible(boolean value) {
        this.onlyShowVisible = value;
    }

    public boolean getOnlyShowVisible() {
        return this.onlyShowVisible;
    }

    static {
        cache = new Hashtable();
    }

    private static class Layer {
        List wwps;
        String name;

        public Layer(String name, List wwps) {
            this.name = name;
            this.wwps = wwps;
        }
    }
}

