/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Container;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.TimeHeightViewManager;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.control.ProfilerControl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.visad.display.Displayable;
import ucar.visad.display.WindBarbDisplayable;
import ucar.visad.display.XYDisplay;
import visad.AxisScale;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.util.DataUtility;

public class WindTimeHeightControl
extends ProfilerControl {
    protected Real currentVerticalInt;
    protected XYDisplay profileDisplay;
    protected TimeHeightViewManager timeHeightView;
    protected FieldImpl fieldImpl;
    protected WindBarbDisplayable wbDisplayable;
    protected JLabel plotLabel;
    protected boolean isSequence = false;
    protected String stationName;
    protected String labelName;
    protected float latitude;
    protected float longitude;
    protected boolean isLatestOnLeft = true;
    protected boolean haveNewStation = false;
    protected AxisScale xScale;
    protected AxisScale yScale;
    protected CompositeDataChoice compositeDataChoice;
    protected DataChoice currentDataChoice = null;
    private float currentLevel;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        boolean result = super.init(dataChoice);
        if (!result) {
            return false;
        }
        this.timeHeightView = new TimeHeightViewManager(this.getViewContext(), new ViewDescriptor("timeheight_of_" + this.paramName), "showControlLegend=false;wireframe=true;"){};
        this.addViewManager(this.timeHeightView);
        this.profileDisplay = this.timeHeightView.getTimeHeightDisplay();
        this.profileDisplay.setAspect(1.0, 0.6);
        if (dataChoice instanceof CompositeDataChoice) {
            this.compositeDataChoice = (CompositeDataChoice)dataChoice;
            if (this.currentDataChoice != null && this.initStation(this.currentDataChoice)) {
                return true;
            }
            for (int dataChoiceIdx = 0; dataChoiceIdx < this.compositeDataChoice.getNumChildren(); ++dataChoiceIdx) {
                this.currentDataChoice = (DataChoice)this.compositeDataChoice.getDataChoices().get(dataChoiceIdx);
                if (!this.initStation(this.currentDataChoice)) continue;
                return true;
            }
            return false;
        }
        return this.initStation(dataChoice);
    }

    @Override
    public boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        if (this.timeHeightView != null) {
            return this.timeHeightView.applyProperties();
        }
        return true;
    }

    protected boolean initStation(DataChoice dataChoice) throws VisADException, RemoteException {
        try {
            if (!this.setData(dataChoice)) {
                return false;
            }
        }
        catch (Exception exc) {
            WindTimeHeightControl.logException("There was an error loading the profiler data: " + dataChoice, exc);
            return false;
        }
        this.currentDataChoice = dataChoice;
        if (this.wbDisplayable == null) {
            this.initDisplayables();
        }
        this.updateLegendAndList();
        return true;
    }

    protected void initDisplayables() throws VisADException, RemoteException {
        Data data = this.getDataInstance().getData();
        FunctionType ftype = (FunctionType)data.getType();
        FunctionType obFT = (FunctionType)ftype.getRange();
        RealTupleType rtt = obFT.getFlatRange();
        this.wbDisplayable = new WindBarbDisplayable("profiler station", rtt, true);
        this.setFlowScale(this.getFlowScale());
        this.profileDisplay.showAxisScales(true);
        this.xScale = this.profileDisplay.getXAxisScale();
        this.xScale.setMinorTickSpacing(3600.0);
        this.xScale.setTitle("Time of day, UT");
        this.xScale.setSnapToBox(true);
        this.setXAxisValues(((FieldImpl)data).getDomainSet());
        this.setYAxisValues((FieldImpl)data);
        this.yScale.setTitle("Height above MSL, meters");
        this.yScale.setSnapToBox(true);
        this.wbDisplayable.setVisible(true);
        this.addAttributedDisplayable(this.wbDisplayable, 8);
        this.profileDisplay.setDisplayables(new Displayable[]{this.wbDisplayable});
        this.profileDisplay.draw();
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.plotLabel = new JLabel(" ");
        this.setLabel();
        return GuiUtils.topCenterBottom(this.plotLabel, this.timeHeightView.getContents(), this.doMakeWidgetComponent());
    }

    @Override
    protected JComponent doMakeExtraComponent() {
        return this.doMakeVerticalIntervalComponent();
    }

    protected void resetDataVerticalInterval(Real verticalInt) throws VisADException, RemoteException {
        if (verticalInt == null || Misc.equals(verticalInt, this.currentVerticalInt) && !this.haveNewStation) {
            return;
        }
        this.currentVerticalInt = verticalInt;
        int numbZs = 1 + (int)((double)this.currentLevel / verticalInt.getValue());
        Linear1DSet newZset = new Linear1DSet((MathType)RealType.Altitude, 0.0, this.currentLevel, numbZs);
        Set timeSet = this.fieldImpl.getDomainSet();
        FieldImpl rvFI = null;
        for (int i = 0; i < timeSet.getLength(); ++i) {
            FlatField oneTimeFF = (FlatField)this.fieldImpl.getSample(i);
            FlatField newFF = (FlatField)oneTimeFF.resample(newZset, 100, 202);
            if (i == 0) {
                rvFI = new FieldImpl(new FunctionType(((SetType)timeSet.getType()).getDomain(), newFF.getType()), timeSet);
            }
            rvFI.setSample(i, (Data)newFF);
        }
        this.wbDisplayable.loadData(rvFI);
    }

    @Override
    public void setFlowScale(float value) {
        super.setFlowScale(value);
        if (this.wbDisplayable != null) {
            this.wbDisplayable.setFlowScale(this.flowScaleValue * 0.02f);
        }
    }

    @Override
    public void setVerticalInterval(float value) {
        super.setVerticalInterval(value);
        if (this.wbDisplayable != null) {
            try {
                this.resetDataVerticalInterval(new Real(value));
            }
            catch (Exception ve) {
                WindTimeHeightControl.logException("setVerticalInterval", ve);
            }
        }
    }

    @Override
    protected Range getInitialRange() throws RemoteException, VisADException {
        Range range = this.getDisplayConventions().getParamRange(this.paramName, this.displayUnit);
        if (range == null) {
            range = this.getRangeFromColorTable();
        }
        if (range == null) {
            return new Range(0.0, 255.0);
        }
        return range;
    }

    protected RealTuple getRealTupleForPoint(float rlat, float rlon) throws VisADException, RemoteException {
        RealTuple visadTup = this.earthToBoxTuple(new EarthLocationTuple(rlat, rlon, 0.0));
        Real[] reals = visadTup.getRealComponents();
        Real altreal = new Real((RealType)reals[2].getType(), 1.0);
        return new RealTuple(new Real[]{reals[0], reals[1]});
    }

    protected void setXAxisValues() throws VisADException {
        try {
            Set timeSet = ((FieldImpl)this.wbDisplayable.getData()).getDomainSet();
            this.setXAxisValues(timeSet);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    protected void setYAxisValues() throws VisADException {
        try {
            FieldImpl data = (FieldImpl)this.wbDisplayable.getData();
            this.setYAxisValues(data);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    protected void setYAxisValues(FieldImpl data) throws VisADException {
        try {
            Set tset = data.getDomainSet();
            int size = tset.getLength();
            int step = 5;
            float hii = 0.0f;
            float loo = 10000.0f;
            for (int i = 0; i < size; ++i) {
                FlatField sfd = (FlatField)data.getSample(i);
                Gridded1DSet dset = (Gridded1DSet)sfd.getDomainSet();
                float[] hi = dset.getHi();
                float[] lo = dset.getLow();
                if (hi[0] > hii) {
                    hii = hi[0];
                }
                if (!(lo[0] < loo)) continue;
                loo = lo[0];
            }
            this.yScale = this.profileDisplay.getYAxisScale();
            if (hii < 5000.0f) {
                double averageSpacing = (double)(hii - loo) / (double)step;
                averageSpacing = (double)((int)(averageSpacing / 100.0)) * 100.0;
                this.yScale.setMajorTickSpacing(averageSpacing);
                this.yScale.setMinorTickSpacing(averageSpacing / (double)step);
                this.yScale.createStandardLabels(hii, 0.0, 0.0, averageSpacing);
                this.profileDisplay.setYRange(0.0, hii);
            } else {
                this.yScale.setMajorTickSpacing(2000.0);
                this.yScale.setMinorTickSpacing(500.0);
                this.yScale.createStandardLabels(16000.0, 0.0, 0.0, 2000.0);
                this.profileDisplay.setYRange(0.0, hii);
            }
            this.currentLevel = hii;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    protected void setXAxisValues(Set timeSet) throws VisADException, RemoteException {
        if (timeSet == null) {
            return;
        }
        double time1 = DataUtility.getSample(timeSet, 0).getValues()[0];
        double time2 = DataUtility.getSample(timeSet, timeSet.getLength() - 1).getValues()[0];
        Hashtable<Double, String> timeLabels = new Hashtable<Double, String>();
        int numSteps = timeSet.getLength();
        int step = numSteps < 5 ? 1 : timeSet.getLength() / 5;
        double majorTickSpacing = 3600.0;
        for (int k = 0; k < timeSet.getLength(); k += step) {
            double time = DataUtility.getSample(timeSet, k).getValues()[0];
            if (k == step) {
                majorTickSpacing = time - time1;
            }
            DateTime dt = new DateTime(time);
            String hr = " ";
            hr = dt.formattedString("HH:mm", TimeZone.getTimeZone("GMT"));
            timeLabels.put(new Double(time), hr);
        }
        this.xScale.setTickBase(time1);
        double averageTickSpacing = (time2 - time1) / (double)(numSteps - 1);
        this.xScale.setMajorTickSpacing(averageTickSpacing * (double)step);
        this.xScale.setMinorTickSpacing(averageTickSpacing);
        if (timeSet.getLength() == 1) {
            if (this.isLatestOnLeft) {
                this.profileDisplay.setXRange(time1 + 3600.0, time1 - 3600.0);
            } else {
                this.profileDisplay.setXRange(time1 - 3600.0, time1 + 3600.0);
            }
        } else if (this.isLatestOnLeft) {
            this.profileDisplay.setXRange(time2, time1);
        } else {
            this.profileDisplay.setXRange(time1, time2);
        }
        this.xScale.setLabelTable(timeLabels);
    }

    public void setLatestOnLeft(boolean yesorno) {
        this.isLatestOnLeft = yesorno;
    }

    protected void setLabel() {
        if (this.plotLabel != null) {
            this.plotLabel.setText("  Lat " + this.latitude + "  Long " + this.longitude);
        }
    }

    public boolean getLatestOnLeft() {
        return this.isLatestOnLeft;
    }

    public void setCurrentDataChoice(DataChoice value) {
        this.currentDataChoice = value;
    }

    public DataChoice getCurrentDataChoice() {
        return this.currentDataChoice;
    }
}

