/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.data.gis.WmsDataSource;
import ucar.unidata.data.gis.WmsSelection;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.imagery.ImageXmlDataSource;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.control.ImageControl;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.GeoUtils;
import visad.Data;
import visad.DisplayEvent;
import visad.FieldImpl;
import visad.FlatField;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.VisADException;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;
import visad.util.DataUtility;

public class WMSControl
extends ImageControl
implements ImageObserver {
    private boolean inGlobe = false;
    private Object loadId;
    private boolean enableAutoFetch = true;
    private int timestamp = 0;
    private DataChoice theDataChoice;
    private Object theLayer = null;
    private Object theTitle = null;
    private FieldImpl imageData;
    private WmsSelection wmsInfo;
    private List wmsSelections;
    private double resolution = 1.0;
    private GeoLocationInfo currentBounds;
    private DisplayEvent dragStartEvent;
    private int imageWidth = 800;
    private int imageHeight = 600;
    private JCheckBox reprojectCbx;
    private JCheckBox clickCbx;
    private List cachedUrls = new ArrayList();
    private List cachedData = new ArrayList();
    private static Hashtable<String, FieldImpl> fixedImageCache = new Hashtable();
    private JLabel legendIconLbl;
    private String legendIconUrl;
    private Image legendImage;
    private String selectedTime;
    private JComboBox timeBox;
    private String writeFile;
    private double scale = 1.0;
    private JSlider scaleSlider;
    private boolean waitingToLoad = false;

    public WMSControl() {
    }

    public WMSControl(List wmsSelections, String title) {
        this.setWmsInfos(wmsSelections);
        this.setDisplayName(title);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        super.init(dataChoice);
        this.inGlobe = this.inGlobeDisplay();
        this.inGlobe = false;
        if (dataChoice != null) {
            this.theDataChoice = dataChoice;
            if (this.theLayer == null) {
                TwoFacedObject layerObj = (TwoFacedObject)this.theDataChoice.getProperty("prop.wms.layer");
                String tmpStr = (String)layerObj.getId();
                int idx = tmpStr.indexOf("-layer=");
                String title = tmpStr.substring(0, idx);
                String layer = tmpStr.substring(idx + 7);
                this.theLayer = layer;
                this.theTitle = title;
            }
            this.wmsSelections = new ArrayList();
            return true;
        }
        if (this.wmsSelections == null || this.wmsSelections.size() == 0) {
            List defaultInfos = WmsSelection.parseWmsResources(this.getControlContext().getResourceManager().getXmlResources(IdvResourceManager.RSC_BACKGROUNDWMS));
            this.setWmsInfos(defaultInfos);
        }
        return true;
    }

    @Override
    public void initDone() {
        if (this.currentBounds == null) {
            this.loadImageFromScreen();
        } else {
            this.loadImage();
        }
        super.initDone();
    }

    @Override
    public boolean isInitDone() {
        if (!super.isInitDone()) {
            return false;
        }
        return !this.waitingToLoad;
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        return new GridDataInstance(dataChoice, this.getDataSelection(), this.getRequestProperties(), EMPTY_RGB_IMAGE);
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    private boolean isLayerFixed() {
        String layer;
        if (this.wmsInfo != null) {
            return this.wmsInfo.isFixedImage();
        }
        return this.theLayer != null && this.theLayer instanceof TwoFacedObject ? (layer = ((TwoFacedObject)this.theLayer).getId().toString()).indexOf("fixed") >= 0 : this.theLayer != null && this.theLayer instanceof String && (layer = (String)this.theLayer).indexOf("fixed") >= 0;
    }

    @Override
    protected boolean getInitialFastRendering() {
        return false;
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        if (this.isLayerFixed()) {
            return;
        }
        if (!this.inGlobe && this.getEnableAutoFetch()) {
            this.loadImageFromScreen();
        }
    }

    @Override
    public void viewpointChanged() {
        super.viewpointChanged();
        if (this.isLayerFixed()) {
            return;
        }
        if (!this.inGlobe && this.getEnableAutoFetch()) {
            this.loadImageFromScreen();
        }
    }

    @Override
    protected String getDetailsContents() {
        if (this.wmsInfo == null) {
            return super.getDetailsContents();
        }
        StringBuffer sb = new StringBuffer(super.getDetailsContents());
        String desc = this.wmsInfo.getDescription();
        if (desc != null) {
            sb.append("<p>Abstract:<br>\n");
            sb.append(StringUtil.breakText(desc, "<br>", 50));
        }
        return sb.toString();
    }

    @Override
    public void handleDisplayChanged(DisplayEvent event) {
        InputEvent inputEvent = event.getInputEvent();
        try {
            int id = event.getId();
            return;
        }
        catch (Exception e) {
            WMSControl.logException("Handling display event changed", e);
            return;
        }
    }

    public void goToAddress() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                WMSControl.this.goToAddressInner();
            }
        });
    }

    private void goToAddressInner() {
        try {
            this.showWaitCursor();
            LatLonPoint llp = GeoUtils.getLocationOfAddress();
            this.showNormalCursor();
            if (llp == null) {
                return;
            }
            this.getNavigatedDisplay().center(GeoUtils.toEarthLocation(llp));
            this.loadImageFromScreen();
        }
        catch (Exception e) {
            this.showNormalCursor();
            WMSControl.logException("Error going to address", e);
        }
    }

    @Override
    public void reloadDataSource() throws RemoteException, VisADException {
        this.loadImageFromScreen();
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.makeMenuItem("Reload Image", this, "loadImageFromScreen"));
        items.add(GuiUtils.makeMenuItem("Reproject to Image", this, "reproject"));
        items.add(GuiUtils.makeMenuItem("Go to Address", this, "goToAddress"));
        items.add("separator");
        super.getViewMenuItems(items, forMenuBar);
    }

    private GeoLocationInfo makeGeoLocationInfo(Rectangle2D.Double rect) {
        GeoLocationInfo gli = null;
        if (this.wmsInfo == null) {
            if (this.inGlobe) {
                return null;
            }
            double minLon = rect.x;
            double maxLon = rect.x + rect.width;
            double minLat = rect.y;
            double maxLat = rect.y + rect.height;
            return new GeoLocationInfo(minLat, minLon, maxLat, maxLon);
        }
        GeoLocationInfo bounds = this.wmsInfo.getBounds();
        if (bounds == null && this.wmsInfo.isFixedImage()) {
            return null;
        }
        if (this.inGlobe || !this.wmsInfo.getAllowSubsets()) {
            return new GeoLocationInfo(this.wmsInfo.getBounds());
        }
        double minLon = rect.x;
        double maxLon = rect.x + rect.width;
        double minLat = rect.y;
        double maxLat = rect.y + rect.height;
        gli = new GeoLocationInfo(minLat, minLon, maxLat, maxLon);
        if (bounds != null) {
            gli.rectify(bounds, 0.0);
            gli.snapToGrid();
            gli.rectify(bounds, 0.0);
        }
        return gli;
    }

    private void setLocation(Rectangle2D.Double rect) throws VisADException, RemoteException {
        int[] lrScreen;
        this.currentBounds = this.makeGeoLocationInfo(rect);
        if (this.inGlobe) {
            return;
        }
        if (this.currentBounds == null) {
            return;
        }
        if (this.wmsInfo == null) {
            return;
        }
        int[] ulScreen = this.earthToScreen(WMSControl.makeEarthLocation(this.currentBounds.getMaxLat(), this.currentBounds.getMinLon(), 0.0));
        if (this.imageWidth > Math.abs(ulScreen[0] - (lrScreen = this.earthToScreen(WMSControl.makeEarthLocation(this.currentBounds.getMinLat(), this.currentBounds.getMaxLon(), 0.0)))[0])) {
            this.imageWidth = Math.abs(ulScreen[0] - lrScreen[0]);
        }
        double widthDegrees = this.currentBounds.getMaxLon() - this.currentBounds.getMinLon();
        double heightDegrees = this.currentBounds.getMaxLat() - this.currentBounds.getMinLat();
        this.imageWidth = this.wmsInfo.getFixedWidth() > -1 ? this.wmsInfo.getFixedWidth() : Math.min(Math.max(this.imageWidth, 50), 2000);
        if (this.wmsInfo.getFixedHeight() > -1) {
            this.imageHeight = this.wmsInfo.getFixedHeight();
        } else {
            this.imageHeight = Math.abs((int)((double)this.imageWidth * this.currentBounds.getDegreesY() / this.currentBounds.getDegreesX()));
            this.imageHeight = Math.min(Math.max(this.imageHeight, 50), 2000);
        }
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        if (this.theDataChoice != null) {
            items.add(GuiUtils.makeMenuItem("Save As Image XML/KML File...", this, "writeImageXml"));
        }
    }

    @Override
    protected boolean canSaveDataInCache() {
        return this.theDataChoice != null;
    }

    public void writeImageXml() {
        String filename = FileManager.getWriteFile(Misc.newList(ImageXmlDataSource.FILTER_XIMG, KmlDataSource.FILTER_KML), ".ximg");
        if (filename != null) {
            this.writeFile = filename;
            this.loadImage();
        }
    }

    @Override
    public void saveDataChoiceInCache() {
        try {
            this.getControlContext().getIdv().saveInCache(this.theDataChoice, (Data)this.imageData, this.getTitle());
        }
        catch (Exception exc) {
            WMSControl.logException("Saving data to cache", exc);
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        List timeList;
        JComponent zPositionPanel = this.doMakeZPositionSlider();
        JComponent alphaSliderComp = this.doMakeAlphaSlider();
        this.reprojectCbx = new JCheckBox("And Reproject", false);
        this.scaleSlider = GuiUtils.makeSlider(0, 100, (int)(this.scale - 1.0) * 25, this, "scaleSliderChanged");
        JComboBox layerBox = null;
        if (this.wmsSelections != null && this.wmsSelections.size() > 1) {
            layerBox = GuiUtils.makeComboBox(this.wmsSelections, this.wmsInfo, false, this, "selectLayer");
        } else if (this.theDataChoice != null) {
            List layerList = (List)this.theDataChoice.getProperty("prop.wms.layers");
            if (layerList != null) {
                ArrayList dataSources = new ArrayList();
                this.theDataChoice.getDataSources(dataSources);
                if (dataSources.size() == 1 && dataSources.get(0) instanceof WmsDataSource) {
                    layerList = ((WmsDataSource)dataSources.get(0)).getLayerList();
                }
            }
            if (layerList != null && layerList.size() > 1) {
                layerBox = GuiUtils.makeComboBox(layerList, this.theLayer, false, this, "selectLayer");
            }
        }
        List list = timeList = this.wmsInfo == null ? null : this.wmsInfo.getTimeList();
        if (timeList != null && timeList.size() > 1) {
            if (this.selectedTime == null) {
                this.selectedTime = (String)timeList.get(0);
            }
            this.timeBox = GuiUtils.makeComboBox(timeList, this.selectedTime, false, this, "setSelectedTime");
        }
        String[] resNames = new String[]{"Very High", "High", "Medium", "Low"};
        double[] resValues = new double[]{0.2, 1.0, 2.0, 3.0};
        ArrayList<TwoFacedObject> resItems = new ArrayList<TwoFacedObject>();
        TwoFacedObject resSelected = null;
        for (int i = 0; i < resValues.length; ++i) {
            TwoFacedObject tfo = new TwoFacedObject((Object)resNames[i], new Double(resValues[i]));
            resItems.add(tfo);
            if (resValues[i] != this.resolution) continue;
            resSelected = tfo;
        }
        JComboBox resolutionBox = GuiUtils.makeComboBox(resItems, resSelected, false, this, "resolutionChanged");
        this.clickCbx = GuiUtils.makeCheckbox("Auto-Reload ", this, "enableAutoFetch");
        this.clickCbx.setToolTipText("Automatically reload image on pan/zoom");
        JButton reloadBtn = GuiUtils.makeImageButton("/ucar/unidata/idv/control/images/Refresh16.gif", this, "loadImageFromScreen");
        reloadBtn.setToolTipText("Reload the image");
        JButton projectBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Home16.gif", this, "reproject");
        projectBtn.setToolTipText("Reproject to image");
        JPanel buttons = GuiUtils.hbox(Misc.newList(reloadBtn, projectBtn, this.clickCbx), 4);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        if (layerBox != null) {
            comps.add(GuiUtils.rLabel("Layer:"));
            comps.add(GuiUtils.left(layerBox));
        }
        comps.add(GuiUtils.rLabel("Image:"));
        comps.add(GuiUtils.left(buttons));
        JPanel labelPanel = GuiUtils.leftRight(GuiUtils.lLabel("Screen"), GuiUtils.rLabel("5X"));
        comps.add(GuiUtils.rLabel("Resolution:"));
        comps.add(GuiUtils.left(resolutionBox));
        comps.add(GuiUtils.rLabel("Vertical Position:"));
        comps.add(GuiUtils.hgrid(zPositionPanel, GuiUtils.filler()));
        comps.add(GuiUtils.rLabel("Transparency:"));
        comps.add(GuiUtils.hgrid(alphaSliderComp, GuiUtils.filler()));
        comps.add(GuiUtils.rLabel("Dimension Scale:"));
        comps.add(GuiUtils.hgrid(GuiUtils.vbox(this.scaleSlider, labelPanel), GuiUtils.filler()));
        JComponent contents = GuiUtils.formLayout(comps);
        return GuiUtils.top(contents);
    }

    public void scaleSliderChanged(int value) {
        double percent = (double)value / 100.0;
        double newScale = 1.0 + percent * 4.0;
        if (newScale != this.scale) {
            this.scale = newScale;
            this.loadImageFromScreen();
        }
    }

    public void loadImageFromScreen() {
        try {
            if (!this.getActive()) {
                return;
            }
            NavigatedDisplay navDisplay = this.getNavigatedDisplay();
            if (navDisplay == null || navDisplay.getDisplay() == null) {
                return;
            }
            Rectangle screenBounds = navDisplay.getScreenBounds();
            this.imageWidth = (int)((double)screenBounds.width * this.scale);
            Rectangle2D.Double rect = this.getNavigatedDisplay().getLatLonBox();
            if (this.scale > 1.0 && !this.inGlobe) {
                double newWidth = this.scale * rect.getWidth();
                double newHeight = this.scale * rect.getHeight();
                rect.setRect(rect.getX() - (newWidth - rect.getWidth()) / 2.0, rect.getY() - (newHeight - rect.getHeight()) / 2.0, newWidth, newHeight);
            }
            GeoLocationInfo tmp = this.makeGeoLocationInfo(rect);
            this.setLocation(rect);
            this.loadImage();
        }
        catch (Exception exc) {
            WMSControl.logException("Loading image", exc);
        }
    }

    private void loadImage() {
        this.waitingToLoad = true;
        Misc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    WMSControl.this.loadImage(WMSControl.this.loadId = JobManager.getManager().stopAndRestart(WMSControl.this.loadId, "WMSControl"));
                }
                finally {
                    WMSControl.this.waitingToLoad = false;
                }
            }
        });
    }

    private void loadImage(Object myLoadId) {
        this.showWaitCursor();
        try {
            long t1 = System.currentTimeMillis();
            FieldImpl imageData = this.readImageData();
            long t2 = System.currentTimeMillis();
            if (imageData != null) {
                this.applyData(imageData);
            }
        }
        catch (Exception exc) {
            WMSControl.logException("There was an error accessing the image.", exc);
        }
        this.showNormalCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldImpl readImageData() throws Exception {
        String url;
        if (this.inGlobe) {
            this.imageWidth = this.wmsInfo != null && this.wmsInfo.getFixedWidth() > -1 ? this.wmsInfo.getFixedWidth() : (this.resolution == 0.5 ? 2048 : (this.resolution == 1.0 ? 1024 : (this.resolution == 2.0 ? 512 : 256)));
            this.imageHeight = this.imageWidth / 2;
        }
        if (this.currentBounds != null && (this.currentBounds.getDegreesX() == 0.0 || this.currentBounds.getDegreesY() == 0.0)) {
            return null;
        }
        if (this.theDataChoice != null) {
            Hashtable<String, Object> requestProperties = new Hashtable<String, Object>();
            if (this.theTitle != null) {
                requestProperties.put("TITLE", this.theTitle);
            } else if (this.theTitle == null && this.theLayer != null) {
                requestProperties.put("TITLE", this.theLayer);
            }
            if (this.theLayer != null) {
                requestProperties.put("prop.wms.layer", this.theLayer);
            }
            if (this.currentBounds != null) {
                requestProperties.put("prop.wms.bounds", this.currentBounds);
            }
            if (!this.inGlobe) {
                requestProperties.put("prop.wms.resolution", new Double(this.resolution));
            }
            requestProperties.put("prop.wms.imagewidth", new Integer(this.imageWidth));
            requestProperties.put("prop.wms.imageheight", new Integer(this.imageHeight));
            if (this.writeFile != null) {
                requestProperties.put("prop.wms.writefile", this.writeFile);
            }
            try {
                FieldImpl data = (FieldImpl)this.theDataChoice.getData(null, requestProperties);
                if (data == null) {
                    FieldImpl fieldImpl = null;
                    return fieldImpl;
                }
                this.imageData = data;
            }
            catch (NullPointerException npe) {
                WMSControl.userMessage("Image layer does not exist");
            }
            finally {
                this.writeFile = null;
            }
            String iconPath = (String)requestProperties.get("prop.wms.iconpath");
            if (!Misc.equals(iconPath, this.legendIconUrl)) {
                this.legendIconUrl = iconPath;
                this.updateLegendAndList();
            }
            return this.imageData;
        }
        GeoLocationInfo boundsToUse = this.inGlobe || !this.wmsInfo.getAllowSubsets() ? this.wmsInfo.getBounds() : this.currentBounds;
        Image image = null;
        if (this.wmsInfo.isFixedImage()) {
            url = this.wmsInfo.getImageFile();
            FieldImpl result = fixedImageCache.get(url);
            if (result != null) {
                return result;
            }
        } else {
            url = this.wmsInfo.assembleRequest(boundsToUse, (int)((double)this.imageWidth / this.resolution), (int)((double)this.imageHeight / this.resolution));
        }
        String cacheGroup = "WMS";
        byte[] imageContent = null;
        if (image == null) {
            List list = this.cachedUrls;
            synchronized (list) {
                for (int i = 0; i < this.cachedUrls.size(); ++i) {
                    if (!url.equals(this.cachedUrls.get(i))) continue;
                    image = (Image)this.cachedData.get(i);
                    break;
                }
            }
        }
        FlatField xyData = null;
        try {
            Object myLoadId = this.loadId;
            if (image == null) {
                if (imageContent == null && (imageContent = IOUtil.readBytes(IOUtil.getInputStream(url), this.loadId)) == null) {
                    return null;
                }
                image = Toolkit.getDefaultToolkit().createImage(imageContent);
                if (!JobManager.getManager().canContinue(myLoadId)) {
                    return null;
                }
                List list = this.cachedUrls;
                synchronized (list) {
                    if (this.cachedUrls.size() > 5) {
                        this.cachedUrls.remove(this.cachedUrls.size() - 1);
                        this.cachedData.remove(this.cachedData.size() - 1);
                    }
                    this.cachedUrls.add(0, url);
                    this.cachedData.add(0, image);
                }
            }
            xyData = DataUtility.makeField(image);
        }
        catch (Exception iexc) {
            if (imageContent != null) {
                String msg = new String(imageContent);
                if (StringUtil.stringMatch(msg = StringUtil.replace(msg, "\n", " ").toLowerCase(), "Service\\s*Exception") && StringUtil.stringMatch(msg, "cannot\\s*be\\s*less\\s*than")) {
                    return null;
                }
                if (msg.indexOf("error") >= 0) {
                    this.userErrorMessage("There was an error accessing the image with the url:\n" + url + "\nError:\n" + new String(imageContent));
                    return null;
                }
            }
            WMSControl.logException("There was an error accessing the image with the url:\n" + url, iexc);
            return null;
        }
        Linear2DSet domain = (Linear2DSet)xyData.getDomainSet();
        Linear2DSet imageDomain = new Linear2DSet((MathType)RealTupleType.SpatialEarth2DTuple, boundsToUse.getMinLon(), boundsToUse.getMaxLon(), domain.getX().getLength(), boundsToUse.getMaxLat(), boundsToUse.getMinLat(), domain.getY().getLength());
        FieldImpl result = GridUtil.setSpatialDomain(xyData, imageDomain, true);
        if (this.wmsInfo.isFixedImage()) {
            fixedImageCache.put(url, result);
        }
        return result;
    }

    @Override
    public MapProjection getDataProjection() {
        return null;
    }

    @Override
    public MapProjection getDataProjectionForMenu() {
        return super.getDataProjection();
    }

    private void applyData(FieldImpl imageData) throws VisADException, RemoteException {
        List colorExcludes = Misc.newList(new ColorExclude(Color.white, 20), new ColorExclude(Color.yellow, 20));
        float[][] rangeValues = imageData.getFloats(false);
        int numPts = rangeValues[0].length;
        boolean cnt = false;
        boolean bl = false;
        this.imageDisplay.loadData(imageData);
    }

    public void reproject() {
        this.setProjectionInView(false);
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        this.imageDisplay.loadData(null);
        return true;
    }

    public void selectLayer(Object layer) {
        this.legendIconUrl = null;
        this.legendImage = null;
        if (layer instanceof WmsSelection) {
            this.wmsInfo = (WmsSelection)layer;
        } else {
            TwoFacedObject layerObj = (TwoFacedObject)layer;
            String tmpStr = (String)layerObj.getId();
            int idx = tmpStr.indexOf("-layer=");
            String layerStr = tmpStr.substring(idx + 7);
            this.theLayer = layerStr;
            this.theTitle = layerObj.getLabel();
        }
        this.updateLegendAndList();
        if (this.imageDisplay != null) {
            if (this.isLayerFixed() && this.getUseFastRendering()) {
                this.setUseFastRendering(false);
            }
            this.loadImageFromScreen();
        }
    }

    public void setImageWidth(int value) {
        this.imageWidth = value;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageHeight(int value) {
        this.imageHeight = value;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void resolutionChanged(TwoFacedObject tfo) {
        this.resolution = (Double)tfo.getId();
        this.loadImage();
    }

    public void setResolution(double value) {
        this.resolution = value;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setCurrentBounds(GeoLocationInfo value) {
        this.currentBounds = value;
    }

    public GeoLocationInfo getCurrentBounds() {
        return this.currentBounds;
    }

    public void setWmsInfo(WmsSelection value) {
        this.wmsInfo = value;
        this.updateLegendAndList();
        if (value != null && (this.wmsSelections == null || this.wmsSelections.size() == 0)) {
            this.wmsSelections = Misc.newList(value);
        }
    }

    public WmsSelection getWmsInfo() {
        return this.wmsInfo;
    }

    @Override
    protected String getTitle() {
        if (this.wmsInfo != null) {
            return this.wmsInfo.getTitle();
        }
        return super.getTitle();
    }

    @Override
    protected void getLegendLabels(List labels, int legendType) {
        WmsSelection selection = this.wmsInfo;
        if (selection == null && this.theLayer != null && this.theLayer instanceof WmsSelection) {
            selection = (WmsSelection)this.theLayer;
        }
        if (this.theLayer != null && this.theTitle != null) {
            labels.add(this.theTitle.toString());
            this.setParamName(this.theTitle.toString());
        } else {
            super.getLegendLabels(labels, legendType);
        }
        if (this.wmsInfo != null) {
            labels.add(this.wmsInfo.getTitle());
            this.setParamName(this.wmsInfo.getTitle());
        }
        this.checkLegendIconLbl();
        this.legendIconLbl.setIcon(null);
        if (this.legendIconUrl == null && selection != null) {
            this.legendIconUrl = selection.getLegendIcon();
        }
        if (this.legendIconUrl != null) {
            ImageIcon icon = GuiUtils.getImageIcon(this.legendIconUrl);
            Image image = icon.getImage();
            if (icon.getImageLoadStatus() == 8) {
                this.setLegendIcon(image, image.getWidth(null), image.getHeight(null));
            } else {
                image.getHeight(this);
            }
        } else {
            this.legendIconLbl.setIcon(null);
        }
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if ((flags & 0x20) != 0) {
            this.setLegendIcon(img, width, height);
            return false;
        }
        return true;
    }

    private void setLegendIcon(Image img, int width, int height) {
        this.legendImage = img;
        Image theImage = img;
        int desiredWidth = 250;
        int desiredHeight = 100;
        if (width > desiredWidth || height > desiredHeight) {
            if (width > height) {
                height = desiredWidth * height / width;
                width = desiredWidth;
            } else {
                width = desiredHeight * width / height;
                height = desiredHeight;
            }
            theImage = img.getScaledInstance(width, height, 0);
        }
        this.legendIconLbl.setIcon(new ImageIcon(theImage));
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        this.checkLegendIconLbl();
        return GuiUtils.vbox(parentComp, this.legendIconLbl);
    }

    private void checkLegendIconLbl() {
        if (this.legendIconLbl != null) {
            return;
        }
        this.legendIconLbl = new JLabel("");
        this.legendIconLbl.setToolTipText("Click to see full legend");
        this.legendIconLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (WMSControl.this.legendImage == null) {
                    return;
                }
                WMSControl.this.showLegendImage();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (WMSControl.this.legendImage == null) {
                    return;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (WMSControl.this.legendImage == null) {
                    return;
                }
            }
        });
    }

    private void showLegendImage() {
        JLabel lbl = new JLabel(new ImageIcon(this.legendImage));
        JScrollPane sp = GuiUtils.makeScrollPane(lbl, this.legendImage.getWidth(null), 400);
        sp.setPreferredSize(new Dimension(Math.max(300, this.legendImage.getWidth(null)), 400));
        GuiUtils.showDialog("Legend", sp);
    }

    public void setWmsInfos(List value) {
        this.wmsSelections = value;
        if (this.wmsSelections != null && this.wmsSelections.size() > 0 && this.wmsInfo == null) {
            if (this.theLayer != null && this.theLayer instanceof String) {
                for (WmsSelection selection : this.wmsSelections) {
                    if (!Misc.equals(this.theLayer, selection.getLayer())) continue;
                    this.wmsInfo = selection;
                    break;
                }
            }
            if (this.wmsInfo == null) {
                this.wmsInfo = (WmsSelection)this.wmsSelections.get(0);
            }
            this.updateLegendAndList();
        }
    }

    public List getWmsInfos() {
        return this.wmsSelections;
    }

    public void setEnableClick(boolean value) {
        this.enableAutoFetch = value;
    }

    public boolean getEnableAutoFetch() {
        return this.enableAutoFetch;
    }

    public void setEnableAutoFetch(boolean value) {
        this.enableAutoFetch = value;
    }

    public void setSelectedTime(String value) {
        this.selectedTime = value;
        if (this.getHaveInitialized()) {
            this.loadImage();
        }
    }

    public String getSelectedTime() {
        return this.selectedTime;
    }

    public void setTheLayer(Object value) {
        this.theLayer = value;
    }

    public Object getTheLayer() {
        return this.theLayer;
    }

    public Object getTheTitle() {
        return this.theTitle;
    }

    public void setTheTitle(Object value) {
        this.theTitle = value;
    }

    public void setScale(double value) {
        this.scale = value;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    protected double getInitialZPosition() {
        if (this.inGlobeDisplay()) {
            return super.getInitialZPosition() - 0.005;
        }
        return super.getInitialZPosition();
    }

    public static class ColorExclude {
        Color baseColor;
        int redRange = 10;
        int greenRange = 10;
        int blueRange = 10;

        public ColorExclude(Color c, int range) {
            this(c, range, range, range);
        }

        public ColorExclude(Color c, int rr, int gr, int br) {
            this.baseColor = c;
            this.redRange = rr;
            this.greenRange = gr;
            this.blueRange = br;
        }
    }
}

