/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.control.FlowDisplayControl;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.RangeDialog;
import ucar.unidata.idv.control.ValueSliderWidget;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.FlowDisplayable;
import ucar.visad.display.WindBarbDisplayable;
import visad.CoordinateSystem;
import visad.Data;
import visad.FieldImpl;
import visad.GriddedSet;
import visad.Real;
import visad.RealTupleType;
import visad.SampledSet;
import visad.VisADException;
import visad.georef.MapProjection;

public class VolumeVectorControl
extends GridDisplayControl
implements FlowDisplayControl {
    FlowDisplayable myDisplay;
    protected DataChoice datachoice;
    ValueSliderWidget barbSizeWidget;
    JComponent sizeComponent;
    ValueSliderWidget trajLengthWidget;
    JComponent trajLengthComponent;
    JComponent trajSkipComponent;
    JComponent trajSkipComponentE;
    JComponent streamLSkipComponent;
    JComponent streamLSkipComponentE;
    ValueSliderWidget streamLLengthWidget;
    JComponent streamLLengthComponent;
    JComponent smoothComponent;
    ValueSliderWidget smoothWidget;
    ValueSliderWidget skipFactorWidget;
    ValueSliderWidget skipFactorWidgetZ;
    private JRadioButton vectorBtn;
    private JRadioButton trajectoryBtn;
    private JRadioButton streamlineBtn;
    boolean isStreamLine = false;
    boolean isVectors = true;
    boolean isTrajectories = false;
    boolean isWindBarbs = false;
    boolean isThreeComponents = true;
    boolean autoSize = false;
    boolean arrowHead = false;
    boolean arrowHeadL = false;
    protected final float scaleFactor = 0.02f;
    float flowScaleValue = 4.0f;
    float arrowHeadSizeValue = 1.0f;
    float trajOffsetValue = 4.0f;
    float streamLOffsetValue = 4.0f;
    private JComponent[] widthSliderComps;
    private Range flowRange;
    RangeDialog rangeDialog;
    private boolean useSpeedForColor = false;
    private boolean coloredByAnother = false;
    private int colorIndex = -1;
    private static final String[] trajFormLabels = new String[]{"Line", "Ribbon", "Cylinder", "Deform Ribbon", "Point"};
    private static final int[] trajForm = new int[]{0, 1, 2, 3, 4};
    private static final String[] streamLFormLabels = new String[]{"Line", "Ribbon", "Cylinder"};
    private static final int[] streamLForm = new int[]{0, 1, 2};
    JComponent trajFormComponent;
    private Integer trajFormType = new Integer(0);
    private int trajStartLevel = 0;
    private int trajEndLevel = 0;
    private int trajSkipLevels = 0;
    JComponent streamLFormComponent;
    private Integer streamLFormType = new Integer(0);
    private int streamLStartLevel = 0;
    private int streamLEndLevel = 0;
    private Range flowColorRange;
    private int skipValueZ = 0;
    JCheckBox arrowCbx;
    JCheckBox arrowCbxL;
    int smoothFactor = 10;
    boolean fromBundle = false;
    ValueSliderWidget vectorAHSizeWidget;
    boolean isLine = true;
    private JComboBox levelBox;
    private JComboBox slevelBox;
    private JComboBox slevelBoxEnd;
    private JComboBox levelBoxEnd;
    protected Object currentLevel;

    public VolumeVectorControl() {
        this.setAttributeFlags(1028);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        DerivedDataChoice ddc;
        List choices0;
        this.datachoice = dataChoice;
        if (!this.isDisplay3D()) {
            LogUtil.userMessage(log_, "Can't render volume in 2D display");
            return false;
        }
        if (dataChoice instanceof DerivedDataChoice && (choices0 = (ddc = (DerivedDataChoice)dataChoice).getChoices()).size() == 3) {
            DirectDataChoice udc = (DirectDataChoice)choices0.get(0);
            DirectDataChoice vdc = (DirectDataChoice)choices0.get(1);
            DataChoice wdc = (DataChoice)choices0.get(2);
            List usTime = udc.getAllDateTimes();
            List wsTime = wdc.getAllDateTimes();
            List selectedTimes = this.getDataSelection().getTimes();
            if (this.isStreamLine || this.isTrajectories) {
                if (selectedTimes != null && selectedTimes.size() < 4) {
                    this.userErrorMessage("Minumum selected times need to be 4 for trajectory calculation");
                    return false;
                }
                if (usTime != null && usTime.size() < 4) {
                    this.userErrorMessage("Minumum selected times need to be 4 for trajectory calculation");
                    return false;
                }
            }
            if (wdc.getSelectedDateTimes() != null) {
                selectedTimes = wdc.getSelectedDateTimes();
                int len = selectedTimes.size();
                if (usTime.get(0) != wsTime.get(0) || usTime.get(len - 1) != wsTime.get(len - 1)) {
                    this.userErrorMessage("w grid selected times are different from u grid ");
                    return false;
                }
            }
        }
        this.levelBox = this.doMakeLevelControl(null);
        this.levelBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VolumeVectorControl.this.getOkToFireEvents()) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                    int selectIdx = ((JComboBox)e.getSource()).getSelectedIndex();
                    if (select != null && VolumeVectorControl.this.isTrajectories) {
                        int ct = ((JComboBox)e.getSource()).getItemCount();
                        if (select.toString().equals("All Levels")) {
                            VolumeVectorControl.this.setTrajStartLevel(select, 0);
                        } else {
                            VolumeVectorControl.this.setTrajStartLevel(select, selectIdx);
                        }
                    }
                }
            }
        });
        this.levelBoxEnd = this.doMakeLevelControl(null);
        this.levelBoxEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VolumeVectorControl.this.getOkToFireEvents()) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                    int selectIdx = ((JComboBox)e.getSource()).getSelectedIndex();
                    if (select != null && VolumeVectorControl.this.isTrajectories) {
                        VolumeVectorControl.this.setTrajEndLevel(select, selectIdx);
                    }
                }
            }
        });
        this.slevelBox = this.doMakeLevelControl(null);
        this.slevelBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VolumeVectorControl.this.getOkToFireEvents()) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                    int selectIdx = ((JComboBox)e.getSource()).getSelectedIndex();
                    if (select != null && VolumeVectorControl.this.isStreamLine) {
                        int ct = ((JComboBox)e.getSource()).getItemCount();
                        if (select.toString().equals("All Levels")) {
                            VolumeVectorControl.this.setStreamLStartLevel(select, 0);
                        } else {
                            VolumeVectorControl.this.setStreamLStartLevel(select, selectIdx);
                        }
                    }
                }
            }
        });
        this.slevelBoxEnd = this.doMakeLevelControl(null);
        this.slevelBoxEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VolumeVectorControl.this.getOkToFireEvents()) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                    int selectIdx = ((JComboBox)e.getSource()).getSelectedIndex();
                    if (select != null && VolumeVectorControl.this.isStreamLine) {
                        VolumeVectorControl.this.setStreamLEndLevel(select, selectIdx);
                    }
                }
            }
        });
        this.myDisplay = (FlowDisplayable)this.createPlanDisplay();
        this.myDisplay.setPointSize(this.getPointSize());
        this.addDisplayable((Displayable)this.myDisplay, this.getAttributeFlags());
        return this.setData(dataChoice);
    }

    protected DisplayableData createPlanDisplay() throws VisADException, RemoteException {
        FlowDisplayable planDisplay;
        if (this.isWindBarbs) {
            planDisplay = new WindBarbDisplayable("FlowPlanViewControl_windbarbs_" + (this.datachoice != null ? this.datachoice.toString() : ""), null);
        } else {
            planDisplay = new FlowDisplayable("FlowPlanViewControl_vectors_" + (this.datachoice != null ? this.datachoice.toString() : ""), null);
            planDisplay.set3DFlow(true);
        }
        planDisplay.setAutoScale(this.autoSize);
        planDisplay.setUseSpeedForColor(this.useSpeedForColor);
        if (this.isStreamLine) {
            planDisplay.setStreamline(this.isStreamLine);
            planDisplay.setIsTrajectories(true);
            planDisplay.setTrojectoriesEnabled(true, this.arrowHeadSizeValue, false);
        } else {
            planDisplay.setStreamline(this.isStreamLine);
            planDisplay.setTrojectoriesEnabled(this.isTrajectories, this.arrowHeadSizeValue, false);
        }
        planDisplay.setTrojectoriesEnabled(this.isTrajectories, this.arrowHeadSizeValue, false);
        if (this.useSpeedForColor || this.coloredByAnother) {
            this.addAttributedDisplayable(planDisplay, 8);
        } else {
            this.addAttributedDisplayable(planDisplay);
        }
        return planDisplay;
    }

    FlowDisplayable getGridDisplay() {
        return this.myDisplay;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        List dchoices;
        this.skipFactorWidget = new ValueSliderWidget(this, 0, 10, "skipValue", this.getSkipWidgetLabel());
        this.skipFactorWidgetZ = new ValueSliderWidget(this, 0, 10, "skipValueZ", this.getSkipWidgetLabel());
        this.addRemovable(this.skipFactorWidget);
        this.addRemovable(this.skipFactorWidgetZ);
        this.barbSizeWidget = new ValueSliderWidget(this, 1, 21, "flowScale", "Size");
        this.addRemovable(this.barbSizeWidget);
        JCheckBox autoSizeCbx = new JCheckBox("Autosize", this.autoSize);
        this.arrowCbx = new JCheckBox("Arrow", this.arrowHead);
        this.arrowCbxL = new JCheckBox("Arrow", this.arrowHeadL);
        autoSizeCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VolumeVectorControl.this.autoSize = ((JCheckBox)e.getSource()).isSelected();
                VolumeVectorControl.this.getGridDisplay().setAutoScale(VolumeVectorControl.this.autoSize);
            }
        });
        this.arrowCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VolumeVectorControl.this.arrowHead = ((JCheckBox)e.getSource()).isSelected();
                if (VolumeVectorControl.this.arrowHead) {
                    VolumeVectorControl.this.getGridDisplay().setArrowHead(VolumeVectorControl.this.arrowHead);
                } else {
                    VolumeVectorControl.this.getGridDisplay().setArrowHead(VolumeVectorControl.this.arrowHead);
                }
                if (!VolumeVectorControl.this.fromBundle) {
                    VolumeVectorControl.this.getGridDisplay().resetTrojectories();
                }
            }
        });
        this.arrowCbxL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VolumeVectorControl.this.arrowHeadL = ((JCheckBox)e.getSource()).isSelected();
                if (VolumeVectorControl.this.arrowHeadL) {
                    VolumeVectorControl.this.getGridDisplay().setArrowHead(VolumeVectorControl.this.arrowHeadL);
                } else {
                    VolumeVectorControl.this.getGridDisplay().setArrowHead(VolumeVectorControl.this.arrowHeadL);
                }
                if (!VolumeVectorControl.this.fromBundle) {
                    VolumeVectorControl.this.getGridDisplay().resetTrojectories();
                }
            }
        });
        this.sizeComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Size: "), (Component)this.barbSizeWidget.getContents(false), autoSizeCbx);
        if (this.getIsThreeComponents()) {
            this.vectorBtn = new JRadioButton(this.isWindBarbs ? "Wind Barbs:" : "Vectors:", this.isVectors);
            this.trajLengthWidget = new ValueSliderWidget(this, 1, 21, "trajOffset", "LengthOffset");
            this.streamLLengthWidget = new ValueSliderWidget(this, 1, 21, "streamLOffset", "LengthOffset");
            this.smoothWidget = new ValueSliderWidget(this, 11, 31, "smoothFactor", "smoothFactor");
            List trajFormList = TwoFacedObject.createList(trajForm, trajFormLabels);
            List streamLFormList = TwoFacedObject.createList(streamLForm, streamLFormLabels);
            JComboBox trajFormBox = new JComboBox();
            JComboBox streamLFormBox = new JComboBox();
            GuiUtils.setListData(trajFormBox, trajFormList);
            GuiUtils.setListData(streamLFormBox, streamLFormList);
            trajFormBox.setSelectedItem(TwoFacedObject.findId(this.getTrajFormType(), trajFormList));
            trajFormBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                    VolumeVectorControl.this.setTrajFormType(select.getId().hashCode());
                    if (select.getLabel() == "Line") {
                        VolumeVectorControl.this.isLine = true;
                        VolumeVectorControl.this.arrowCbx.setSelected(VolumeVectorControl.this.arrowHead);
                    } else {
                        VolumeVectorControl.this.arrowCbx.setSelected(false);
                        VolumeVectorControl.this.isLine = false;
                    }
                    VolumeVectorControl.this.enableArrowCompnoentBox();
                }
            });
            this.enableArrowCompnoentBox();
            streamLFormBox.setSelectedItem(TwoFacedObject.findId(this.getStreamLFormType(), streamLFormList));
            streamLFormBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                    VolumeVectorControl.this.setStreamLFormType(select.getId().hashCode());
                }
            });
            this.trajFormComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Trajectory Form: "), GuiUtils.filler(), trajFormBox, GuiUtils.filler());
            this.trajLengthComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Length Offset: "), (Component)this.trajLengthWidget.getContents(false), this.arrowCbx);
            this.trajSkipComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Trajectory Start Level: "), GuiUtils.filler(), this.levelBox);
            this.trajSkipComponentE = GuiUtils.hbox((Component)GuiUtils.rLabel("Trajectory End Level: "), GuiUtils.filler(), this.levelBoxEnd);
            this.trajectoryBtn = new JRadioButton("Trajectories:", this.isTrajectories);
            this.streamLFormComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Streamline Form: "), GuiUtils.filler(), streamLFormBox, GuiUtils.filler());
            this.streamLLengthComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Length Offset: "), (Component)this.streamLLengthWidget.getContents(false), this.arrowCbxL);
            this.smoothComponent = GuiUtils.hbox(GuiUtils.rLabel("Smooth Factor: "), this.smoothWidget.getContents(false));
            this.streamLSkipComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Streamline Start Level: "), GuiUtils.filler(), this.slevelBox);
            this.streamLSkipComponentE = GuiUtils.hbox((Component)GuiUtils.rLabel("Streamline End Level: "), GuiUtils.filler(), this.slevelBoxEnd);
            this.streamlineBtn = new JRadioButton("Streamlines:", this.isStreamLine);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRadioButton source = (JRadioButton)e.getSource();
                    if (source == VolumeVectorControl.this.trajectoryBtn) {
                        VolumeVectorControl.this.isTrajectories = true;
                        VolumeVectorControl.this.isVectors = false;
                        VolumeVectorControl.this.isStreamLine = false;
                        if (!VolumeVectorControl.this.fromBundle) {
                            VolumeVectorControl.this.setStreamlines();
                            if (VolumeVectorControl.this.getTrajEndLevel() == 0) {
                                Object ob = VolumeVectorControl.this.levelBoxEnd.getSelectedItem();
                                VolumeVectorControl.this.levelBoxEnd.setSelectedItem(ob);
                            } else {
                                VolumeVectorControl.this.levelBoxEnd.setSelectedIndex(VolumeVectorControl.this.getTrajEndLevel());
                            }
                        }
                    } else if (source == VolumeVectorControl.this.streamlineBtn) {
                        VolumeVectorControl.this.isStreamLine = true;
                        VolumeVectorControl.this.isTrajectories = false;
                        VolumeVectorControl.this.isVectors = false;
                        if (!VolumeVectorControl.this.fromBundle) {
                            VolumeVectorControl.this.setStreamlines();
                            if (VolumeVectorControl.this.getTrajEndLevel() == 0) {
                                Object ob = VolumeVectorControl.this.slevelBoxEnd.getSelectedItem();
                                VolumeVectorControl.this.slevelBoxEnd.setSelectedItem(ob);
                            } else {
                                VolumeVectorControl.this.slevelBoxEnd.setSelectedIndex(VolumeVectorControl.this.getStreamLEndLevel());
                            }
                        }
                    } else {
                        VolumeVectorControl.this.isVectors = true;
                        VolumeVectorControl.this.isTrajectories = false;
                        VolumeVectorControl.this.isStreamLine = false;
                        if (!VolumeVectorControl.this.fromBundle) {
                            VolumeVectorControl.this.setStreamlines();
                        }
                    }
                }
            };
            this.vectorBtn.addActionListener(listener);
            this.trajectoryBtn.addActionListener(listener);
            this.streamlineBtn.addActionListener(listener);
            GuiUtils.buttonGroup(this.vectorBtn, this.trajectoryBtn, this.streamlineBtn);
            Insets spacer = new Insets(0, 30, 0, 0);
            JPanel rightComp = GuiUtils.vbox(GuiUtils.left(GuiUtils.vbox(this.vectorBtn, GuiUtils.inset((Component)this.sizeComponent, spacer))), GuiUtils.left(GuiUtils.vbox(this.trajectoryBtn, GuiUtils.vbox(GuiUtils.inset((Component)this.trajFormComponent, spacer), GuiUtils.inset((Component)this.trajLengthComponent, spacer), GuiUtils.inset((Component)this.trajSkipComponent, spacer), GuiUtils.inset((Component)this.trajSkipComponentE, spacer)))), GuiUtils.left(GuiUtils.vbox(this.streamlineBtn, GuiUtils.vbox(GuiUtils.inset((Component)this.streamLFormComponent, spacer), GuiUtils.inset((Component)this.streamLLengthComponent, spacer), GuiUtils.inset((Component)this.smoothComponent, spacer), GuiUtils.inset((Component)this.streamLSkipComponent, spacer), GuiUtils.inset((Component)this.streamLSkipComponentE, spacer)))));
            JLabel showLabel = GuiUtils.rLabel("Show:");
            showLabel.setVerticalTextPosition(1);
            controlWidgets.add(new WrapperWidget(this, GuiUtils.top(GuiUtils.inset((Component)showLabel, new Insets(10, 0, 0, 0))), GuiUtils.left(GuiUtils.top(rightComp))));
        }
        this.vectorAHSizeWidget = new ValueSliderWidget(this, 0, 40, "ArrowHeadSize", "Arrow Head Size", 10.0f);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Arrow Scale: "), this.vectorAHSizeWidget.getContents(false)));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("XY Skip:"), GuiUtils.left(this.skipFactorWidget.getContents(false))));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Z Skip:"), GuiUtils.left(this.skipFactorWidgetZ.getContents(false))));
        this.enableTrajLengthBox();
        this.enableStreamLLengthBox();
        this.enableVectorBox();
        List timeL = this.getDataSelection().getTimes();
        if (timeL == null && this.getHadDataChoices() && (timeL = ((DataChoice)(dchoices = this.getMyDataChoices()).get(0)).getSelectedDateTimes()) != null && timeL.size() == 0) {
            timeL = ((DataChoice)dchoices.get(0)).getAllDateTimes();
        }
        if (timeL != null && timeL.size() < 4) {
            GuiUtils.enableTree(this.trajectoryBtn, false);
        }
        if (timeL != null && timeL.size() < 4) {
            GuiUtils.enableTree(this.streamlineBtn, false);
        }
        super.getControlWidgets(controlWidgets);
    }

    public int getSmoothFactor() {
        return this.smoothFactor;
    }

    public void setSmoothFactor(int f) {
        this.smoothFactor = f;
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setSmoothFactor(f);
                this.getGridDisplay().setStreamline(true);
                this.getGridDisplay().resetTrojectories();
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
        if (this.smoothWidget != null) {
            this.smoothWidget.setValue(f);
        }
    }

    public boolean getIsThreeComponents() {
        return this.isThreeComponents;
    }

    public void setStreamlines() {
        if (this.getGridDisplay() != null) {
            int ct = this.levelBox.getItemCount();
            String tt = this.levelBox.getSelectedItem().toString();
            if (tt.equals("All Levels")) {
                this.getGridDisplay().setZskip(0);
            } else {
                this.getGridDisplay().setZskip(ct - 1);
            }
            this.getGridDisplay().setIsTrajectories(this.isTrajectories);
            this.getGridDisplay().setStreamline(this.isStreamLine);
            if (this.isStreamLine) {
                this.getGridDisplay().setTrajFormType(this.getStreamLFormType());
                this.getGridDisplay().setIsTrajectories(true);
                this.getGridDisplay().setTrajStartLevel(this.streamLStartLevel);
                this.getGridDisplay().setTrajOffset(this.getStreamLOffset());
                if (this.arrowHeadL) {
                    this.getGridDisplay().setArrowHead(true);
                    this.arrowCbxL.setSelected(this.arrowHeadL);
                }
                this.getGridDisplay().setTrojectoriesEnabled(true, this.arrowHeadL, this.arrowHeadSizeValue, false);
            } else {
                this.getGridDisplay().setTrajFormType(this.getTrajFormType());
                this.getGridDisplay().setTrajStartLevel(this.trajStartLevel);
                this.getGridDisplay().setTrajOffset(this.getTrajOffset());
                if (this.arrowHead) {
                    this.getGridDisplay().setArrowHead(true);
                    this.arrowCbx.setSelected(this.arrowHead);
                }
                this.getGridDisplay().setTrojectoriesEnabled(this.isTrajectories, this.arrowHead, this.arrowHeadSizeValue, false);
            }
            this.enableTrajLengthBox();
            this.enableStreamLLengthBox();
            this.enableVectorBox();
        }
        if (this.trajectoryBtn != null) {
            this.vectorBtn.setSelected(this.isVectors);
            this.trajectoryBtn.setSelected(this.isTrajectories);
        }
    }

    private void enableArrowCompnoentBox() {
        GuiUtils.enableTree(this.arrowCbx, this.isLine);
    }

    public void setArrowHeadSize(float f) {
        this.arrowHeadSizeValue = f;
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setTrajOffset(this.getTrajOffset());
                this.getGridDisplay().setArrowHeadSize(this.arrowHeadSizeValue);
                if (this.isTrajectories) {
                    this.getGridDisplay().resetTrojectories();
                }
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
        if (this.vectorAHSizeWidget != null) {
            this.vectorAHSizeWidget.setValue(f);
        }
    }

    public float getArrowHeadSize() {
        return this.arrowHeadSizeValue;
    }

    private void enableTrajLengthBox() {
        if (this.trajLengthComponent != null) {
            GuiUtils.enableTree(this.trajLengthComponent, this.isTrajectories);
            GuiUtils.enableTree(this.trajFormComponent, this.isTrajectories);
            GuiUtils.enableTree(this.trajSkipComponent, this.isTrajectories);
            GuiUtils.enableTree(this.trajSkipComponentE, this.isTrajectories);
            GuiUtils.enableTree(this.levelBox, this.isTrajectories);
            GuiUtils.enableTree(this.levelBoxEnd, this.isTrajectories);
        }
    }

    private void enableStreamLLengthBox() {
        if (this.streamLLengthComponent != null) {
            GuiUtils.enableTree(this.streamLLengthComponent, this.isStreamLine);
            GuiUtils.enableTree(this.streamLFormComponent, this.isStreamLine);
            GuiUtils.enableTree(this.streamLSkipComponent, this.isStreamLine);
            GuiUtils.enableTree(this.streamLSkipComponentE, this.isStreamLine);
            GuiUtils.enableTree(this.smoothComponent, this.isStreamLine);
            GuiUtils.enableTree(this.slevelBox, this.isStreamLine);
            GuiUtils.enableTree(this.slevelBoxEnd, this.isStreamLine);
        }
    }

    private void enableVectorBox() {
        if (this.sizeComponent != null) {
            GuiUtils.enableTree(this.sizeComponent, !this.isTrajectories);
        }
    }

    @Override
    public void setPointSize(float value) {
        super.setPointSize(value);
        if (this.myDisplay != null) {
            try {
                this.myDisplay.setPointSize(this.getPointSize());
            }
            catch (Exception e) {
                VolumeVectorControl.logException("Setting point size", e);
            }
        }
    }

    @Override
    protected void applySkipFactor() {
        try {
            this.showWaitCursor();
            if (!this.fromBundle) {
                this.loadVolumeData();
            }
        }
        catch (Exception exc) {
            VolumeVectorControl.logException("loading volume data", exc);
        }
        finally {
            this.showNormalCursor();
        }
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        List levelsList;
        if (!super.setData(choice) || this.getNavigatedDisplay() == null) {
            return false;
        }
        DataSelection tmpSelection = new DataSelection(this.getDataSelection());
        tmpSelection.setFromLevel(null);
        tmpSelection.setToLevel(null);
        List cchoices = ((DerivedDataChoice)choice).getChoices();
        if (cchoices.size() == 2) {
            DataChoice uvwchoice = (DataChoice)((DerivedDataChoice)choice).getChoices().get(0);
            DataChoice wchoice = (DataChoice)((DerivedDataChoice)uvwchoice).getChoices().get(2);
            levelsList = wchoice.getAllLevels(tmpSelection);
        } else {
            DataChoice wchoice = (DataChoice)((DerivedDataChoice)choice).getChoices().get(2);
            levelsList = wchoice.getAllLevels(tmpSelection);
        }
        Object[] levels = this.getGridDataInstance().getLevels();
        if (levels == null && levelsList != null && levelsList.size() > 0) {
            levels = levelsList.toArray(new Object[levelsList.size()]);
        }
        if (!this.reloadFromBounds) {
            this.setLevels(levels);
        }
        this.myDisplay.setActive(false);
        this.myDisplay.setUseSpeedForColor(this.useSpeedForColor);
        this.myDisplay.setColoredByAnother(this.coloredByAnother);
        if (this.useSpeedForColor) {
            this.colorIndex = this.myDisplay.getSpeedTypeIndex();
        }
        if (this.coloredByAnother) {
            this.colorIndex = 3;
        }
        this.loadVolumeData();
        if (this.useSpeedForColor || this.coloredByAnother) {
            this.setFlowColorRange();
        }
        this.myDisplay.setActive(true);
        return true;
    }

    public void setLevels(Object[] levels) {
        if (levels == null) {
            levels = this.getGridDataInstance().getLevels();
        }
        this.setOkToFireEvents(false);
        if (this.levelBox == null || this.slevelBox == null) {
            return;
        }
        this.levelBox.setEnabled(false);
        this.levelBoxEnd.setEnabled(false);
        this.slevelBox.setEnabled(false);
        this.slevelBoxEnd.setEnabled(false);
        Object[] all = this.formatLevels(levels);
        GuiUtils.setListData(this.levelBox, this.formatLevels(levels));
        GuiUtils.setListData(this.levelBoxEnd, this.formatLevels(levels));
        GuiUtils.setListData(this.slevelBox, this.formatLevels(levels));
        GuiUtils.setListData(this.slevelBoxEnd, this.formatLevels(levels));
        int len = (levels.length - 1) / (this.skipValueZ + 1) + 2;
        if (!this.fromBundle) {
            this.currentLevel = all[len - 1];
        }
        this.trajStartLevel = this.getTrajStartLevel();
        this.streamLStartLevel = this.getStreamLStartLevel();
        if (this.currentLevel == null) {
            this.levelBox.setSelectedItem(this.getLabeledReal(all[levels.length]));
            this.slevelBox.setSelectedItem(this.getLabeledReal(all[levels.length]));
        } else {
            this.levelBox.setSelectedItem(this.getLabeledReal(this.currentLevel));
            this.slevelBox.setSelectedItem(this.getLabeledReal(this.currentLevel));
        }
        if (this.currentLevel != null && ((TwoFacedObject)this.currentLevel).getLabel().equals("All Levels")) {
            this.slevelBoxEnd.setSelectedItem(this.getLabeledReal(this.currentLevel));
        } else if (this.currentLevel == null) {
            this.slevelBoxEnd.setSelectedItem(this.getLabeledReal(all[levels.length]));
        } else {
            this.slevelBoxEnd.setSelectedItem(this.getLabeledReal(all[this.getStreamLEndLevel()]));
        }
        if (this.currentLevel != null && ((TwoFacedObject)this.currentLevel).getLabel().equals("All Levels")) {
            this.levelBoxEnd.setSelectedItem(this.getLabeledReal(this.currentLevel));
        } else if (this.currentLevel == null) {
            this.levelBoxEnd.setSelectedItem(this.getLabeledReal(all[levels.length]));
        } else {
            this.levelBoxEnd.setSelectedItem(this.getLabeledReal(all[this.getTrajEndLevel()]));
        }
        this.setOkToFireEvents(true);
        this.levelBox.setEnabled(true);
        this.levelBoxEnd.setEnabled(true);
        this.slevelBox.setEnabled(true);
        this.slevelBoxEnd.setEnabled(true);
    }

    @Override
    protected Object[] formatLevels(Object[] levels) {
        if (levels == null) {
            return null;
        }
        int zskip = this.skipValueZ;
        int len = (levels.length - 1) / (zskip + 1) + 1 + 1;
        Object[] tfoList = new Object[len];
        for (int i = 0; i < len - 1; ++i) {
            int j = i * (zskip + 1);
            tfoList[i] = this.getLabeledReal(levels[j]);
        }
        tfoList[len - 1] = new TwoFacedObject((Object)"All Levels", new Real(0.0));
        return tfoList;
    }

    private void setFlowColorRange() throws RemoteException, VisADException {
        if (this.getGridDisplay() != null && this.getFlowRange() == null) {
            Range[] ranges = null;
            Data data = this.getGridDisplay().getData();
            if (data != null) {
                int speedIndex;
                ranges = GridUtil.getMinMax((FieldImpl)data);
                double max = Double.NEGATIVE_INFINITY;
                double min = Double.POSITIVE_INFINITY;
                int startComp = 0;
                int numComps = this.getIsThreeComponents() ? 3 : 2;
                boolean isCartesian = this.getGridDisplay().isCartesianWind();
                if (!isCartesian && (speedIndex = this.getGridDisplay().getSpeedTypeIndex()) != -1) {
                    startComp = speedIndex;
                    numComps = startComp + 1;
                }
                if ((this.useSpeedForColor || this.coloredByAnother) && ranges.length > numComps) {
                    Range compRange = ranges[ranges.length - 1];
                    max = Math.max(compRange.getMax(), max);
                    min = Math.min(compRange.getMin(), min);
                } else {
                    for (int i = startComp; i < numComps; ++i) {
                        Range compRange = ranges[i];
                        max = Math.max(compRange.getMax(), max);
                        min = Math.min(compRange.getMin(), min);
                    }
                }
                if (!(this.useSpeedForColor || this.coloredByAnother || Double.isInfinite(max) || Double.isInfinite(min))) {
                    max = Math.max(max, -min);
                    min = isCartesian ? -max : 0.0;
                }
                this.flowColorRange = new Range(min, max);
            } else {
                this.flowColorRange = new Range(-40.0, 40.0);
            }
        }
    }

    public void setArrowHead(boolean arrow) {
        this.arrowHead = arrow;
    }

    public boolean getArrowHead() {
        return this.arrowHead;
    }

    public void setArrowHeadL(boolean arrow) {
        this.arrowHeadL = arrow;
    }

    public boolean getArrowHeadL() {
        return this.arrowHeadL;
    }

    public void setFlowColorRange(Range colorRange) {
        this.flowColorRange = colorRange;
    }

    public Range getFlowColorRange() {
        return this.flowColorRange;
    }

    public Range getFlowRange() {
        return this.flowRange;
    }

    public void setFlowRange(Range f) {
        this.flowRange = f;
        if (this.getGridDisplay() != null && this.flowRange != null) {
            try {
                this.getGridDisplay().setFlowRange(this.flowRange);
            }
            catch (Exception excp) {
                VolumeVectorControl.logException("setFlowRange: ", excp);
            }
        }
        if (this.getHaveInitialized()) {
            this.doShare((Object)"FlowDisplayControl.SHARE_FLOWRANGE", this.flowRange);
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        return GuiUtils.left(this.doMakeWidgetComponent());
    }

    private void loadVolumeData() throws VisADException, RemoteException {
        FieldImpl grid;
        Trace.call1("VRC.loadVolumeData");
        FieldImpl newGrid = grid = this.getGridDataInstance().getGrid();
        if (this.getSkipValue() > 0 && this.getSkipValueZ() > 0) {
            newGrid = grid = GridUtil.subset(grid, this.getSkipValue() + 1, this.getSkipValue() + 1, this.getSkipValueZ() + 1);
        } else if (this.getSkipValue() > 0) {
            newGrid = grid = GridUtil.subset(grid, this.getSkipValue() + 1);
        } else if (this.getSkipValueZ() > 0) {
            newGrid = grid = GridUtil.subset(grid, 1, 1, this.getSkipValueZ() + 1);
        }
        Trace.call1("VRC.loadVolumeData.loadData");
        this.myDisplay.loadData(newGrid);
        Trace.call2("VRC.loadVolumeData.loadData");
        Trace.call2("loadVolumeData");
    }

    public float[][] setStartPointsFromDomain2D(int trajForm, int skip, float[][] setLocs, int lenX, int lenY, int level, float[][] flowValues, float ribbonWidthFac) throws VisADException {
        int len2D = lenX * lenY;
        float[][] locs2D = new float[3][len2D];
        System.arraycopy(setLocs[0], level * len2D, locs2D[0], 0, len2D);
        System.arraycopy(setLocs[1], level * len2D, locs2D[1], 0, len2D);
        System.arraycopy(setLocs[2], level * len2D, locs2D[2], 0, len2D);
        float[][] startPts = new float[3][];
        int[] o_j = new int[]{0, 0, 1, 1};
        int[] o_i = new int[]{0, 1, 0, 1};
        int m = 0;
        int jA = 1 + o_j[m] * (skip / 2);
        int jB = lenY - skip;
        int iA = 1 + o_i[m] * (skip / 2);
        int iB = lenX - skip;
        int numJ = 1 + (jB - 1 - jA) / skip;
        int numI = 1 + (iB - 1 - iA) / skip;
        int num = numJ * numI;
        if (trajForm == 3) {
            num *= 2;
        }
        startPts[0] = new float[num];
        startPts[1] = new float[num];
        startPts[2] = new float[num];
        float[] norm = new float[]{0.0f, 0.0f, 1.0f};
        float[] traj = new float[3];
        float width = ribbonWidthFac * 0.006f;
        num = 0;
        for (int j = 1 + o_j[m] * (skip / 2); j < lenY - skip; j += skip) {
            for (int i = 1 + o_i[m] * (skip / 2); i < lenX - skip; i += skip) {
                int k = j * lenX + i;
                if (trajForm == 3) {
                    float u = flowValues[0][k];
                    float v = flowValues[1][k];
                    traj[0] = u;
                    traj[1] = v;
                    traj[2] = 0.0f;
                    float mag = (float)Math.sqrt(u * u + v * v);
                    traj[0] = traj[0] / mag;
                    traj[1] = traj[1] / mag;
                    float[] norm_x_traj = VolumeVectorControl.AxB(norm, traj);
                    startPts[0][num] = width * norm_x_traj[0] + locs2D[0][k];
                    startPts[1][num] = width * norm_x_traj[1] + locs2D[1][k];
                    startPts[2][num] = width * norm_x_traj[2] + locs2D[2][k];
                    startPts[0][++num] = -width * norm_x_traj[0] + locs2D[0][k];
                    startPts[1][num] = -width * norm_x_traj[1] + locs2D[1][k];
                    startPts[2][num] = -width * norm_x_traj[2] + locs2D[2][k];
                    ++num;
                    continue;
                }
                startPts[0][num] = locs2D[0][k];
                startPts[1][num] = locs2D[1][k];
                startPts[2][num] = locs2D[2][k];
                ++num;
            }
        }
        return startPts;
    }

    public static float[] AxB(float[] A, float[] B) {
        float[] axb = new float[]{A[1] * B[2] - A[2] * B[1], -(A[0] * B[2] - A[2] * B[0]), A[0] * B[1] - A[1] * B[0]};
        return axb;
    }

    private GriddedSet makeLinearGrid(GriddedSet domainSet, CoordinateSystem cs) throws VisADException, RemoteException {
        Object object;
        Trace.call1("VRC.makeLinearGrid");
        SampledSet ss = null;
        boolean latLonOrder = GridUtil.isLatLonOrder(domainSet);
        Trace.call1("VRC.convertDomain");
        ss = latLonOrder ? Util.convertDomain(domainSet, RealTupleType.LatitudeLongitudeAltitude, null) : Util.convertDomain(domainSet, RealTupleType.SpatialEarth3DTuple, null);
        Trace.call2("VRC.convertDomain");
        float[][] refVals = ss.getSamples(true);
        MapProjectionDisplay mpd = (MapProjectionDisplay)this.getNavigatedDisplay();
        MapProjection mp = mpd.getMapProjection();
        boolean mapLatLonOrder = mp.isLatLonOrder();
        if (latLonOrder) {
            object = refVals;
        } else {
            float[][] fArrayArray = new float[3][];
            fArrayArray[0] = refVals[1];
            fArrayArray[1] = refVals[0];
            object = fArrayArray;
            fArrayArray[2] = refVals[2];
        }
        float[][] newVals = object;
        Trace.call1("VRC.toRef");
        newVals = cs.toReference(newVals);
        Trace.call2("VRC.toRef");
        Trace.call1("VRC.scaleVerticalValues");
        newVals[2] = mpd.scaleVerticalValues(newVals[2]);
        Trace.call2("VRC.scaleVerticalValues");
        int[] lengths = domainSet.getLengths();
        GriddedSet xyzSet = GriddedSet.create(RealTupleType.SpatialCartesian3DTuple, newVals, domainSet.getLengths(), null, null, null, false, true);
        return xyzSet;
    }

    @Override
    public void projectionChanged() {
        try {
            this.loadVolumeData();
        }
        catch (Exception exc) {
            VolumeVectorControl.logException("loading volume data", exc);
        }
        super.projectionChanged();
    }

    @Override
    public boolean getIsRaster() {
        return false;
    }

    public float getFlowScale() {
        return this.flowScaleValue;
    }

    public void setFlowScale(float f) {
        this.flowScaleValue = f;
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setFlowScale(this.getDisplayScale() * 0.02f * this.flowScaleValue);
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
    }

    public float getTrajOffset() {
        return this.trajOffsetValue;
    }

    public float getStreamLOffset() {
        return this.streamLOffsetValue;
    }

    public void setTrajOffset(float f) {
        this.trajOffsetValue = f;
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setTrajOffset(this.trajOffsetValue);
                this.getGridDisplay().setArrowHead(this.arrowHead);
                this.getGridDisplay().resetTrojectories();
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
        if (this.trajLengthWidget != null) {
            this.trajLengthWidget.setValue(f);
        }
    }

    public void setStreamLOffset(float f) {
        this.streamLOffsetValue = f;
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setTrajOffset(this.trajOffsetValue);
                this.getGridDisplay().setArrowHead(this.arrowHeadL);
                this.getGridDisplay().resetTrojectories();
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
        if (this.streamLLengthWidget != null) {
            this.streamLLengthWidget.setValue(f);
        }
    }

    public void setTrajectories(boolean v) {
        this.isTrajectories = v;
        this.isVectors = !v;
        this.isStreamLine = !v;
        this.setStreamlines();
    }

    public void setVectors(boolean v) {
        this.isTrajectories = !v;
        this.isVectors = v;
        this.isStreamLine = !v;
        this.setStreamlines();
    }

    public void setStreamline(boolean v) {
        this.isTrajectories = !v;
        this.isVectors = !v;
        this.isStreamLine = v;
        this.setStreamlines();
    }

    public Integer getTrajFormType() {
        return this.trajFormType;
    }

    public Integer getStreamLFormType() {
        return this.streamLFormType;
    }

    public void setTrajFormType(Integer trajForm) {
        this.trajFormType = trajForm;
        if (this.isTrajectories && this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setTrajFormType(trajForm);
                this.getGridDisplay().setArrowHead(this.arrowHead);
                this.setLineWidth(super.getLineWidth());
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
    }

    public void setStreamLFormType(Integer streamLForm) {
        this.streamLFormType = streamLForm;
        if (this.isStreamLine && this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setTrajFormType(streamLForm);
                this.getGridDisplay().setArrowHead(this.arrowHeadL);
                this.setLineWidth(super.getLineWidth());
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
    }

    public void setTrajStartLevel(Object startLevel, int idx) {
        this.trajStartLevel = idx;
        this.currentLevel = startLevel;
        int ct = this.levelBox.getItemCount();
        Object endLevel = this.levelBoxEnd.getSelectedItem();
        int jdx = this.levelBoxEnd.getSelectedIndex();
        if (ct == 1) {
            ct = 2;
        }
        if (this.getGridDisplay() != null && !this.fromBundle) {
            try {
                this.getGridDisplay().setTrajStartLevel(idx);
                if (((TwoFacedObject)startLevel).getLabel().equals("All Levels")) {
                    this.getGridDisplay().setStartPoints(null, null);
                    this.getGridDisplay().setZskip(0);
                    this.getGridDisplay().resetTrojectories();
                } else if (idx == jdx) {
                    this.getGridDisplay().setStartPoints(null, null);
                    this.getGridDisplay().setZskip(ct - 1);
                    this.getGridDisplay().resetTrojectories();
                } else if (!((TwoFacedObject)endLevel).getLabel().equals("All Levels")) {
                    this.levelBoxEnd.setSelectedIndex(jdx);
                }
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
    }

    public void setTrajEndLevel(Object endLevel, int idx) {
        this.trajEndLevel = idx;
        int bt = this.levelBoxEnd.getItemCount();
        int ct = this.levelBox.getItemCount();
        if (ct == 1) {
            ct = 2;
        }
        if (bt == 1) {
            bt = 2;
        }
        int jdx = this.levelBox.getSelectedIndex();
        if (this.getGridDisplay() != null) {
            try {
                if (((TwoFacedObject)endLevel).getLabel().equals("All Levels") || ((TwoFacedObject)this.currentLevel).getLabel().equals("All Levels")) {
                    this.getGridDisplay().setTrajStartLevel(0);
                    this.getGridDisplay().setStartPoints(null, null);
                    this.getGridDisplay().setZskip(0);
                    this.getGridDisplay().resetTrojectories();
                } else if (idx == jdx) {
                    this.getGridDisplay().setTrajStartLevel(idx);
                    this.getGridDisplay().setStartPoints(null, null);
                    this.getGridDisplay().setZskip(ct - 1);
                    this.getGridDisplay().resetTrojectories();
                } else {
                    GriddedSet domainSet = (GriddedSet)this.getGridDataInstance().getSpatialDomain();
                    CoordinateSystem cs = this.getNavigatedDisplay().getDisplayCoordinateSystem();
                    float[][] domainLatLonAlt = GridUtil.getEarthLocationPoints(domainSet);
                    MapProjectionDisplay mpd = (MapProjectionDisplay)this.getNavigatedDisplay();
                    boolean isLatLon = GridUtil.isLatLonOrder(domainSet);
                    int latIndex = isLatLon ? 1 : 0;
                    int lonIndex = isLatLon ? 0 : 1;
                    int numX = domainSet.getLengths()[lonIndex];
                    int numY = domainSet.getLengths()[latIndex];
                    int numXY = numX * numY;
                    int startZ = idx > jdx ? jdx : idx;
                    int endZ = idx > jdx ? idx : jdx;
                    int numXY0 = numXY;
                    if (this.getSkipValue() > 0) {
                        numXY0 = numXY / (this.getSkipValue() + 1) + 1;
                    }
                    int numP = numXY0 * (endZ - startZ + 1);
                    float[][] geoVals = new float[3][numP];
                    int skipFactor = this.getSkipValue();
                    int jj = 0;
                    for (int k = startZ; k <= endZ; ++k) {
                        int j = 0;
                        while (j < numXY) {
                            int ii = k * numXY * (this.getSkipValueZ() + 1) + j;
                            geoVals[0][jj] = domainLatLonAlt[lonIndex][ii];
                            geoVals[1][jj] = domainLatLonAlt[latIndex][ii];
                            geoVals[2][jj] = domainLatLonAlt[2][ii];
                            ++jj;
                            j = j + 1 + skipFactor;
                        }
                    }
                    float[][] setLocs = cs.toReference(geoVals);
                    setLocs[2] = mpd.scaleVerticalValues(setLocs[2]);
                    RealTupleType types = cs.getReference();
                    this.getGridDisplay().setStartPoints(types, setLocs);
                    this.getGridDisplay().resetTrojectories();
                }
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
    }

    public void setStreamLStartLevel(Object startLevel, int idx) {
        this.streamLStartLevel = idx;
        this.currentLevel = startLevel;
        int ct = this.slevelBox.getItemCount();
        Object endLevel = this.slevelBoxEnd.getSelectedItem();
        int jdx = this.slevelBoxEnd.getSelectedIndex();
        if (ct == 1) {
            ct = 2;
        }
        if (this.getGridDisplay() != null && !this.fromBundle) {
            try {
                this.getGridDisplay().setTrajStartLevel(idx);
                if (((TwoFacedObject)startLevel).getLabel().equals("All Levels")) {
                    this.getGridDisplay().setStartPoints(null, null);
                    this.getGridDisplay().setZskip(0);
                    this.getGridDisplay().resetTrojectories();
                } else if (idx == jdx) {
                    this.getGridDisplay().setStartPoints(null, null);
                    this.getGridDisplay().setZskip(ct - 1);
                    this.getGridDisplay().resetTrojectories();
                } else if (!((TwoFacedObject)endLevel).getLabel().equals("All Levels")) {
                    this.slevelBoxEnd.setSelectedIndex(jdx);
                }
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
    }

    public int getStreamLStartLevel() {
        return this.streamLStartLevel;
    }

    public void setStreamLStartLevel(int startLevel) {
        this.streamLStartLevel = startLevel;
    }

    public int getStreamLEndLevel() {
        return this.streamLEndLevel;
    }

    public void setStreamLEndLevel(int endLevel) {
        this.streamLEndLevel = endLevel;
    }

    public Object getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(Object object) {
        this.currentLevel = object;
    }

    public int getTrajStartLevel() {
        return this.trajStartLevel;
    }

    public void setTrajStartLevel(int startLevel) {
        this.trajStartLevel = startLevel;
    }

    public int getTrajEndLevel() {
        return this.trajEndLevel;
    }

    public void setTrajEndLevel(int endLevel) {
        this.trajEndLevel = endLevel;
    }

    public void setStreamLEndLevel(Object endLevel, int idx) {
        this.streamLEndLevel = idx;
        int bt = this.slevelBoxEnd.getItemCount();
        int ct = this.slevelBox.getItemCount();
        if (ct == 1) {
            ct = 2;
        }
        if (bt == 1) {
            bt = 2;
        }
        int jdx = this.slevelBox.getSelectedIndex();
        if (this.getGridDisplay() != null) {
            try {
                if (((TwoFacedObject)endLevel).getLabel().equals("All Levels") || ((TwoFacedObject)this.currentLevel).getLabel().equals("All Levels")) {
                    this.getGridDisplay().setTrajStartLevel(0);
                    this.getGridDisplay().setStartPoints(null, null);
                    this.getGridDisplay().setZskip(0);
                    this.getGridDisplay().resetTrojectories();
                } else if (idx == jdx) {
                    this.getGridDisplay().setTrajStartLevel(idx);
                    this.getGridDisplay().setStartPoints(null, null);
                    this.getGridDisplay().setZskip(ct - 1);
                    this.getGridDisplay().resetTrojectories();
                } else {
                    GriddedSet domainSet = (GriddedSet)this.getGridDataInstance().getSpatialDomain();
                    CoordinateSystem cs = this.getNavigatedDisplay().getDisplayCoordinateSystem();
                    float[][] domainLatLonAlt = GridUtil.getEarthLocationPoints(domainSet);
                    MapProjectionDisplay mpd = (MapProjectionDisplay)this.getNavigatedDisplay();
                    boolean isLatLon = GridUtil.isLatLonOrder(domainSet);
                    int latIndex = isLatLon ? 1 : 0;
                    int lonIndex = isLatLon ? 0 : 1;
                    int numX = domainSet.getLengths()[lonIndex];
                    int numY = domainSet.getLengths()[latIndex];
                    int numXY = numX * numY;
                    int startZ = idx > jdx ? jdx : idx;
                    int endZ = idx > jdx ? idx : jdx;
                    int numXY0 = numXY;
                    if (this.getSkipValue() > 0) {
                        numXY0 = numXY / (this.getSkipValue() + 1) + 1;
                    }
                    int numP = numXY0 * (endZ - startZ + 1);
                    float[][] geoVals = new float[3][numP];
                    int skipFactor = this.getSkipValue();
                    int jj = 0;
                    for (int k = startZ; k <= endZ; ++k) {
                        int j = 0;
                        while (j < numXY) {
                            int ii = k * numXY * (this.getSkipValueZ() + 1) + j;
                            geoVals[0][jj] = domainLatLonAlt[lonIndex][ii];
                            geoVals[1][jj] = domainLatLonAlt[latIndex][ii];
                            geoVals[2][jj] = domainLatLonAlt[2][ii];
                            ++jj;
                            j = j + 1 + skipFactor;
                        }
                    }
                    float[][] setLocs = cs.toReference(geoVals);
                    setLocs[2] = mpd.scaleVerticalValues(setLocs[2]);
                    RealTupleType types = cs.getReference();
                    this.getGridDisplay().setStartPoints(types, setLocs);
                    this.getGridDisplay().resetTrojectories();
                }
            }
            catch (Exception ex) {
                VolumeVectorControl.logException("setFlowScale: ", ex);
            }
        }
    }

    public void setColoredByAnother(boolean yesno) {
        this.coloredByAnother = yesno;
    }

    public boolean getColoredByAnother() {
        return this.coloredByAnother;
    }

    public void setUseSpeedForColor(boolean yesno) {
        this.useSpeedForColor = yesno;
    }

    public boolean getUseSpeedForColor() {
        return this.useSpeedForColor;
    }

    @Override
    protected int getColorRangeIndex() {
        if (this.colorIndex >= 0) {
            return this.colorIndex;
        }
        return this.getIsThreeComponents() ? 3 : 2;
    }

    @Override
    public Range getRangeForColorTable() throws RemoteException, VisADException {
        if (this.getFlowColorRange() == null) {
            this.setFlowColorRange();
        }
        return this.getFlowColorRange();
    }

    private Range makeFlowRange(Range r) {
        if (this.haveMultipleFields()) {
            return r;
        }
        if (r == null) {
            return r;
        }
        double max = Math.max(Math.abs(r.getMax()), Math.abs(r.getMin()));
        return new Range(-max, max);
    }

    @Override
    protected boolean haveMultipleFields() {
        if (this.getGridDataInstance() == null) {
            return false;
        }
        return this.getGridDataInstance().getNumRealTypes() > (this.getIsThreeComponents() ? 3 : 2) || this.useSpeedForColor || this.coloredByAnother;
    }

    @Override
    public boolean showColorControlWidget() {
        return !this.useSpeedForColor && !this.coloredByAnother;
    }

    @Override
    public String getColorWidgetLabel() {
        return "Color";
    }

    @Override
    protected String getColorParamName() {
        if (this.useSpeedForColor) {
            return "windSpeed";
        }
        if (this.coloredByAnother) {
            return this.getGridDataInstance().getRealTypeName(this.colorIndex);
        }
        return super.getColorParamName();
    }

    @Override
    protected Range getInitialRange() throws RemoteException, VisADException {
        if (this.useSpeedForColor) {
            return this.flowRange;
        }
        if (this.coloredByAnother) {
            return this.getGridDataInstance().getRanges()[this.colorIndex];
        }
        return super.getInitialRange();
    }

    public void setSkipValueZ(int value) {
        this.skipValueZ = value;
        if (this.skipFactorWidgetZ != null) {
            this.skipFactorWidgetZ.setValue(value);
        }
        if (this.getControlContext() != null) {
            this.applySkipFactor();
            this.setLevels(null);
        }
        this.doShare((Object)"DisplayControlImpl.SHARE_SKIPVALUEZ", new Integer(this.skipValueZ));
        FlowDisplayable fd = this.getGridDisplay();
        if (fd != null) {
            int ct;
            String tt;
            if (this.isStreamLine) {
                tt = this.slevelBox.getSelectedItem().toString();
                ct = this.slevelBox.getItemCount();
            } else {
                tt = this.levelBox.getSelectedItem().toString();
                ct = this.levelBox.getItemCount();
            }
            if (tt.equals("All Levels")) {
                this.getGridDisplay().setZskip(1);
            } else {
                this.getGridDisplay().setZskip(ct - 1);
            }
            if (this.isTrajectories) {
                this.getGridDisplay().resetTrojectories();
            }
        }
    }

    public int getSkipValueZ() {
        return (int)(this.skipFactorWidgetZ == null ? (float)this.skipValueZ : this.skipFactorWidgetZ.getValue());
    }

    @Override
    public void setLineWidth(int width) throws RemoteException, VisADException {
        if ((this.isTrajectories || this.isStreamLine) && this.getGridDisplay() != null) {
            if (this.trajFormType == 4) {
                this.setPointSize((float)width * 1.0f);
            } else if (this.trajFormType == 2) {
                this.getGridDisplay().setTrajWidth((float)width * 0.01f);
            } else if (this.trajFormType == 1 || this.trajFormType == 3) {
                this.getGridDisplay().setRibbonWidth(width);
            }
            if (!this.fromBundle) {
                this.getGridDisplay().resetTrojectories();
            }
        }
        super.setLineWidth(width);
    }

    @Override
    public int getLineWidth() {
        return super.getLineWidth();
    }

    public boolean getIsTrajectories() {
        return this.isTrajectories;
    }

    public void setIsTrajectories(boolean isTrajectories) {
        this.isTrajectories = isTrajectories;
    }

    public boolean getIsStreamline() {
        return this.isStreamLine;
    }

    public void setIsStreamline(boolean isStreamLine) {
        this.isStreamLine = isStreamLine;
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties) {
        this.fromBundle = true;
        super.initAfterUnPersistence(vc, properties);
        if (this.isTrajectories) {
            if (this.trajectoryBtn == null) {
                this.doMakeWidgetComponent();
            }
            this.trajectoryBtn.doClick();
            int width = super.getLineWidth();
            if (this.isTrajectories && this.getGridDisplay() != null) {
                this.getGridDisplay().setTrajFormType(this.trajFormType);
                if (this.trajFormType == 2) {
                    this.getGridDisplay().setTrajWidth((float)width * 0.01f);
                } else if (this.trajFormType == 1 || this.trajFormType == 3) {
                    this.getGridDisplay().setRibbonWidth(width);
                }
                if (this.arrowHead) {
                    this.getGridDisplay().setArrowHead(true);
                    this.arrowCbx.setSelected(this.arrowHead);
                }
                this.levelBoxEnd.setSelectedIndex(this.getTrajEndLevel());
            }
        } else if (this.isStreamLine) {
            if (this.streamlineBtn == null) {
                this.doMakeWidgetComponent();
            }
            this.streamlineBtn.doClick();
            int width = super.getLineWidth();
            if (this.isStreamLine && this.getGridDisplay() != null) {
                this.getGridDisplay().setTrajFormType(this.streamLFormType);
                if (this.streamLFormType == 2) {
                    this.getGridDisplay().setTrajWidth((float)width * 0.01f);
                } else if (this.streamLFormType == 1 || this.streamLFormType == 3) {
                    this.getGridDisplay().setRibbonWidth(width);
                }
                if (this.arrowHeadL) {
                    this.getGridDisplay().setArrowHead(true);
                    this.arrowCbxL.setSelected(this.arrowHeadL);
                }
                if (this.currentLevel != null && ((TwoFacedObject)this.currentLevel).getLabel().equals("All Levels")) {
                    this.slevelBox.setSelectedItem(this.currentLevel);
                } else if (this.currentLevel == null) {
                    int len = this.slevelBoxEnd.getItemCount();
                    this.slevelBox.setSelectedIndex(len - 1);
                } else {
                    this.slevelBox.setSelectedIndex(this.getStreamLStartLevel());
                }
                this.slevelBoxEnd.setSelectedIndex(this.getStreamLEndLevel());
            }
        } else {
            if (this.vectorBtn == null) {
                this.doMakeWidgetComponent();
            }
            this.vectorBtn.doClick();
            this.setFlowScale(this.flowScaleValue);
            this.setArrowHeadSize(this.arrowHeadSizeValue);
        }
        if (this.skipFactorWidgetZ != null) {
            this.skipFactorWidgetZ.setValue(this.getSkipValueZ());
        }
        this.fromBundle = false;
    }
}

