/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Container;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.VolumeDisplayable;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.Display;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Linear3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.data.CachedFlatField;

public class VolumeRenderControl
extends GridDisplayControl {
    VolumeDisplayable myDisplay;
    boolean useTexture3D = false;
    private boolean usePoints = false;
    int xyResample = 192;
    int zResample = 96;
    private float alpha = 1.0f;
    private JSlider qualitySlider = null;
    private int volumeQuality = 75;

    public VolumeRenderControl() {
        this.setAttributeFlags(312);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!this.isDisplay3D()) {
            LogUtil.userMessage(log_, "Can't render volume in 2D display");
            return false;
        }
        this.myDisplay = new VolumeDisplayable("volrend_" + dataChoice);
        this.myDisplay.setUseRGBTypeForSelect(true);
        this.myDisplay.addConstantMap(new ConstantMap(this.useTexture3D ? 1.0 : 0.0, Display.Texture3DMode));
        this.myDisplay.setPointSize(this.getPointSize());
        this.addDisplayable((Displayable)this.myDisplay, this.getAttributeFlags());
        return this.setData(dataChoice);
    }

    private static FieldImpl makeLinearGrid(FieldImpl grid, GriddedSet xyzSet, MapProjectionDisplay mpd, int xyResample, int zResample, int[][] indices, float[][] weights) throws VisADException, RemoteException {
        Trace.call1("VRC.setSpatialDomain");
        FieldImpl newGrid = GridUtil.setSpatialDomain(grid, xyzSet);
        Trace.call2("VRC.setSpatialDomain");
        float[] lows = xyzSet.getLow();
        float[] highs = xyzSet.getHi();
        Linear3DSet volumeXYZ = new Linear3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, lows[0], highs[0], xyResample, lows[1], highs[1], xyResample, lows[2], highs[2], zResample);
        Trace.call1("VRC.resampleGrid");
        newGrid = VolumeRenderControl.resampleGrid((FlatField)newGrid, volumeXYZ, indices, weights);
        Trace.call2("VRC.resampleGrid");
        Trace.call2("VRC.makeLinearGrid");
        return newGrid;
    }

    private static FlatField resampleGrid(FlatField grid, Linear3DSet volumeXYZ, int[][] indices, float[][] weights) throws VisADException, RemoteException {
        int numLocs = volumeXYZ.getLength();
        CachedFlatField newFF = new CachedFlatField((FunctionType)grid.getType(), volumeXYZ);
        float[][] values = grid.getFloats(false);
        float[][] newValues = new float[1][numLocs];
        float newVal = 0.0f;
        for (int k = 0; k < numLocs; ++k) {
            newVal = 0.0f;
            if (indices[k] == null || weights[k] == null) continue;
            for (int i = 0; i < indices[k].length; ++i) {
                if (indices[k][i] >= values[0].length) continue;
                newVal += weights[k][i] * values[0][indices[k][i]];
            }
            newValues[0][k] = newVal;
        }
        newFF.setSamples(newValues, false);
        return newFF;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        if (!this.usePoints) {
            JCheckBox textureToggle = GuiUtils.makeCheckbox("", this, "useTexture3D");
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Resolution:"), this.doMakeQualitySlider()));
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Use 3D Texture:"), GuiUtils.leftCenter(textureToggle, GuiUtils.filler())));
        } else {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Point Size:"), GuiUtils.left(this.doMakePointSizeWidget())));
        }
    }

    protected void applyQuality() throws VisADException, RemoteException {
        if (this.myDisplay != null) {
            int xyResample0 = (int)(2.56 * (double)this.getVolumeQuality());
            int zResample0 = (int)(1.28 * (double)this.getVolumeQuality());
            if (xyResample0 != this.xyResample) {
                this.xyResample = xyResample0;
                this.zResample = zResample0;
                this.loadVolumeData();
            }
        }
        this.getIdv().getIdvUIManager().clearWaitCursor();
    }

    public int getVolumeQuality() {
        return this.volumeQuality;
    }

    public void setVolumeQuality(int quality) {
        this.volumeQuality = quality;
    }

    @Override
    public void setPointSize(float value) {
        super.setPointSize(value);
        if (this.myDisplay != null) {
            try {
                this.myDisplay.setPointSize(this.getPointSize());
            }
            catch (Exception e) {
                VolumeRenderControl.logException("Setting point size", e);
            }
        }
    }

    protected JSlider doMakeQualitySlider() {
        if (this.qualitySlider == null) {
            this.qualitySlider = GuiUtils.makeSlider(50, 100, this.volumeQuality, this, "setQuality");
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            labels.put(new Integer(100), GuiUtils.lLabel("High"));
            labels.put(new Integer(75), GuiUtils.cLabel("Medium"));
            labels.put(new Integer(50), GuiUtils.rLabel("Low"));
            this.qualitySlider.setLabelTable(labels);
            this.qualitySlider.setPaintLabels(true);
        }
        return this.qualitySlider;
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (!super.setData(choice) || this.getNavigatedDisplay() == null) {
            return false;
        }
        this.loadVolumeData();
        return true;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        if (this.usePoints) {
            this.setAttributeFlags(2048);
        }
        return GuiUtils.left(this.doMakeWidgetComponent());
    }

    public void setQuality(int quality) {
        this.volumeQuality = quality;
        if (this.getHaveInitialized()) {
            try {
                this.showWaitCursor();
                this.applyQuality();
            }
            catch (Exception exc) {
                VolumeRenderControl.logException("loading volume data", exc);
            }
            finally {
                this.showNormalCursor();
            }
        }
    }

    @Override
    protected void applySkipFactor() {
        this.showNormalCursor();
    }

    private void loadVolumeData() throws VisADException, RemoteException {
        FieldImpl grid;
        Trace.call1("VRC.loadVolumeData");
        FieldImpl newGrid = grid = this.getGridDataInstance().getGrid();
        if (this.getSkipValue() > 0) {
            newGrid = grid = GridUtil.subset(grid, this.getSkipValue() + 1);
        }
        if (!this.usePoints) {
            this.setProjectionInView(true, true);
            CoordinateSystem cs = this.getNavigatedDisplay().getDisplayCoordinateSystem();
            if (cs != null && this.getNavigatedDisplay() instanceof MapProjectionDisplay) {
                MapProjectionDisplay mpd = (MapProjectionDisplay)this.getNavigatedDisplay();
                try {
                    Object object;
                    GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(grid);
                    SampledSet ss = null;
                    boolean latLonOrder = GridUtil.isLatLonOrder(domainSet);
                    Trace.call1("VRC.convertDomain");
                    ss = latLonOrder ? Util.convertDomain(domainSet, RealTupleType.LatitudeLongitudeAltitude, null) : Util.convertDomain(domainSet, RealTupleType.SpatialEarth3DTuple, null);
                    Trace.call2("VRC.convertDomain");
                    float[][] refVals = ss.getSamples(true);
                    if (latLonOrder) {
                        object = refVals;
                    } else {
                        float[][] fArrayArray = new float[3][];
                        fArrayArray[0] = refVals[1];
                        fArrayArray[1] = refVals[0];
                        object = fArrayArray;
                        fArrayArray[2] = refVals[2];
                    }
                    float[][] newVals = object;
                    Trace.call1("VRC.toRef");
                    newVals = cs.toReference(newVals);
                    Trace.call2("VRC.toRef");
                    Trace.call1("VRC.scaleVerticalValues");
                    newVals[2] = mpd.scaleVerticalValues(newVals[2]);
                    Trace.call2("VRC.scaleVerticalValues");
                    GriddedSet xyzSet = GriddedSet.create(RealTupleType.SpatialCartesian3DTuple, newVals, domainSet.getLengths(), null, null, null, false, true);
                    float[] lows = xyzSet.getLow();
                    float[] highs = xyzSet.getHi();
                    Linear3DSet volumeXYZ = new Linear3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, lows[0], highs[0], this.xyResample, lows[1], highs[1], this.xyResample, lows[2], highs[2], this.zResample);
                    int numLocs = volumeXYZ.getLength();
                    if (GridUtil.isConstantSpatialDomain(grid) && GridUtil.getTimeSet(grid) == null) {
                        System.out.println("ConstantSpatialDomain");
                        int[][] indices = new int[numLocs][];
                        float[][] weights = new float[numLocs][];
                        float[][] xyzLocs = volumeXYZ.getSamples(false);
                        Gridded3DSet domainSet0 = (Gridded3DSet)grid.getDomainSet();
                        domainSet0.valueToInterp(xyzLocs, indices, weights);
                        newGrid = VolumeRenderControl.makeLinearGrid(grid, xyzSet, mpd, this.xyResample, this.zResample, indices, weights);
                    } else {
                        Set timeSet = GridUtil.getTimeSet(grid);
                        ExecutorService executor = Executors.newFixedThreadPool(8);
                        ArrayList<FieldImpl> result = new ArrayList<FieldImpl>();
                        ArrayList<Future<FieldImpl>> pthreads = new ArrayList<Future<FieldImpl>>();
                        FieldImpl fgrid = GridUtil.setSpatialDomain((FieldImpl)grid.getSample(0), xyzSet);
                        Gridded3DSet domainSet0 = (Gridded3DSet)fgrid.getDomainSet();
                        int[][] indices = new int[numLocs][];
                        float[][] weights = new float[numLocs][];
                        float[][] xyzLocs = volumeXYZ.getSamples(false);
                        domainSet0.valueToInterp(xyzLocs, indices, weights);
                        Trace.call1("VRC.makeLinearGrid");
                        for (int i = 0; i < timeSet.getLength(); ++i) {
                            makeLinearGridThredds makeLinearGridThredds2 = new makeLinearGridThredds((FieldImpl)grid.getSample(i), xyzSet, mpd, this.xyResample, this.zResample, indices, weights);
                            Future<FieldImpl> future = executor.submit(makeLinearGridThredds2);
                            pthreads.add(future);
                        }
                        for (Future future : pthreads) {
                            try {
                                result.add((FieldImpl)future.get());
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (ExecutionException e) {
                                e.printStackTrace();
                            }
                        }
                        for (int i = 0; i < timeSet.getLength(); ++i) {
                            FieldImpl fieldImpl = (FieldImpl)result.get(i);
                            if (i == 0) {
                                FunctionType ft = new FunctionType(((SetType)timeSet.getType()).getDomain(), fieldImpl.getType());
                                newGrid = new FieldImpl(ft, timeSet);
                            }
                            newGrid.setSample(i, (Data)fieldImpl, false);
                        }
                    }
                }
                catch (VisADException ve) {
                    ve.printStackTrace();
                    this.userErrorMessage("Can't render volume for " + this.paramName + " in this projection. Try using the data projection");
                    newGrid = grid;
                }
            }
        }
        Trace.call1("VRC.loadVolumeData.loadData");
        this.myDisplay.loadData(newGrid);
        Trace.call2("VRC.loadVolumeData.loadData");
        Trace.call2("loadVolumeData");
    }

    @Override
    public void projectionChanged() {
        try {
            this.loadVolumeData();
        }
        catch (Exception exc) {
            VolumeRenderControl.logException("loading volume data", exc);
        }
        super.projectionChanged();
    }

    public void setUseTexture3D(boolean use) {
        this.useTexture3D = use;
        if (this.myDisplay != null) {
            try {
                this.myDisplay.addConstantMap(new ConstantMap(this.useTexture3D ? 1.0 : 0.0, Display.Texture3DMode));
            }
            catch (Exception e) {
                VolumeRenderControl.logException("setUseTexture3D", e);
            }
        }
    }

    public boolean getUseTexture3D() {
        return this.useTexture3D;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    public void setUsePoints(boolean value) {
        this.usePoints = value;
    }

    public boolean getUsePoints() {
        return this.usePoints;
    }

    static class makeLinearGridThredds
    implements Callable<FieldImpl> {
        FieldImpl grid;
        GriddedSet xyzSet;
        MapProjectionDisplay mpd;
        int xyResample;
        int zResample;
        int[][] indices;
        float[][] weights;

        private makeLinearGridThredds(FieldImpl grid, GriddedSet xyzSet, MapProjectionDisplay mpd, int xyResample, int zResample, int[][] indices, float[][] weights) {
            this.grid = grid;
            this.xyzSet = xyzSet;
            this.mpd = mpd;
            this.xyResample = xyResample;
            this.zResample = zResample;
            this.indices = indices;
            this.weights = weights;
        }

        @Override
        public FieldImpl call() {
            FieldImpl ff = null;
            try {
                ff = VolumeRenderControl.makeLinearGrid(this.grid, this.xyzSet, this.mpd, this.xyResample, this.zResample, this.indices, this.weights);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ff;
        }
    }
}

