/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.vecmath.Point3d;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.LineProbeControl;
import ucar.unidata.idv.control.VerticalProfileInfo;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.idv.control.chart.VerticalProfileChart;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Range;
import ucar.visad.GeoUtils;
import ucar.visad.display.Animation;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;

public class VerticalProfileControl
extends LineProbeControl {
    public static final int COL_NAME = 0;
    public static final int COL_SAMPLING = 1;
    public static final int NUM_COLS = 2;
    private List infos = new ArrayList();
    public static final String SHARE_PROFILE = "VerticalProfileControl.SHARE_PROFILE";
    private String[] samplingLabels = new String[]{"Weighted Average", "Nearest Neighbor"};
    private VerticalProfileChart chart;
    private JTable paramsTable;
    private JComponent tablePanel;
    private AbstractTableModel tableModel;
    private LatLonWidget latLonWidget;
    private JComponent aniWidget;
    private boolean showTable = false;
    private Unit altUnit = null;
    private String altCoord = "height";

    public VerticalProfileControl() {
        this.setAttributeFlags(52);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        return this.init(Misc.newList(dataChoice));
    }

    @Override
    public boolean init(List choices) throws VisADException, RemoteException {
        ActionListener llListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VerticalProfileControl.this.handleLatLonWidgetChange();
            }
        };
        this.latLonWidget = new LatLonWidget("Lat: ", "Lon: ", llListener);
        this.aniWidget = this.getAnimationWidget().getContents(false);
        this.setContents(this.doMakeContents());
        this.doMakeProbe();
        return true;
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            this.setTimesForAnimation();
            boolean isBundle = this.getIdv().getStateManager().isLoadingXml();
            if (!isBundle && this.getDataChoices().get(0).toString().startsWith("Conserved Sounding")) {
                ((DataChoice)this.getDataChoices().get(0)).setName("theta");
                ((DataChoice)this.getDataChoices().get(0)).setId("theta");
                this.doMoveProbe();
                List cdcs = ((DerivedDataChoice)this.getDataChoices().get(0)).getChoices();
                DataChoice dc1 = (DataChoice)cdcs.get(1);
                this.addNewData(Misc.newList(dc1));
                DataChoice dc2 = (DataChoice)cdcs.get(2);
                this.addNewData(Misc.newList(dc2));
            } else {
                this.doMoveProbe();
            }
        }
        catch (Exception exc) {
            VerticalProfileControl.logException("initDone", exc);
        }
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        return GuiUtils.vbox(parentComp, this.getChart().getThumb());
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            this.getChart().timeChanged(time);
        }
        catch (Exception exc) {
            VerticalProfileControl.logException("changePosition", exc);
        }
        super.timeChanged(time);
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        if (this.chart != null) {
            this.chart.setControl(this);
        }
        this.tableModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public int getRowCount() {
                List dataChoices = VerticalProfileControl.this.getDataChoices();
                if (dataChoices == null) {
                    return 0;
                }
                return dataChoices.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    VerticalProfileControl.this.getVPInfo(rowIndex).setSamplingMode(VerticalProfileControl.this.getSamplingModeValue(aValue.toString()));
                    VerticalProfileControl.this.doMoveProbe();
                    return;
                }
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    return VerticalProfileControl.this.getFieldName(row);
                }
                if (column == 1) {
                    return VerticalProfileControl.this.getSamplingModeName(VerticalProfileControl.this.getVPInfo(row).getSamplingMode());
                }
                return "";
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Parameter";
                    }
                    case 1: {
                        return "Sampling";
                    }
                }
                return "";
            }
        };
        this.paramsTable = new JTable(this.tableModel);
        this.paramsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                int row = VerticalProfileControl.this.paramsTable.rowAtPoint(e.getPoint());
                if (row < 0 || row >= VerticalProfileControl.this.getDataChoices().size()) {
                    return;
                }
                List choices = VerticalProfileControl.this.getDataChoices();
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem jmi = VerticalProfileControl.this.doMakeChangeParameterMenuItem();
                popupMenu.add(jmi);
                popupMenu.addSeparator();
                List items = VerticalProfileControl.this.getParameterMenuItems(row);
                GuiUtils.makePopupMenu(popupMenu, items);
                JMenu dataChoiceMenu = VerticalProfileControl.this.getControlContext().doMakeDataChoiceMenu(VerticalProfileControl.this.getDataChoiceAtRow(row));
                popupMenu.add(dataChoiceMenu);
                popupMenu.show(VerticalProfileControl.this.paramsTable, e.getX(), e.getY());
            }
        });
        this.paramsTable.setToolTipText("Right click to edit");
        JScrollPane scrollPane = new JScrollPane(this.paramsTable);
        this.paramsTable.getColumnModel().getColumn(1).setCellEditor(new SamplingEditor());
        JTableHeader header = this.paramsTable.getTableHeader();
        this.tablePanel = new JPanel();
        this.tablePanel.setVisible(this.showTable);
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(scrollPane);
        scrollPane.setPreferredSize(new Dimension(200, 100));
        JPanel bottomPanel = GuiUtils.leftRight(this.aniWidget, this.latLonWidget);
        bottomPanel = GuiUtils.inset((Component)bottomPanel, 5);
        JPanel bottom = GuiUtils.centerBottom(this.tablePanel, bottomPanel);
        return GuiUtils.centerBottom(this.getChart().getContents(), bottom);
    }

    protected void processNewData(List newChoices) throws VisADException, RemoteException {
        ArrayList<VerticalProfileInfo> newInfos = new ArrayList<VerticalProfileInfo>();
        this.showWaitCursor();
        for (int i = 0; i < newChoices.size(); ++i) {
            VerticalProfileInfo info = new VerticalProfileInfo(this);
            newInfos.add(info);
            DataChoice dc = (DataChoice)newChoices.get(i);
            info.setDataInstance(new GridDataInstance(dc, this.getDataSelection(), this.getRequestProperties()));
            this.initializeVerticalProfileInfo(info);
        }
        this.showNormalCursor();
        this.appendDataChoices(newChoices);
        this.infos.addAll(newInfos);
        this.resetData();
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        this.updateLegendLabel();
        this.setTimesForAnimation();
        this.doMoveProbe();
        this.fireStructureChanged();
    }

    @Override
    protected void doMoveProbe() {
        super.doMoveProbe();
    }

    @Override
    protected void addNewData(List newChoices) throws VisADException, RemoteException {
        this.processNewData(newChoices);
        this.doShare((Object)"DisplayControlImpl.SHARE_CHOICES", newChoices);
    }

    private void handleLatLonWidgetChange() {
        try {
            double lat = this.latLonWidget.getLat();
            double lon = this.latLonWidget.getLon();
            double[] xyz = this.earthToBox(VerticalProfileControl.makeEarthLocation(lat, lon, 0.0));
            this.setProbePosition(xyz[0], xyz[1]);
        }
        catch (Exception exc) {
            VerticalProfileControl.logException("Error setting lat/lon", exc);
        }
    }

    public DataChoice getDataChoiceAtRow(int row) {
        List choices = this.getDataChoices();
        if (row >= choices.size()) {
            return null;
        }
        return (DataChoice)choices.get(row);
    }

    private VerticalProfileInfo getVPInfo(int row) {
        VerticalProfileInfo info;
        while (row >= this.infos.size()) {
            info = new VerticalProfileInfo(this);
            this.infos.add(info);
        }
        info = (VerticalProfileInfo)this.infos.get(row);
        if (info.getDataInstance() == null) {
            List choices = this.getDataChoices();
            try {
                DataChoice dc = (DataChoice)choices.get(row);
                this.showWaitCursor();
                info.setDataInstance(new GridDataInstance(dc, this.getDataSelection(), this.getRequestProperties()));
                this.showNormalCursor();
                this.initializeVerticalProfileInfo(info);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return info;
    }

    private void initializeVerticalProfileInfo(VerticalProfileInfo info) throws VisADException, RemoteException {
        Unit vpUnit = info.getUnit();
        String name = info.getDataInstance().getParamName();
        if (vpUnit == null) {
            vpUnit = this.getDisplayConventions().selectDisplayUnit(name, info.getDataInstance().getRawUnit(0));
        }
        info.setUnit(vpUnit);
        if (this.altUnit == null && this.altCoord.equals("pressure")) {
            info.setAltitudeUnit(CommonUnits.HECTOPASCAL);
            this.altUnit = CommonUnits.HECTOPASCAL;
        } else if (this.altUnit == null) {
            info.setAltitudeUnit(CommonUnit.meter);
        }
        Range vpRange = info.getLineState().getRange();
        LineState lstate = info.getLineState();
        if (vpRange == null) {
            vpRange = this.getDisplayConventions().getParamRange(name, vpUnit);
            if (vpRange == null) {
                vpRange = info.getDataInstance().getRange(0);
                Unit u = info.getDataInstance().getRawUnit(0);
                if (!Misc.equals(u, vpUnit) && Unit.canConvert(u, vpUnit)) {
                    vpRange = new Range(vpUnit.toThis(vpRange.getMin(), u), vpUnit.toThis(vpRange.getMax(), u));
                }
            }
            info.getLineState().setRange(vpRange);
        } else if (vpRange != null && lstate.getUnit() != null && !lstate.getUnit().equals(vpUnit)) {
            Unit u = lstate.getUnit();
            vpRange = new Range(vpUnit.toThis(vpRange.getMin(), u), vpUnit.toThis(vpRange.getMax(), u));
            info.getLineState().setRange(vpRange);
        }
    }

    String getFieldName(int row) {
        return this.getVPInfo(row).getDataInstance().getDataChoice().getName();
    }

    @Override
    protected String getChangeParameterLabel() {
        return "Add Parameter...";
    }

    private List getParameterMenuItems(final int row) {
        ArrayList<JMenu> items = new ArrayList<JMenu>();
        JMenu paramMenu = new JMenu("Parameter " + this.getFieldName(row));
        items.add(paramMenu);
        VerticalProfileInfo rowInfo = this.getVPInfo(row);
        paramMenu.add(GuiUtils.makeMenuItem("Chart Properties", this, "showLineProperties", rowInfo));
        JMenuItem jmi = new JMenuItem("Change Unit...");
        paramMenu.add(jmi);
        jmi.addActionListener(new ObjectListener(new Integer(row)){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Unit newUnit = VerticalProfileControl.this.getDisplayConventions().selectUnit(VerticalProfileControl.this.getVPInfo(row).getUnit(), null);
                if (newUnit != null) {
                    VerticalProfileInfo vpi = VerticalProfileControl.this.getVPInfo(row);
                    vpi.setUnit(newUnit);
                    try {
                        VerticalProfileControl.this.initializeVerticalProfileInfo(vpi);
                        VerticalProfileControl.this.doMoveProbe();
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("After changing units", exc);
                    }
                }
            }
        });
        jmi = new JMenuItem("Remove");
        paramMenu.add(jmi);
        jmi.addActionListener(new ObjectListener(new Integer(row)){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VerticalProfileControl.this.removeField((Integer)this.theObject);
            }
        });
        return items;
    }

    private FieldImpl makeProfile(FieldImpl fi) throws VisADException, RemoteException {
        boolean isSequence = GridUtil.isTimeSequence(fi);
        TupleType parm = GridUtil.getParamType(fi);
        SampledSet domain = GridUtil.getSpatialDomain(fi);
        RealType height = (RealType)((SetType)domain.getType()).getDomain().getComponent(2);
        RealTupleType domainType = new RealTupleType(RealType.Altitude);
        FunctionType pType = new FunctionType(domainType, parm);
        FunctionType profileType = null;
        FieldImpl profile = null;
        Gridded1DSet profileDomain = null;
        int numIters = 1;
        if (isSequence) {
            SampledSet timeDomain = (SampledSet)fi.getDomainSet();
            numIters = timeDomain.getLength();
            RealTupleType tMT = ((SetType)timeDomain.getType()).getDomain();
            profileType = new FunctionType(tMT, pType);
            profile = new FieldImpl(profileType, timeDomain);
        } else {
            profileType = pType;
        }
        for (int i = 0; i < numIters; ++i) {
            SampledSet ss = GridUtil.getSpatialDomain(fi, i);
            if (profileDomain == null || !GridUtil.isConstantSpatialDomain(fi)) {
                Unit vUnit = ss.getSetUnits()[2];
                float[][] domainVals = ss.getSamples();
                if (!height.equals(RealType.Altitude)) {
                    CoordinateSystem cs = ss.getCoordinateSystem();
                    domainVals = ss.getCoordinateSystem().toReference(domainVals, ss.getSetUnits());
                    vUnit = cs.getReferenceUnits()[2];
                }
                float[] alts = domainVals[2];
                if (this.altUnit != null && this.altUnit.isConvertible(CommonUnits.HECTOPASCAL)) {
                    CoordinateSystem pressToHeightCS = DataUtil.getPressureToHeightCS("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem");
                    float[][] hvals = pressToHeightCS.fromReference(new float[][]{alts});
                    alts = hvals[0];
                } else if (!vUnit.equals(CommonUnit.meter)) {
                    alts = CommonUnit.meter.toThis(alts, vUnit);
                }
                try {
                    profileDomain = new Gridded1DSet((MathType)domainType, (float[][])new float[][]{alts}, domainVals[0].length, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, false);
                }
                catch (Exception e) {
                    break;
                }
            }
            FlatField ff = new FlatField(pType, profileDomain);
            if (isSequence) {
                ff.setSamples(((FlatField)fi.getSample(i)).getFloats(false));
                profile.setSample(i, (Data)ff);
                continue;
            }
            ff.setSamples(((FlatField)fi).getFloats(false));
            profile = ff;
        }
        return profile;
    }

    @Override
    protected void probePositionChanged(RealTuple position) {
        try {
            this.loadProfile(position);
        }
        catch (Exception exc) {
            VerticalProfileControl.logException("probePositionChanged", exc);
        }
    }

    protected void reSetProfileAltitudeUnit(Unit aUnit) {
        ArrayList localInfos = new ArrayList(this.infos);
        ArrayList<VerticalProfileInfo> chartInfos = new ArrayList<VerticalProfileInfo>();
        LatLonPoint llp = null;
        for (int i = 0; i < localInfos.size(); ++i) {
            VerticalProfileInfo info = (VerticalProfileInfo)localInfos.get(i);
            if (info == null || info.getDataInstance() == null) continue;
            try {
                llp = info.getLastPoint();
                info.setAltitudeUnit(aUnit);
                FieldImpl newFI = GridUtil.getProfileAtLatLonPoint(info.getDataInstance().getGrid(), llp, info.getSamplingMode());
                if (newFI == null) continue;
                info.setProfile(this.makeProfile(newFI), llp);
                chartInfos.add(info);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.getChart().setProfiles(chartInfos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateLegendLabel();
    }

    public void loadProfile(RealTuple position) throws VisADException, RemoteException {
        Real[] reals;
        double[] values;
        if (!this.getHaveInitialized()) {
            return;
        }
        if (this.infos == null || position == null) {
            return;
        }
        LatLonPoint llp = null;
        RealTupleType rttype = (RealTupleType)position.getType();
        if (rttype.equals(RealTupleType.SpatialCartesian2DTuple)) {
            values = position.getValues();
            EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{values[0], values[1], 1.0});
            llp = elt.getLatLonPoint();
        } else if (rttype.equals(RealTupleType.SpatialCartesian3DTuple)) {
            values = position.getValues();
            double length = new Point3d(0.0, 0.0, 0.0).distance(new Point3d(values[0], values[1], values[2]));
            if (length != 0.0) {
                values[0] = values[0] * (1.0 / length);
                values[1] = values[1] * (1.0 / length);
                values[2] = values[2] * (1.0 / length);
            }
            EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{values[0], values[1], values[2]});
            llp = elt.getLatLonPoint();
        } else if (rttype.equals(RealTupleType.SpatialEarth2DTuple)) {
            reals = position.getRealComponents();
            llp = new LatLonTuple(reals[1], reals[0]);
        } else if (rttype.equals(RealTupleType.LatitudeLongitudeTuple)) {
            reals = position.getRealComponents();
            llp = new LatLonTuple(reals[0], reals[1]);
        } else {
            throw new VisADException("Can't convert position to navigable point");
        }
        ArrayList localInfos = new ArrayList(this.infos);
        ArrayList<VerticalProfileInfo> chartInfos = new ArrayList<VerticalProfileInfo>();
        for (int i = 0; i < localInfos.size(); ++i) {
            FieldImpl newFI;
            VerticalProfileInfo info = (VerticalProfileInfo)localInfos.get(i);
            if (info == null || info.getDataInstance() == null || (newFI = GridUtil.getProfileAtLatLonPoint(info.getDataInstance().getGrid(), llp, info.getSamplingMode())) == null) continue;
            info.setProfile(this.makeProfile(newFI), llp);
            chartInfos.add(info);
        }
        this.getChart().setProfiles(chartInfos);
        if (llp != null) {
            this.positionText = this.getDisplayConventions().formatLatLonPoint(llp);
            if (this.latLonWidget != null) {
                this.latLonWidget.setLat(this.getDisplayConventions().formatLatLon(llp.getLatitude().getValue()));
                this.latLonWidget.setLon(this.getDisplayConventions().formatLatLon(llp.getLongitude().getValue()));
            }
        }
        this.updateLegendLabel();
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeMenuItem("Save Chart Image...", this.getChart(), "saveImage"));
        items.add(GuiUtils.makeMenuItem("Export Current Time as CSV...", this, "exportCsv"));
        items.add(GuiUtils.makeMenuItem("Export All Times as CSV...", this, "exportCsvAllTimes"));
    }

    public void exportCsv() {
        try {
            Animation animation = this.getInternalAnimation();
            int step = animation.getCurrent();
            Set aniSet = animation.getSet();
            DateTime[] times = Animation.getDateTimeArray(aniSet);
            if (times.length == 0) {
                return;
            }
            this.exportToCsv(new Real[]{times[step]});
            this.paramsTable.repaint();
        }
        catch (Exception exc) {
            VerticalProfileControl.logException("Exporting to csv", exc);
        }
    }

    public void exportCsvAllTimes() {
        try {
            Animation animation = this.getInternalAnimation();
            Set aniSet = animation.getSet();
            Real[] times = Animation.getDateTimeArray(aniSet);
            this.exportToCsv(times);
            this.paramsTable.repaint();
        }
        catch (Exception exc) {
            VerticalProfileControl.logException("Exporting to csv", exc);
        }
    }

    public void exportToCsv(Real[] times) {
        try {
            Real aniValue;
            int timeIdx;
            String filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_CSV, FileManager.FILTER_XLS), ".csv");
            if (filename == null) {
                return;
            }
            List choices = this.getDataChoices();
            Real[] levels = this.getGridDataInstance().getLevels();
            if (times.length == 0) {
                LogUtil.userMessage("No times to export");
                return;
            }
            ArrayList<List> rows = new ArrayList<List>();
            List cols = Misc.newList("Time", "Level");
            for (int row = 0; row < choices.size(); ++row) {
                VerticalProfileInfo info = this.getVPInfo(row);
                cols.add(this.getFieldName(row));
            }
            rows.add(cols);
            for (timeIdx = 0; timeIdx < times.length; ++timeIdx) {
                aniValue = times[timeIdx];
                for (int level = 0; level < levels.length; ++level) {
                    Real lev = levels[level];
                    cols = Misc.newList("" + aniValue, "" + lev);
                    rows.add(cols);
                }
            }
            for (timeIdx = 0; timeIdx < times.length; ++timeIdx) {
                aniValue = times[timeIdx];
                for (int row = 0; row < choices.size(); ++row) {
                    VerticalProfileInfo info = this.getVPInfo(row);
                    Data rt = null;
                    FieldImpl sample = info.getProfile();
                    rt = sample != null ? sample.evaluate(aniValue, info.getSamplingMode(), 202) : info.getProfile().getSample(0);
                    float[][] levelData = ((FlatField)rt).getFloats();
                    for (int l = 0; l < levels.length; ++l) {
                        cols = (List)rows.get(timeIdx * levels.length + 1 + l);
                        cols.add(Float.valueOf(levelData[0][l]));
                    }
                }
            }
            DataUtil.writeCsv(filename, rows);
        }
        catch (Exception exc) {
            VerticalProfileControl.logException("Exporting to csv", exc);
        }
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        items.add("separator");
        ArrayList<JMenuItem> paramItems = new ArrayList<JMenuItem>();
        paramItems.add(GuiUtils.makeCheckboxMenuItem("Show Parameter Table", this, "showTable", null));
        paramItems.add(this.doMakeChangeParameterMenuItem());
        List choices = this.getDataChoices();
        for (int i = 0; i < choices.size(); ++i) {
            paramItems.addAll(this.getParameterMenuItems(i));
        }
        items.add(GuiUtils.makeMenu("Parameters", paramItems));
        JMenu chartMenu = new JMenu("Chart");
        chartMenu.add(GuiUtils.makeCheckboxMenuItem("Show Thumbnail in Legend", this.getChart(), "showThumb", null));
        JMenuItem jmj = new JMenuItem("Change Altitude Unit...");
        jmj.addActionListener(new ObjectListener(new Integer(0)){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Unit newUnit = VerticalProfileControl.this.getDisplayConventions().selectUnit(CommonUnit.meter, null);
                VerticalProfileControl.this.altUnit = newUnit;
                if (newUnit != null) {
                    try {
                        VerticalProfileControl.this.reSetProfileAltitudeUnit(VerticalProfileControl.this.altUnit);
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("After changing units", exc);
                    }
                }
            }
        });
        chartMenu.add(jmj);
        ArrayList chartMenuItems = new ArrayList();
        this.getChart().addViewMenuItems(chartMenuItems);
        GuiUtils.makeMenu(chartMenu, chartMenuItems);
        items.add(chartMenu);
        items.add(this.doMakeProbeMenu(new JMenu("Probe")));
    }

    public Unit getAltUnit() {
        return this.altUnit;
    }

    public void setAltUnit(Unit unit) {
        this.altUnit = unit;
    }

    public void setAltCoord(String cname) {
        this.altCoord = cname;
    }

    public String getAltCoord() {
        return this.altCoord;
    }

    public void showLineProperties(VerticalProfileInfo vpInfo) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    VerticalProfileControl.this.doMoveProbe();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Updating position", exc);
                }
            }
        };
        LineState lineState = vpInfo.getLineState();
        lineState.showPropertiesDialog(listener, this.getChart().getPlotNames(), this.getChart().getCurrentRanges());
    }

    private void removeField(int row) {
        VerticalProfileInfo info = this.getVPInfo(row);
        GridDataInstance di = info.getDataInstance();
        if (di != null) {
            this.removeDataChoice(di.getDataChoice());
        }
        this.infos.remove(row);
        try {
            this.setTimesForAnimation();
        }
        catch (Exception e) {
            VerticalProfileControl.logException("Error updating times: ", e);
        }
        this.fireStructureChanged();
        this.doMoveProbe();
    }

    private void setTimesForAnimation() throws VisADException, RemoteException {
        Set myTimes = this.calculateTimeSet();
        if (myTimes == null) {
            return;
        }
        this.getAnimationWidget().setBaseTimes(myTimes);
    }

    private Set calculateTimeSet() {
        List choices = this.getDataChoices();
        if (choices.isEmpty()) {
            return null;
        }
        Set newSet = null;
        for (int i = 0; i < choices.size(); ++i) {
            try {
                VerticalProfileInfo info = this.getVPInfo(i);
                GridDataInstance dataInstance = info.getDataInstance();
                Set set = GridUtil.getTimeSet(dataInstance.getGrid());
                if (set == null) continue;
                if (newSet == null) {
                    newSet = set;
                    continue;
                }
                newSet = newSet.merge1DSets(set);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newSet;
    }

    private void fireStructureChanged() {
        this.tableModel.fireTableStructureChanged();
        this.paramsTable.getColumnModel().getColumn(1).setCellEditor(new SamplingEditor());
    }

    public void setShowThumbNail(boolean value) {
        this.getChart().setShowThumb(value);
    }

    public void setShowTable(boolean value) {
        this.showTable = value;
        if (this.tablePanel != null) {
            this.tablePanel.setVisible(this.showTable);
            this.tablePanel.invalidate();
            this.tablePanel.validate();
        }
    }

    public boolean getShowTable() {
        return this.showTable;
    }

    public void setInfos(List value) {
        this.infos = value;
    }

    public List getInfos() {
        return this.infos;
    }

    public VerticalProfileChart getChart() {
        if (this.chart == null) {
            this.chart = new VerticalProfileChart(this, "Vertical Profile");
        }
        return this.chart;
    }

    public void setVerticalProfileChart(VerticalProfileChart value) {
        this.chart = value;
    }

    public VerticalProfileChart getVerticalProfileChart() {
        return this.chart;
    }

    @Override
    public void relocateDisplay(LatLonRect originalBounds, LatLonRect newBounds, boolean useDataProjection) {
        double latRatio = 0.5;
        double lonRatio = 0.5;
        EarthLocationTuple el = null;
        if (originalBounds == null) {
            GeoSelection gs = this.dataSelection.getGeoSelection();
            GeoLocationInfo ginfo = new GeoLocationInfo(newBounds);
            gs.setBoundingBox(ginfo);
            try {
                this.updateDataSelection(this.dataSelection);
                this.getGridDataInstance().setDataSelection(this.dataSelection);
                this.getGridDataInstance().reInitialize();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int row2 = 0; row2 < this.infos.size(); ++row2) {
                VerticalProfileInfo info = (VerticalProfileInfo)this.infos.get(row2);
                if (info.getDataInstance() == null) continue;
                try {
                    info.setDataInstance(this.getGridDataInstance());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else if (originalBounds != null && !newBounds.containedIn(originalBounds)) {
            for (int row = 0; row < this.infos.size(); ++row) {
                VerticalProfileInfo info = (VerticalProfileInfo)this.infos.get(row);
                if (info.getDataInstance() == null) continue;
                try {
                    info.setDataInstance(this.getGridDataInstance());
                    continue;
                }
                catch (Exception row2) {
                    // empty catch block
                }
            }
        }
        double deltaLat = newBounds.getLatMax() - newBounds.getLatMin();
        double deltaLon = newBounds.getLonMax() - newBounds.getLonMin();
        LatLonPointImpl lowerLeft = newBounds.getLowerLeftPoint();
        double nlat = lowerLeft.getLatitude() + deltaLat * latRatio;
        double nlon = lowerLeft.getLongitude() + deltaLon * lonRatio;
        double nalt = 0.0;
        try {
            if (el != null) {
                nalt = el.getAltitude().getValue();
            }
            if (nlon < 0.0) {
                nlon = GeoUtils.normalizeLongitude360(nlon);
            }
            EarthLocation newel = VerticalProfileControl.makeEarthLocation(nlat, nlon, nalt);
            double[] ets = this.earthToBox(newel);
            this.setPosition(new RealTuple(new Real[]{new Real(RealType.XAxis, ets[0]), new Real(RealType.YAxis, ets[1])}));
            this.setProbePosition(ets[0], ets[1]);
            this.probePositionChanged(this.getPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean canExportData() {
        return false;
    }

    public class SamplingEditor
    extends DefaultCellEditor {
        public SamplingEditor() {
            super(new JComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            JComboBox box = (JComboBox)this.getComponent();
            GuiUtils.setListData(box, VerticalProfileControl.this.samplingLabels);
            box.setSelectedItem(value);
            return box;
        }
    }
}

