/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.gis.SpatialGrid;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.LayoutModelWidget;
import ucar.unidata.idv.control.PlanViewControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.GridValueDisplayable;
import visad.Data;
import visad.DisplayEvent;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.SetType;
import visad.VisADException;

public class ValuePlanViewControl
extends PlanViewControl {
    private GridValueDisplayable pointDisplay = null;
    private float layoutScale = 1.0f;
    private StationModel layoutModel = null;
    private SpatialGrid stationGrid;
    private boolean declutter = true;
    private float declutterFilter = 1.0f;
    protected LayoutModelWidget layoutModelWidget;

    public ValuePlanViewControl() {
        this.setAttributeFlags(2048);
    }

    @Override
    protected DisplayableData createPlanDisplay() throws VisADException, RemoteException {
        this.pointDisplay = new GridValueDisplayable("plan_text_" + this.paramName, this.getControlContext().getJythonManager());
        this.pointDisplay.setStationModel(this.getLayoutModel());
        this.addAttributedDisplayable(this.pointDisplay);
        return this.pointDisplay;
    }

    @Override
    public void initDone() {
        super.initDone();
        this.loadDataInThread();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("prop.resourcechange")) {
            StationModel changedModel = (StationModel)evt.getNewValue();
            this.handleChangedStationModel(changedModel);
        } else if (evt.getPropertyName().equals("prop.resourceremove")) {
            StationModel changedModel = (StationModel)evt.getOldValue();
            if (this.layoutModel.getName().equals(changedModel.getName())) {
                this.handleStationModelChange();
            }
        }
        super.propertyChange(evt);
    }

    protected void handleChangedStationModel(StationModel changedModel) {
        if (this.layoutModel.getName().equals(changedModel.getName())) {
            this.setLayoutModel(changedModel);
        }
    }

    public void setLayoutModelFromWidget(StationModel lm) {
        this.setLayoutModel(lm);
    }

    private void handleStationModelChange() {
        StationModel changedModel = null;
        if (this.layoutModel != null) {
            changedModel = this.getControlContext().getStationModelManager().getStationModel(this.layoutModel.getName());
        }
        if (changedModel != null) {
            if (changedModel != this.layoutModel) {
                this.setLayoutModel(changedModel);
            }
            return;
        }
        this.setLayoutModel(this.getControlContext().getStationModelManager().getDefaultStationModel());
    }

    @Override
    public void handleDisplayChanged(DisplayEvent evt) {
        try {
            int id = evt.getId();
            InputEvent inputEvent = evt.getInputEvent();
            if (id == 12) {
                this.setScaleOnLayout();
            } else {
                super.handleDisplayChanged(evt);
            }
        }
        catch (Exception e) {
            ValuePlanViewControl.logException("Handling display event changed", e);
        }
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        this.loadDataInThread();
    }

    @Override
    public void viewpointChanged() {
        super.viewpointChanged();
        this.loadDataInThread();
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        JCheckBox toggle = new JCheckBox("", this.declutter);
        toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValuePlanViewControl.this.setDeclutter(((JCheckBox)e.getSource()).isSelected());
                ValuePlanViewControl.this.loadDataInThread();
            }
        });
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Declutter:"), toggle));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Layout Model:"), this.makeLayoutModelWidget()));
        super.getControlWidgets(controlWidgets);
    }

    protected void loadDataInThread() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                ValuePlanViewControl.this.showWaitCursor();
                try {
                    if (ValuePlanViewControl.this.getGridDisplayable() != null) {
                        if (ValuePlanViewControl.this.currentSlice == null) {
                            Object newLevel = ValuePlanViewControl.this.currentLevel;
                            ValuePlanViewControl.this.currentLevel = null;
                            ValuePlanViewControl.this.loadDataAtLevel(newLevel);
                        } else {
                            ValuePlanViewControl.this.getGridDisplayable().loadData(ValuePlanViewControl.this.getSliceForDisplay(ValuePlanViewControl.this.currentSlice));
                        }
                    }
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Loading data", exc);
                }
                ValuePlanViewControl.this.showNormalCursor();
            }
        });
    }

    @Override
    protected FieldImpl getSliceForDisplay(FieldImpl slice) throws VisADException {
        FieldImpl subset = super.getSliceForDisplay(slice);
        if (this.getHaveInitialized() && this.pointDisplay != null) {
            try {
                this.pointDisplay.setShouldUseAltitude(GridUtil.is3D(subset));
            }
            catch (Exception excp) {
                ValuePlanViewControl.logException("setting should use altitude", excp);
            }
        }
        FieldImpl stationData = GridUtil.getGridAsPointObs(subset);
        if (this.declutter) {
            try {
                stationData = this.doDeclutter(stationData);
            }
            catch (RemoteException re) {
                ValuePlanViewControl.logException("getSliceForDisplay: doDeclutter", re);
            }
        }
        return stationData;
    }

    public void setLayoutModel(StationModel model) {
        this.layoutModel = model;
        if (this.layoutModelWidget != null) {
            this.layoutModelWidget.setLayoutModel(model);
        }
        if (this.getHaveInitialized() && this.pointDisplay != null) {
            try {
                this.pointDisplay.setStationModel(this.layoutModel);
            }
            catch (Exception excp) {
                ValuePlanViewControl.logException("setting layout", excp);
            }
        }
    }

    public StationModel getLayoutModel() {
        if (this.layoutModel == null) {
            this.layoutModel = this.makeLayoutModel();
        }
        return this.layoutModel;
    }

    public float getLayoutScale() {
        return this.layoutScale;
    }

    public void setLayoutScale(float f) {
        this.layoutScale = f;
        if (this.pointDisplay != null) {
            try {
                this.setScaleOnLayout();
            }
            catch (Exception exc) {
                ValuePlanViewControl.logException("Setting scale ", exc);
            }
        }
    }

    private void setScaleOnLayout() throws RemoteException, VisADException {
        this.setScaleOnLayout(this.getDisplayScale() * this.layoutScale);
    }

    private void setScaleOnLayout(float f) throws RemoteException, VisADException {
        if (this.pointDisplay != null) {
            this.pointDisplay.setScale(f);
        }
    }

    public void setDeclutter(boolean v) {
        this.declutter = v;
    }

    public boolean getDeclutter() {
        return this.declutter;
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    public void setDeclutterFilter(float filter) {
        this.declutterFilter = filter;
    }

    public float getDeclutterFilter() {
        return this.declutterFilter;
    }

    public void editLayoutModel() {
        this.getControlContext().getStationModelManager().show(this.layoutModel);
    }

    protected float getScaleFromDisplayable() {
        if (this.pointDisplay != null) {
            return this.pointDisplay.getScale();
        }
        return 0.0f;
    }

    protected JPanel makeLayoutModelWidget() {
        final JTextField scaleField = new JTextField(Misc.format(this.layoutScale), 5);
        ActionListener scaleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    ValuePlanViewControl.this.setLayoutScale((float)Misc.parseNumber(scaleField.getText()));
                }
                catch (Exception nfe) {
                    ValuePlanViewControl.this.userErrorMessage("Bad scale format");
                }
            }
        };
        scaleField.addActionListener(scaleListener);
        JButton scaleBtn = new JButton("Apply");
        scaleBtn.addActionListener(scaleListener);
        this.layoutModelWidget = new LayoutModelWidget(this, (Object)this, "setLayoutModelFromWidget", this.getLayoutModel());
        JPanel stationModelPanel = GuiUtils.hbox((Component)GuiUtils.left(this.layoutModelWidget), (Component)GuiUtils.rLabel("   Scale:"), GuiUtils.hflow(Misc.newList(scaleField, scaleBtn), 4, 0));
        return stationModelPanel;
    }

    private StationModel makeLayoutModel() {
        StationModel layout = null;
        String name = "Grids>Grid Value";
        layout = this.getControlContext().getStationModelManager().getStationModel(name);
        if (layout == null) {
            LogUtil.userErrorMessage("Unable to find layout model: " + name + ". Using default");
        }
        if (layout == null) {
            layout = this.getControlContext().getStationModelManager().getDefaultStationModel();
        }
        return layout;
    }

    private FieldImpl doDeclutter(FieldImpl obs) throws VisADException, RemoteException {
        long millis = System.currentTimeMillis();
        boolean isTimeSequence = GridUtil.isTimeSequence(obs);
        FieldImpl declutteredField = null;
        if (isTimeSequence) {
            Set timeSet = obs.getDomainSet();
            declutteredField = new FieldImpl((FunctionType)obs.getType(), timeSet);
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)obs.getSample(i);
                FieldImpl subTime = this.doTheActualDecluttering(oneTime);
                if (subTime == null) continue;
                declutteredField.setSample(i, (Data)subTime, false);
            }
        } else {
            declutteredField = this.doTheActualDecluttering(obs);
        }
        return declutteredField;
    }

    private FieldImpl doTheActualDecluttering(FieldImpl pointObs) throws VisADException, RemoteException {
        if (pointObs == null || pointObs.isMissing()) {
            return pointObs;
        }
        FieldImpl retField = null;
        Set domainSet = pointObs.getDomainSet();
        int numObs = domainSet.getLength();
        Vector<PointOb> v = new Vector<PointOb>();
        long t1 = System.currentTimeMillis();
        Rectangle glyphBounds = this.getLayoutModel().getBounds();
        float myScale = this.getScaleFromDisplayable() * 0.0025f * this.getDeclutterFilter();
        Rectangle2D.Double scaledGlyphBounds = new Rectangle2D.Double(glyphBounds.getX() * (double)myScale, glyphBounds.getY() * (double)myScale, glyphBounds.getWidth() * (double)myScale, glyphBounds.getHeight() * (double)myScale);
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        Rectangle2D.Double obBounds = new Rectangle2D.Double();
        obBounds.width = ((RectangularShape)scaledGlyphBounds).getWidth();
        obBounds.height = ((RectangularShape)scaledGlyphBounds).getHeight();
        if (this.stationGrid == null) {
            this.stationGrid = new SpatialGrid(200, 200);
        }
        this.stationGrid.clear();
        this.stationGrid.setGrid(this.getBounds(), scaledGlyphBounds);
        double[] xyz = new double[3];
        for (int i = 0; i < numObs; ++i) {
            if (!(pointObs.getSample(i) instanceof PointOb)) continue;
            PointOb ob = (PointOb)pointObs.getSample(i);
            xyz = navDisplay.getSpatialCoordinates(ob.getEarthLocation(), xyz);
            obBounds.x = xyz[0];
            obBounds.y = xyz[1];
            if (!this.stationGrid.markIfClear(obBounds, "")) continue;
            v.add(ob);
        }
        long t2 = System.currentTimeMillis();
        if (v.isEmpty()) {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), 1));
            retField.setSample(0, pointObs.getSample(0), false);
        } else if (v.size() == numObs) {
            retField = pointObs;
        } else {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), v.size()));
            retField.setSamples(v.toArray(new PointOb[v.size()]), false, false);
        }
        long t3 = System.currentTimeMillis();
        return retField;
    }

    protected Rectangle2D getBounds() {
        return this.calculateRectangle();
    }

    protected LinearLatLonSet calculateLatLonBounds(Rectangle2D screenBounds) {
        if (screenBounds.getWidth() == 0.0 || screenBounds.getHeight() == 0.0) {
            return null;
        }
        LinearLatLonSet bounds = null;
        try {
            Rectangle2D.Double rect = this.getNavigatedDisplay().getLatLonBox();
            bounds = new LinearLatLonSet((MathType)RealTupleType.LatitudeLongitudeTuple, rect.y, rect.y + rect.height, 11, rect.x, rect.x + rect.width, 11);
        }
        catch (Exception e) {
            try {
                bounds = new LinearLatLonSet((MathType)RealTupleType.LatitudeLongitudeTuple, -90.0, 90.0, 19, -180.0, 180.0, 37);
            }
            catch (Exception ne) {
                ValuePlanViewControl.logException("calculating LLLSet ", ne);
            }
        }
        return bounds;
    }
}

