/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import ucar.unidata.data.gis.Transect;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.VMManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.GlyphCreatorCommand;
import ucar.unidata.idv.control.drawing.TransectGlyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import visad.Real;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.MapProjection;

public class TransectDrawingControl
extends DrawingControl {
    private boolean showRegularTransects = true;
    private boolean showDisplayTransects = true;
    private boolean autoUpdateTransect = true;

    public TransectDrawingControl() {
        this.currentCmd = CMD_STRETCH;
        this.setCoordType(3);
        this.setLineWidth(4);
    }

    public void zSliderChanged(int value) {
        super.zSliderChanged(value);
        try {
            ArrayList glyphs = new ArrayList(this.getGlyphs());
            for (int glyphIdx = 0; glyphIdx < glyphs.size(); ++glyphIdx) {
                DrawingGlyph glyph = (DrawingGlyph)glyphs.get(glyphIdx);
                glyph.setZPosition((float)this.getZPosition());
                glyph.updateLocation();
            }
        }
        catch (Exception e) {
            TransectDrawingControl.logException("Setting Z position ", e);
        }
    }

    private boolean isThisANormalTransect(DrawingGlyph glyph) {
        if (!(glyph instanceof TransectGlyph)) {
            return false;
        }
        if (glyph.getPoints().size() < 2) {
            return false;
        }
        return !((TransectGlyph)glyph).getForDisplay();
    }

    @Override
    protected void selectionChanged() {
        TransectGlyph glyph;
        super.selectionChanged();
        if (this.selectedGlyphs.size() > 0 && this.autoUpdateTransect && this.isThisANormalTransect(glyph = (TransectGlyph)this.selectedGlyphs.get(0))) {
            Transect transect = this.makeTransect(glyph);
            this.getControlContext().getIdv().getVMManager().setTransect(transect);
        }
    }

    protected void transectChanged(DrawingGlyph glyph) {
        if (this.autoUpdateTransect && this.isThisANormalTransect(glyph)) {
            this.getControlContext().getIdv().getVMManager().setTransect(this.makeTransect((TransectGlyph)glyph));
            this.writeTransects();
        }
    }

    @Override
    protected void doneMovingGlyph(DrawingGlyph glyph) {
        super.doneMovingGlyph(glyph);
        this.transectChanged(glyph);
    }

    @Override
    public void removeGlyph(DrawingGlyph glyph) {
        super.removeGlyph(glyph);
        this.transectChanged(glyph);
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            List transects = this.getControlContext().getResourceManager().getTransects();
            for (int i = 0; i < transects.size(); ++i) {
                Transect transect = (Transect)transects.get(i);
                ArrayList<String> pointStrings = new ArrayList<String>();
                List points = transect.getPoints();
                for (int ptIdx = 0; ptIdx < points.size(); ++ptIdx) {
                    LatLonPointImpl llp = (LatLonPointImpl)points.get(ptIdx);
                    pointStrings.add(llp.getLatitude() + "");
                    pointStrings.add(llp.getLongitude() + "");
                }
                TransectGlyph newGlyph = new TransectGlyph((DrawingControl)this, null, transect.getEditable());
                newGlyph.setStartText(transect.getStartText());
                newGlyph.setEndText(transect.getEndText());
                newGlyph.setLineWidth(4.0f);
                if (transect.getColor() != null) {
                    newGlyph.setColor(transect.getColor());
                } else if (transect.getEditable()) {
                    newGlyph.setColor(this.getColor());
                } else {
                    newGlyph.setColor(Color.blue);
                }
                newGlyph.setZPosition(0.0f);
                newGlyph.setCoordType(3);
                newGlyph.processPointStrings(pointStrings);
                newGlyph.setName(transect.getName());
                boolean glyphOk = true;
                for (int glyphIdx = 0; glyphIdx < this.glyphs.size(); ++glyphIdx) {
                    TransectGlyph existingTransectGlyph;
                    Transect existingTransect;
                    DrawingGlyph existingGlyph = (DrawingGlyph)this.glyphs.get(glyphIdx);
                    if (!(existingGlyph instanceof TransectGlyph)) continue;
                    String existingName = existingGlyph.getName();
                    if (existingName == null) {
                        existingName = "";
                    }
                    if (!Misc.equals(existingName, newGlyph.getName()) || !(existingTransect = this.makeTransect(existingTransectGlyph = (TransectGlyph)existingGlyph)).equals(transect)) continue;
                    glyphOk = false;
                    break;
                }
                if (!glyphOk) continue;
                this.addGlyph(newGlyph);
            }
            this.checkTransectVisiblity();
            List<ViewManager> vms = this.getControlContext().getIdv().getVMManager().getViewManagers();
            for (int i = 0; i < vms.size(); ++i) {
                ViewManager vm = vms.get(i);
                if (!(vm instanceof TransectViewManager)) continue;
                this.setDisplayedTransect((TransectViewManager)vm);
            }
        }
        catch (Exception e) {
            TransectDrawingControl.logException("Reading transects", e);
        }
    }

    @Override
    public MapProjection getDataProjection() {
        MapProjection mp = this.getMapViewProjection();
        return mp;
    }

    public boolean getNormalize360() {
        boolean normalized = true;
        MapProjection mp = this.getMapViewProjection();
        double x = mp.getDefaultMapArea().getX();
        if (x < 0.0) {
            normalized = false;
        }
        return normalized;
    }

    @Override
    protected List getShapeCommands() {
        return Misc.newList(GlyphCreatorCommand.CMD_TRANSECT);
    }

    @Override
    protected void addControlWidgets(List widgets) {
        super.addControlWidgets(widgets);
        widgets.add(GuiUtils.filler());
        widgets.add(GuiUtils.left(GuiUtils.makeCheckbox("Automatically update transects", this, "autoUpdateTransect")));
        widgets.add(GuiUtils.filler());
        widgets.add(GuiUtils.left(GuiUtils.makeCheckbox("Show transects", this, "showRegularTransects", null)));
        widgets.add(GuiUtils.filler());
        widgets.add(GuiUtils.left(GuiUtils.makeCheckbox("Show active transects", this, "showDisplayTransects", null)));
    }

    @Override
    protected void addFileMenuItems(List items, boolean forMenuBar) {
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Save Transects", this, "writeTransects"));
    }

    public void setDisplayedTransect(TransectViewManager tvm) throws VisADException, RemoteException {
        this.checkTransectVisiblity();
        TransectGlyph tg = this.findGlyph(tvm);
        if (tg == null) {
            tg = this.makeDisplayTransectGlyph(tvm);
        }
        Transect transect = tvm.getAxisTransect();
        LatLonPointImpl from = (LatLonPointImpl)transect.getPoints().get(0);
        LatLonPointImpl to = (LatLonPointImpl)transect.getPoints().get(1);
        ArrayList<String> pointStrings = new ArrayList<String>();
        pointStrings.add(from.getLatitude() + "");
        pointStrings.add(from.getLongitude() + "");
        pointStrings.add(to.getLatitude() + "");
        pointStrings.add(to.getLongitude() + "");
        tg.processPointStrings(pointStrings, this.getNormalize360());
        tg.setMaxDataDistance(tvm.getMaxDataDistance());
        tg.updateLocation();
    }

    public void writeTransects() {
        List glyphs = this.getGlyphs();
        ArrayList<Transect> transects = new ArrayList<Transect>();
        for (int i = 0; i < glyphs.size(); ++i) {
            DrawingGlyph glyph = (DrawingGlyph)glyphs.get(i);
            if (!this.isThisANormalTransect(glyph)) continue;
            transects.add(this.makeTransect((TransectGlyph)glyph));
        }
        this.getControlContext().getResourceManager().writeTransects(transects);
    }

    private Transect makeTransect(TransectGlyph glyph) {
        List glyphPoints = glyph.getPoints();
        ArrayList<LatLonPointImpl> points = new ArrayList<LatLonPointImpl>();
        for (int ptIdx = 0; ptIdx < glyphPoints.size(); ++ptIdx) {
            EarthLocation elt = (EarthLocation)glyphPoints.get(ptIdx);
            LatLonPointImpl llp = new LatLonPointImpl(elt.getLatLonPoint().getLatitude().getValue(), elt.getLatLonPoint().getLongitude().getValue());
            points.add(llp);
        }
        Transect transect = new Transect(glyph.getName(), points);
        transect.setStartText(glyph.getStartText());
        transect.setEndText(glyph.getEndText());
        transect.setColor(glyph.getColor());
        return transect;
    }

    @Override
    protected boolean showFilledCbx() {
        return false;
    }

    @Override
    protected void makeModePanel(List widgets) {
        List commands = Misc.newList(CMD_SELECT, CMD_MOVE, CMD_STRETCH);
        List shapes = this.getShapeCommands();
        ButtonGroup bg = new ButtonGroup();
        widgets.add(GuiUtils.rLabel("Mode:"));
        widgets.add(GuiUtils.left(GuiUtils.hbox((Component)this.makeButtonPanel(shapes, bg), (Component)this.makeButtonPanel(commands, bg), this.enabledCbx)));
    }

    @Override
    protected boolean showTimeWidgets() {
        return false;
    }

    @Override
    protected boolean showLocationWidgets() {
        return false;
    }

    @Override
    protected String getGlyphNameDefault(DrawingGlyph glyph) {
        if (!(glyph instanceof TransectGlyph)) {
            return super.getGlyphNameDefault(glyph);
        }
        if (((TransectGlyph)glyph).getForDisplay()) {
            return "Display Transect";
        }
        return "Transect";
    }

    public void transectViewsChanged() {
        this.checkTransectVisiblity();
    }

    public void setAutoUpdateTransect(boolean value) {
        this.autoUpdateTransect = value;
    }

    public boolean getAutoUpdateTransect() {
        return this.autoUpdateTransect;
    }

    public void setShowRegularTransects(boolean value) {
        this.showRegularTransects = value;
        if (this.getHaveInitialized()) {
            this.checkTransectVisiblity();
        }
    }

    public boolean getShowRegularTransects() {
        return this.showRegularTransects;
    }

    public void setShowDisplayTransects(boolean value) {
        this.showDisplayTransects = value;
        if (this.getHaveInitialized()) {
            this.checkTransectVisiblity();
        }
    }

    public boolean getShowDisplayTransects() {
        return this.showDisplayTransects;
    }

    @Override
    public void setDisplayVisibility(boolean on) {
        super.setDisplayVisibility(on);
        this.checkTransectVisiblity();
    }

    @Override
    public boolean shouldBeVisible(DrawingGlyph tg) {
        if (!this.getDisplayVisibility()) {
            return false;
        }
        if (this.isThisANormalTransect(tg)) {
            return this.showRegularTransects;
        }
        return this.showDisplayTransects;
    }

    @Override
    protected void timeChanged(Real time) {
    }

    private void checkTransectVisiblity() {
        try {
            TransectGlyph tg;
            boolean meVisible = this.getDisplayVisibility();
            VMManager vmManager = this.getControlContext().getIdv().getVMManager();
            List vms = vmManager.getViewManagers(TransectViewManager.class);
            ArrayList glyphs = new ArrayList(this.getGlyphs());
            for (int glyphIdx = 0; glyphIdx < glyphs.size(); ++glyphIdx) {
                DrawingGlyph glyph = (DrawingGlyph)glyphs.get(glyphIdx);
                if (!(glyph instanceof TransectGlyph)) continue;
                tg = (TransectGlyph)glyph;
                if (this.isThisANormalTransect(tg)) {
                    glyph.setVisible(meVisible && this.showRegularTransects);
                    continue;
                }
                tg.setVisible(meVisible && this.showDisplayTransects);
                if (tg.getViewDescriptor() == null) continue;
                TransectViewManager tvm = (TransectViewManager)VMManager.findViewManagerInList(tg.getViewDescriptor(), vms);
                if (tvm == null) {
                    this.removeGlyph(tg);
                    continue;
                }
                vms.remove(tvm);
                this.checkDisplayTransectName(tg, tvm);
            }
            for (int i = 0; i < vms.size(); ++i) {
                TransectViewManager tvm = (TransectViewManager)vms.get(i);
                tg = this.findGlyph(tvm);
                if (tg != null) continue;
                tg = this.makeDisplayTransectGlyph(tvm);
            }
        }
        catch (Exception exc) {
            TransectDrawingControl.logException("Toggling transect visibility", exc);
        }
    }

    private void checkDisplayTransectName(TransectGlyph tg, TransectViewManager tvm) {
        String name = "Display";
        if (tvm.getName() != null && tvm.getName().length() > 0) {
            name = name + ": " + tvm.getName();
        }
        tg.setName(name);
    }

    private TransectGlyph makeDisplayTransectGlyph(TransectViewManager tvm) throws VisADException, RemoteException {
        TransectGlyph tg = new TransectGlyph(this, null, false, true);
        tg.setColor(Color.green);
        tg.setZPosition(0.0f);
        tg.setCoordType(3);
        tg.setLineWidth(2.0f);
        tg.initFinal();
        tg.setViewDescriptor(tvm.getViewDescriptor());
        this.addGlyph(tg);
        this.checkDisplayTransectName(tg, tvm);
        return tg;
    }

    private TransectGlyph findGlyph(TransectViewManager tvm) {
        ArrayList glyphs = new ArrayList(this.getGlyphs());
        for (int glyphIdx = 0; glyphIdx < glyphs.size(); ++glyphIdx) {
            TransectGlyph tg;
            DrawingGlyph glyph = (DrawingGlyph)glyphs.get(glyphIdx);
            if (!(glyph instanceof TransectGlyph) || (tg = (TransectGlyph)glyph).getViewDescriptor() == null || !tvm.isDefinedBy(tg.getViewDescriptor())) continue;
            return tg;
        }
        return null;
    }
}

