/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.sounding.CosmicTrajectoryFeatureTypeInfo;
import ucar.unidata.data.sounding.TrackDataSource;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.data.sounding.TrajectoryFeatureTypeAdapter;
import ucar.unidata.idv.control.AerologicalSoundingControl;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.IndicatorPoint;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.PickableLineDrawing;
import visad.ActionImpl;
import visad.Data;
import visad.DateTime;
import visad.Field;
import visad.RealTuple;
import visad.RealTupleType;
import visad.VisADException;
import visad.georef.LatLonPoint;
import visad.georef.NamedLocationTuple;

public class TrajectoryFeatureTypeSoundingControl
extends AerologicalSoundingControl {
    private final DisplayableData track = new LineDrawing("TrajectoryFeatureTypeSoundingControl track");
    private DateTime bottomTime;
    private PickableLineDrawing stationProbes;
    private LatLonPoint[] latLons;
    private IndicatorPoint selectedStation;
    private JComboBox stationMenue;
    private boolean ignoreStationMenuEvent = false;
    private String[] stationIds;
    private int selectedStationIndex = -1;
    private List<Data[]> dataList;
    private List<DateTime> timeList;

    public TrajectoryFeatureTypeSoundingControl() throws VisADException, RemoteException {
        super(true);
        this.track.setPointSize(2.0f);
        this.stationProbes = new PickableLineDrawing("RAOB Points");
        this.selectedStation = new IndicatorPoint("Selected Station", RealTupleType.LatitudeLongitudeTuple);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.init()) {
            return false;
        }
        this.setSpatialLoci(this.track);
        this.setSpatialLoci(this.stationProbes);
        if (!this.setData(dataChoice)) {
            return false;
        }
        ArrayList dsList = new ArrayList();
        dataChoice.getDataSources(dsList);
        TrackDataSource ds = (TrackDataSource)dsList.get(0);
        List adapters = ds.getAdapters();
        try {
            this.initDataChoice(adapters);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initSounding(this.dataList.get(0));
        this.stationProbes.setData(Util.indexedField(this.latLons, false));
        this.stationProbes.addAction(new ActionImpl("Station Probe Action"){
            private boolean first;
            {
                this.first = true;
            }

            @Override
            public void doAction() {
                if (this.first) {
                    this.first = false;
                } else {
                    Misc.run(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = TrajectoryFeatureTypeSoundingControl.this.stationProbes.getCloseIndex();
                                if (i >= 0 && TrajectoryFeatureTypeSoundingControl.this.stationMenue != null) {
                                    TrajectoryFeatureTypeSoundingControl.this.ignoreStationMenuEvent = true;
                                    TrajectoryFeatureTypeSoundingControl.this.selectedStation.setPoint((RealTuple)((Object)TrajectoryFeatureTypeSoundingControl.this.latLons[i]));
                                    TrajectoryFeatureTypeSoundingControl.this.stationMenue.setSelectedIndex(i);
                                    TrajectoryFeatureTypeSoundingControl.this.setStation(i);
                                }
                            }
                            catch (Exception ex) {
                                DisplayControlBase.logException(ex);
                            }
                            finally {
                                TrajectoryFeatureTypeSoundingControl.this.ignoreStationMenuEvent = false;
                            }
                        }
                    });
                }
            }
        });
        this.setPointSize();
        this.addDisplayable((Displayable)this.stationProbes, 4);
        this.addDisplayable((Displayable)this.selectedStation, 4);
        if (this.getSelectedStationIndex() >= 0) {
            this.selectedStation.setPoint((RealTuple)((Object)this.latLons[this.getSelectedStationIndex()]));
        }
        this.updateHeaderLabel();
        return true;
    }

    public void setSelectedStationIndex(int value) {
        this.selectedStationIndex = value;
    }

    public int getSelectedStationIndex() {
        if (this.stationMenue != null) {
            return this.stationMenue.getSelectedIndex();
        }
        return -1;
    }

    private void setPointSize() {
        try {
            this.stationProbes.setPointSize(5.0f);
            this.selectedStation.setPointSize(10.0f);
        }
        catch (Exception exc) {
            TrajectoryFeatureTypeSoundingControl.logException("Set point size ", exc);
        }
    }

    public boolean initDataChoice(List<TrajectoryFeatureTypeAdapter> adapters) throws VisADException, RemoteException, Exception {
        int len = adapters.size();
        this.stationIds = new String[len];
        this.latLons = new LatLonPoint[len];
        this.dataList = new ArrayList<Data[]>();
        this.timeList = new ArrayList<DateTime>();
        for (int i = 0; i < len; ++i) {
            TrajectoryFeatureTypeAdapter cta = adapters.get(i);
            List<TrackInfo> infos = cta.getTrackInfos();
            CosmicTrajectoryFeatureTypeInfo cfti = (CosmicTrajectoryFeatureTypeInfo)infos.get(0);
            Data[] sddata = cfti.getAerologicalDiagramDataArray();
            this.dataList.add(sddata);
            NamedLocationTuple s = cfti.getLatLonPoint();
            this.latLons[i] = s.getLatLonPoint();
            this.stationIds[i] = s.getIdentifier().getValue();
            this.timeList.add(cfti.getStartTime());
        }
        return true;
    }

    public boolean initSounding(Data[] sounding) throws VisADException, RemoteException {
        Field tempPro = (Field)sounding[0];
        Field dewPro = (Field)sounding[1];
        this.setSoundings(new Field[]{tempPro}, new Field[]{dewPro}, new Field[]{null});
        return true;
    }

    @Override
    protected String getSpatialLociLabel() {
        return "Track";
    }

    @Override
    Component getSpecificWidget() throws VisADException, RemoteException {
        this.stationMenue = new JComboBox<String>(this.stationIds);
        if (this.selectedStationIndex >= 0 && this.selectedStationIndex < this.stationIds.length) {
            this.stationMenue.setSelectedIndex(this.selectedStationIndex);
            this.setStation(this.selectedStationIndex);
        } else {
            this.setStation(0);
        }
        this.stationMenue.setToolTipText("Soundings");
        this.stationMenue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    TrajectoryFeatureTypeSoundingControl.this.updateHeaderLabel();
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.stationMenue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrajectoryFeatureTypeSoundingControl.this.ignoreStationMenuEvent) {
                    return;
                }
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TrajectoryFeatureTypeSoundingControl.this.setStation(TrajectoryFeatureTypeSoundingControl.this.stationMenue.getSelectedIndex());
                            Misc.runInABit(250L, new Runnable(){

                                @Override
                                public void run() {
                                    TrajectoryFeatureTypeSoundingControl.this.stationMenue.requestFocus();
                                }
                            });
                            TrajectoryFeatureTypeSoundingControl.this.updateHeaderLabel();
                        }
                        catch (Exception ex) {
                            DisplayControlBase.logException(ex);
                        }
                    }
                });
            }
        });
        return GuiUtils.top(GuiUtils.inset((Component)GuiUtils.label("Soundings: ", this.stationMenue), 8));
    }

    private void setStation(int index) throws VisADException, RemoteException {
        this.selectedStation.setPoint((RealTuple)((Object)this.latLons[index]));
        this.setLocation(this.latLons[index]);
        this.initSounding(this.dataList.get(index));
        this.getSoundingView().updateDisplayList();
    }

    @Override
    protected void updateHeaderLabel() {
        int timeIdx = this.getCurrentIdx();
        int index = this.getSelectedStationIndex();
        if (index >= 0) {
            this.headerLabel.setText(this.stationIds[index]);
        } else {
            this.headerLabel.setText(this.stationIds[0]);
        }
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList("%station%"));
        labels.addAll(Misc.newList("Station"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        int index = this.getSelectedStationIndex();
        if (index >= 0) {
            patterns.add("%station%");
            values.add("" + this.stationIds[index]);
        }
    }
}

