/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import ucar.unidata.idv.control.SoundingDataNode;
import ucar.visad.Util;
import ucar.visad.quantities.AirPressure;
import visad.Data;
import visad.DateTime;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SingletonSet;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.georef.LatLonTuple;
import visad.util.DataUtility;

final class TrackSoundingDataNode
extends SoundingDataNode {
    private Field field;

    TrackSoundingDataNode(SoundingDataNode.Listener listener) throws VisADException, RemoteException {
        super(listener);
    }

    @Override
    public void setData(Data data) throws VisADException, RemoteException {
        this.field = (Field)data;
        if (this.field != null) {
            float[][] values = this.field.getFloats();
            int[] indexes = Util.strictlySortedIndexes(values[0], false);
            int primaryIndex = indexes[0];
            this.setOutputTimes(new SingletonSet(new RealTuple(new Real[]{new DateTime((Real)DataUtility.getSample(this.field.getDomainSet(), primaryIndex).getComponent(0))})));
            RealTuple loc3 = (RealTuple)((Tuple)this.field.getSample(primaryIndex)).getComponent(4);
            LatLonTuple loc = new LatLonTuple((Real)loc3.getComponent(0), (Real)loc3.getComponent(1));
            this.setOutputLocation(loc);
            float[] press = Util.take(values[0], indexes);
            float[] temps = Util.take(values[1], indexes);
            float[] dews = Util.take(values[2], indexes);
            float[] spds = Util.take(values[3], indexes);
            float[] dirs = Util.take(values[4], indexes);
            float[] lats = Util.take(values[5], indexes);
            float[] lons = Util.take(values[6], indexes);
            float[] alts = Util.take(values[7], indexes);
            this.setOutputLocations(GriddedSet.create(RealTupleType.LatitudeLongitudeAltitude, new float[][]{lats, lons, alts}, new int[]{lats.length}));
            TupleType rangeType = (TupleType)((FunctionType)this.field.getType()).getRange();
            RealType presType = (RealType)rangeType.getComponent(0);
            RealType altType = (RealType)((RealTupleType)rangeType.getComponent(4)).getComponent(2);
            Gridded1DSet presDomain = Gridded1DSet.create(AirPressure.getRealTupleType(), press, null, presType.getDefaultUnit(), null);
            presDomain = Gridded1DSet.create(presDomain.getType(), presDomain.getSamples(false)[0], null, presDomain.getSetUnits()[0], null);
            RealType tempType = (RealType)((TupleType)((FunctionType)this.field.getType()).getRange()).getComponent(1);
            RealType dewType = (RealType)((TupleType)((FunctionType)this.field.getType()).getRange()).getComponent(2);
            RealTupleType windType = (RealTupleType)((TupleType)((FunctionType)this.field.getType()).getRange()).getComponent(3);
            FlatField tempPro = new FlatField(new FunctionType(AirPressure.getRealTupleType(), tempType), presDomain);
            FlatField dewPro = new FlatField(new FunctionType(AirPressure.getRealTupleType(), dewType), presDomain);
            FlatField windPro = new FlatField(new FunctionType(AirPressure.getRealTupleType(), windType), presDomain);
            tempPro.setSamples(new float[][]{temps}, false);
            dewPro.setSamples(new float[][]{dews}, false);
            dewPro.setSamples(new float[][]{spds, dirs}, false);
            this.setOutputProfiles(new Field[]{tempPro}, new Field[]{dewPro}, new Field[]{windPro});
        }
    }
}

