/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.AerologicalSoundingControl;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.LineDrawing;
import ucar.visad.functiontypes.DewPointProfile;
import ucar.visad.functiontypes.InSituAirTemperatureProfile;
import ucar.visad.functiontypes.PolarHorizontalWindOfPressure;
import ucar.visad.quantities.AirPressure;
import visad.CoordinateSystem;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.Field;
import visad.FlatField;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.georef.LatLonTuple;

public class TrackSoundingControl
extends AerologicalSoundingControl {
    private final DisplayableData track = new LineDrawing("TrackSoundingControl track");
    private DateTime bottomTime;

    public TrackSoundingControl() throws VisADException, RemoteException {
        super(true);
        this.track.setPointSize(2.0f);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.init()) {
            return false;
        }
        this.setSpatialLoci(this.track);
        if (!this.setData(dataChoice)) {
            return false;
        }
        Field field = (Field)this.getDataInstance().getData();
        float[][] params = field.getFloats();
        float[] press = params[0];
        float[] temps = params[1];
        float[] dews = params[2];
        float[] spds = params[3];
        float[] dirs = params[4];
        float[] lats = params[5];
        float[] lons = params[6];
        float[] alts = params[7];
        Set timeDomain = field.getDomainSet();
        int[] indexes = Util.strictlySortedIndexes(press, false);
        Unit[] defaultRangeUnits = field.getDefaultRangeUnits();
        press = Util.take(press, indexes);
        temps = Util.take(temps, indexes);
        dews = Util.take(dews, indexes);
        spds = Util.take(spds, indexes);
        dirs = Util.take(dirs, indexes);
        lats = Util.take(lats, indexes);
        lons = Util.take(lons, indexes);
        alts = Util.take(alts, indexes);
        this.bottomTime = new DateTime(new Real((RealType)((SetType)timeDomain.getType()).getDomain().getComponent(0), timeDomain.indexToDouble(new int[]{0})[0][0], timeDomain.getSetUnits()[0]));
        this.setLocation(new LatLonTuple(new Real(RealType.Latitude, lats[0], defaultRangeUnits[5]), new Real(RealType.Longitude, lons[0], defaultRangeUnits[6])));
        this.track.setData(new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, (float[][])new float[][]{lats, lons, alts}, lats.length));
        Gridded1DSet presDomain = new Gridded1DSet((MathType)AirPressure.getRealTupleType(), (float[][])new float[][]{press}, press.length, (CoordinateSystem)null, new Unit[]{defaultRangeUnits[0]}, (ErrorEstimate[])null);
        FlatField tempPro = new FlatField(InSituAirTemperatureProfile.instance(), presDomain);
        FlatField dewPro = new FlatField(DewPointProfile.instance(), presDomain);
        FlatField windPro = new FlatField(PolarHorizontalWindOfPressure.instance(), presDomain);
        tempPro.setSamples(new float[][]{temps});
        dewPro.setSamples(new float[][]{dews});
        windPro.setSamples(new float[][]{spds, dirs});
        this.setSoundings(new Field[]{tempPro}, new Field[]{dewPro}, new Field[]{windPro});
        this.setSounding(0);
        this.addDisplayable((Displayable)this.track, 4);
        return true;
    }

    @Override
    protected String getSpatialLociLabel() {
        return "Track";
    }

    @Override
    Component getSpecificWidget() {
        return new JLabel(this.bottomTime.toString());
    }
}

