/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataTimeRange;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.control.ControlWidget;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.LayoutModelWidget;
import ucar.unidata.idv.control.ValueSliderWidget;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.ui.symbol.LabelSymbol;
import ucar.unidata.ui.symbol.ShapeSymbol;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.display.Animation;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.SelectRangeDisplayable;
import ucar.visad.display.StationModelDisplayable;
import ucar.visad.display.TrackDisplayable;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.GriddedSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationLite;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;
import visad.util.DataUtility;

public class TrackControl
extends GridDisplayControl {
    private final Object DATA_MUTEX = new Object();
    private static final Data DUMMY_DATA = new Real(0.0);
    TrackDisplayable trackDisplay;
    SelectRangeDisplayable selectRangeDisplay;
    int trackWidth = 2;
    private JLabel sliderLabel;
    private JLabel widthLabel;
    protected LayoutModelWidget layoutModelWidget;
    private static final String CMD_ALL = "id.wholetrace";
    private static final String CMD_POINT = "id.pointtrace";
    private static final String CMD_RANGE = "id.timetrace";
    private static final String CMD_ANIMATION_TIME = "animation_time";
    private static final String CMD_TRACK_TIME = "track_time";
    private String trackType = "id.timetrace";
    protected StationModelDisplayable indicator = null;
    protected DisplayableData timesHolder = null;
    private JTextField markerTextField;
    private JComboBox symbolBox;
    private String markerText = "";
    private String markerSymbol = "NONE";
    private StationModel layoutModel = null;
    private Range lastRange;
    private EarthLocationLite lastIndicatorPosition;
    private DateTime lastIndicatorTime;
    private boolean markerVisible = false;
    private boolean useTrackTimes = false;
    private boolean timeDeclutterEnabled = false;
    private boolean askedUserToDeclutterTime = false;
    private double timeDeclutterMinutes = 1.0;
    JComponent[] timeDeclutterComps;
    private JTextField timeDeclutterFld;
    private JCheckBox timeDeclutterCbx;
    private boolean ignoreTimeDeclutterEnabled = false;
    private float markerScale = 1.0f;
    protected static final String[] TIMES_TO_USE = new String[]{"Nominal Time", "Track Times"};
    private boolean timeSubsetEnabled = false;
    private double timeSubsetMinutes = 30.0;
    private boolean useTrackTime = true;

    public TrackControl() {
        this.setAttributeFlags(568);
    }

    private boolean trackDataOk() throws VisADException, RemoteException {
        DataInstance dataInstance = this.getDataInstance();
        return dataInstance != null && dataInstance.dataOk();
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        MapViewManager mvm = this.getMapViewManager();
        if (mvm != null) {
            items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Show Flythrough", this, "showFlythrough", null), "/auxdata/ui/icons/plane.png"));
        }
        super.getViewMenuItems(items, forMenuBar);
    }

    public void showFlythrough() throws Exception {
        MapViewManager mvm = this.getMapViewManager();
        FlatField flatField = this.getFlatField();
        Set domainSet = flatField.getDomainSet();
        ArrayList<FlythroughPoint> points = new ArrayList<FlythroughPoint>();
        int length = domainSet.getLength();
        for (int i = 0; i < length; ++i) {
            Real[] llaR = DataUtility.getSample(domainSet, i).getRealComponents();
            Tuple tuple = (Tuple)flatField.getSample(i);
            EarthLocationLite el = new EarthLocationLite(llaR[0], llaR[1], llaR[2]);
            points.add(new FlythroughPoint(el, new DateTime((Real)tuple.getComponent(1))));
        }
        mvm.flythrough(points);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!this.trackDataOk()) {
            return false;
        }
        this.trackDisplay = new TrackDisplayable("track" + dataChoice);
        this.setLineWidth(this.trackWidth);
        this.addDisplayable((Displayable)this.trackDisplay, this.getAttributeFlags());
        this.selectRangeDisplay = new SelectRangeDisplayable();
        this.addDisplayable((Displayable)this.selectRangeDisplay, 288);
        this.getViewAnimation();
        this.indicator = new StationModelDisplayable("indicator");
        this.indicator.setScale(this.markerScale);
        this.indicator.setShouldUseAltitude(true);
        this.updateIndicator();
        this.addDisplayable(this.indicator);
        this.timesHolder = new LineDrawing(CMD_TRACK_TIME + dataChoice);
        this.timesHolder.setManipulable(false);
        this.timesHolder.setVisible(false);
        this.addDisplayable(this.timesHolder);
        return this.setData(dataChoice);
    }

    protected void updateIndicator() {
        if (this.indicator != null) {
            try {
                this.lastIndicatorPosition = null;
                this.indicator.setStationModel(this.getMarkerLayout());
                this.indicator.setVisible(this.getMarkerVisible());
                this.setScaleOnMarker();
                this.applyTimeRange();
            }
            catch (Exception exc) {
                TrackControl.logException("Updating indicator", exc);
            }
        }
    }

    @Override
    public String getColorWidgetLabel() {
        return "Marker Color";
    }

    @Override
    protected void setDataInstance(DataInstance dataInstance) {
        super.setDataInstance(dataInstance);
        try {
            if (this.selectRangeDisplay != null) {
                this.selectRangeDisplay.setSelectRealType(this.getGridDataInstance().getRealType(0));
            }
        }
        catch (Exception exc) {
            TrackControl.logException("setting range real type", exc);
        }
    }

    @Override
    public LatLonPoint getDisplayCenter() throws RemoteException, VisADException {
        FlatField flatField = this.getFlatField();
        if (flatField == null) {
            return null;
        }
        Set domainSet = flatField.getDomainSet();
        Real[] llaR = DataUtility.getSample(domainSet, domainSet.getLength() - 1).getRealComponents();
        return new LatLonTuple(llaR[0].getValue(), llaR[1].getValue());
    }

    @Override
    protected void timeChanged(Real time) {
        if (!this.isInitDone()) {
            return;
        }
        try {
            this.applyTimeRange();
        }
        catch (Exception exc) {
            TrackControl.logException("applyTimeRange", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        GridDataInstance gdi;
        Unit newUnit;
        if (this.trackDisplay == null) {
            return true;
        }
        if (!super.setData(choice)) {
            // empty if block
        }
        if ((newUnit = this.getDisplayUnit()) != null && !newUnit.equals(this.getDisplayUnit()) && Unit.canConvert(newUnit, this.getRawDataUnit())) {
            this.trackDisplay.setDisplayUnit(newUnit);
            this.selectRangeDisplay.setDisplayUnit(newUnit);
        }
        FlatField ff = null;
        FieldImpl grid = null;
        if (!this.trackDataOk()) {
            if (this.trackDisplay != null) {
                this.trackDisplay.setData(DUMMY_DATA);
                this.indicator.setVisible(false);
                this.timesHolder.setData(DUMMY_DATA);
            }
            return true;
        }
        if (this.indicator != null) {
            this.indicator.setVisible(this.getMarkerVisible());
        }
        GridDataInstance gridDataInstance = gdi = this.getGridDataInstance();
        synchronized (gridDataInstance) {
            ff = this.getFlatField();
            if (ff != null) {
                grid = this.getGridDataInstance().getGrid(false);
            }
        }
        if (ff != null && grid != null) {
            this.updateTimeSelectRange();
            if (this.useTrackTimes) {
                this.trackDisplay.setTrack(this.mergeGrid(grid));
            } else {
                this.trackDisplay.setTrack(grid);
            }
            this.setTrackTimes();
            this.applyTimeRange();
        }
        return true;
    }

    protected FieldImpl mergeGrid(FieldImpl fi) throws VisADException, RemoteException {
        FunctionType fiType = (FunctionType)fi.getType();
        int len = fi.getLength();
        ArrayList<FlatField> datas = new ArrayList<FlatField>();
        Set st = fi.getDomainSet();
        Unit[] ut = fi.getDomainUnits();
        float[][] t = st.getSamples();
        DateTime[] times = new DateTime[]{t[0].length > 2 ? new DateTime((double)t[0][2], ut[0]) : new DateTime((double)t[0][0], ut[0])};
        for (int i = 0; i < len; ++i) {
            datas.add((FlatField)fi.getSample(i));
        }
        if (datas.isEmpty()) {
            return null;
        }
        if (datas.size() == 1) {
            return (FlatField)datas.get(0);
        }
        FlatField retField = null;
        try {
            int numObs = 0;
            GriddedSet domainSet = null;
            DataImpl ff = null;
            for (int i = 0; i < datas.size(); ++i) {
                ff = (FlatField)datas.get(i);
                domainSet = (GriddedSet)((FieldImpl)ff).getDomainSet();
                numObs += domainSet.getLength();
            }
            FunctionType retType = (FunctionType)ff.getType();
            RealTupleType rtt = DataUtility.getFlatRangeType((Function)((Object)ff));
            double[][] domainVals = new double[domainSet.getDimension()][numObs + datas.size()];
            float[][] values = new float[rtt.getDimension()][numObs + datas.size()];
            int curPos = 0;
            for (int i = 0; i < datas.size(); ++i) {
                int j;
                FlatField data = (FlatField)datas.get(i);
                GriddedSet dset = (GriddedSet)data.getDomainSet();
                double[][] samples = dset.getDoubles(false);
                int length = dset.getLength();
                float[][] vals = data.getFloats(false);
                for (j = 0; j < samples.length; ++j) {
                    domainVals[j][curPos] = samples[j][0];
                    System.arraycopy(samples[j], 0, domainVals[j], curPos + 1, length);
                }
                for (j = 0; j < vals.length; ++j) {
                    values[j][curPos] = Float.NaN;
                    System.arraycopy(vals[j], 0, values[j], curPos + 1, length);
                }
                curPos += length;
            }
            GriddedSet newDomain = null;
            newDomain = domainSet instanceof Gridded1DDoubleSet ? new Gridded1DDoubleSet(domainSet.getType(), domainVals, numObs, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors()) : GriddedSet.create(domainSet.getType(), Set.doubleToFloat(domainVals), new int[]{numObs += datas.size()}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
            retField = new FlatField(retType, newDomain);
            retField.setSamples(values, false);
        }
        catch (RemoteException re) {
            throw new VisADException("got RemoteException " + re);
        }
        FieldImpl fi0 = new FieldImpl(fiType, CalendarDateTime.makeTimeSet(times));
        fi0.setSample(0, (Data)retField, false);
        return fi0;
    }

    protected void setTrackTimes() throws VisADException, RemoteException {
        Unit[] units;
        Gridded1DDoubleSet timeSet;
        double[] times;
        FlatField f;
        if (!this.trackType.equals(CMD_RANGE) || this.trackDisplay == null) {
            return;
        }
        Data d = this.trackDisplay.getData();
        if (d.equals(DUMMY_DATA)) {
            return;
        }
        if (!this.getUseTrackTimes()) {
            this.timesHolder.setData(DUMMY_DATA);
            return;
        }
        try {
            f = (FlatField)((FieldImpl)d).getSample(0);
        }
        catch (ClassCastException e) {
            f = (FlatField)d;
        }
        double[][] samples = f.getValues(false);
        int numTimes = samples[1].length;
        if (!this.getTimeDeclutterEnabled() && !this.getAskedUserToDeclutterTime() && numTimes > 1000) {
            int success = GuiUtils.showYesNoCancelDialog(this.getWindow(), "<html>There are " + numTimes + " time steps in the data.<br>Do you want to show them all?</html>", "Time Declutter", GuiUtils.CMD_NO);
            if (success == 2) {
                return;
            }
            this.setAskedUserToDeclutterTime(true);
            this.setTimeDeclutterEnabled(success == 1);
        }
        if (!Util.isStrictlySorted(times = samples[1])) {
            int[] indexes = Util.strictlySortedIndexes(times, true);
            times = Util.take(times, indexes);
        }
        if (this.getTimeDeclutterEnabled()) {
            LogUtil.message("Track display: subsetting times");
            Trace.call1("declutterTime");
            times = this.declutterTime(times);
            Trace.call2("declutterTime");
            LogUtil.message("");
        }
        if ((timeSet = new Gridded1DDoubleSet((MathType)RealTupleType.Time1DTuple, new double[][]{times}, times.length, (CoordinateSystem)null, new Unit[]{(units = f.getDefaultRangeUnits())[1]}, (ErrorEstimate[])null, false)) != null) {
            this.timesHolder.setData(timeSet);
        }
    }

    private double[] declutterTime(double[] times) throws VisADException, RemoteException {
        int numTimes = times.length;
        int seconds = (int)(this.timeDeclutterMinutes * 60.0);
        if (seconds == 0) {
            seconds = 1;
        }
        double[] tmpTimes = new double[times.length];
        int numFound = 0;
        Hashtable<Integer, Integer> seenTime = new Hashtable<Integer, Integer>();
        for (int timeIdx = 0; timeIdx < numTimes; ++timeIdx) {
            Integer timeKey = new Integer((int)(times[timeIdx] / (double)seconds));
            if (timeIdx < numTimes - 1 && seenTime.get(timeKey) != null) continue;
            seenTime.put(timeKey, timeKey);
            tmpTimes[numFound++] = times[timeIdx];
        }
        double[] newTimes = new double[numFound];
        System.arraycopy(tmpTimes, 0, newTimes, 0, numFound);
        return newTimes;
    }

    private FlatField getFlatField() throws VisADException, RemoteException {
        if (!this.trackDataOk()) {
            return null;
        }
        return DataUtil.getFlatField(this.getDataInstance().getData());
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        JComponent contents = (JComponent)super.doMakeContents();
        if (this.trackType.equals(CMD_RANGE)) {
            JTabbedPane jtp = new JTabbedPane();
            jtp.add("Layout", GuiUtils.topLeft(contents));
            ArrayList<WrapperWidget> timeWidgets = new ArrayList<WrapperWidget>();
            timeWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Times to Use:"), this.doMakeTimeOptionWidget(), null));
            super.addTimeModeWidget(timeWidgets);
            List widgetComponents = ControlWidget.fillList(timeWidgets);
            GuiUtils.tmpInsets = new Insets(4, 8, 4, 8);
            GuiUtils.tmpFill = 2;
            JPanel timesComp = GuiUtils.doLayout(widgetComponents, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            jtp.add("Times", GuiUtils.topLeft(timesComp));
            return jtp;
        }
        return GuiUtils.top(contents);
    }

    protected void timeDeclutterChanged() {
        try {
            this.setTrackTimes();
        }
        catch (Exception e) {
            TrackControl.logException("setTrackTimes", e);
        }
    }

    protected JComponent[] getTimeDeclutterComps() {
        if (this.timeDeclutterComps != null) {
            return this.timeDeclutterComps;
        }
        ActionListener timeDeclutterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    if (TrackControl.this.ignoreTimeDeclutterEnabled) {
                        return;
                    }
                    TrackControl.this.timeDeclutterMinutes = Misc.parseNumber(TrackControl.this.timeDeclutterFld.getText().trim());
                    if (TrackControl.this.timeDeclutterEnabled != TrackControl.this.timeDeclutterCbx.isSelected()) {
                        TrackControl.this.timeDeclutterEnabled = TrackControl.this.timeDeclutterCbx.isSelected();
                        TrackControl.this.timeDeclutterChanged();
                    } else if (TrackControl.this.timeDeclutterEnabled) {
                        TrackControl.this.timeDeclutterChanged();
                    }
                }
                catch (NumberFormatException nfe) {
                    TrackControl.this.userErrorMessage("Bad number format");
                }
            }
        };
        this.timeDeclutterFld = new JTextField(this.getDisplayConventions().format(this.getTimeDeclutterMinutes()), 4);
        this.timeDeclutterFld.addActionListener(timeDeclutterListener);
        this.timeDeclutterCbx = new JCheckBox("", this.getTimeDeclutterEnabled());
        this.timeDeclutterCbx.addActionListener(timeDeclutterListener);
        this.timeDeclutterComps = new JComponent[]{this.timeDeclutterCbx, this.timeDeclutterFld};
        return this.timeDeclutterComps;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        if (!this.checkFlag(1)) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Marker:"), this.makeLayoutModelWidget()));
        }
        controlWidgets.add(new WrapperWidget(this, GuiUtils.topCenter(GuiUtils.rLabel(this.getLineWidthWidgetLabel() + ":"), GuiUtils.filler()), this.getLineWidthWidget().getContents(false)));
    }

    @Override
    protected void addTimeModeWidget(List controlWidgets) {
    }

    protected Component doMakeTimeOptionWidget() {
        JComboBox<String> box = new JComboBox<String>(TIMES_TO_USE);
        box.setSelectedIndex(this.getUseTrackTimes() ? 1 : 0);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackControl.this.setUseTrackTimes(((JComboBox)e.getSource()).getSelectedIndex() == 1);
                FieldImpl grid = TrackControl.this.getTrjGridDataInstance();
                try {
                    if (TrackControl.this.useTrackTimes) {
                        TrackControl.this.trackDisplay.setTrack(TrackControl.this.mergeGrid(grid));
                    } else {
                        TrackControl.this.trackDisplay.setTrack(grid);
                    }
                    TrackControl.this.setTrackTimes();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JComponent[] timeDeclutterComps = this.getTimeDeclutterComps();
        JPanel timeDeclutter = GuiUtils.left(GuiUtils.hflow(Misc.newList(new Component[]{box, new JLabel(" Show Every: "), timeDeclutterComps[1], new JLabel(" minutes "), timeDeclutterComps[0], new JLabel("enabled")}), 2, 1));
        return timeDeclutter;
    }

    protected FieldImpl getTrjGridDataInstance() {
        return this.getGridDataInstance().getGrid(false);
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties, List preSelectedDataChoices) {
        if (this.timeSubsetEnabled) {
            DataTimeRange dtr = new DataTimeRange();
            dtr.setEndMode(this.useTrackTime ? 0 : 1);
            dtr.setStartMode(3);
            dtr.setStartOffsetMinutes(-1.0 * this.timeSubsetMinutes);
            this.setDataTimeRange(dtr);
        }
        super.initAfterUnPersistence(vc, properties, preSelectedDataChoices);
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        if (this.getDataTimeRange() != null) {
            dsd.addPropertyValue(this.getDataTimeRange(), "dataTimeRange", "Time Mode", "Display");
        }
        dsd.addPropertyValue(new Boolean(this.getUseTrackTimes()), "useTrackTimes", "Use Track Times", "Display");
        dsd.addPropertyValue(new Boolean(this.getTimeDeclutterEnabled()), "timeDeclutterEnabled", "Subset Times", "Display");
        dsd.addPropertyValue(new Float(this.getTimeDeclutterMinutes()), "timeDeclutterMinutes", "Subset Interval (min)", "Display");
        dsd.addPropertyValue(this.getMarkerLayout(), "markerLayout", "Marker Layout", "Display");
        dsd.addPropertyValue(new Float(this.markerScale), "markerScale", "Marker Scale", "Display");
        dsd.addPropertyValue(new Integer(this.getLineWidth()), "lineWidth", "Line Width", "Display");
    }

    @Override
    public void setDataTimeRange(DataTimeRange range) {
        super.setDataTimeRange(range);
        if (this.getHaveInitialized()) {
            this.applyTimeRange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTimeRange() {
        try {
            EarthLocationLite elt;
            Real[] llaR;
            int index;
            Unit dataTimeUnit;
            FlatField flatField;
            GridDataInstance gridDataInstance;
            if (!this.trackDataOk()) {
                return;
            }
            DataTimeRange dataTimeRange = this.getDataTimeRange(true);
            GridDataInstance gridDataInstance2 = gridDataInstance = this.getGridDataInstance();
            synchronized (gridDataInstance2) {
                flatField = this.getFlatField();
                if (flatField == null) {
                    return;
                }
                dataTimeUnit = gridDataInstance.getRawUnit(1);
            }
            Range r = this.getRangeForTimeSelect();
            RealType dataTimeRealType = Util.getRealType(dataTimeUnit);
            Real startReal = new Real(dataTimeRealType, r.getMin(), dataTimeUnit);
            Real endReal = new Real(dataTimeRealType, r.getMax(), dataTimeUnit);
            Animation anime = this.getViewAnimation();
            Real aniValue = anime != null ? anime.getAniValue() : null;
            Real[] startEnd = this.getDataTimeRange().getTimeRange(startReal, endReal, aniValue);
            double startDate = startEnd[0].getValue(dataTimeUnit);
            double endDate = startEnd[1].getValue(dataTimeUnit);
            if (!Misc.equals(this.lastRange, new Range(startDate, endDate))) {
                this.lastRange = new Range(startDate, endDate);
                if (this.trackDisplay != null) {
                    this.trackDisplay.setSelectedRange(startDate, endDate);
                }
            }
            double aniDate = aniValue != null && aniValue instanceof Real ? aniValue.getValue(dataTimeUnit) : endDate;
            DataTimeRange dtr = this.getDataTimeRange();
            if (dtr != null && this.trackDisplay != null && this.useTrackTimes) {
                dtr.setEndMode(1);
                this.trackDisplay.setSelectedRange(startDate, aniDate);
            }
            double[] times = flatField.getValues(false)[1];
            for (index = 0; index < times.length; ++index) {
                if (times[index] >= aniDate) {
                    --index;
                    break;
                }
                if (times[index] == aniDate) break;
            }
            if (index == times.length) {
                --index;
            }
            if (index < 0) {
                index = 0;
            }
            if ((llaR = DataUtility.getSample(flatField.getDomainSet(), index).getRealComponents()) != null && !Misc.equals(elt = new EarthLocationLite(llaR[0], llaR[1], llaR[2]), this.lastIndicatorPosition)) {
                this.lastIndicatorTime = new DateTime(times[index], dataTimeUnit);
                this.lastIndicatorPosition = elt;
                this.indicator.setStationData(PointObFactory.makePointObs(elt));
                this.doShare((Object)"ProbeControl.SHARE_POSITION", elt);
                this.updateDisplayList();
            }
        }
        catch (Exception e) {
            TrackControl.logException("applyTimeRange", e);
        }
    }

    @Override
    protected Hashtable getRequestProperties() {
        Hashtable props = super.getRequestProperties();
        props.put("track type", this.trackType);
        return props;
    }

    protected void updateTimeSelectRange() {
        try {
            Range r = this.getRangeForTimeSelect();
            if (r == null) {
                return;
            }
            if (this.trackDisplay != null) {
                this.trackDisplay.setRangeForSelect(r.getMin(), r.getMax());
            }
        }
        catch (Exception e) {
            TrackControl.logException("updateTimeSelectRange", e);
        }
    }

    private Range getRangeForTimeSelect() throws VisADException, RemoteException {
        Range range = this.getRange();
        GridDataInstance gdi = this.getGridDataInstance();
        if (gdi != null && gdi.getNumRealTypes() > 1) {
            range = gdi.getRange(1);
        }
        return range;
    }

    @Override
    protected boolean haveMultipleFields() {
        return false;
    }

    @Override
    protected int getColorRangeIndex() {
        return 0;
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (!this.getHaveInitialized()) {
            return;
        }
        if (dataId.equals("DisplayControlImpl.SHARE_SELECTRANGE") && ((DataChoice)data[0]).basicallyEquals(this.getDataChoice())) {
            try {
                this.setSelectRange((Range)data[1]);
            }
            catch (Exception exc) {
                TrackControl.logException("receiveShareData.level", exc);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    public void setTrackWidth(int width) {
        this.setLineWidth(width);
    }

    @Override
    public void setLineWidth(int width) {
        this.trackWidth = width;
        try {
            super.setLineWidth(width);
            if (this.trackDisplay != null) {
                this.trackDisplay.setLineWidth(width);
            }
        }
        catch (Exception ve) {
            TrackControl.logException("setting line width", ve);
        }
    }

    @Override
    public int getLineWidth() {
        return this.trackWidth;
    }

    /*
     * Enabled aggressive block sorting
     */
    private StationModel makeLayoutModel() {
        StationModel layout;
        block12: {
            block13: {
                boolean showSymbol;
                layout = null;
                if (this.markerText.equals("") || this.markerSymbol.equals("NONE")) break block13;
                layout = new StationModel("TrackLocation");
                LabelSymbol textSymbol = new LabelSymbol();
                textSymbol.setValue(this.markerText);
                ShapeSymbol shapeSymbol = new ShapeSymbol(0, 0);
                shapeSymbol.setShape(this.markerSymbol);
                if (this.getColor() != null) {
                    shapeSymbol.setForeground(this.getColor());
                    textSymbol.setForeground(this.getColor());
                } else {
                    shapeSymbol.setForeground(Color.magenta);
                    textSymbol.setForeground(Color.magenta);
                }
                shapeSymbol.bounds = new Rectangle(-15, -15, 30, 30);
                shapeSymbol.setRectPoint("MM");
                boolean showId = !this.markerText.equals("");
                boolean bl = showSymbol = !this.markerSymbol.equals("NONE");
                if (showId) {
                    layout.addSymbol(textSymbol);
                }
                if (showSymbol) {
                    layout.addSymbol(shapeSymbol);
                }
                if (showSymbol && showId) {
                    textSymbol.bounds = new Rectangle(-11, -31, 72, 24);
                    textSymbol.setRectPoint("LM");
                    break block12;
                } else if (showId) {
                    textSymbol.bounds = new Rectangle(-11, -8, 72, 24);
                    textSymbol.setRectPoint("MM");
                    break block12;
                } else if (!showSymbol) {
                    // empty if block
                }
                break block12;
            }
            String name = "Location";
            layout = this.getControlContext().getStationModelManager().getStationModel(name);
            if (layout == null) {
                LogUtil.userErrorMessage("Unable to find layout model: " + name + ". Using default");
            }
        }
        if (layout == null) {
            layout = this.getControlContext().getStationModelManager().getDefaultStationModel();
        }
        if (this.layoutModelWidget != null) {
            this.layoutModelWidget.setLayoutModel(layout);
        }
        return layout;
    }

    @Override
    protected Set getDataTimeSet() throws RemoteException, VisADException {
        return this.lastIndicatorTime == null ? null : CalendarDateTime.makeTimeSet(new DateTime[]{this.lastIndicatorTime});
    }

    protected int getTrackWidth() {
        return this.getLineWidth();
    }

    public void setTrackType(String type) {
        this.trackType = type;
    }

    public String getTrackType() {
        return this.trackType;
    }

    public void setTimeSubsetMinutes(double value) {
        this.timeSubsetMinutes = value;
    }

    public void setTimeSubsetEnabled(boolean value) {
        this.timeSubsetEnabled = value;
    }

    public void setUseTrackTime(boolean value) {
        this.useTrackTime = value;
    }

    public void setUseTrackTimes(boolean value) {
        this.useTrackTimes = value;
        if (this.getHaveInitialized()) {
            try {
                this.setTrackTimes();
            }
            catch (Exception e) {
                TrackControl.logException("setTrackTimes", e);
            }
        }
    }

    public boolean getUseTrackTimes() {
        return this.useTrackTimes;
    }

    public void setTimeDeclutterMinutes(double value) {
        this.timeDeclutterMinutes = value;
    }

    public double getTimeDeclutterMinutes() {
        return this.timeDeclutterMinutes;
    }

    public void setTimeDeclutterEnabled(boolean value) {
        this.timeDeclutterEnabled = value;
        if (this.timeDeclutterCbx != null && value != this.timeDeclutterCbx.isSelected()) {
            this.ignoreTimeDeclutterEnabled = true;
            this.timeDeclutterCbx.setSelected(value);
            this.ignoreTimeDeclutterEnabled = false;
        }
    }

    public boolean getTimeDeclutterEnabled() {
        return this.timeDeclutterEnabled;
    }

    public void setAskedUserToDeclutterTime(boolean value) {
        this.askedUserToDeclutterTime = value;
    }

    public boolean getAskedUserToDeclutterTime() {
        return this.askedUserToDeclutterTime;
    }

    public void setMarkerText(String value) {
        this.markerText = value;
        this.markerVisible = true;
    }

    public void setMarkerSymbol(String value) {
        this.markerSymbol = value;
        this.markerVisible = true;
    }

    public void setMarkerLayout(StationModel model) {
        this.layoutModel = model;
        if (this.getHaveInitialized() && this.indicator != null) {
            try {
                this.indicator.setStationModel(this.layoutModel);
            }
            catch (Exception excp) {
                TrackControl.logException("setting marker layout", excp);
            }
        }
    }

    public StationModel getMarkerLayout() {
        if (this.layoutModel == null) {
            this.layoutModel = this.makeLayoutModel();
        }
        return this.layoutModel;
    }

    public float getMarkerScale() {
        return this.markerScale;
    }

    public void setMarkerScale(float f) {
        this.markerScale = f;
        if (this.indicator != null) {
            try {
                this.setScaleOnMarker();
            }
            catch (Exception exc) {
                TrackControl.logException("Setting scale ", exc);
            }
        }
    }

    private void setScaleOnMarker() throws RemoteException, VisADException {
        this.setScaleOnMarker(this.getDisplayScale() * this.markerScale);
    }

    private void setScaleOnMarker(float f) throws RemoteException, VisADException {
        if (this.indicator != null) {
            this.indicator.setScale(f);
        }
    }

    public void editLayoutModel() {
        this.getControlContext().getStationModelManager().show(this.layoutModel);
    }

    public void setMarkerVisible(boolean value) {
        this.markerVisible = value;
        if (this.getHaveInitialized() && this.indicator != null) {
            try {
                this.indicator.setVisible(this.markerVisible);
            }
            catch (Exception excp) {
                TrackControl.logException("setting marker visible", excp);
            }
        }
    }

    public boolean getMarkerVisible() {
        return this.markerVisible;
    }

    public void setStationModelFromWidget(final StationModel sm) {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                TrackControl.this.showWaitCursor();
                try {
                    TrackControl.this.setMarkerLayout(sm);
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Changing station model", exc);
                }
                TrackControl.this.showNormalCursor();
            }
        });
    }

    protected JPanel makeLayoutModelWidget() {
        StationModel marker = this.getMarkerLayout();
        this.layoutModelWidget = new LayoutModelWidget(this, (Object)this, "setStationModelFromWidget", this.layoutModel);
        ValueSliderWidget vsw = new ValueSliderWidget(this, 0, 50, "markerScale", "Scale", 10.0f);
        vsw.setSnapToTicks(false);
        vsw.setEnabled(this.markerVisible);
        JLabel vswLabel = GuiUtils.rLabel("   Scale: ");
        vswLabel.setEnabled(this.markerVisible);
        final JPanel markerComp = GuiUtils.doLayout(new Component[]{this.layoutModelWidget, vswLabel, vsw.getContents(false)}, 3, GuiUtils.WT_N, GuiUtils.WT_N);
        JCheckBox showMarker = new JCheckBox("", this.markerVisible);
        showMarker.setToolTipText("Show the marker");
        showMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isVisible = ((JCheckBox)e.getSource()).isSelected();
                TrackControl.this.setMarkerVisible(isVisible);
                GuiUtils.enableTree(markerComp, isVisible);
            }
        });
        GuiUtils.enableTree(markerComp, this.markerVisible);
        return GuiUtils.left(GuiUtils.doLayout(new Component[]{showMarker, GuiUtils.inset((Component)markerComp, new Insets(0, 8, 0, 0))}, 3, GuiUtils.WT_N, GuiUtils.WT_N));
    }
}

